/* sendmail.c -- Send a file via e-mail.
 *
 * Dean Collins 
 * created: Sat Mar 12 23:52:35 1994
 * 
 * Modified: Dean Collins Fri Mar 18 16:40:38 1994
 * Removed unneeded call to ReadBuf() (which has been removed.)
 * Provided more error checking.
 * 
 * Modified: Dean Collins Sun Jan 15 02:06:36 PST 1995
 * Changed DEBUG output so it goes to stderr.
 */

/*
 * Copyright (c) 1994 Dean Collins.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notices appear in all copies and
 * that both those copyright notices and this permission notice appear in
 * supporting documentation, and that the name of
 * Dean Collins not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission from both parties.  
 * Dean Collins makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 * DEAN COLLINS DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>		/* General C utilities header file */
#include <stdio.h>		/* Standard input/output utilities hdr. file */
#include <string.h>		/* String and memory functions header file.*/
#include <errno.h>		/* Error utilities header file */
#ifndef SYSV
#include <sys/types.h>		/* Common data types */
#endif
#include <sys/stat.h>		/* File status utilities */

#ifndef SYSV

#include <sys/file.h>		/* Low-level file I/O */
#include <limits.h>		/* Common system limits */
#ifdef linux
#include <unistd.h>		/* Standard Unix definitions */
#endif /* linux */
/* end not system 5 */

#else /* it is system 5 */

#include <strings.h>		/* String and memory functions header file.*/
#include <unistd.h>		/* Standard Unix definitions */
#include <fcntl.h>		/* File control */

#endif /* system 5 */

/* No non-system includes should be here, other than util.h. */
#include "util.h"		/* Misc. low-level utilities */


#ifdef DEBUG
#define MYDEBUG(a,b,c,d,e) fprintf(stderr,a,b,c,d,e)
#endif

#ifndef BLCKSZ
#define BLCKSZ 16000
#endif


/******************** MODULES *************************************/

/*
______________________________________________________________________
SendMail()

FUNCTION DESCRIPTION:

     This function mails a file to a user.
______________________________________________________________________
REVISION HISTORY:
     Author:  Dean Collins      Date: 3/12/94
______________________________________________________________________
*/


int 
SendMail(char *Prog,
	 char *Opts,
	 char *Subject,
	 char *User,
         char *Host,
	 char *Filename)

     /* Interface description:
         INPUT:
          Prog   	- The mail program to use (/usr/bin/sendmail, 
			  /usr/bin/mail, etc...  Full path specification reqd.)
          Opts   	- The command-line options to use with Prog.
          Subject 	- The subject of the e-mail message.
          User    	- The user to send the mail to.
          Host    	- The host the User is on.
          Filename 	- The name of the file to send.
         OUTPUT:
          None.
         RETURN VALUE:
          int    - Success/Failure.  If -1 see errno for error information.
     */
{
     /* Internal variables: */
          /* Major */
          /* Minor */
   char tmpname[L_tmpnam+1] ;	/* A temporary filename */
   int infd=0, outfd=0 ;	/* input and output file descriptors */
   char *buf=NULL ;		/* Temporary data buffer */
   int n ;			/* Number of bytes read */
   char cmdline[100] ;		/* A command line passed to system() */


   /*----------------- Start of SendMail() routine ------------------*/

#  ifdef DEBUG
   fprintf(stderr,"Entering SendMail()\n") ;
#  endif

	/* Is mail program "sendmail" ? */
   if (strstr(Prog,"sendmail"))
   { 	/* If so, compose a message to pipe to it. */

      tmpnam(tmpname) ; /*Generate tmp filename */

#     ifdef DEBUG
      fprintf(stderr,"using sendmail.  tmpname=%s\n", tmpname) ;
#     endif

      infd = open (Filename,
		    O_RDONLY,
		    S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH) ;
      if (outfd == -1)
      { /*error*/
         return(-1) ;
      } 

      outfd = open (tmpname,
		    O_RDWR | O_APPEND | O_CREAT | O_EXCL,
		    S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH) ;
      if (outfd == -1)
      { /*error*/
#        ifdef DEBUG
         fprintf(stderr,"Leaving SendMail()\n") ;
#        endif
         if (errno != EEXIST)
            unlink(tmpname) ;		/* Delete the temporary file */
         return(-1) ;
      } 

      buf = (char *) malloc(BLCKSZ+1) ;
      if (buf == NULL)
      {  /* error */
#        ifdef DEBUG
         fprintf(stderr,"Leaving SendMail()\n") ;
#        endif
         unlink(tmpname) ;		/* Delete the temporary file */
         return(-1) ;
      }

      if ( !strlen(Host)) /* Is destination host specified or not?*/
      {                   /* no destination host */
         sprintf(buf, "To: %s\nSubject: %s\n\n", User, Subject) ;
      }
      else		  /* yes, desination host is specified */
      {
      		/* Create headers for mail, writing to file
		 * This is a bit of a mess, due to the #ifdefs.
		 * Only one of the _EMAIL's should be defined, or you're
		 * in trouble...
		 */

#        ifdef INTERNET_EMAIL
		/* Assumes User@Host is the proper address..... */
         sprintf(buf, "To: %s@%s\nSubject: %s\n\n", User, Host, Subject) ;
#        endif /*INTERNET_EMAIL*/

#        ifdef UUCP_EMAIL
		/* Assumes Host!User is the proper address..... */
         sprintf(buf, "To: %s!%s\nSubject: %s\n\n", Host, User, Subject) ;
#        endif /*UUCP_EMAIL*/

		/* Add other address formats here.... */

#        if ! (defined(INTERNET_EMAIL) | defined(UUCP_EMAIL))
		/* Assumes User on the local host is the proper address...*/
         sprintf(buf, "To: %s\nSubject: %s\n\n", User, Subject) ;
#        endif /*no e-mail address type defined*/

      }

#     ifdef DEBUG
      fprintf(stderr,"\t-----MAIL MESSAGE START-----\n(begin headers)\n%s", buf) ;
#     endif

      if (WriteBuf (outfd, buf, strlen(buf)) == -1) /*Write the headers */
      {  /* error */
#        ifdef DEBUG
         fprintf(stderr,"Leaving SendMail() -- WriteBuf() returned -1\n") ;
#        endif
         unlink(tmpname) ;		/* Delete the temporary file */
         return(-1) ;
      }

#     ifdef DEBUG
      fprintf(stderr,"(begin body)\n") ;
#     endif

		/* Copy input file to output file */
      while ( (n = read (infd, buf, BLCKSZ)) > 0)
      {  if (WriteBuf (outfd, buf, n) == -1)	/*Write the headers */
         {  /* error */
#           ifdef DEBUG
            fprintf(stderr,"Leaving SendMail()\n") ;
#           endif
            unlink(tmpname) ;		/* Delete the temporary file */
            return(-1) ;
         }
#        ifdef DEBUG
         fprintf(stderr,"%s", buf) ;
#        endif
      }

#     ifdef DEBUG
      fprintf(stderr,"\n\t-----MAIL MESSAGE END-----\n") ;
#     endif


      close (infd) ;
      close (outfd) ;

      sprintf (cmdline, "%s %s < %s", Prog, Opts, tmpname) ;
#     ifdef DEBUG
      fprintf(stderr,"cmdline:  %s\n", cmdline) ;
#     endif

      system(cmdline) ;		/* call sendmail */
      unlink(tmpname) ;		/* Delete the temporary file */

   } /* end of 'if Prog is sendmail' section */


   else	/* If not "sendmail", it must be a mail program like /bin/mail. */
   {	/* So, build a command line to send the file.  This is much simpler. */

	/* Note:  Don't put user@host in this, since there will be a
	 * security hole at least a mile wide if you do.
         */

      sprintf(cmdline,"%s %s '%s' %s < %s",Prog,Opts,Subject,User,Filename);
#     ifdef DEBUG
      fprintf(stderr,"cmdline:  %s\n", cmdline) ;
#     endif
      system(cmdline) ;  /* Execute the command (return value not checked.) */
   }

#  ifdef DEBUG
   fprintf(stderr,"Leaving SendMail()\n") ;
#  endif

   return 1 ;

}  /*--------------------- End of SendMail() ------------------------*/

/* End of sendmail.c */
