/* Author:  Luke Shenenan */

/* Modified: 2/14/93, DC.
 * Added FULLRECORD/PARTIALRECORD field to all view_reopen() and
 * get_problem() calls.
 *
 * Modified: Dean Collins Sat Feb 12 17:13:51 1994
 * Modification recommended by Jaap Haalboom (haalboom@prl.philips.nl).
 * Fixed a printf that was an fprintf.

 * Modified: Dean Collins Fri Apr 08 21:01:09 1994
 * Fixed a problem with long summaries (greater than 68 chars.) causing
 * summaries to not show up in the "Show All Unsolved" list.
 * In the process FormatUnsolvedSummaries() is no longer needed,
 * just use FormatSummaries().  Also, SUMMARY_DESC_LEN has been added,
 * which is the maximum length of the summary description strings
 * (like "  (SOLVED)", etc.)
 *
 * Modified: Dean Collins Mon Jan  2 16:39:12 PST 1995
 * Changed all printfs in DEBUG sections to fprintf(stderr...).
 *
 * Modified: Dean Collins Sun May 21 13:59:00 PDT 1995
 * Changed argument 4 of all calls to get_problem() from NULL to 0.
 * It expects an int, and NULL is often defined as a pointer.
 */

/*
 * Copyright (c) 1995,1994,1993 Dean Collins.
 * Copyright (c) 1993,1992 Luke Sheneman.
 * Copyright (c) 1992 University of Idaho, Moscow, Idaho.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation free of charge for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of the University of Idaho
 * Dean Collins and Luke Sheneman not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written 
 * prior permission.  The University of Idaho, Luke Sheneman and Dean Collins 
 * make no representations about the suitability of this software for 
 * any purpose.  It is provided "as is" without express or implied warranty.
 *  
 * THE UNIVERSITY OF IDAHO, LUKE SHENEMAN, AND DEAN COLLINS  DISCLAIM ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY OF IDAHO
 * LUKE SHENEMAN OR DEAN COLLINS BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */


 /*
 *
 *	summaries.c - included the following functions:
 *
 *	ReadUnsolvedSummaries()	and FormatUnsolvedSummaries() - Provides an 
 *		array of strings which contain all of the problem summaries for
 *		all of the unsolved problems and reopened requested problems 
 *		for a problem type. 
 *	ReadSummaries() and FormatSummaries() - Provides an array of strings
 *		which contain all the problem summaries for a problem type.
 *	CompPrid() - compares two problem id's  (PRIDS).  Used for sorting.
 *	AddSummary() - Adds a summary to a linked list of Summary structs.
 *      ReadUnsolved() - Reads an unsolved summary or a reopen requested problem
 *		 and returns a problem record to the user interface.
 *	FixPath() - Convert bewteen zdbm and neb_cloud compatible path strings.
 *      FreeSummaries() - Free a linked list of Summary structures.  
 *	SortSummaries() - Sorts summaries by problem id and time of day.
 *	AddSortedSummary() - Adds a sorted summary to a linked list of summary
 *		structures.
 *	FreeList() - This should free a dynamically allocated array of strings.
 *
 *
 */ 
 

#include <stdio.h>
#include <zdbm.h>
#include "cloud.h"
#include "clouderror.h"



/* ReadUnsolvedSummaries() - Traverses all of the leaves of the problem tree 
	looking for unsolved problems, and returns an array of strings 
	containing a sorted list of unsolved summaries and reopen requested 
	problems.

	Author:  Luke Sheneman			Date: 09/11/92
	Revision: Luke Sheneman			Date: 12/06/92

		I rewrote the entire thing last night.  It is much easier to 
			understand now.  

		It appears to be debugged.
*/


Summary *ReadUnsolvedSummaries(tree,unsummaries)
ProblemTree *tree; 
char **unsummaries[];
{
	problem_record 		*old,*new,dummy;
	static Summary		*unsum=NULL;
	reopened_record 	*newreopened,*oldreopened;
	struct Full_path	pathlist,*temp_pathlist;
	char newpath[DBPATHLEN];
	char oldprid[MAXPRID];
		/* The 30 in the oldshor_description definition is the maximum
		 * number of characters that can be appended to a short desc.
		 * This is used for the "(SOLVED)", "(UNSOLVED)" etc. strings.
		 */
	char oldshort_description[MAXSUMLEN+30] ;
	int loop;

	cld_errno=0;

	if(unsum)
	{
		FreeSummaries(unsum);
		unsum=NULL;
	}

	pathlist.next=NULL;
	strcpy(pathlist.path,ROOTSTR);
	TraverseLeaves(tree,&pathlist);
#ifdef DEBUG
	zdebug("\n") ;
	TraverseList(stderr,&pathlist);
	zdebug("\n") ;
#endif /* DEBUG */

	temp_pathlist=pathlist.next;
	while(temp_pathlist)
	{
		strcpy(newpath,FixPath(temp_pathlist->path));
		old=get_problem(newpath,NULL,UNSOLVED,0,NOLINKS,PARTIALRECORD);/*Modified: 2/27/93, DC*/
		if(old)
		{
			strcpy(oldprid,old->prid);
/*			strcat(old->short_description,"  (UNSOLVED)");*/
			unsum=AddSummary(unsum,old,newpath);
			new=get_problem(newpath,NULL,UNSOLVED,0,NOLINKS,PARTIALRECORD);/*Modified: 2/27/93, DC*/
			if(!new)
			{
				cld_errno=CLD_ERR3;
				return(NULL);
			}
			while(strcmp(oldprid,new->prid))
			{
/*				strcat(new->short_description,"  (UNSOLVED)");*/
				AddSummary(unsum,new,newpath);
				new=get_problem(newpath,NULL,UNSOLVED,0,NOLINKS,PARTIALRECORD);/*Modified: 2/27/93, DC*/
				if(!new)
				{
					cld_errno=CLD_ERR3;
					return(NULL);
				}
			}
		}
		temp_pathlist=temp_pathlist->next;
	}



	oldreopened=view_reopen(NULL,PARTIALRECORD); /*Modified: 2/27/93, DC*/
	if(oldreopened)
	{
		strcpy(oldprid,oldreopened->prid);

		strcpy(dummy.prid,oldreopened->prid);
		strcpy(dummy.short_description,oldreopened->pro_rec->short_description);
/*		strcat(dummy.short_description,"  (REOPEN REQUEST)");*/
		dummy.status=REOPENED;

		unsum=AddSummary(unsum,&dummy,"");
		newreopened=view_reopen(NULL,PARTIALRECORD); /*Modified: 2/27/93, DC*/
		if(newreopened)
		{
			while(strcmp(oldprid,newreopened->prid))
			{
				strcpy(dummy.prid,newreopened->prid);
				strcpy(dummy.short_description,newreopened->pro_rec->short_description);
/*				strcat(dummy.short_description,"  (REOPEN REQUEST)");*/
				dummy.status=REOPENED;

				AddSummary(unsum,&dummy,"");
				newreopened=view_reopen(NULL,PARTIALRECORD);/* Modified: 2/27/93, DC*/
				if(!newreopened)
				{
					cld_errno=CLD_ERR4;
					return(NULL);
				}
					
			}
		}
		else
		{
			cld_errno=CLD_ERR4;
			return(NULL);
		}
	}	


/*	unsum=FormatUnsolvedSummaries(unsum,unsummaries);*/
	unsum=FormatSummaries(NULL,unsum,unsummaries);
	return(unsum);
}









/* ReadSummaries() - Reads solved and unsolved problem summaries at a given
	leaf, and stuffs the summaries, in sorted order into an array of 
	strings.

	Author:  Luke Sheneman				Date:  09/11/92
	Revision:  Luke Sheneman			Date:  12/06/92

		I rewrote the thing.  It works perfectly, and is easier to 
			read and understand and debug.

		It appears to work flawlessly.	80)

*/

Summary *ReadSummaries(tree,path,summaries)
ProblemTree *tree;
char *path;
char **summaries[];
{
	static Summary *summarylist=NULL;
	Summary *solved=NULL,*unsolved=NULL;
	problem_record *old, *new;
	char oldprid[MAXPRID];
	char newpath[DBPATHLEN];


	cld_errno=0;

	strcpy(newpath,FixPath(path));

	if(summarylist)
	{
		FreeSummaries(summarylist);
		summarylist=NULL;
	}	
	/* Read the unsolved into a linked list */
	old=get_problem(newpath,NULL,UNSOLVED,0,LINKS,PARTIALRECORD);/*Modified: 2/27/93, DC*/
	if(old)
	{
		strcpy(oldprid,old->prid);
		unsolved=AddSummary(unsolved,old,newpath);
		new=get_problem(newpath,NULL,UNSOLVED,0,LINKS,PARTIALRECORD);/*Modified: 2/27/93, DC*/
		if(!new)
		{
			cld_errno=CLD_ERR3;
			return(NULL);
		}
		while(strcmp(oldprid,new->prid))
		{
			AddSummary(unsolved,new,newpath);
			new=get_problem(newpath,NULL,UNSOLVED,0,LINKS,PARTIALRECORD);/*Modified 2/27/93, DC*/
			if(!new)
			{
				cld_errno=CLD_ERR3;
				return(NULL);
			}
		}
	}


	/* Read the solved into a linked list */
	old=get_problem(newpath,NULL,SOLVED,0,LINKS,PARTIALRECORD);/*Modified 2/27/93, DC*/
	if(old)
	{
		strcpy(oldprid,old->prid);
		solved=AddSummary(solved,old,newpath);
		new=get_problem(newpath,NULL,SOLVED,0,LINKS,PARTIALRECORD);/*Modified 2/27/93, DC*/
		if(!new)
		{
			cld_errno=CLD_ERR5;
			return(NULL);
		}
		while(strcmp(oldprid,new->prid))
		{
			AddSummary(solved,new,newpath);
			new=get_problem(newpath,NULL,SOLVED,0,LINKS,PARTIALRECORD);/*Modified 2/27/93, DC*/
			if(!new)
			{
				cld_errno=CLD_ERR5;
				return(NULL);
			}
		}
	}

	/* Let's build the array of strings and get out of here.  */

	summarylist=FormatSummaries(solved,unsolved,summaries);
	unsolved=solved=NULL;

	return(summarylist);
}









/* FormatSummaries() - This function is called by ReadSummaries().  Given
	a linked list of solved and unsolved Summary structures, sort and 
	stuff all summaries into an array of strings.

	Author:  Luke Sheneman.				Date:  09/11/92

		It seems to be debugged and working....

	Modified:  Dean Collins.			Date:  04/08/94

		The unsolved list can now contain reopen requests.
		This function should be used instead of
		FormatUnsolvedSummaries(), which is no longer needed.
		Just pass NULL as the solved list.
		Also, SUMMARY_DESC_LEN is used instead of "25".
		It's the max length of the "  (SOLVED)", "  (UNSOLVED)", 
		etc. strings.

		It again seems to be debugged and working...

*/
	
Summary *FormatSummaries(solved,unsolved,summaries)
Summary *solved;
Summary *unsolved;
char **summaries[];
{
	Summary *ts,*sorted_unsolved=NULL,*sorted_solved=NULL,*list=NULL;
	int loop=0,cnt=0;
	char dummy[MAXSUMLEN+SUMMARY_DESC_LEN];

	cld_errno=0;

	/*  Lets count the number of problems so that we can allocate appropriate storage */

#ifdef DEBUG
	zdebug("In FormatSummaries() before sorting of unsolved.\n");
	zdebug("And now solved:\n");
	TraverseSummaries(solved);
	zdebug("And now unsolved:\n");
	TraverseSummaries(unsolved);
#endif /* DEBUG */

	sorted_unsolved=SortSummaries(unsolved);

#ifdef DEBUG
	zdebug("\n\nIn FormatSummaries() AFTER sorting of UNSOLVED.\n");
	TraverseSummaries(sorted_unsolved);
#endif /* DEBUG */

	
	ts=sorted_unsolved;
	while(ts)
	{
		cnt++;
		ts=ts->next;
	}

	zdebug("In FormatSummaries() before sorting of solved.\n");

	sorted_solved=SortSummaries(solved);

#ifdef DEBUG
	zdebug("\n\nIn FormatSummaries() AFTER sorting of SOLVED.\n");
	TraverseSummaries(sorted_solved);
#endif /* DEBUG */

	ts=sorted_solved;
	while(ts)
	{
		cnt++;
		ts=ts->next;
	}
	if(!cnt)
	{
		(*summaries)=(char **)malloc(sizeof(char *));
		(*summaries)[0]=(char *)malloc(2);
		(*summaries)[0]=NULL;
		return(NULL);
		
	}

	(*summaries)=(char **)malloc(sizeof(char *)*(cnt+1));

	/* Let's copy the unsolved problem summaries into an array of strings.\n");  */
	ts=sorted_unsolved;
	while(ts)
	{
		(*summaries)[loop]=(char *)malloc(strlen(ts->summary)+SUMMARY_DESC_LEN);
		strcpy(dummy,ts->summary);
		switch (ts->status) /* added 4/8/94 DC */
		{   case UNSOLVED: strcat(dummy,"  (UNSOLVED)"); break;
		    case REOPENED: strcat(dummy,"  (REOPEN REQUEST)"); break;
		}
		strcpy((*summaries)[loop++],dummy);
		ts=ts->next;
	}

	/* Let's copy the solved problem summaries into an array of strings.\n"); */
	ts=sorted_solved;
	while(ts)
	{
		(*summaries)[loop]=(char *)malloc(strlen(ts->summary)+SUMMARY_DESC_LEN);
		strcpy(dummy,ts->summary);
		strcat(dummy,"  (SOLVED)");
		strcpy((*summaries)[loop++],dummy);
		ts=ts->next;
	}
	(*summaries)[loop]=NULL;

	/* Lets create the new summarylist */

	ts=sorted_unsolved;	
	while(ts)
	{
		list=AddSortedSummary(list,ts);
		ts=ts->next;
	}
	ts=sorted_solved;	
	while(ts)
	{
		list=AddSortedSummary(list,ts);
		ts=ts->next;
	}
	
	return(list);
}










/* FormatUnsolvedSummaries() - This function resembles FormatSummaries().  It 
receives a linked list of unsolved Summary structure and sorts and then stuffs
them into an array of strings for use in the user interface.

	Author:  Luke Sheneman				Date:  09/12/92


		This function appears to work...

*/

Summary *FormatUnsolvedSummaries(unsolved,summaries)
Summary *unsolved;
char **summaries[];
{
	Summary *ts,*solved;	/* "solved" should be read as "sorted" */ 
	int loop=0;
	int cnt=0;

/* THIS FUNCTION IS NO LONGER USED.  USE FormatSummaries() INSTEAD.
 * I'm keeping this function around for now "just in case" I've overlooked
 * some need for it.  It'll almost certainly probably go away in the future.
 */
return(FormatSummaries(NULL,unsolved,summaries)) ;

	cld_errno=0;

	/* Sort The Bastard */

	solved=SortSummaries(unsolved);	   

	ts=solved;

	/* Traverse A Linked List Of Summary Structures, 
		Sticking Them Into An Array Of Strings */
	while(ts)
	{
		cnt++;
		ts=ts->next;
	}
	(*summaries)=(char **)malloc(sizeof(char *)*(cnt+1));
	ts=solved;
	while(ts)
	{
		(*summaries)[loop]=(char *)malloc(strlen(ts->summary)+1);
		strcpy((*summaries)[loop++],ts->summary);
		ts=ts->next;
	}
	(*summaries)[loop]=NULL;

	return(solved);
}









/* CompPrid() - This function compares two different problem ids and returns a
   value indicating which problem ID chronologically appears before the other 
   one.  A negative value is returned if the first PRID is smaller than the 
   second.  A positive value is returned if the first PRID is larger than the
   second.  A zero is returned if they are the same.

	Author:  Luke Sheneman				Date:  11/14/92

		This function works...


*/

int CompPrid(prid1,prid2)
char prid1[MAXPRID],prid2[MAXPRID];
{
	int res;
	char y1[5],y2[5];
	char d1[4],d2[4];
	char f1[6],f2[6];

	cld_errno=0;

	y1[0]=prid1[3]; y1[1]=prid1[4]; y1[2]=prid1[5]; y1[3]=prid1[6]; y1[4]='\0';
	y2[0]=prid2[3]; y2[1]=prid2[4]; y2[2]=prid2[5]; y2[3]=prid2[6]; y2[4]='\0';

	res=strcmp(y1,y2);
	if(res>0)
		return(1);
	else if(res<0)
		return(-1);
	else
	{
		d1[0]=prid1[0]; d1[1]=prid1[1]; d1[2]=prid1[2]; d1[3]='\0';
		d2[0]=prid2[0]; d2[1]=prid2[1]; d2[2]=prid2[2]; d2[3]='\0';

		res=strcmp(d1,d2);
		if(res>0)
			return(1);
		else if(res<0)
			return(-1);
		else
		{
			f1[0]=prid1[7]; f1[1]=prid1[8]; f1[2]=prid1[9]; f1[3]=prid1[10]; f1[4]=prid1[11]; f1[5]='\0';
			f2[0]=prid2[7]; f2[1]=prid2[8]; f2[2]=prid2[9]; f2[3]=prid2[10]; f2[4]=prid2[11]; f2[5]='\0';
			res=strcmp(f1,f2);
			if(res>0)
				return(1);
			else if(res<0)
				return(-1);
			else
				return(0);
		}
	}
}








/* AddSummary() - This function adds a Summary node to the end of a linked
	list of Summary structures.  Pass in the head (which can be NULL)
	into this function, as well as a problem record and a path in the
	problem tree.  If the head sent into AddSummary() is NULL, 
	AddSummary() will generate the head and return a pointer to it to
	the calling function.


	Author:  Luke Sheneman				Date:  11/23/92

		This function works great...


*/


Summary *AddSummary(head,rec,path)
Summary *head;
problem_record *rec;
char *path;
{
	Summary *t=NULL,*temp=NULL;

	cld_errno=0;

	if(!head)
	{
		if(!t)
			t=(Summary *)malloc(sizeof(Summary));
		strcpy(t->path,path);
		strcpy(t->prid,rec->prid);
		strcpy(t->summary,rec->short_description);
		t->status=rec->status;
		t->next=NULL;
		
		return(t);
	}
	else
	{
		t=head;
		while(t->next)
			t=t->next;
		if(!temp)
			temp=(Summary *)malloc(sizeof(Summary));
		strcpy(temp->path,path);
		strcpy(temp->prid,rec->prid);
		strcpy(temp->summary,rec->short_description);
		temp->status=rec->status;
		t->next=temp;
		temp->next=NULL;

		return(head);
	}
}








/* ReadUnsolved() - Reads an unsolved problem from the database given a
	tree, path, a linked list of summary structures, and a problem
	number.  The function returns a pointer to a problem record, or
	NULL on error.

	Author: Luke Sheneman				Date:  11/12/92

		This function has been tested fairly throughly.

*/


problem_record *ReadUnsolved(tree,path,unsolved,problem)
ProblemTree *tree;
char *path;
Summary *unsolved;
int problem;
{
	Summary *sum;
	char prid[MAXPRID];
	static problem_record *realres;
	reopened_record *reopened;
	problem_record *res;
	int cnt=0;

	cld_errno=0;

	sum=unsolved;
	while( (sum) && (cnt<problem) )
	{
		cnt++;
		sum=sum->next;
	}
	if(sum)
	{
		strcpy(path,FixPath(sum->path));
		strcpy(prid,sum->prid);
		switch(sum->status)
		{
			case UNSOLVED:
			{
				res=get_problem(path,prid,PARTICULAR,0,LINKS,FULLRECORD);/*Modified 2/14/93, DC*/
				if(!res)
					cld_errno=CLD_ERR6;
				else
				{
					if(realres)
					{
						zdebug("In ReadUnsolved() - about to free a problem record.\n");

						FreeProblemRecord(realres);
					}

					zdebug("In readUnsolved() - about to malloc a problem record.\n");

					realres=(problem_record *)malloc(sizeof(problem_record));
					CopyProblemRecord(realres,res);
					
					return(realres);	
				}
			}
			case REOPENED:
			{
				reopened=view_reopen(sum->prid,FULLRECORD);/*Modified: 2/14/93, DC*/
				if(!reopened)
					cld_errno=CLD_ERR7;
				else
				{
					if(realres)
						FreeProblemRecord(realres);
					realres=(problem_record *)malloc(sizeof(problem_record));
					CopyProblemRecord(realres,reopened->pro_rec);
					return(reopened->pro_rec);
				}
			}
			default:
			{
				cld_errno=CLD_ERR8;
				return(NULL);
			}
		}
	}
	else
	{
		cld_errno=CLD_ERR9;
		return(NULL);		
	}
}










/* FixPath() - This function converts between the cloud format for representing
	paths and the zdbm method for representing paths.  This was a work-around
	due to inadequate planning.  This function should hopefully be unnecessary
	in future versions.

	Author:  Luke Sheneman				Date:  11/29/92

		This function was tested using black and white box tests, and 
			seems to work flawlessly for most cases.

        Revision:  Dean Collins				Date:  07/24/93
		   FixPath() returns "newpath", an array.  Return was
		   returning the value of the address of the array,
		   not the array itself.  Therefore, the data in the
		   array may be invalid upon returning to the caller.
		   (Guess this is one of the cases where it didn't
		   work flawlessly... :-)

*/

char *FixPath(path)  /* convert between cloud paths and zdbm paths */
char *path;
{
	int loop,c=0,cnt,len;
	static char newpath[DBPATHLEN]; /* Changed to static 7/24/93, DC */
	char temppath[DBPATHLEN];
	char dummy[DBPATHLEN];
	char ch;

	cld_errno=0;

	/* Some checking, first... */
	if(path==NULL)
		return(NULL);
	if(path[0]=='\0')
		return(path);

	temppath[0]='\0';
	strcpy(temppath,path);	/* Make a copy. */

	/* Remove leading slashes */

	loop=0;
	while(temppath[loop++]=='/');
	loop--;
	for(cnt=loop;cnt<strlen(temppath);)
		newpath[c++]=temppath[cnt++];
	newpath[c]='\0';
	strcpy(temppath,newpath);

	loop=0;
	ch=32;
	while( (ch!='/') && (ch!='\0') )
		ch=temppath[loop++];
	for(c=0;c<loop;c++)
		dummy[c]=temppath[c];

	dummy[loop-1]='\0';

	if(!strcmp(dummy,ROOTSTR))
	{
		cnt=0;
		for(c=loop-1;c<strlen(temppath);c++)
			newpath[cnt++]=temppath[c];
		newpath[cnt]='\0';
	}
	strcpy(temppath,newpath);

	/* remove trailing slashes */

	len=strlen(temppath);
	while(temppath[len-1]=='/')      /* remove trailing slashes */
	{
		temppath[len-1]='\0';
		len=strlen(temppath);
	}
	strcpy(newpath,temppath);

	/* remove the single preceeding slash, if there is one after the removal of ROOTSTR */

	if(temppath[0]=='/')
	{
		for(loop=1;loop<strlen(temppath);loop++)
			newpath[loop-1]=temppath[loop];
		newpath[strlen(temppath)-1]='\0';
	}

	strcpy(temppath,newpath);

	zdebug1("In FixPath().  returning: %s\n",newpath);

/*
	if(newpath[0]=='\0')
		return("");
	else

*/
		return(newpath);
}










/* FreeSummaries() - This function traverses a linked list of summary structures
	in order to free all dynamically allocated structures...prevents massive
	memory leak.

	Author: Luke Sheneman				11/15/92

		This function is trivial and appears to work.

*/

int FreeSummaries(summaryhead)
Summary *summaryhead;
{
	Summary *p,*t;

	cld_errno=0;

	t=summaryhead;
	if(!t)
		return(False);
	else
	{
		while(t)
		{
			p=t->next;
			free(t);
			t=p;
		}
		summaryhead=NULL;
		return(True);
	}
}












/* SortSummaries() - This function sorts a list of summary structures 
	based upon their PRID's.  Added functionality needs to be added
	so problems are also sorted by time of day.


	Author:  Luke Sheneman.				Date:  11/21/92

*/


Summary *SortSummaries(unsorted)	/* Selection Sort (easiest to implement) */
Summary *unsorted;
{
	Summary *ts,*oldest_summary,*sorted=NULL;
	char oldest_prid[MAXPRID];
	int flag=True;

	if(!unsorted)	/* unsorted was EMPTY! */
		return(unsorted);

	oldest_summary=NULL;

	while(flag==True)
	{
		ts=unsorted;
		strcpy(oldest_prid,"9999999999999");
		while(ts)
		{
			if(CompPrid(oldest_prid,ts->prid)>0)	/* CompPrid() (1 = second older) */
			{
				oldest_summary=ts;
				strcpy(oldest_prid,ts->prid);	
			}
			ts=ts->next;	
		}
		if(!strcmp(oldest_summary->prid,"9999999999999"))
			flag=False;
		else
		{
			sorted=AddSortedSummary(sorted,oldest_summary);
			strcpy(oldest_summary->prid,"9999999999999");
		}
	}

	FreeSummaries(unsorted);
	unsorted=NULL;
	return(sorted);
}











/*  AddSortedSummary() - This function adds a sorted summary structure to the 
	end of a list of summary structures.
	
	Author:  Luke Sheneman				Date:  11/12/92


		This function works...

*/

Summary *AddSortedSummary(head,oldest_summary)
Summary *head;
Summary *oldest_summary;
{
	Summary *t=NULL,*temp=NULL;

	if(!head)
	{
		if(!t)
			t=(Summary *)malloc(sizeof(Summary));
		strcpy(t->path,oldest_summary->path);
		strcpy(t->prid,oldest_summary->prid);
		strcpy(t->summary,oldest_summary->summary);
		t->status=oldest_summary->status;
		t->next=NULL;
		
		return(t);
	}
	else
	{
		t=head;
		while(t->next)
			t=t->next;
		if(!temp)
			temp=(Summary *)malloc(sizeof(Summary));
		strcpy(temp->path,oldest_summary->path);
		strcpy(temp->prid,oldest_summary->prid);
		strcpy(temp->summary,oldest_summary->summary);
		temp->status=oldest_summary->status;
		t->next=temp;
		temp->next=NULL;

		return(head);
	}
}











/* FreeList() - This function frees a dynamically allocated array of
	strings.  

	Author:  Luke Sheneman.				Date:  12/05/92

		This should work fine...can't tell if it really does, but
			it doesn't crash or cause any related problems.
			
*/


void FreeList(list)
char *list[];
{
	int loop=0;

	zdebug("In FreeList()\n");	/* Changed 2/14/94 DC */

	while( list[loop] )
		free(list[loop++]);	
}
