.TH zdbm 3 "22 July 1995" "Zombie Software" "PTS version 1.1a2"
.SH NAME
.IP "zdbm - " 7
database library for the Problem Tracking System
(Zombie Database Manager).
.SH SUMMARY
.I PTS
is a database tool which is used to improve communication
between system users and support personnel about problems encountered
with the system.
.I ZDBM
is the underlying database library for
.I PTS.
It should not be confused with dbm, ndbm or dbz.
.PP
.I PTS
application developers should probably build their software on top
of the Cloud library (included with
.I PTS)
rather than directly on top of
.I ZDBM.
.SH SYNOPSIS
.nf
#include "zdbm.h"

char *add_problem(reporter_record, *rep_rec,
                  char *problem_description,
                  char *short_description, char *db_path);

char *add_reporter(char *db_path, char *prid,
                   reporter_record *rep_rec);

char *confirm_reopen(char *reopen_prid, reporter_record *rep_rec,
                     char *sys_string, char *reasons);

int delete_problem(char *db_path, char *prid, int permissions);

int deny_reopen(char *reopen_prid);

edit_record *edit_info(char *db_path, char *prid);

int edit_log(char *db_path, char *prid, char *mod_log, int mode);

problem_record *get_problem(char *db_path, char *prid, int type,
                            int direction, int links,
                            int whole_record);

int link_problem(char *old_db_path, char *new_db_path, char *prid);

int move_problem(char *old_db_path, char *new_db_path, char *prid);

int remove_edit(char *db_path, char *prid);

int request_reopen(char *db_path, char *prid, char *reasons,
                   reporter_record *rep_rec);

int solve_problem(char *db_path, char *prid);

reopened_record *view_reopen(char *reopen_prid, int whole_record);

char *zdbm_strerror(int zerror);
.fi

.SH STRUCTURE DEFINITIONS
.sp 1
structure for a reporter record:
.sp 1
.nf
typedef struct
{
   char account_name[MAXNAMELEN];  /* the name of the reporter */
   char node_name[MAXHOSTNAMELEN]; /* the name of the machine the
                                    * problem is on */
   char date_time[MAXNAMELEN];     /* the date and time the report
                                    * was made */
} reporter_record;
.fi
.sp 2
structure for a problem record:
.sp 1
.nf
typedef struct
{
   char prid[MAXPRID];       /* the problem id of this problem */
   int  status;              /* the status of the problem,
                              * SOLVED, UNSOLVED or REOPENED*/
   char short_description[MAXSUMLEN];/* the short description for
                                      * this problem */
   int  num_rep;             /* the number of reporter records */
   reporter_record *reporter_list;   /* an array of reporter records*/
   int  num_old_rep;         /* number of old reporter records */
   reporter_record *old_reporter_list;
   char *log_file;           /* the log file */
   void *reop_rec;           /* points to the reopened record, if
                              * the problem has been reopened, NULL
                              * otherwise */
} problem_record;
.fi
.sp 2
structure for a reopened record, what is returned by view_reopen():
.sp 1
.nf
typedef struct
{
   char prid[MAXPRID];       /* the problem id of the reopened
                              * record */
   char db_path[DBPATHLEN];  /* the db_path to the problem that is to
                              * be reopened */
   char *reasons_log;        /* the data in the file containing
                              * the reasons */
   reporter_record rep_rec;  /* the person that requested that the
                              * problem be reopened */
   problem_record *pro_rec;  /* the problem record of the reopened
                              * problem */
} reopened_record;
.fi
.sp 2
structure for the edit information:
.sp 1
.nf
typedef struct
{
   int  ef;                       /* whether the problem is currently
                                   * being edited (TRUE or FALSE) */
   char account_name[MAXNAMELEN]; /* the name of the user doing the
                                   * edit */
   char node_name[MAXHOSTNAMELEN];/* the name of the machine the
                                   * PTS is running on */
   int pid;                       /* the process id of the PTS
                                   * running the edit */
} edit_record;
.fi

.SH FUNCTION DESCRIPTIONS

.I ADD_PROBLEM --
.br
This function will add a new problem to the PTS data base.
If the leaf of the problem tree given does not exist then zdbm will create
the leaf and the problem given will be the first one in the new leaf.

If the problem is added successfully a pointer to the new problem id is
returned, otherwise NULL is returned and the error code is placed in
db_errorno.  The value returned points to static storage and is overwritten
each time add_problem() is called.  If the problem can not be added every
effort is made to return the data base to the same state it was in before
the problem was added.

Parameter descriptions:
.br
.IP rep_rec 10
.br
points to the reporter record of the person who reported
the problem being added.
.br
.IP problem_description 10
contains a description of the problem, this is treated
as a NULL terminated character string.
.br
.IP short_description   10
contains a short description of the problem, this is
a NULL terminated character string.
.br
.IP db_path 10
the path to the leaf that the problem will reside in -
ie PTSROOT/Software/Mail/Elm.
.PP

.I ADD_REPORTER
.br
This function will add a reporter to the list of reporters
for a particular problem.

If the  reporter is added to the list the problem id of the original problem
will be returned (if the problem id given the function is a linked problem
then the problem id of the ultimate parent will be returned).  If the reporter
is already listed or an error occurs then NULL is returned and the error code
is placed in db_errorno.  The pointer returned points to static storage and
is overwritten each time add_reporter() is called.

Parameter descriptions:
.br
.IP db_path 10
the path to the leaf that the problem will reside in - ie
PTSROOT/Software/Mail/Elm.
.br
.IP prid 10
the problem id of the problem to add the reporter too.
.br
.IP rep_rec 10
the reporter record for the person to add to the list of reporters.
.PP

.I CONFIRM_REOPEN
.br
This function will reopen a currently solved problem.  This
is usually called by a sysop.  If a user wishes to reopen a problem the
reasons for the problem to be reopened, along with a reporter record for
that person, the problem id and the location of the problem to be reopened are
placed in a special leaf of the problem tree.  If the sysop feels the problem
should be reopened then this function is used to mark the problem as reopened
which creates an "old reporters list" (containing the reporter records of the
people who had previously reported the problem), creates a new reporters list
(containing the reporter record of the person wishing to reopen the problem),
and adds the name of the sysop who authorized the reopening and the reasons
for reopening the problem to the problem log.  The problem is then removed
from the special reopen leaf of the problem tree.

If the problem is reopened successfully then the problem id of the original
problem is returned (if the problem given is a linked problem then the
ultimate parent's id is returned).  The pointer returned points to static
storage that is overwritten each time confirm_reopen() is called.  If there
was an error during the process then every effort is made to return the data
base to the state it was in before the problem was reopened, NULL is returned
and the error code is placed in db_errorno.

Parameter descriptions:
.br
.IP reopen_prid 10
problem id of the reopen request.
.br
.IP rep_rec 10
reporter record for the person requesting the problem be
reopened.
.br
.IP sys_string 10
about the sysop authorizing the problem to be
reopened.  Zdbm makes no determination as to what the
information is, it is treated as a NULL terminated string.
Examples of information that may be helpful are; the name of
sysop confirming the reopen and the data and time of the
reopen.
.br
.IP reasons 10
reasons why the reporter would like the the problem
reopened.  This is treated as a NULL terminated string.
.PP

.I DELETE_PROBLEM
.br
This function removes a problem from the data base.  If the
problem happens to be the ultimate parent in a series of linked problems then
the permission parameter must be set to DELETEOK in order for the problem
to be removed from the data base.  This is because the deletion of an ultimate
parent will result in the deletion of all of it's children from the data base.

It is advisable to make the first call to this function with the permission
set to DELETENOTOK.  In this case if the problem to be deleted is an
ultimate parent then an error will be signaled (error code is LINKERR) and the
problem will not be deleted, the calling program can then confirm that the
user wishes to remove the parent before it is actually removed.  If on the
other hand the problem to be deleted is not an ultimate parent then it will be
removed from the data base.

If the deletion is successful then SUCCESS is returned, otherwise FAIL is
returned and the error code is placed in db_errorno.  If an error occurs
during the process then every effort is made to leave the data base in a
consistent state.  This may mean that the problem is not removed or that
only part of the problem is removed.  In the latter case, as far as
zdbm is concerned the problem no longer exists and any portions of the problem
that remain in the data base can not be reached - ie it is taking up space,
but has no effect on searches.

Parameter descriptions:
.br
.IP db_path 10
path to the leaf that the problem to be deleted resides in.
.br
.IP prid 10
problem id of the problem to be deleted.
.br
.IP permissions 10
permission flag to use (DELETEOK, DELETENOTOK, see above)
.PP

.I DENY_REOPEN
.br
This function is used if the sysop does not think that a problem
that has been requested for reopening should be.  After a call to this
function the reopen request will no longer exist in the special reopen leaf,
and the problem will remain solved.

If the request is removed then SUCCESS is returned, otherwise FAIL is returned
and the error code is placed in db_errorno.  If an error occurs during the
removal then every effort is made to ensure that the data base is in a
consistent state.  In the event of an error then either the request is not
removed or only part of the request is removed.  In the latter case, those
portions of the request left in the data base can not be accessed - ie
they take up space, but cannot be acted upon by zdbm.

Parameter description:
.br
.IP reopen_prid 10
the problem id of the reopen request.
.PP

.I EDIT_INFO
.br
This function returns information about a problem that is
currently being edited.  This is used in the event that an incarnation of
PTS is killed (or dies) while a sysop is editing a problem.  In this case the
edit lock may not be removed.  The information returned will allow a sysop to
determine if this is the case.  The sysop can then call the remove_edit()
function to remove the edit lock if it is determined that the process that
holds the lock is no longer running.

If the call succeeds then a pointer to an edit record is returned, otherwise
NULL is returned and the error code is placed in db_errorno.

Parameter descriptions:
.br
.IP db_path 10
path to the data base leaf that contains the problem to get
information about.
.br
.IP prid 10
problem id of the problem to get information about.
.PP

.I EDIT_LOG
.br
This function either begins or ends an edit session on the problem
id passed in depending on the value of mode. If mode is START then an edit
session is started and the problem is locked so no other process can edit
that problem.  If the problem given is a linked problem, then the edit lock
will be placed on the ultimate parent of the problem.  The problem itself
will still be readable by other zdbm processes.

If the mode is END then mod_log points to the modified problem log, which
overwrites the existing problem log for the problem given (the ultimate
parent if the problem given is linked) and the edit lock is removed.

The calling program MUST get the problem record using the get_problem()
function before it can be edited since edit_log() only performs problem
locking and unlocking.

If the call succeeds then SUCCESS is returned otherwise FAIL is returned
and the error code is placed in db_errorno.  If an error occurs while ending
an edit session then every effort is made to leave the data base in the state
it was prior to the edit being started - the problem log remains unchanged
and the current process still owns the edit lock.

Parameter descriptions:
.br
.IP db_path 10
path to the data base leaf that the problem to edit resides in.
.br
.IP prid 10
problem id of the problem to edit.
.br
.IP mod_log 10
a pointer to the modified problem log (a NULL terminated character
string) if mode is END, NULL otherwise.
.br
.IP mode 10
mode of the edit (START or END).
.PP

.I GET_PROBLEM
.br
This function is used to get a problem from the PTS data base.
There are three types of problems returned;

.ti 10
1.  The next unsolved problem (in the leaf given)
.ti 10
2.  The next solved problem (in the leaf given)
.ti 10
3.  A particular problem (with the prid given,
.ti 10
    in the leaf given)
.fi

depending on the value of type.  If the links parameter is set to LINKS then
the ultimate parent of a linked problem is returned.  If links is set to
NOLINKS then linked problems are ignored during a search.  If the caller
requested a particular problem then the links parameter is ignored and the
ultimate parent of a linked problem is returned.

If the whole_record parameter is set to PARTIALRECORD then only the following
fields of a problem record have meaning;

.IP prid 10
problem id that was found
.br
.IP sf 10
the problem is solved, unsolved or reopened
.br
.IP short_description 10
a short description of the problem
.PP

All the other fields are either set to 0 or NULL.

If the whole_record parameter is set to FULLRECORD then all the fields of
the problem record returned have meaning.

The two searches can be thought of as searching a circular linked list, in
that as long as the leaf to search does not change then the problem returned
will be the next (un)solved problem in that leaf.  It is up to the calling
program to determine when the head of the list is returned by get_problem().
If the leaf specified in the current call to get_problem() is not the same
as the last call to get_problem() then a new search is started and the head
of the list of problems for the new leaf is returned.  Using these search
methods a calling program can return all the (un)solved problems in a leaf
or the entire problem tree.

The direction parameter has no effect currently and is ignored.  In future
versions of zdbm it will be used to change the direction of the search -
ie either forward from the current position in the list or backward from the
current position.

If the call succeeds then a pointer to a problem record is returned, otherwise
null is returned and the error code is placed in db_errorno.  The pointer
points to a static record that is overwritten each time get_problem() is
called.

Parameter descriptions:
.br
.IP db_path 10
the leaf path to search.
.br
.IP prid 10
problem id of the problem to find if searching for a
particular problem, ignored otherwise (should be set to NULL).
.br
.IP type 10
type of search to perform, UNSOLVED, SOLVED or PARTICULAR
depending on what type of problem the caller wants respectively.
.br
.IP direction 10
implemented in the current version, ignored (should be set to NULL).
.br
.IP links 10
whether or not searches follow links (LINKS, NOLINKS), ignored
if type is PARTICULAR.
.br
.IP whole_record 10
whether the calling program wants to return the entire problem
record or only part (see above).
.PP

.I LINK_PROBLEM
.br
This function links a problem to more than one problem leaf.
The problem being linked will appear to be in multiple leaves of the problem
tree, although it will reside in only one leaf (the leaf that contained the
original problem).  If the problem given to link to is itself a linked (child)
problem then the new child problem will point back to the original or ultimate
parent of the current problem.  If the new leaf does not exist then it is
created by zdbm and the child problem is the first problem in the new leaf.
If the problem already resides in the new leaf (either as a child or ultimate
parent) then an error is signaled.  This function is useful if a particular
problem could logically reside in more than one problem leaf.

If the linking is successful then SUCCESS is returned, otherwise FAIL is
returned and the error code is placed in db_errorno.  If the process fails
then every attempt is made to ensure that the data base is the same state is
was in before the linking was attempted.

Parameter descriptions:
.br
.IP old_db_path 10
the data base path to the leaf the original problem resides in.
.br
.IP new_db_path 10
the data base path to the leaf to place the child problem in.
.br
.IP prid 10
problem id of the problem (parent) to link.
.PP

.I MOVE_PROBLEM
.br
This function will physically move a problem from one leaf
to another.  After a successful call to this function the problem will no
longer reside in its original leaf.  This call is useful if a user placed
a problem in an improper leaf.

If the move is successful then SUCCESS is returned, otherwise FAIL is returned
and the error code is placed in db_errorno.  If an error occurs during the
move every attempt is made to ensure that the data base is returned to the
same state as it was before the move.  It is possible, however for the
original problem to not be removed from the data base if an error occurs.  For
this reason it is advisable to check the leaves to see if the problem exists
in both leaves and to remove it from the original leaf if it does.

Parameter descriptions:
.br
.IP old_db_path 10
the data base path to the leaf that contains the problem to
move.
.br
.IP new_db_path 10
the data base path to the leaf to move the problem to.
.br
.IP prid 10
problem id of the problem to move.
.PP

.I REMOVE_EDIT
.br
This function is used to to remove an edit lock from a problem.
It is used when a process dies while it was editing a problem.  Since this
function will remove the edit lock even if the process that holds the lock
is still active care should be taken when using this function.  The
edit_info() function should be called prior to a call to this function, so
the sysop can check to see if indeed the process that holds the edit lock
is inactive.

If the edit lock is removed SUCCESS is returned, otherwise FAIL is returned.
If an error occurs during the removal the edit lock will still be active.

Parameter descriptions:
.br
.IP db_path 10
data base path that contains the problem to remove the edit
lock from.
.br
.IP prid 10
problem id of the problem to remove the edit lock from.
.PP

.I REQUEST_REOPEN
.br
This function is used to request that a solved problem be
reopened, or set to unsolved.  This is used if a problem reoccurs or the
fix used before has proved to be inadequate. 

When a problem is reopened the information is placed in a special data base
leaf until a sysop looks at the request and either grants or denies it.

If the function succeeds in placing the request in the special leaf then
SUCCESS is returned, otherwise FAIL is returned and the error code is placed
in db_errorno.  If an error occurs during the process then every effort is
made to restore the data base to the state it was in before the function
was called - ie the request is removed from the reopen leaf.

Parameter descriptions:
.br
.IP db_path 10
the data base path to the leaf containing the problem to reopen.
.br
.IP prid    10
the problem id of the problem to reopen.
.br
.IP reasons 10
the reasons for reopening the problem, treated as a NULL terminated
character string.
.br
.IP rep_rec 10
the reporter record of the person who is requesting that the problem
be reopened.
.PP

.I SOLVE_PROBLEM
.br
This function is called when a problem in the data base has
been solved.  It essentially marks the problem as solved.  If the problem
given is a linked problem then the ultimate parent is also marked as solved
and any children will be updated.  In addition a solved problem as returned
by get_problem() has no reporters_list (its value is NULL).  Solved problems
do however have an old_reporters_list which is returned by get_problem().

If the call succeeds then SUCCESS is returned, otherwise FAIL is returned and
the error code is placed in db_errorno.  If the call fails every attempt is
made to return the data base to a consistent state - ie the problem remains
unsolved.

Parameter descriptions:
.br
.IP db_path 10
the data base path of the leaf containing the problem that has been
solved.
.br
.IP prid 10
the problem that is to be marked as solved.
.PP

.I VIEW_REOPEN
.br
This function allows a sysop to view a problem that has been
requested for reopening.  In this way a sysop can read the reasons why the
problem should be reopened along with the problem log of the original problem.

If the reopen_prid parameter is NULL then view_reopen() returns the next
reopen request in the reopen leaf.  This is similar to searching for the
next (un)solved problem using get_problem().  As such the values returned
can be thought of as nodes in a circular linked list.  It is up to the
calling program to determine when the head of the list reached.

If the reopen_prid is not NULL then view_reopen() will return the
reopen_record that corresponds to the reopen problem id that is given.

Since the reopen_record contains a problem_record (as returned by
get_problem() the caller has the choice of getting a partial or complete
problem_record by specifying the appropriate value (see get_problem()
for more details).

If the call succeeds then a pointer to a reopened_record is returned.  If
there are no reopen requests pending or an error occurs then NULL is returned.
The pointer returned points to static data that is overwritten each time
either view_reopen() or get_problem() is called.

Parameter descriptions:
.br
.IP reopen_prid 10
reopen problem id of the request to find, NULL if looking
for the next request.
.br
.IP whole_record 10
whether or not the reopened_record returned contains a
complete or partial problem record (see get_problem()).
.PP

.I ZDBM_STRERROR
.br
This function is similar to the system call strerror() in that
it returns a character string that is terminated with a newline (\\n) followed
by a NULL character that corresponds to the value that is passed in. 
The character strings give a brief description of what the error code
corresponds to.

A pointer to a string is always returned.  If the value passed in is out of
range for any error code that zdbm knows about the string "Unknown ZDBM error
code.\\n" is returned.  Zdbm knows about most system error codes as well as
db_errorno codes.  Any error code below the value stored in
END_OF_ZDBM_ERROR_CODES will be recognized by zdbm_strerror().

Parameter description:
.br
.IP zerror 10
the value of db_errorno.
.PP

.SH MORE INFORMATION
.I PTS
is distributed with a very large amount of documentation, including
the Software Requirements Specification, the Software Design Document
and the manual pages.
.SH SEE ALSO
pts(1), ptsager(1M), pts.cf(8), xpts(1), newprob(1).
.SH AUTHORS
The Problem Tracking System was originally designed by
.I Zombie Software
at the University of Idaho.
The
.I ZDBM
database library was designed and implemented by Chris Hyde.
See
.I pts(1)
for more information.
.sp 1
.SH COPYRIGHT
Copyright (c) 1995,1994,1993,1992 Dean Collins, Chris Hyde, Luke Sheneman,
Brian Goff, and John Hunter.
.br
Copyright (c) 1992 University of Idaho, Moscow, Idaho.

