.TH pts.cf 8 "22 July 1995" "Zombie Software" "PTS version 1.1a2"
.SH NAME
pts.cf - Problem Tracking System configuration file
.SH DESCRIPTION
.I PTS
is a database tool which is used to improve communication 
between system users and support personnel about problems encountered
with the system.
.I pts.cf
is the configuration file for 
.I PTS.
Among other things, it specifies what problem types are available,
and who should receive mail from
.I ptsager.
.PP
Any 
.I xpts
or 
.I ptsager
processes running before you make changes to the
.I pts.cf
file will not see your changes.
.SH CONFIG FILE FORMAT
Lines in the configuration file fall into the following categories:

.IP "problem-type line --" 10
Specifies a
.I leaf
in the problem tree.  Problems are organized into a tree structure,
rather like a directory structure.  Problems can only be reported into
leaves of the problem tree.  These lines are used to enumerate all the
leaves in the tree.
It's format is:
.br
.ti 20
.sp 1
leaf:   /type/subtype/subtype.../leaf\\n
.sp 1
The string "leaf:" is used to identify a problem-type leaf line,
and is optional in this version of
.I PTS.
Type and subtype cannot contain spaces, or the "/", ",", or "#"
characters.  Leaves cannot, by definition, have subtypes.
.sp 1
Some examples of problem-type lines are:
.sp 1
.ti 20
leaf:   /Software/Mail/elm
.br
.ti 20
leaf:   /Software/Mail/tin
.br
.ti 20
leaf:   /Hardware/Keyboard
.br
.ti 20
leaf:   /Hardware/Mouse
.br
.ti 20
leaf:   /Other
.sp 1
.I PTS
is case sensitive.  However you type your problem types
is 
.I exactly
how they will be displayed by
.I xpts
and referenced by the rest of the 
.I PTS
system.
Care must be taken not to enter things like "/Foo/Bar" and "/foo/Car".
"Foo" is not the same as "foo" and will result in both "Foo" and "foo"
being added to the problem tree (and confusing all your users).
.sp 1
There is no effective limit to the number of leaves or to the tree's depth.
.sp 1
.IP "mail line --" 10
Specifies a user to send mail to whenever 
a problem gets over a certain number of days old.
It's format is:
.br
.ti 20
.sp 1
mail: user days\\n
.sp 1
OR
.br
.ti 20
.sp 1
mail: user days list\\n
.sp 1
user -- The e-mail address of the person to notify.  This address may
contain alphanumerics and the characters "@", "%", "!", ".", "-" and "_".
.sp 1
days -- An integer number of days.
.sp 1
list -- Used to specify portions of the problem tree.
.sp 1
If the list is specified, only unsolved problems in the listed
parts of the problem tree will be mentioned in the 
.I ptsager
report.
This field is a comma seperated list of problem types.
These do
.I NOT
need to be leaves in the problem tree; any location in the tree
will do.  For example, the following would send mail to the user "bilbo"
about problems in either "/Software/Mail" or "/Software/News" that
are three days old:
.sp 1
.ti 20
mail: bilbo 3 /Software/Mail,/Software/News
.sp 1
There is no effective limit to the number of "mail:" lines you can have
in your configuration file, or to the number of tree paths you can list.
Also, identical users may appear on multiple mail lines.
Each line of the mail list is considered seperatly when generating reports.
.sp 1
.IP "mailer line --" 10
(not to be confused with a "mail:" line.)  Specifies the e-mail program
.I PTS
uses to send e-mail.  It's syntax is:
.sp 1
.ti 20
mailer:    fullpath\\n
.sp 1
fullpath should specify the complete path to your e-mail program,
such as "/usr/bin/mail" or "/usr/lib/sendmail".  The default mailer
is usually sendmail.  If you don't use sendmail, e-mail to problem
reporters cannot be sent to remote hosts (as in "user@host").
It will be delivered on whatever host
.I xpts
or
.I ptsager
is run on.
For this reason, sendmail is recommended.  Also, if you don't use
sendmail, whatever e-mail command you choose must have a command-line
method of specifying the subject.
If this line appears in the configuration file more than once
only the last occurance will be used.
.sp 1
.IP "mailer_opts line --" 10
Specifies the command-line options to use with the e-mail program
specified in the "mailer:" line.  It's syntax is:
.sp 1
.ti 20
mailer_opts:    options\\n
.sp 1
If "mailer:" is set to sendmail (as recommended), this should
probably be "-t".
.sp 1
If you are using some other e-mail program, this should probably
be "-s", the subject flag.  If, however, your e-mail program
uses something other than "-s" to specify the subject you will
need to set mailer_opts to be the appropriate value.
Whatever option(s) you specify, the last option must be the one used
for the subject (when not using sendmail).
.sp 1
If this line appears in the configuration file more than once
only the last occurance will be used.
.sp 1
.IP "printer line --" 10
Specifies the printer command
.I PTS
uses to print files.  It's syntax is:
.sp 1
.ti 20
printer:    fullpath\\n
.sp 1
fullpath should specify the complete path to your print program,
such as "/usr/bin/lp".
If this line appears in the configuration file more than once
only the last occurance will be used.
.sp 1
.IP "printer_opts line --" 10
Specifies the command-line options to use with the printer program
specified in the "printer:" line.  It's syntax is:
.sp 1
.ti 20
printer_opts:    options\\n
.sp 1
The default value of options is "", an empty string.
If this line appears in the configuration file more than once
only the last occurance will be used.
.sp 1
.IP "sysops line --" 10
Specifies a set of users who should be considered "sysops", regardless
of whether they are in the "sysop" group.
It's syntax is:
.sp 1
.ti 20
sysops:    user1 user2 user3 ...\\n
.sp 1
If this line appears in the configuration file more than once
the lists will be merged.
.PP
In addition, the following may be in the configuration file:
.IP "comments --" 10
Anything after and including the # character is ignored.
.IP "blanks --" 10
Spaces, tabs, and newlines are ignored wherever there are not required.
.IP "continuations --" 10
If a line ends with a backslash character "\\" the line it appears
on and the following line will be considered as one line.
Continuations are ignored within comments.
.SH MODIFICATIONS
.sp 1
The problem tree hierarcy is
easy to add to but more difficult to change after
.I PTS
has been used.  Care should be taken in specifying a problem tree.
.SH SAMPLE CONFIG FILE
.sp 1
.nf
# /usr/local/lib/PTS/pts.cf
# This is the config file for the Problem Tracking System (PTS).
#
#
############################################################
# 
mailer:       /usr/lib/sendmail #What mail prog. to use?
mailer_opts:  -t                #And it's command-line opts?
printer:      /usr/bin/lpr      #What print prog. to use?
printer_opts:  -Plj             #And it's command-line opts?

############################################################
#Sysop list goes here... (optional)
#
sysops:   dean chris sheneman brian hunter874 
sysops:   simon johnd

############################################################
#Mail list goes here...
#                           
#      e-mail              
#      address          age problem types list (opt.)
#====  ================ === =================================
mail:  dean              2
mail:  dean%foo@bar.com  1  /Software/Mail, /Software/News
mail:  simon             4
mail:  sirocco@gaea.com  2  /Software/PTS, \\
                            /Software/Programming, \\
                            /Software/X-Windows-System/Programming
mail:  simon             1  /Hardware
mail:  johnd             7
mail:  zombie@cemetary   1  /Software/PTS


############################################################
# Problem types go here...
#   list leaves ONLY...
#   Case IS significant...

## Report PTS problems with PTS... What a concept!
leaf:  /Software/PTS/problems
leaf:  /Software/PTS/suggestions
leaf:  /Software/PTS/comments

leaf:  /Software/Editors/vi
leaf:  /Software/Editors/emacs
leaf:  /Software/Editors/Other

leaf:  /Software/Programming/C
leaf:  /Software/Programming/Pascal
leaf:  /Software/Programming/Fortran
leaf:  /Software/Programming/Scheme
leaf:  /Software/Programming/ML
leaf:  /Software/Programming/Other

leaf:  /Software/X-Windows-System/Usage
leaf:  /Software/X-Windows-System/Programming
leaf:  /Software/X-Windows-System/Other

leaf:  /Software/Network/Remote-Logins
leaf:  /Software/Network/File-Transfers
leaf:  /Software/Network/Other

#Note these two.  Often problems will be appropriate
#in multiple leaves.
leaf:  /Hardware/Modems
leaf:  /Software/Modems

leaf:  /Software/Shell/Korn-shell(ksh)
leaf:  /Software/Shell/C-Shell(csh)
leaf:  /Software/Shell/Bourne-Shell(sh)
leaf:  /Software/Shell/Aegis
leaf:  /Software/Shell/Other

leaf:  /Software/Login-Logout

leaf:  /Software/Mail/elm
leaf:  /Software/Mail/mail
leaf:  /Software/Mail/mh
leaf:  /Software/Mail/xmh
leaf:  /Software/Mail/sendmail
leaf:  /Software/Mail/Other

leaf:  /Software/Other

leaf:  /Hardware/Printer
leaf:  /Hardware/Keyboard
leaf:  /Hardware/Display
leaf:  /Hardware/Mouse
leaf:  /Hardware/Tape-Drive
leaf:  /Hardware/Hard-Drive
leaf:  /Hardware/Network
leaf:  /Hardware/X-Terminal
leaf:  /Hardware/Other

leaf:  /Other

################ END OF pts.cf #############################
.fi
.SH FILES
/usr/local/lib/PTS --
.I  PTS
library files.
.br
/usr/local/lib/PTS/pts.cf --
.I  PTS
configuration file.
.br
/usr/local/lib/PTS/DB --
.I  PTS
database.
.SH SEE ALSO
pts(1), xpts(1), ptsager(1M), newprob(1), zdbm(3).
.SH AUTHORS
The Problem Tracking System was originally designed by
.I Zombie Software
at the University of Idaho.
The configuration file parser was designed and implemented by Dean Collins,
with a little help from Luke Sheneman.  See
.I pts(1)
for more information.
.sp 1
.SH COPYRIGHT
Copyright (c) 1995,1994,1993,1992 Dean Collins & Chris Hyde.
Copyright (c) 1992 Luke Sheneman, Brian Goff, and John Hunter.
.br
Copyright (c) 1992 University of Idaho, Moscow, Idaho.

