/* Copyright (c) 1995 Dean Collins */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */

#include "CURcurses.h"
#include "text.h"
#include "cpts.h"

char *PickProbMenuHelp[]={
        "b=blah, x=extra blah, o=options, /=search",
        "j=line down, k=line up, q=quit",
        NULL} ;

char *ProbSelMenuHelp[]={
        "b=blah, x=extra blah, o=options, /=search",
        "j=line down, k=line up, q=quit",
        NULL} ;


int PickProblemMenu(CursesObjp cur, WINDOW *win, UserInfo *UserInfoRecp,
		    ProblemTree *ProbTree, char *OldPath, int OldItem)
{
   ScnRec *scnrec=NULL ;
   WINDOW *PickPMenu=NULL ;
   WINDOW *ProbSelMenu=NULL ;
   int CurItem=0 ;
   int done=0 ;
   int Selection=0 ;
   char Path[DBPATHLEN+1] ;
   char **ProblemItems=NULL ;
   int status=0 ;
   int i=0 ;
   char tmpstr[DBPATHLEN+20] ; /* 20 is an arbitrary size.  Must be long enough
				* to contain "Pick Problem (...)".
				*/
   int maxlen=0 ;
   problem_record *ProblemRecord=NULL ;
   Summary *CloudSummaries=NULL ;
   char **NewList=NULL ;
   int flag=0 ;
   char **SummaryItems=NULL ;

#ifdef DEBUG
   fprintf(stderr,"Entering PickProblemMenu()\n") ;
#endif
   
   strcpy (Path, OldPath) ;

   scnrec = NewScnRec() ;
   scnrec->Title1 = "CPTS v.0.0" ;
   maxlen = cur->COLS - 40 ;

   ProblemItems = (char **)calloc(MAXBRANCHES, sizeof(char *)) ;
   for (i=0; i<MAXBRANCHES; ++i)
   {  ProblemItems[i]    = (char *)malloc(DBPATHLEN) ;
      ProblemItems[i][0] = '\0' ;
   }




#ifdef DEBUG
   fprintf(stderr,"PROBLEMITEMS=%p\n", ProblemItems) ;
   fprintf(stderr,"Calling FormatProblemTypes()...\n") ;
#endif

   if (strlen(Path) == 0)
   {
      strcpy(Path, ROOTSTR) ;
/*CLD*/   status = FormatProblemTypes(ProbTree, Path, 0, ABS_TYPE, ProblemItems) ;
   }
   else
/*CLD*/   status = FormatProblemTypes(ProbTree, Path, OldItem, INC_TYPE, ProblemItems) ;

#ifdef DEBUG
   fprintf(stderr,"PickProblemMenu(): Returned from FormatProblemTypes()...Path=%s\n",Path) ;
   fprintf(stderr,"PickProblemMenu(): FormatProblemTypes status is %d\n", status) ;
fprintf(stderr,"PickProblemMenu(): Removing extra ProblemItems strings\n") ;
#endif


   /* Remove extra Items strings with free().*/
   if (ProblemItems!= NULL)
      for (i=0; i<MAXBRANCHES; ++i)
      {  if (ProblemItems[i] != NULL)
            if (ProblemItems[i][0] == '\0')
            {  free(ProblemItems[i]) ;
               ProblemItems[i]=NULL ;
            }
      }
#ifdef DEBUG
   fprintf(stderr,"PickProblemMenu(): Done removing extra Items strings with free\n") ;

   for (i=0; ProblemItems[i] != NULL; ++i)
   {  fprintf(stderr,"PickProblemMenu(): ProblemItems[%d]=%p\n",i, ProblemItems[i]) ;
      fprintf(stderr,"PickProblemMenu(): ProblemItems[%d]='%s'\n", i, ProblemItems[i]) ;
   }
   fprintf(stderr,"PickProblemMenu(): ProblemItems[%d] is NULL\n", i) ;

#endif




   if (status < 0)      /* Error in problem-type path */
   {   /* Might be an error, might be a summary selection.
        * Call ReadProblem to decide.  If it returns NULL there
        * was an error.
        */
#ifdef DEBUG
      fprintf(stderr,"PickProblem(): FormatProblemTypes() returned an error,\t(OK, if already at a leaf).\n") ;
#endif
      strcpy(OldPath, Path) ; /* Save the Path */
#ifdef DEBUG
      fprintf(stderr,"PickProblem(): Calling ReadProblem() in cloud...\n") ;
#endif
/*CLD*/      ProblemRecord=ReadProblem(ProbTree, Path, CurItem, CloudSummaries) ;
#ifdef DEBUG
      fprintf(stderr,"PickProblem(): Returned from ReadProblem()...ProblemRecord=%p\n",
             ProblemRecord) ;
#endif
      strcpy(Path, OldPath) ; /* Restore the Path, since ReadProblem */
			      /* will probably munge it up. */

      if (ProblemRecord == NULL)
      {  
#ifdef DEBUG
         printf("XPTS(misc.c): ReadProblem() returned a NULL\n") ;
#endif

         CURDialog(cur, "Error", "Problem nonexistent!") ;
        	/* Refresh main menu */
         touchwin(cur->Screen) ;
         wrefresh(cur->Screen) ;


      }
   }


        /**** NOT  A  LEAF ****/

   if (status > 0)
   {

      scnrec->Items = ProblemItems ;
      scnrec->Helptext = PickProbMenuHelp ;

      if (strlen(Path) < maxlen)
      {
         strcpy(tmpstr,"Pick Problem (/") ;
         strncat(tmpstr,FixPath(Path),DBPATHLEN) ;
         strcat(tmpstr,")") ;
      }
      else
      {  strcpy(tmpstr,"Pick Problem (...") ;
         strcat(tmpstr,StrTail(FixPath(Path),maxlen-3)) ; /* -3 for the "..." */
         strcat(tmpstr,")") ;
      }


      scnrec->Title2 = tmpstr ;

      PickPMenu = newwin(0,0,0,0) ; /* New full-screen window */
      CURwenter(cur,PickPMenu) ;
      wclear(PickPMenu) ;

      ListWin(cur, PickPMenu, scnrec->Title1, scnrec->Title2, "?=help",
	   scnrec->Items, scnrec->Helptext, 0) ;
      wrefresh(PickPMenu) ;

      while (!done)
      {  HilightItem(cur, PickPMenu, &CurItem, scnrec->Items, 2) ;
         Selection=GetSelection(cur,PickPMenu) ;
         done=DoPPSelection(&cur, PickPMenu, Selection, scnrec->Items, 2,
			    &CurItem, UserInfoRecp, ProbTree, Path) ;
         wrefresh(PickPMenu) ;

      }
      if (done > 0)
         Exit(cur,done) ;

      delwin(PickPMenu) ;


/*    FreeStrings(ProblemItems) ;*/


   }



        /**** IS  A  LEAF ****/

   if (status == 0)     /* No child types, only summaries exist */
   {

/*CLD*/ CloudSummaries = ReadSummaries(ProbTree, Path, &NewList) ;
#ifdef DEBUG
      fprintf(stderr,"PickProblem(): Returned from ReadSummaries()...\n") ;
#endif

#ifdef DEBUG
      if (NewList != NULL)
      {  for (i=0; NewList[i] != NULL; ++i)
         {  fprintf(stderr,"PickProblem(): NewList[%d]=%p\n",i, NewList[i]) ;
            fprintf(stderr,"PickProblem(): NewList[%d]='%s'\n", i, NewList[i]) ;
         }
         fprintf(stderr,"PickProblem(): NewList[%d] is NULL\n", i) ;
      } else fprintf(stderr,"PickProblem(): NewList is NULL\n") ;
#endif

      flag=0 ;
      if (NewList == NULL) flag=1 ;
      else if ((int) (NewList[0]) == (int)NULL) flag=1 ;

      if (flag)
      {  /* NO PROBLEMS! */
#ifdef DEBUG
         fprintf(stderr,"PickProblem(): No problems found \n") ;
#endif



      }
      else
      {
         /* if an empty list was not returned, set the value of list to
          * be NewList.
          */
         scnrec->Items = NewList ;
         scnrec->Helptext = ProbSelMenuHelp ;

         if (strlen(Path) < maxlen)
         {
            strcpy(tmpstr,"Problem Selection (/") ;
            strncat(tmpstr,FixPath(Path),DBPATHLEN) ;
            strcat(tmpstr,")") ;
         }
         else
         {  strcpy(tmpstr,"Problem Selection (...") ;
            strcat(tmpstr,StrTail(FixPath(Path),maxlen-3)) ; /* -3 for the "..." */
            strcat(tmpstr,")") ;
         }

         scnrec->Title2 = tmpstr ;

         ProbSelMenu = newwin(0,0,0,0) ; /* New full-screen window */
         CURwenter(cur,ProbSelMenu) ;
         wclear(ProbSelMenu) ;

         ListWin(cur, ProbSelMenu, scnrec->Title1, scnrec->Title2, "?=help",
	   scnrec->Items, scnrec->Helptext, 0) ;
         wrefresh(ProbSelMenu) ;

         while (!done)
         {  HilightItem(cur, ProbSelMenu, &CurItem, scnrec->Items, 2) ;
            Selection=GetSelection(cur,ProbSelMenu) ;
            done=DoVPSelection(&cur, ProbSelMenu, Selection, scnrec->Items, 2,
                               &CurItem, UserInfoRecp, ProbTree, Path,
				CloudSummaries) ;
            wrefresh(ProbSelMenu) ;

         }
         if (done > 0)
            Exit(cur,done) ;

         delwin(ProbSelMenu) ;

      }
      if (SummaryItems) FreeList(SummaryItems) ;
      SummaryItems=NewList ;
   }

#ifdef DEBUG
   fprintf(stderr,"Leaving PickProblemMenu()\n") ;
#endif
}
