/* Copyright (c) 1995 Dean Collins */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */

#include "CURcurses.h"
#include "text.h"
#include "cpts.h"


int DoPSSelection(CursesObj **CurMenup,
		  WINDOW *win,
		  int Selection, 
		  char **list,
		  int helplen,
		  int *CurItemp,
		  UserInfo *UserInfoRecp,
		  ProblemTree *ProbTree,
		  char *Path)
{
   CursesObj *CurMenu ;
   int CurItem ;

   CurMenu=*CurMenup ;
   CurItem=*CurItemp ;

#ifdef DEBUG
   fprintf(stderr,"Selection=%d\nSelection='%c'\n",Selection, Selection) ;
#endif

   switch (Selection)
   {    case 'q':
   	case 'Q': 
		return (1) ; /* done */

        case KEY_LEFT:
	case 'h':
		return (-1) ; /* previous screen */

        case KEY_UP:
	case 'k':
		--CurItem; HilightItem(CurMenu,win,&CurItem,list,helplen); break;

        case KEY_DOWN:
	case 'j':
		++CurItem; HilightItem(CurMenu,win,&CurItem,list,helplen); break;

/*
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
		CurItem = atoi(Selection) - 1 ;
		if (CurItem <0) CurItem = 0 ;
		HilightItem(CurMenu,win,&CurItem,list,helplen);
		break;
*/

        case KEY_RIGHT:
	case '\n':
	case 'l':
/*		PickProblemMenu(CurMenu, win, UserInfoRecp, ProbTree, Path, CurItem) ;
*/
			/* Refresh main menu */
		touchwin(win) ;
		wrefresh(win) ;
		break ;
   }

   *CurItemp = CurItem ;

   return 0 ;  /* not done */
}

