/* Test program #1 -- Text-Test */

/* Copyright 1993 Dean Collins */

#include <stdlib.h>
#include <stdio.h>              /* Standard input/output utilities hdr. file */
#include <sys/param.h>          /* System parameters header file */
#include "pts.h"
#include "zdbm.h"               /* Zombie Database Manager header file */
#include "cloud.h"              /* Nebulous Cloud header file */
#include "clouderror.h"         /* Nebulous Cloud error rtn. header file */
#include "config.h"             /* Config. file parser header file */
/*#include "util.h"*/


main(int argc, char *argv[])
{
   char *text ;
   char **UnsolvedList = NULL ;
   Summary *CloudUnSummaries = NULL ;
   ProblemTree *ProbTree ;
   UserInfo UserInfoRec ;
   int i,index ;
   char Path[100] ;
   problem_record * ProblemRecord ;

     /* Get information about the user and read the problem hierarchy. */
#ifdef DEBUG
   printf("calling Setup()...\n") ;
#endif
   printf("loading config file...\n") ;
/*CLD*/   if (Setup(&UserInfoRec, &ProbTree) == False)
   {  fprintf(stderr, "Error in configuration file %s !\n", CONFIGFILE) ;
      exit(1);
   }
#ifdef DEBUG
   printf("returned from Setup()...\n") ;
   printf("\tUserInfoRec.sysopflag = %d\n", UserInfoRec.sysopflag);
   printf("\tUserInfoRec.username  = %s\n", UserInfoRec.username) ;
   printf("\tUserInfoRec.realname  = %s\n", UserInfoRec.realname) ;
#endif

	/* Read all unsolved problems */
   printf("searching for all unsolved problems...\n") ;
   CloudUnSummaries = ReadUnsolvedSummaries(ProbTree, &UnsolvedList) ;

   if (!CloudUnSummaries)
	;

#ifdef DEBUG
   printf("Checking for NULL values\n") ;
   if (ProbTree == NULL) printf("ProbTree is NULL\n") ;
   if (CloudUnSummaries== NULL) printf("CloudUnSummaries is NULL\n") ;
   if (UnsolvedList == NULL) printf("UnsolvedList is NULL\n") ;
   else if (UnsolvedList[0] == NULL) printf("UnsolvedList[0] is NULL\n") ;
#endif

   while (index != -1)
   {
	    /* Print summaries with lines numbered. */
      PrintSummaries(CloudUnSummaries,UnsolvedList) ;

	    /* Get selection from user */
      index=GetSelection() ;

      if (index >=0)
      {
		/* Read selected problem */
/*CLD*/  ProblemRecord = ReadUnsolved(ProbTree, Path, CloudUnSummaries, index) ;
 

		/* Format the problem */
         text=FormatProblem(ProblemRecord, Path) ;

		/* Print the problem */
         printf("-----------------------------------"
		"-----------------------------------\n") ;
         printf("%s",text) ;
         printf("-----------------------------------"
		"-----------------------------------\n") ;
      }
   }
}

PrintSummaries(Summary *CloudUnSummaries,
	       char **UnsolvedList)
{
   int i,j ;
   char str[MAXSUMLEN+1] ;

#ifdef DEBUG
   printf("entering PrintSummaries()\n") ;
#endif
   for (i=0; UnsolvedList[i] != NULL; ++i)
   {  strcpy(str,UnsolvedList[i]) ;
      for (j=0; j<strlen(str); ++j)
         if (str[j] == '\n')
            str[j] = ' ' ;
      printf("%-4d :\t%s\n",i+1,str) ;
   }
#ifdef DEBUG
   printf("leaving PrintSummaries()\n") ;
#endif
}

int GetSelection(void)
{
   int index ;
   char line[1000] ;
   char test[1000] ;

   printf("Enter problem number to view ('q' to quit):\n==>") ;
   gets(line) ;
   sscanf(line,"%d",&index) ;
   sscanf(line,"%s",test) ;
   if (test[0] == 'q' || index <= 0)
   {  index = 0 ;
   }
   return (index-1) ;
}

