/**************************************************
 * control.c : control channel functions for pcucp
 *
 * Copyright (C) 1992 J.Lepp{j{rvi
 **************************************************/

#include <stdio.h>
#include <string.h>

#include "system.h"
#include "usrmsg.h"
#include "packetio.h"
#include "fifo.h"
#include "mux.h"

#undef  SYS_PROTOS
#define SYS_PROTOS 0
#include "control.h"

#define CTRL_MAXCMD 32

typedef struct
{
    char buf[CTRL_MAXCMD];
}   CMDBUF;

static FIFO_DEF(_fifo,CMDBUF,8);

static char _connectArg[32]; /* adjust also sscanf() in CtrlWrite() */

void CtrlInit()
{
    FIFO_CLR(_fifo);
    _connectArg[0] = '\0';
}

char *CtrlGetConArg()
{
    return(_connectArg[0] ? _connectArg : NULL);
}

int CtrlRead(id,buf,nbytes)
int id;
char *buf;
int nbytes;
{
    CMDBUF cmd;
    int len;

    if (!FIFO_GET(_fifo,cmd))
    {
        len = strlen(cmd.buf);
        if (len < nbytes)
        {
            memcpy(buf,cmd.buf,len);
            return(len);
        }

        MsgError("CtrlRead","unexpected error");
    }

    return(0);
}

void CtrlWrite(id,buf,nbytes)
int id;
char *buf;
int nbytes;
{
    char cmd[CTRL_MAXCMD], arg[CTRL_MAXCMD];

    if (nbytes > CTRL_MAXCMD || nbytes >= (PACKET_MAX - 1))
    {
        MsgError("CtrlWrite","unexpected error");
        return;
    }

    buf[nbytes] = '\0';
    sscanf(buf,"%s %d %s",cmd,&id,arg);

    if (!stricmp("OPEN",cmd))
    {
        _MuxOpen(MUX_OPEN_REMOTE,id,arg);
    }
    else if (!stricmp("CLOSE",cmd))
    {
        MuxClose(id);
    }
    else if (!stricmp("PRIORIZE",cmd))
    {
        MuxPriorize(id);
    }
    else if (!stricmp("CONNECT",cmd))
    {
        sscanf(buf,"%*s %32s",_connectArg);
    }
    else if (!stricmp("EXT",cmd))
    {
        /* do nothing */
    }
    else
        MsgDisplay(MSG_ERROR,"invalid control command : %s",buf);
}

int CtrlSendCmd(fmt,a0,a1,a2,a3,a4,a5)
char *fmt;
int a0,a1,a2,a3,a4,a5;
{
    CMDBUF cmd;
    char buf[256];

    sprintf(buf,fmt,a0,a1,a2,a3,a4,a5);
    strncpy(cmd.buf,buf,sizeof(cmd.buf));

    if (cmd.buf[sizeof(cmd.buf) - 1])
    {
        MsgError("CtrlSendCmd","command would be too long");
        return(-1);
    }

    if (FIFO_PUT(_fifo,cmd))
    {
        MsgError("CtrlSendCmd","out of buffers, command lost");
        return(-1);
    }

    return(0);
}

