/********************************************
 * utmpmod.c : modify a /etc/utmp entry, BSD
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ********************************************/

#include <sys/types.h>
#include <utmp.h>

#define SYS_INCL_FILEIO
#define SYS_INCL_STDLIB
#include "system.h"
#include "utmpmod.h"

int UtmpSetEntry(line,name,host,time)
char *line, *name, *host;
long time;
{
  struct utmp sutmp;
  int fd, ret = -1;

  fd = open("/etc/utmp",O_RDWR);
  if (fd < 0)
    return(0); /* can't write, so be it */

  while(read(fd,&sutmp,sizeof(sutmp)) == sizeof(sutmp))
    {
      if (!strncmp(sutmp.ut_line,line,sizeof(sutmp.ut_line)))
	{
	  if (lseek(fd,-((off_t) sizeof(sutmp)),SEEK_CUR) < 0L)
	    {
	      close(fd);
	      return(-1);
	    }

	  break;
	}
    }

  /* File pointer should now point to the location where the
   * entry is to be written. That is, to an existing slot
   * if there was one with the same tty name, or to the end of
   * utmp file, if the tty name was not found.
   */

  strncpy(sutmp.ut_line,line,sizeof(sutmp.ut_line));
  strncpy(sutmp.ut_name,name,sizeof(sutmp.ut_name));
  strncpy(sutmp.ut_host,host,sizeof(sutmp.ut_host));
  sutmp.ut_host[sizeof(sutmp.ut_host) - 1] = '\0';
  sutmp.ut_time = time;

  if (write(fd,&sutmp,sizeof(sutmp)) == sizeof(sutmp))
    ret = 0;	

  close(fd);
  return(ret);
}













