/*****************************************************
 * tty.c : BSD tty handling
 *
 * by Jouni Lepp{j{rvi (C) 1992
 *****************************************************/

#include <sgtty.h>
#include <fcntl.h>

struct sgttyb _oldParams;
static int _fdFlgs;

void TtyStore()
{
  ioctl(0,TIOCGETP,&_oldParams);
  _fdFlgs = fcntl(0,F_GETFL);  
}

void TtyRestore()
{
  ioctl(0,TIOCSETP,&_oldParams);
  fcntl(0,F_SETFL,_fdFlgs);
}

void TtyRaw()
{
  struct sgttyb params;
  int flgs;

  params = _oldParams;

  params.sg_flags |= RAW;
  params.sg_flags &= ~(TANDEM | ECHO | CRMOD);
 
  ioctl(1,TIOCSETP,&params);

  flgs = fcntl(0,F_GETFL);
  fcntl(0,F_SETFL,flgs | FNDELAY);
}

void TtySetSize(fd,cx,cy)
int fd, cx, cy;
{
#ifdef TIOCSWINSZ
  static struct winsize ws;

  ws.ws_row = cy;
  ws.ws_col = cx;
  ioctl(fd,TIOCSWINSZ,&ws);
#endif
}

void TtySane()
{
  TtyRestore();
}
