#!/bin/sh
#
# @(#)makesrc.sh	4.3 94/09/04
#
# Make software source code release
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#    libdi - CD Audio Player Device Interface Library
#
#    Copyright (C) 1994  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

SRCLIST=misc.d/SRCLIST

# Use Sysv echo if possible
if [ -x /usr/5bin/echo ]				# SunOS SysV echo
then
	ECHO=/usr/5bin/echo
elif [ -z "`(echo -e a) 2>/dev/null | fgrep e`" ]	# GNU bash, etc.
then
	ECHO="echo -e"
else							# generic SysV
	ECHO=echo
fi

CURDIR=`pwd`
if [ `basename "$CURDIR"` = misc.d ]
then
	cd ..
elif [ ! -f install.sh ]
then
	$ECHO "You must run the makesrc.sh script while in the xmcd"
	$ECHO "source code distribution top-level directory or in the"
	$ECHO "misc.d subdirectory."
	exit 1
fi

if [ ! -r $SRCLIST ]
then
	$ECHO "Error: Cannot open $SRCLIST"
	exit 2
fi

# Create tar archive
tar cf xmcdsrc.tar `awk '!/^#/ { print $1 }' $SRCLIST`

# Compress tar archive
compress xmcdsrc.tar

$ECHO '

Instructions to unpack xmcd source code release
-----------------------------------------------

The following is a compressed and uuencoded tar archive containing
the xmcd, cda and libdi source code files.  To extract, make a
suitable source code directory for xmcd and save this message in a
file "xmcdsrc.uue" in that directory.  Then, change to the directory
and do the following:

	uudecode xmcdsrc.uue
	uncompress xmcdsrc.tar.Z
	tar xvf xmcdsrc.tar

Read the README and INSTALL files for further instructions.

' >xmcdsrc.uue

# Uuencode
uuencode xmcdsrc.tar.Z xmcdsrc.tar.Z >>xmcdsrc.uue

rm -f xmcdsrc.tar.Z
ls -l xmcdsrc.uue
exit 0

