#!/bin/sh
#
# @(#)makerel.sh	4.3 94/09/04
#
# Make software binary release
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#
#    Copyright (C) 1994  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

# The file containing a list of binary release files
BINLIST=misc.d/BINLIST

# Use Sysv echo if possible
if [ -x /usr/5bin/echo ]				# SunOS SysV echo
then
	ECHO=/usr/5bin/echo
elif [ -z "`(echo -e a) 2>/dev/null | fgrep e`" ]	# GNU bash, etc.
then
	ECHO="echo -e"
else							# generic SysV
	ECHO=echo
fi

CURDIR=`pwd`
if [ `basename "$CURDIR"` = misc.d ]
then
	cd ..
elif [ ! -f install.sh ]
then
	$ECHO "You must run the makerel.sh script while in the xmcd"
	$ECHO "source code distribution top-level directory or in the"
	$ECHO "misc.d subdirectory."
	exit 1
fi

if [ ! -r $BINLIST ]
then
	$ECHO "Error: Cannot open $BINLIST"
	exit 2
fi

# Strip the binary symbol tables
strip xmcd.d/xmcd
strip cda.d/cda
strip wm2xmcd.d/wm2xmcd

# Remove comment section of binaries if possible
(mcs -da '@(#)xmcd v1.3 (C) Ti Kan 1994' xmcd.d/xmcd) >/dev/null 2>&1
(mcs -da '@(#)cda v1.3 (C) Ti Kan 1994' cda.d/cda) >/dev/null 2>&1
(mcs -da '@(#)wm2xmcd v1.3 (C) Ti Kan 1994' wm2xmcd.d/wm2xmcd) >/dev/null 2>&1

# Create tar archive
tar cf xmcd.tar `awk '!/^#/ { print $1 }' $BINLIST`

# Compress tar archive
compress xmcd.tar

$ECHO '
Instructions to unpack xmcd binary and other info
-------------------------------------------------

At the end of this message is a compressed and uuencoded tar
file containing the xmcd, cda and wm2xmcd utility binaries
as well as their supporting files.  To extract, save this
message in a file "xmcd.uue" and do the following while
logged in as root:

	uudecode xmcd.uue
	uncompress xmcd.tar.Z
	tar xvf xmcd.tar
	sh ./install.sh

Be sure to run the "install.sh" script to install and configure
the software.  Otherwise, it will not work properly.

See the README file for further information.
' >xmcdbin.uue

# Uuencode
uuencode xmcd.tar.Z xmcd.tar.Z >>xmcdbin.uue

rm -f xmcd.tar.Z
ls -l xmcdbin.uue
exit 0

