/*
 *   libdi - CD Audio Player Device Interface Library
 *
 *   Copyright (C) 1994  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   This software module contains code that interfaces the CD player
 *   application to the HP-UX Release 9.0 operating system.  The name
 *   "HP" and "hpux" are used here for identification purposes only.
 *   This software and its author are not affiliated with the Hewlett-
 *   Packard Company.
 */
#ifndef __OS_HPUX_H__
#define __OS_HPUX_H__

#if defined(__hpux) && !defined(DEMO_ONLY)

#ifndef LINT
static char *_os_hpux_h_ident_ = "@(#)os_hpux.h	4.1 94/09/29";
#endif

#include <sys/scsi.h>

#ifndef OSI_MODULE
#define OSI_MODULE
#endif

#ifndef SETUID_ROOT
#define SETUID_ROOT
#endif


/* Public function prototypes */
extern bool_t	pthru_send(byte_t, word32_t, byte_t *, word32_t, byte_t,
			word32_t, byte_t, byte_t, byte_t);
extern bool_t	pthru_open(char *);
extern void	pthru_close(void);
extern char	*pthru_vers(void);

#endif	/* __hpux DEMO_ONLY */

#endif	/* __OS_HPUX_H__ */

