.TH xboard 6 "December 6, 1992" "X Version 11"
.SH NAME
xboard \- X user interface for GNU Chess and the Internet Chess Server
.SH SYNOPSIS
.B xboard [ options ]
.SH DESCRIPTION
.IR xboard
is an X11/Xt/Athena Widgets chessboard that can serve as a
user interface for GNU Chess or
for the Internet Chess Server.
.PP
As an interface to GNU Chess,
.IR xboard
lets you play a game against the machine,
set up arbitrary positions,
force variations, or watch
a game between two machines.
.PP
As an interface to the Internet Chess Server,
.IR xboard
lets you play against other ICS users,
observe games they are playing, or review
games that have recently finished.
.PP
You can also use
.IR xboard
as a chessboard to play through games.
It will read a game file or allow you to play 
through a variation manually.
This is useful for keeping track of email postal games,
browsing games off the net, or reviewing GNU Chess and ICS
games you have saved.
.PP
After starting
.IR xboard ,
you make moves by pressing mouse button 1
while the cursor is over a square with your piece on it
and dragging the mouse to another square.

.SH OPTIONS
The following command line options correspond to X resources
with the same names, so you can set them in your
.IR \&.Xdefaults
file if you like.
For options that have two names, the longer
one is the name of the corresponding X resource.
.TP 8
.B standard Xt options
.IR xboard
accepts standard Xt options like -display, -geometry, and -iconic.
.TP 8
.B -bell or -ringBellAfterMoves "(True | False)"
If this option is True, 
.IR xboard
alerts you by ringing the terminal bell after each
of your opponent's moves (or after every move if
you are observing a game on the Internet Chess Server).
The bell is not rung after moves you make 
or moves read from a saved game file.  Default: False.

If you turn on this option when using
.IR xboard
with the Internet Chess Server, you will probably want to
give the "bell" command to the ICS, since otherwise the ICS
will ring the bell itself after every move (not just yours).
.TP 8
.B -tc or -timeControl minutes[:seconds]
.PD 0
.TP 8
.B -mps or -movesPerSession moves
Each player begins with the specified amount of time on his clock.
If a player makes the specified number of moves before his clock runs out,
.IR xboard
adds the specified amount of time to his clock.
Default: 40 moves in 5 minutes.
.PD
.TP 8
.B -st or -searchTime minutes[:seconds]
Tell GNU Chess to spend at most the given amount of time searching
for each of its moves.  Without this option, GNU Chess chooses
its search time based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets -clockMode to False.
.TP 8
.B -sd or -searchDepth number
Tell GNU Chess to look ahead at most the given number of moves when searching
for a move to make.  Without this option, GNU Chess chooses
its search depth based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -clock or -clockMode "(True | False)"
Determines whether or not to use the clock.
If clockMode is False, the clock does not run, but the
side that is to play next is still highlighted.
.TP 8
.B -autoflag or -autoCallFlag "(True | False)"
If autoCallFlag is True and your opponent runs out of time
before you do,
.IR xboard
will automatically call his flag, claiming a win on time (or a draw
if you do not have mating material).
Default: False.
.TP 8
.B -td or -timeDelay seconds
Time delay between moves during "Load Game".
Fractional seconds are allowed; try -td 0.4.  
A time delay value of -1 tells
.IR xboard
not to step through game files automatically.
Default: 1 second.
.TP 8
.B -ics or -internetChessServerMode "(True | False)"
Connect with an Internet Chess Server to play chess against
its other users, observe games they are playing, or
review games that have recently finished.  Default: False.

To use xboard in ICS mode, run it in the foreground, and use the
terminal you started it from to type commands and receive text responses
from the chess server.  Useful ICS commands include
.IR who
to see who is logged on,
.IR games
to see what games are being played,
.IR match
to challenge another player to a game,
.IR observe
to observe an ongoing game,
.IR oldmoves
to review a recently completed game,
and of course
.IR help .
Whenever you ask to observe an ongoing game, review a completed game, or
resume an adjourned game,
.IR xboard
retrieves and parses the list of past moves from the ICS, so
you can review them with the Forward and Backward buttons
or save them with Save Game.
.TP 8
.B -icshost or -internetChessServerHost host
The Internet host name or address of the chess server to connect 
to when in ICS mode.  
Default: "valkyries.andrew.cmu.edu".

If your site doesn't have a working Internet name server, try 
specifying the host address in numeric form.  The address for valkyries
is currently "128.2.232.4".
.TP 8
.B -icsport or -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS mode.
Default: 5000.
.TP 8
.B -fcp or -firstChessProgram program
Name of first chess program.
In matches between two machines, this program plays black.
Default: "gnuchessx".
.TP 8
.B -scp or -secondChessProgram program
Name of second chess program, if needed.
In matches between two machines, this program plays white; otherwise
it is not started.
Default: "gnuchessx".
.TP 8
.B -fh or -firstHost host
Name of host the first chess program plays on.
Default: "localhost".
.TP 8
.B -sh or -secondHost host
Name of host the second chess program plays on.
Default: "localhost".
.TP 8
.B -rsh or -remoteShell shell_name
Some systems do not use rsh as the remote shell.
This option allows a user to name the remote shell command.
This should be done in the resource file.
.TP 8
.B -mm or -matchMode "(False | Init | Position | Opening)"
Automatically run a game between
.IR firstChessProgram
and
.IR secondChessProgram .
If
.IR matchMode
is set to
.IR Init ,
.IR xboard
will start the game with the initial chess position.
If
.IR matchMode
is set to
.IR Position ,
.IR xboard
will start the game with the position specified by the
.IR loadPositionFile
resource.
If
.IR matchMode
is set to
.IR Opening ,
.IR xboard
will play out the opening moves specified by the
.IR loadGameFile
resource.
If the
.IR saveGameFile 
resource is set, a move record for the match will
be appended to the specified file.
If the
.IR savePositionFile 
resource is set, the final position reached in the match will
be appended to the specified file.
When the match is over, 
.IR xboard
will exit.
Default: "False".
.TP 8
.B -ncp or -noChessProgram "(True | False)"
If this option is True,
.IR xboard
acts as a passive chessboard; it does not
start a chess program.
This option also sets -clockMode to False.
Default: False.
.TP 8
.B -lgf or -loadGameFile file
If this option is set, 
.IR xboard
reads the specified game file at startup.
If the option value ends with a space followed by a number
.IR N ,
the
.IR N th
game found in the file is loaded.
.TP 8
.B -sgf or -saveGameFile file
If this option is set, 
.IR xboard 
appends a record of every game played to the specified file.
.TP 8
.B -autosave or autoSaveGames "(True | False)"
If this option is True, at the end of every game
.IR xboard
prompts you for a filename and appends a record
of the game to the file you specify.
.TP 8
.B -lpf or -loadPositionFile file
If this option is set,
.IR xboard
loads the specified position file at startup.
If the option value ends with a space followed by a number
.IR N ,
the
.IR N th
position found in the file is loaded.
.TP 8
.B -spf or -savePositionFile file
If this option is set, 
.IR xboard 
appends the final position reached in
every game played to the specified file.
.TP 8
.B -size or -boardSize "(Large | Medium | Small)"
Determines how large the board will be and what built-in piece bitmaps
will be used by default.  On a large board (the default), 
pieces are 80x80 pixels, on a medium board 64x64 pixels, and
on a small board 40x40 pixels.
.TP 8
.B -coords or -showCoords "(True | False)"
If this option is True,
.IR xboard
displays algebraic coordinates along the board's left and bottom edges.
The default is False.  The
.IR coordFont
resource specifies what font to use.  
.TP 8
.B -mono or -monoMode "(True | False)"
Determines whether
.IR xboard
displays its pieces and squares with two colors or four.
You shouldn't have to specify monochrome;
.IR xboard
will determine if this is necessary.
.TP 8
.B -debug or -debugMode "(True | False)"
Turns on debugging printout.
.SH RESOURCES
.TP 8
.B XBoard*initString
The string that is sent to initialize the chess program.
Default: "new\\nbeep\\nrandom\\neasy\\n".

If you change this resource, don't remove the "new" and "beep" commands.
You can remove the "random" command if you
like; including it causes GNU Chess to randomize its move selection slightly so
that it doesn't play the same moves in every game.  
(Even without "random", GNU Chess
randomizes its choice of moves from its opening book.)
You can also remove "easy" if you like; including it toggles easy mode
off, causing GNU Chess to think on your time.
That is, if "easy" is 
.IR included
in the initString, GNU Chess thinks
on your time; if not, it does not.  
(Yes, this does seem backwards, doesn't it!)
To see what GNU Chess is thinking about, you can add the "post" 
command and run 
.IR xboard
with 
.IR -debugMode
set to True.
You can also try adding other commands to the initString; 
see the GNU Chess documentation for details.
.TP 8
.B XBoard*whiteString
.PD 0
.TP 8
.B XBoard*blackString
These resources control what is sent when the Machine White and Machine Black
buttons are selected.  This is mostly for compatibility with obsolete versions
of GNU Chess.
.PD
.TP 8
.B XBoard*gateway
If this resource is set to a host name,
.IR xboard
uses
.IR rsh
to run telnet on the given host to communicate with the Internet
Chess Server instead of opening a direct TCP connection.

This resource is useful if your machine is unable
to connect directly to the ICS but is able
to rsh to a gateway host that can connect to the ICS.
As an example, suppose the gateway host is
called gate.wassamatta-u.edu, and you set resources as
follows:
.EX 4
XBoard*gateway:			gate.wassamatta-u.edu
XBoard*internetChessServer:	valkyries.andrew.cmu.edu
XBoard*icsPort:			5000
.EE
Then when you run
.IR xboard
in ICS mode, it will connect to the ICS by using rsh
to run the command "telnet valkyries.andrew.cmu.edu 5000" on
host gate.wassamatta-u.edu.
.TP 8
.B XBoard*useTelnet
If this resource is set to True, 
.IR xboard 
uses the 
.IR telnet (1)
program to communicate with the Internet Chess
Server instead of opening a direct TCP connection.
The default is False.  

This resource is useful if your machine is unable to connect directly
to the ICS but is able to telnet to a gateway host that can
connect to the ICS.  It is more general than the gateway 
resource, because you may be able to telnet to a host that 
you cannot rsh to, but it's not as convenient to use.
As an example, suppose the gateway host is
called gate.wassamatta-u.edu, and you set resources as
follows:
.EX 4
XBoard*useTelnet:            True
XBoard*internetChessServer:  gate.wassamatta-u.edu
XBoard*icsPort:              23
.EE
Then when you run
.IR xboard
in ICS mode, you will get a login prompt from the gateway host.
Log in there and run the telnet program (giving a command like
"telnet valkyries.andrew.cmu.edu 5000") to connect to the ICS.
.PP
.TP 8
.B XBoard*telnetProgram
This resource gives the name of the telnet program to be used with the 
gateway and useTelnet resources.  The default is "telnet".
.TP 8
.B XBoard*mainFont
The font used for command buttons, messages, and the clocks.
If the resource
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose the most appropriate font for the board size being used.
Default: -*-helvetica-medium-o-normal--*-*-*-*-*-*-*-*.
.TP 8
.B XBoard*coordFont
The font used for rank and file coordinate labels if 
.IR showCoords
is True.
If the resource
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose the most appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B XBoard*font
The font used in popup dialogs, menus, and comments.
Default: -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*.
.PP
Alternate bitmaps for piece icons can be specified
either by choosing one of the built-in sets or with
the file name resources described below.
There are three built-in sets of piece bitmaps available,
large (the default), medium, or small.
It is easiest to select the size you prefer in the .Xdefaults file:
.sp 1
.EX 4
XBoard*boardSize:  Medium
.EE
.PP
The following resources let you change piece bitmaps individually.
.TP 8
.B XBoard*solidPawnBitmap
.PD 0
.TP 8
.B XBoard*solidKnightBitmap
.TP 8
.B XBoard*solidBishopBitmap
.TP 8
.B XBoard*solidRookBitmap 
.TP 8
.B XBoard*solidQueenBitmap
.TP 8
.B XBoard*solidKingBitmap
Names of the bitmap files for the solid piece icons.
.PD

.PD 0
.TP 8
.B XBoard*outlinePawnBitmap 
.TP 8
.B XBoard*outlineKnightBitmap 
.TP 8
.B XBoard*outlineBishopBitmap 
.TP 8
.B XBoard*outlineRookBitmap 
.TP 8
.B XBoard*outlineQueenBitmap 
.TP 8
.B XBoard*outlineKingBitmap 
Names of the bitmap files for the outline piece icons.  These
are used only in monochrome mode.
.PD

.TP 8
.B XBoard*whitePieceColor
Color specification for white pieces,
suitable for
.IR XParseColor (3X11).
Default: #FFFFCC.
These colors look good on a DEC workstation.
If you need different colors, try using the
.IR xcolors
application.  Source for
.IR xcolors
can be found in the X11 contrib directory.
.TP 8
.B XBoard*blackPieceColor
Same for black pieces.
Default: #202020.
.TP 8
.B XBoard*lightSquareColor
Same for light squares.
Default: #C8C365.
.TP 8
.B XBoard*darkSquareColor
Same for dark squares.
Default: #77A26D.
.PP
If you are using a grayscale monitor, try setting the colors to:
.sp 1
.EX 4
XBoard*whitePieceColor:     gray100
XBoard*blackPieceColor:     gray0
XBoard*lightSquareColor:    gray80
XBoard*darkSquareColor:     gray60
.EE
.SH COMMAND BUTTONS AND KEYS
.PP
Note: Some of the buttons described below are present only when 
.IR xboard 
is in Internet Chess Server mode; some only when it is not.
.TP 8
.B Quit
Quits
.IR xboard .
Q or q is a keyboard equivalent.
.TP 8
.B Reset
Resets
.IR xboard
and GNU Chess to the beginning of a new chess game.
If you were playing or observing a game 
on the Internet Chess Server that is not finished yet,
you will also need to enter an appropriate command to
end your participation (for example, "resign" or "observe").
.TP 8
.B Flip View
Inverts the view of the chess board.
.TP 8
.B Edit Position
Lets you set up an arbitrary board position.
Use mouse button 1 to drag pieces to new squares, or to
delete a piece by dragging it off the board or dragging an empty square
on top of it.  To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  You can set the side to play next
by clicking on the White or Black indicator at the top of the screen.
.TP 8
.B Machine Black
Forces GNU Chess to play black.  Not available in ICS mode.
.TP 8
.B Machine White
Forces GNU Chess to play white.  Not available in ICS mode.
.TP 8
.B Force Moves
Forces a series of moves.  That is, GNU Chess stops playing
and
.IR xboard
allows you to make moves for both black and white.  
Not available in ICS mode.
.TP 8
.B Two Machines
Plays a game between two computer programs.  Not available in ICS mode.
.TP 8
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming a draw
if you are both out of time.  ICS mode only.
.TP 8
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move 
rule, as appropriate.
This button is present only in ICS mode; currently
GNU Chess does not offer draws or accept draw offers, and it automatically
claims a draw by repetition whenever possible.
.TP 8
.B Decline Draw
Declines a pending draw offer from your opponent.  ICS mode only.
.TP 8
.B Resign
Resigns the game to your opponent.  ICS mode only.
.TP 8
.B Load Game
Plays a game from a record file.
A popup dialog prompts you for the filename.
If the file contains more than one game, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the filename, separated by a space.
G or g is a keyboard equivalent.

The game file parser will accept almost any file that contains 
moves in algebraic notation.
If the file includes an 
.IR xboard
position diagram
bracketed by "[--" and "--]" before the
first move, the game starts from that position.
Text enclosed in parentheses or square brackets is assumed to be
commentary and is displayed in a pop-up window.
Any other text in the file is ignored.
.TP 8
.B Load Position
Sets up a position from a position file.
A popup dialog prompts you for the filename.
If the file contains more than one saved position, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the filename, separated by a space.
Position files must be in the format that the Save Position command
writes.
.TP 8
.B Save Game
Appends a record of the current game to a file.
A popup dialog prompts you for the filename.
If the game did not begin with the standard starting position,
the game file includes the starting position used.
Game files are human-readable, and can also be read back by
the Load Game command.
.TP 8
.B Save Position
Appends a diagram of the current position to a file.
A popup dialog prompts you for the filename.
Position files are human-readable, and can also be read back by
the Load Position command.
.TP 8
.B Forward
Steps forward through a series of remembered moves or
through a game file.
If you hold down the shift key while selecting Forward, 
.IR xboard
jumps forward to the last remembered position in the game.
F or f is a keyboard equivalent.
.TP 8
.B Backward
Steps backward through a series of remembered moves.
If you hold down the shift key while selecting Backward, 
.IR xboard
jumps backward to the first remembered position in the game.
B or b is a keyboard equivalent.

Backward normally only reviews old positions; it does not retract moves.
If you are playing against GNU Chess and want to change your last move,
you must use Force Moves mode to do so.  Wait until it is your turn,
press Force Moves, press Backward twice, make a different move, and
then press Machine White or Machine Black to get GNU Chess back into the game.
.TP 8
.B Pause
Pauses updates to the board, and if you are playing
against GNU Chess, also pauses your clock.
To continue, press Pause again, then press Shift+Forward
if you want to immediately update the display to the latest position.
P or p is a keyboard equivalent.

If you press Pause when you are playing against GNU Chess and
it is not your move, GNU Chess's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop.  Since board updates are paused, however,
you will not see the move until you press Forward.
This behavior is meant to simulate adjournment with a sealed move.
.TP 8
.B Hint
Displays a move hint from GNU Chess.  Not available in ICS mode.
.TP 8
.B Iconify
I, i, C or c iconifies
.IR xboard .
.SH ENVIRONMENT
Game and position files
are found in the directory named by the CHESSDIR environment
variable.  If this variable is not set, the current working
directory is used.
If CHESSDIR is set,
.IR xboard
actually changes its working directory to $CHESSDIR, so GNU Chess listing
files will be stored there as well.
.SH SEE ALSO
.IR gnuchess (6)
.SH LIMITATIONS
The game parser recognizes only algebraic notation.
.PP
The internal move legality tester does not look at the game history,
so in some cases it misses illegal castling or en passant captures.
However, if you attempt such a move when using
.IR gnuchess
(or the ICS), it will reject the move, and
.IR xboard
will undo it and let you try another.
.PP
In ICS mode, 
.IR xboard
cannot handle observing (and/or playing) more than one game at
a time.  It may get confused if you try to do this, though it
tries to recover gracefully.  Use the Reset button and the ICS
refresh command if you have problems.
.PP
Your password gets echoed when you log on to the ICS.  This
happens because 
.IR xboard
does not implement the telnet protocol.  Also, if useTelnet
is set to True, every line you type to the ICS gets echoed an extra time.  
This happens because 
.IR xboard
does not put the keyboard into raw mode and let the
telnet program do all the echoing.  (The details of
how to do so vary on different systems.)
.PP
Some
.IR xboard
functions may not work with versions of GNU Chess earlier 
than 4.0, patchlevel 52. 
In particular, with GNU Chess 3.1
the timeControl resource can be given only to
the nearest minute, restoring a saved position with 
black to play may not work, and if you use
the Backward button after a mate or draw, the clocks are reset (because 
GNU Chess has exited and must
be restarted).
.SH AUTHORS
Original authors:  Chris Sears and Dan Sears.
.PP
Enhancements, current maintainer:  Tim Mann.
.PP
Thanks to John Chanak for the initial implementation of ICS mode.
.SH COPYRIGHT
XBoard borrows its colors, icon and piece bitmaps from XChess,
which was written and is copyrighted by Wayne Christopher.
.PP
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
Enhancements Copyright 1992 Free Software Foundation, Inc.
.PP
The following terms apply to Digital Equipment Corporation's copyright
interest in XBoard:
.PP
.RS
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.RE
.PP
The following terms apply to the enhanced version of XBoard distributed
by the Free Software Foundation:
.PP
.RS
This file is part of XBOARD.
.PP
XBOARD is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone for
the consequences of using it or for whether it serves any particular
purpose or works at all, unless he says so in writing.  Refer to the XBOARD
General Public License for full details.
.PP
Everyone is granted permission to copy, modify and redistribute XBOARD, but
only under the conditions described in the XBOARD General Public License. A
copy of this license is supposed to have been given to you along with
XBOARD so you can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice and this
notice must be preserved on all copies.
.RE
