/*
 * mhz.c - calculate clock rate and megahertz
 *
 * Usage: mhz [-c]
 *
 * The sparc specific code is to get around a feature of SuperSPARC
 * that does two adds in one clock.  Apparently, only SuperSPARC does this.
 * Thanks to John Mashey (mash@sgi.com) for explaining SuperSPARC to me.
 *
 * The AIX specific code is because the C compiler on rs6000s does not 
 * respect the register directive.  "a" below is a stack variable and 
 * there are two instructions per increment instead of one.
 * Please note that this may not be correct for other AIX systems.
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: mhz.c,v 1.1 1994/11/18 08:51:55 lm Exp $\n";

#ifndef N
#define N       20000000
#endif

#include	"timing.c"

main(ac, av)
        char  **av;
{
	register a, i;
	int	result = 1024*1024*1024;
	int	tries = 0;
	double	mhz;

	write(2, id, strlen(id));
        for (tries = 0; tries < 5; ++tries) {
                /* time empty loop */
		i = N - 1000;
		a = 1024;
                start();
                while (i > 0) {
#ifdef sparc
#	define	FOUR	a >>= 1; a >>= 1; a >>= 1; a >>= 1;
#else
#	ifdef _AIX	/* really for the rs6000 only */
#		define	FOUR	a++; a++;
#	else
#		define	FOUR	a++; a++; a++; a++;
#	endif
#endif
#define TWENTY	FOUR FOUR FOUR FOUR FOUR
#define	H	TWENTY TWENTY TWENTY TWENTY TWENTY
			H H H H H
			H H H H H
			i -= 1000;
                }
		i = stop();
		if (i < result)
			result = i;
	}
	/*
	 * We figure that the loop overhead is about 5 instructions out of 1000.
	 * So we figure that we acually execute N * 1.005 instructions.
	 */
	mhz = (N * 1.005) / result;
	if (ac == 2 && !strcmp(av[1], "-c")) {
		printf("%.4f\n", 1000 / mhz);
	} else {
		printf("%.2f Mhz, %.0f nanosec clock\n", mhz, 1000 / mhz);
	}
	exit(0);
}
