/*
 * udp_xact.c - simple UDP transaction latency test
 *
 * Three programs in one -
 *	server usage:	udp_xact -s
 *	client usage:	udp_xact hostname
 *	shutdown:	udp_xact -hostname
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_udp.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";
#include "bench.h"
#include "lib_udp.c"
#include "timing.c"

main(ac, av)
	char  **av;
{
	write(2, id, strlen(id));
	if (ac != 2 && ac != 3) {
		fprintf(stderr, "Usage: %s -s OR %s [-]serverhost [proto]\n",
		    av[0], av[0]);
		exit(1);
	}
	if (!strcmp(av[1], "-s")) {
		if (fork() == 0) {
			server_main(ac, av);
		}
		exit(0);
	} else {
		client_main(ac, av);
	}
	exit(0);
}

client_main(ac, av)
	char  **av;
{
	int     sock;
	int     seq = 0;
	int     ret;
	int     n = 0;
	char    buf[200];
	char   *server;

	if (ac != 2) {
		fprintf(stderr, "Usage: %s hostname\n", av[0]);
		exit(1);
	}

	server = av[1][0] == '-' ? &av[1][1] : av[1];
	sock = udp_connect(server, UDP_XACT);

	/*
	 * Stop server code.
	 */
	if (av[1][0] == '-') {
		while (seq-- > -5) {
			(void) send(sock, &seq, sizeof(seq), 0);
		}
		exit(0);
	}

	start();
	while (seq++ < 5000) {
		if (send(sock, &seq, sizeof(seq), 0) != sizeof(seq)) {
			perror("lat_udp client: send failed");
			exit(5);
		}
		if (recv(sock, &ret, sizeof(ret), 0) != sizeof(ret)) {
			perror("lat_udp client: recv failed");
			exit(5);
		}
		if (seq == ret) {
			n++;
		}
	}
	stop();
	sprintf(buf, "UDP latency using %s", server);
	micro(buf, n);
}

server_main(ac, av)
	char  **av;
{
	int     sock, sent, namelen, seq = 0;
	struct sockaddr_in it;

	GO_AWAY;

	sock = udp_server(UDP_XACT);

	while (1) {
		namelen = sizeof(it);
		if (recvfrom(sock, &sent, sizeof(sent), 0, &it, &namelen) < 0) {
			fprintf(stderr, "lat_udp server: recvfrom: got wrong size\n");
			exit(9);
		}
		if (sent < 0) {
			udp_done(UDP_XACT);
			exit(0);
		}
		if (sent != ++seq) {
printf("lat_udp server: wanted %d, got %d, resyncing\n", seq, sent);	/**/
			seq = sent;
		}
		if (sendto(sock, &seq, sizeof(seq), 0, &it, sizeof(it)) < 0) {
			perror("lat_udp sendto");
			exit(9);
		}
	}
}
