/*
 * tcp_xact.c - simple TCP transaction latency test
 *
 * Three programs in one -
 *	server usage:	tcp_xact -s
 *	client usage:	tcp_xact hostname
 *	shutdown:	tcp_xact -hostname
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_tcp.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";
#include "bench.h"
#include "lib_tcp.c"
#include "timing.c"
#define	N	5000

main(ac, av)
	char  **av;
{
	write(2, id, strlen(id));
	if (ac != 2) {
		fprintf(stderr, "Usage: %s -s OR %s [-]serverhost\n",
		    av[0], av[0]);
		exit(1);
	}
	if (!strcmp(av[1], "-s")) {
		if (fork() == 0) {
			server_main(ac, av);
		}
		exit(0);
	} else {
		client_main(ac, av);
	}
	exit(0);
}

client_main(ac, av)
	char  **av;
{
	int     newsock, sock;
	char	*server;

	if (ac != 2) {
		fprintf(stderr, "usage: %s host\n", av[0]);
		exit(1);
	}
	server = av[1][0] == '-' ? &av[1][1] : av[1];
	sock = tcp_connect(server, TCP_XACT);

	/*
	 * Stop server code.
	 */
	if (av[1][0] == '-') {
		close(sock);
		exit(0);
	}

	doclient(sock, server);
	exit(0);
	/* NOTREACHED */
}

doclient(sock, host)
	char	*host;
{
	char    c;
	int     i;
	char	buf[100];

	start();
	for (i = 0; i < N; ++i) {
		write(sock, &c, 1);
		read(sock, &c, 1);
	}
	stop();
	sprintf(buf, "TCP latency using %s", host);
	micro(buf, N);
}

server_main(ac, av)
	char  **av;
{
	int     server, newsock, sock;

	if (ac != 2) {
		fprintf(stderr, "usage: %s -s\n", av[0]);
		exit(1);
	}
	GO_AWAY;
	sock = tcp_server(TCP_XACT);
	for (;;) {
		newsock = tcp_accept(sock);
		doserver(newsock);
	}
	/* NOTREACHED */
}

doserver(sock)
{
	char    c;
	int	n = 0;

	while (read(sock, &c, 1) == 1) {
		write(sock, &c, 1);
		n++;
	}

	/*
	 * A connection with no data means shut down.
	 */
	if (n == 0) {
		tcp_done(TCP_XACT);
		exit(0);
	}
}
