/*
 * lat_proc.c - process creation tests
 *
 * Usage: lat_proc
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_proc.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include	"timing.c"


main(ac, av)
	char	**av;
{
	int	i, pid;
	char	*nav[2];

	write(2, id, strlen(id));
	start();
	for (i = 0; i < 600; ++i) {
		switch (pid = fork()) {
		    case -1:
			perror("fork");
			exit(1);

		    case 0:	/* child */
			exit(1);

		    default:
			while (wait(0) != pid)
				;
		}
	}
	stop();
	micro("Process fork+exit", 600);
	
	nav[0] = "hello";
	nav[1] = 0;
	start();
	for (i = 0; i < 100; ++i) {
		switch (pid = fork()) {
		    case -1:
			perror("fork");
			exit(1);

		    case 0: 	/* child */
			close(1);
		    	execve("./hello", nav, 0);
			exit(1);

		    default:
			while (wait(0) != pid)
				;
		}
	}
	stop();
	micro("Process fork+execve", 100);
	
	start();
	for (i = 0; i < 100; ++i) {
		switch (pid = fork()) {
		    case -1:
			perror("fork");
			exit(1);

		    case 0:	/* child */
			close(1);
		    	execlp("/bin/sh", "sh", "-c", "./hello", 0);
			exit(1);

		    default:
			while (wait(0) != pid)
				;
		}
	}
	stop();
	micro("Process fork+/bin/sh -c", 100);
	exit(0);
}
