/*
 * lat_pipe.c - pipe transaction test
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_pipe.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include "timing.c"

#define N	2000
#define	TRIES	5

int
main()
{
	int	p1[2], p2[2];
	int	i;
	int	time = 0x7fffffff;
	char	c;
	int	pid;
	int	j;

	write(2, id, strlen(id));
     	if (pipe(p1) == -1 || pipe(p2) == -1) {
		perror("pipe");
		exit(1);
	}

	pid = fork();
	if (pid == -1) {
		perror("fork");
		exit(1);
	}
	if (pid > 0) {
		/*
		 * One time around to make sure both processes are started.
		 */
		if (write(p1[1], &c, 1) != 1 ||
		    read(p2[0], &c, 1) != 1 ||
		    write(p1[1], &c, 1) != 1) {
			perror("read/write on pipe");
			exit(1);
		}
		for (j = 0; j < TRIES; ++j) {
			start();
			for (i = 0; i < N; ++i) {
				if (read(p2[0], &c, 1) != 1 ||
				    write(p1[1], &c, 1) != 1) {
					perror("read/write on pipe");
					exit(1);
				}
			}
			i = stop();
			if (time > i) {
				time = i;
			}
		}
		fprintf(stderr, "Pipe latency: %d microseconds\n", time / N);
		kill(pid, 15);
	} else {
		for ( ;; ) {
			if (read(p1[0], &c, 1) != 1 ||
			    write(p2[1], &c, 1) != 1) {
				perror("read/write on pipe");
				exit(1);
			}
		}
	}
}
