/*
 * lat_mmap.c - time how fast a mapping can be made and broken down
 *
 * Usage: mmap size file
 *
 * XXX - If an implementation did lazy address space mapping, this test
 * will make that system look very good.  I haven't heard of such a system.
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_mmap.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include "timing.c"

#include <sys/stat.h>
#include <sys/mman.h>

#define	CHK(x)	if ((x) == -1) { perror("x"); exit(1); }
#ifndef	N
#define	N	5000
#endif

main(ac, av)
	char **av;
{
	int fd;
	int i;
	char *where;
	int *p;
	int size;
	struct stat sbuf;

	write(2, id, strlen(id));
	if (ac != 3) {
		fprintf(stderr, "usage: %s size file\n", av[0]);
		exit(1);
	}
	size = atoi(av[1]);
	if ((last(av[1]) == 'k') || (last(av[1]) == 'K'))
		size *= 1024;
	if ((last(av[1]) == 'm') || (last(av[1]) == 'M'))
		size *= (1024 * 1024);
	CHK(fd = open(av[2], 2));
	CHK(fstat(fd, &sbuf));
	if (sbuf.st_size < size) {
		fprintf(stderr, "%s: file %s is not as big as size %d\n",
		    av[0], av[2], size);
		exit(1);
	}
	start();
	for (i = 0; i < N; ++i) {
		where = mmap(0, size, PROT_READ, MAP_SHARED, fd, 0);
		if ((int)where == -1) {
			perror("mmap");
			exit(1);
		}
		munmap(where, size);
	}
	i = stop();
	fprintf(stderr, "%.02f %d\n", size/(1024*1024.), i / N);
	exit(0);
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}
