/*
 * lat_mem_wr - figure out memory write latency
 *
 * This algorthm from Satya N of SMCC.  Errors are mine.
 *
 * The idea is to assume that the external cache is no more than 8MB in
 * size (XXX - not true soon?) and that it is no more than 8 way set
 * associative.  Create a memory region that is 8*8 = 64MB in size and
 * store into that region every 8MB.  This is structured such that each
 * store should be a cache miss and that there are several stores in
 * a short period of time.  The point is to get worst "average" case
 * memory write latency and to not have the latency masked by store buffers.
 *
 * XXX - I'm getting 220 ns / store on an SS2.  That's too fast.  I think.
 */
char	*id = "$Id: lat_mem_wr2.c,v 1.1 1994/11/18 08:51:29 lm Exp $\n";

#define	N	50000000	/* 5 million */
#define	SIZE	0x4000000	/* 64 MB */
#define	TMPFILE	"big-sparse-file"

#include "timing.c"
#include <sys/mman.h>
#include <fcntl.h>	/* for open flags */

#define	CHK(x)	if ((int)(x) == -1) { perror("x"); exit(1); }

main(ac, av)
	char	**av;
{
	int	i, time, fd;
	char 	*where;

	write(2, id, strlen(id));
	unlink(TMPFILE);
	CHK(fd = open(TMPFILE, O_RDWR|O_CREAT|O_TRUNC, 0666));
	CHK(ftruncate(fd, SIZE));
	CHK(where = mmap(0, SIZE, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0));

#define	TOUCH \
	where[0x0] = 1;		where[0x400000] = 1;	where[0x800000] = 1;  \
	where[0xc00000] = 1;	where[0x1000000] = 1;	where[0x1400000] = 1; \
	where[0x1800000] = 1;	where[0x1c00000] = 1;	

	/*
	 * Touch pages apart to creat them.
	 */
     	TOUCH;

	/* 
	 * Time a bunch of loads.
	 */
	start();
     	for (i = N/8; i-- > 0; ) {
     		TOUCH;
	}
	time  = stop();
	printf("%.0f ns per store\n", time / (N / 1000.));
}
