/*
 * lat_connect.c - simple TCP connection latency test
 *
 * Three programs in one -
 *	server usage:	lat_connect -s
 *	client usage:	lat_connect hostname [N]
 *	shutdown:	lat_connect -hostname
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_connect.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";
#include "bench.h"
#define	NO_SETSOCKOPT
#include "lib_tcp.c"
#include "timing.c"

/*
 * A small N is used because the connections hang around even after the
 * socket has been closed.  XXX - is this a TCP (implementation) bug?
 */
#define	N	20

main(ac, av)
	char  **av;
{
	write(2, id, strlen(id));
	if (ac != 2) {
		fprintf(stderr, "Usage: %s -s OR %s [-]serverhost\n",
		    av[0], av[0]);
		exit(1);
	}
	if (!strcmp(av[1], "-s")) {
		if (fork() == 0) {
			server_main(ac, av);
		}
		exit(0);
	} else {
		client_main(ac, av);
	}
	exit(0);
	/* NOTREACHED */
}

client_main(ac, av)
	char  **av;
{
	int     sock;
	char	*server;
	int	i, tmp, cost;

	if (ac != 2) {
		fprintf(stderr, "usage: %s host\n", av[0]);
		exit(1);
	}
	server = av[1][0] == '-' ? &av[1][1] : av[1];

	/*
	 * Stop server code.
	 */
	if (av[1][0] == '-') {
		sock = tcp_connect(server, TCP_CONNECT);
		write(sock, "0", 1);
		close(sock);
		exit(0);
		/* NOTREACHED */
	}

	cost = 0x7fffffff;
	for (i = 0; i < N; ++i) {
		start();
		sock = tcp_connect(server, TCP_CONNECT);
		tmp = stop();
		if (tmp < cost)
			cost = tmp;
		write(sock, "1", 1);
		close(sock);
	}
	fprintf(stderr, "TCP/IP connection cost to %s: %d microseconds\n", 
	    server, cost);

	exit(0);
	/* NOTREACHED */
}

server_main(ac, av)
	char  **av;
{
	int     newsock, sock;
	char	c;

	if (ac != 2) {
		fprintf(stderr, "usage: %s -s\n", av[0]);
		exit(1);
	}
	GO_AWAY;
	sock = tcp_server(TCP_CONNECT);
	for (;;) {
		newsock = tcp_accept(sock);
		c = 0;
		read(newsock, &c, 1);
		if (c && c == '0') {
			exit(0);
		}
		close(newsock);
	}
	/* NOTREACHED */
}
