/*
 * bw_tcp.c - simple TCP bandwidth test
 *
 * Three programs in one -
 *	server usage:	bw_tcp -s
 *	client usage:	bw_tcp hostname
 *	shutdown:	bw_tcp -hostname
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_tcp.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";
#include "lib_tcp.c"
#include "timing.c"

main(ac, av)
	char  **av;
{
	write(2, id, strlen(id));
	if (ac != 2 && ac != 3) {
		fprintf(stderr, "Usage: %s -s OR %s [-]serverhost\n",
		    av[0], av[0]);
		exit(1);
	}
	if (!strcmp(av[1], "-s")) {
		if (fork() == 0) {
			server_main(ac, av);
		}
		exit(0);
	} else {
		client_main(ac, av);
	}
	exit(0);
}

client_main(ac, av)
	char  **av;
{
	char    buf[SOCKBUF];
	int     data, control;
	int     c;
	int     bytes;
	char   *server;

	if (ac != 2 && ac != 3) {
		(void)fprintf(stderr, "usage: %s remotehost [count]\n",
		    av[0]);
		exit(0);
	}
	if (ac == 3) {
		bytes = atoi(av[2]);
		if ((last(av[2]) == 'k') || (last(av[2]) == 'K'))
			bytes *= 1024;
		if ((last(av[2]) == 'm') || (last(av[2]) == 'M'))
			bytes *= (1024 * 1024);
	} else {
		bytes = 3*1024*1024;
	}
	if (av[1][0] == '-') {
		bytes = 0;
		server = &av[1][1];
	} else {
		server = av[1];
	}
	control = tcp_connect(server, TCP_CONTROL);
	data = tcp_connect(server, TCP_DATA);
	(void)sprintf(buf, "%d", bytes);
	if (write(control, buf, strlen(buf)) != strlen(buf)) {
		perror("control write");
		exit(1);
	}
	/*
	 * Disabler message to other side.
	 */
	if (bytes == 0) {
		exit(0);
	}
	while (bytes > 0 && (c = write(data, buf, sizeof(buf))) > 0)
		bytes -= c;
	(void)close(data);
	(void)fprintf(stderr, "Socket bandwidth using %s: ", server);
	while (read(control, buf, 1) == 1) {
		(void)fprintf(stderr, "%c", buf[0]);
		if (buf[0] == '\n') {
			exit(0);
		}
	}
	exit(0);
	/*NOTREACHED*/
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}

server_main()
{
	int	data, control, newdata, newcontrol;

	GO_AWAY;

	data = tcp_server(TCP_DATA);
	control = tcp_server(TCP_CONTROL);

	for ( ;; ) {
		newcontrol = tcp_accept(control);
		newdata = tcp_accept(data);
		absorb(newcontrol, newdata);
	}
}

/*
 * Read the number of bytes to be transfered on the control socket.
 * Read that many bytes on the data socket.
 * Write the performance results on the control socket.
 */
absorb(control, data)
{
	int	nread, save, nbytes;
#ifdef	SO_RCVBUF
	char	buf[SOCKBUF];
	int	sockbuf = SOCKBUF;

	while (setsockopt(data, SOL_SOCKET, SO_RCVBUF, &sockbuf, sizeof(int))) {
		sockbuf -= 128;
	}
#endif
	bzero(buf, SOCKBUF);
	if (read(control, buf, SOCKBUF) <= 0) {
		perror("control nbytes");
		exit(7);
	}
	nbytes = save = atoi(buf);

	/*
	 * A hack to allow turning off the absorb daemon.
	 */
     	if (nbytes == 0) {
		tcp_done(TCP_DATA);
		tcp_done(TCP_CONTROL);
		exit(0);
	}
	start();
	while (nbytes > 0 && (nread = read(data, buf, sizeof(buf))) > 0)
		nbytes -= nread;
	stop();
	(void)close(2);		/* stderr - timing stats go to stderr */
	(void)dup(control);	/* stderr == control now */
	mb(save);
}

