/*
 * bw_pipe.c - pipe bandwidth benchmark.
 *
 * Usage: bw_pipe
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_pipe.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include	"timing.c"

#define	BUFSIZE	(64*1024)
#define	XFER	(1024*1024*50)

extern	void	exit();		/* for lint on SunOS 4.x */
void		writer(), reader();

int
main()
{
	int	pipes[2];

	write(2, id, strlen(id));
	if (pipe(pipes) == -1) {
		perror("pipe");
		exit(1);
	}
	switch (fork()) {
	    case 0:
		reader(pipes[0]);
		exit(0);
		/*NOTREACHED*/
	    	
	    case -1:
		perror("fork");
		exit(1);
		/*NOTREACHED*/

	    default:
	    	writer(pipes[1]);
		wait(0);
		exit(0);
		/*NOTREACHED*/
	}
}

void
writer(fd)
	int	fd;
{
	int	todo = XFER;
	int	n, done = 0;
	char	buf[BUFSIZE];

	while ((done < todo) && ((n = write(fd, buf, sizeof(buf))) > 0))
		done += n;
}

void
reader(fd)
	int	fd;
{
	int	todo = XFER;
	int	n, done = 0;
	char	buf[BUFSIZE];

	sleep(1);
	start();
	while ((done < todo) && ((n = read(fd, buf, sizeof(buf))) > 0))
		done += n;
	stop();
	fprintf(stderr, "Pipe bandwidth: ");
	mb(todo);
}
