/*
 * bw_mmap_rd.c - time reading & summing of a file using mmap
 *
 * Usage: bw_mmap_rd size file
 *
 * Sizes less than 2m are not recommended.  Memory is read by summing it up
 * so the numbers include the cost of the adds.  If you use sizes large
 * enough, you can compare to bw_mem_rd and get the cost of TLB fills 
 * (very roughly).
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_mmap_rd.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include "timing.c"
#include <sys/mman.h>
#include <sys/stat.h>


#define	CHK(x)	if ((int)(x) == -1) { perror("x"); exit(1); }

main(ac, av)
	char **av;
{
	int i, size, fd;
	char *where;
	unsigned int sum = 0, *p;
	struct stat sbuf;

	write(2, id, strlen(id));
	if (ac != 3) {
		fprintf(stderr, "Usage: %s size file\n", av[0]);
		exit(1);
	}
	/* XXX - align size? */
	size = bytes(av[1]);
	CHK(fd = open(av[2], 0));
	CHK(fstat(fd, &sbuf));
	if (size > sbuf.st_size) {
		fprintf(stderr, "%s: is too small\n", av[1]);
		exit(1);
	}
	CHK(where = mmap(0, size, PROT_READ, MAP_SHARED, fd, 0));
	p = (unsigned int*)where;

	start();
     	for (i = size/sizeof(*p); i >= 200; i -= 200) {
#define	TWENTY	sum += p[0]+p[1]+p[2]+p[3]+p[4]+p[5]+p[6]+p[7]+p[8]+p[9]+ \
		p[10]+p[11]+p[12]+p[13]+p[14]+p[15]+p[16]+p[17]+p[18]+p[19]; \
		p += 20;
#define	HUNDRED	TWENTY TWENTY TWENTY TWENTY TWENTY
		HUNDRED
		HUNDRED
	}
	stop(sum);
#ifdef	CHECK
	printf("%s: %u\n", av[2], sum);
#endif
	bandwidth(size, 0);
}

int
bytes(s)
	char	*s;
{
	int	n = atoi(s);

	if ((last(s) == 'k') || (last(s) == 'K'))
		n *= 1024;
	if ((last(s) == 'm') || (last(s) == 'M'))
		n *= (1024 * 1024);
	return (n);
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}
