/*
 * bw_mem_wr.c - simple memory write bandwidth benchmark
 *
 * Usage: bw_mem_wr size
 *
 * Sizes less than 1m are not recommended.  This benchmark is directly
 * comparable to the bw_mem_rd benchmark because both do a load/store
 * and an add per word.
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_mem_wr.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include	"timing.c"

#ifndef TYPE
#define TYPE    unsigned int
#endif
#define	SIZE	sizeof(TYPE)
#ifndef N
#define N	10
#endif

main(ac, av)
        char  **av;
{
	register TYPE *p;
	register unsigned long acc;
	register TYPE *end;
        int     usecs, i, bytes;
        TYPE   *mem;
	double	mb;

	write(2, id, strlen(id));
	if (ac != 2) {
		fprintf(stderr,
		    "Usage: %s size\n", av[0]);
		exit(1);
	}
	bytes = atoi(av[1]);
	if ((last(av[1]) == 'k') || (last(av[1]) == 'K'))
		bytes *= 1024;
	if ((last(av[1]) == 'm') || (last(av[1]) == 'M'))
		bytes *= (1024 * 1024);
        mem = (TYPE *)malloc(bytes + 16384);
	if (!mem) {
		perror("malloc");
		exit(1);
	}
	bzero(mem, bytes);	/* for Linux */

	/*
	 * This is a store & an increment on each word so that the memory
	 * and increment operations closely approximate those of the read
	 * test.  We want a store & an op per word.
	 */
#define	TEN	*p++=1;*p++=1;*p++=1;*p++=1;*p++=1; \
		*p++=1;*p++=1;*p++=1;*p++=1;*p++=1;
#define	FIFTY	TEN TEN TEN TEN TEN
#define	HUNDRED	FIFTY FIFTY

	acc = 0;
	end = mem + (bytes/SIZE) - 200;
	start();
	for (i = 0; i < N; ++i) {
		for (p = mem; p < end; ) {
			HUNDRED
			HUNDRED
		}
	}
	usecs = stop(acc);
	fprintf(stderr, "%.04f ", bytes / (1024.*1024));
	bytes *= N;
	mb = bytes / (1024.*1024);
	fprintf(stderr, "%.2f\n", mb / (usecs / 1000000.));
	exit(0);
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}
