/*
 * bw_file_rd.c - time reading & summing of a file
 *
 * Usage: bw_file_rd size file
 *
 * The intent is that the file is in memory, so run this twice or more,
 * and report only the best numbers.  Disk benchmarking is done with lmdd.
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: bw_file_rd.c,v 1.1 1994/11/18 08:49:48 lm Exp $\n";

#include "timing.c"


#define	CHK(x)		if ((int)(x) == -1) { perror("x"); exit(1); }
#define	MIN(a, b)	((a) < (b) ? (a) : (b))

main(ac, av)
	char **av;
{
	int n, j, size, fd;
	char	buf[1024*64];
	unsigned int sum, *p;

	write(2, id, strlen(id));

	if (ac != 3) {
		fprintf(stderr, "Usage: %s size file\n", av[0]);
		exit(1);
	}
	size = bytes(av[1]);
	CHK(fd = open(av[2], 0));
	start();
	while (size > 0) {
		CHK(n = read(fd, buf, sizeof(buf)));
		if (n < sizeof(buf)) {
			break;
		}
#define	SIXTEEN	sum += p[0]+p[1]+p[2]+p[3]+p[4]+p[5]+p[6]+p[7]+p[8]+p[9]+ \
		p[10]+p[11]+p[12]+p[13]+p[14]+p[15]; p += 16;
#define	SIXTYFOUR	SIXTEEN SIXTEEN SIXTEEN SIXTEEN
		for (p=(unsigned int*)buf, j=0; j < 64; ++j) {
			/*
			 * This assumes that sizeof(int) == 4
			 */
			SIXTYFOUR
			SIXTYFOUR
			SIXTYFOUR
			SIXTYFOUR	/* 256 * 4 = 1K; * 64 in loop = 64K */
		}
		size -= n;
	}
	stop();
	bandwidth(bytes(av[1]), 0);
}

int
bytes(s)
	char	*s;
{
	int	n = atoi(s);

	if ((last(s) == 'k') || (last(s) == 'K'))
		n *= 1024;
	if ((last(s) == 'm') || (last(s) == 'M'))
		n *= (1024 * 1024);
	return (n);
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}
