/* Copyright (c) 1987, 1988  Stanley T. Shebs, University of Utah. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* RCS $Header: /home/users/brossard/X/commands/x11conq/RCS/play.c,v 2.0 90/10/20 12:50:33 brossard Exp Locker: brossard $ */
/*
 * $Log:	play.c,v $
 * Revision 2.0  90/10/20  12:50:33  brossard
 * First version that tries to merge changes from 5.4
 * 
 * Revision 1.5  90/09/04  12:33:12  brossard
 * The computer would sometime go into an infinite loop
 * 
 * Revision 1.4  90/07/30  11:45:22  brossard
 * Only beep when there is a unit to move (manually)
 * 
 * Revision 1.3  90/07/19  19:17:49  brossard
 * Multi move units would only play the first move.
 * 
 * Revision 1.2  90/07/17  20:13:33  brossard
 * Better display of the curside
 * 
 * Revision 1.1  90/07/17  18:42:16  brossard
 * Initial revision
 * 
 */

#include "config.h"
#include "misc.h"
#include "dir.h"
#include "period.h"
#include "side.h"
#include "unit.h"
#include "map.h"
#include "global.h"

bool delaymove;

/* Unit can be awake permanently or temporarily. */

#define is_awake(u) ((u)->orders.type == AWAKE || (u)->awake)

/* The movement phases starts by precomputing theoretical maxima for moves, */
/* then does each side simultaneously. */

movement_phase()
{
    register Side *side;

    if (Debug) printf("Entering movement phase\n");
    compute_moves();
    for_all_sides(side) {
	side->directorder = FALSE;
	side->movunit = NULL;
	side->curunit = NULL;
	if (!humanside(side))
	    init_machine_turn(side);
    }
/*
 *	1- play the computers
 *	2- play all humans in parallel
 *	2.1- Find the first unit to be moved
 */
    play_computers();
    for_all_sides(side) {
	if (!humanside(side) || side->lost) continue;
	if (Debug) printf("--- %s ---\n", side->name);
	side->done = FALSE;
	side->loopagain = FALSE;
	side->curunit = NULL;
	move_mode(side);
	show_curside(side);
	find_unit_to_play( side );
	if( !side->done ) beep( side );
	unshow_curside(side);
    }
/*
 *	2.2- Go wait for an input
 *	2.3- Play that input
 *	2.4- Find next unit to play
 */
    while( players_to_be_played() ) wait_for_input();

    /* For display hacking, also to find misc bugs :-) */
}
/*
 *	Find a unit for the player to move, all unit on "automatic"
 * are just moved as we scan the array.  So basically, loop through the
 * unit to be moved until we block on input.
 */
find_unit_to_play( side )
    register Side *side;
{
    register Unit *unit;
    bool loop;

    do {
	loop = FALSE;
	if( side->curunit ) {
	    if( delaymove ){
		unit = side->curunit->next;
		side->loopagain = TRUE;
		delaymove = FALSE;
	    } else unit = side->curunit;
	} else		unit = unitlist;
	for( ; unit ; unit = unit->next )
	    while( unit->side == side && alive(unit) && unit->movesleft > 0 ) {
		make_current(side, unit);
		move_1(side, unit);
		if( side->lost ) return;
		if( side->reqactive ) {
		    setup_handle_requests( side );
		    return;
		}
	    }
	side->curunit = NULL;
	if( side->loopagain ) {
	    side->loopagain = FALSE;
	    loop = TRUE;
	}
    } while( loop ) ;
/*
 *	Well it looks like this player didn't have anything to move!
 */
    side->done = TRUE;
    if (side->mode != SURVEY) goto_empty_hex(side);
    survey_mode(side);
    request_command(side);
    setup_handle_requests( side );
}

/* To move a single unit once.  Return true if we need player input */
/* A single move is either under preset orders, or must be */
/* supplied by a human player, or computed by a machine. */

move_1(side, unit)
Side *side;
Unit *unit;
{
    Side *side2;

    if (Debug) printf("%s going to move\n", unit_handle(NULL, unit));
    if (idled(unit) && global.setproduct) {
	request_new_product(unit);
    } else if (!is_awake(unit)) {
	follow_order(unit);
    } else if (under_control(unit)) {
	side->directorder = TRUE;
	request_command(side);
    } else {
	show_info(side);
	machine_move(unit);
    }
}
/* computer moves, different from above because we don't have worry about
 * blocking input
 */

computer_move_1(side, unit)
Side *side;
Unit *unit;
{
    Side *side2;

    if (Debug) printf("%s going to move\n", unit_handle(NULL, unit));
    side->move_tries = 0;
    while (alive(unit) && unit->movesleft > 0 && !delaymove && !side->lost) {
	if (idled(unit) && global.setproduct) {
	    request_new_product(unit);
	} else if (!is_awake(unit)) {
	    follow_order(unit);
	} else {
	    show_info(side);
	    machine_move(unit);
	}
/*
 *	Not necessary with new mplay (?)
	side->move_tries++;
 */
    }
    if (delaymove) {
	fprintf(stderr,"Machine delayed its move!\n");
	delaymove = FALSE;
	side->loopagain = TRUE;
    }
}
play_computers()
{
    register Unit *unit;
    register Side *side;
    for_all_sides(side) {
	if (humanside(side)) continue;
	if (Debug) printf("--- %s ---\n", side->name);
	if (!side->lost) {
	    show_curside(side);
	    side->loopagain = TRUE;
	    while (side->loopagain && !side->lost) {
		side->loopagain = FALSE;
		for_all_units(unit) {
		    if (unit->side == side && !side->lost) {
			if (change_machine_product(unit)) {
			    request_new_product(unit);
			} else {
			    make_current(side, unit);
			    move_mode(side);
			    computer_move_1(side, unit);
			}
		    }
		}
		if( side->loopagain ) fprintf( stderr, "Computer loops\n" );
	    }
	    unshow_curside(side);
	}
    }
}
players_to_be_played()
{
    register Side *side;
    int count = 0;
    for_all_sides(side)	/* computers are always done */
	if( ! side->lost && ! side->done ) count++;
    return count;
}
