#include "config.h"
#include "misc.h"
#include "side.h"
#include <X11/Xlib.h>
#include "X11.h"

/* Main funnel for input returns both mouse and keyboard events, and maybe */
/* other kinds eventually.  Some events like window exposure are handled */
/* strictly locally. */

extern bool delaymove;

wait_for_input()
{
    fd_set              readfds;
    int			nfound;
    register Side *side;

#ifdef	FD_ZERO
    FD_ZERO( &readfds );
#else
    readfs = 0;
#endif
    for_all_sides( side ) {
	if ( ! active_display(side)) continue;
#ifdef	FD_ZERO
	FD_SET( ConnectionNumber(sdd()), &readfds );
#else
	readfds |= (1 << ConnectionNumber(sdd()));
#endif
	side->lasttime = time(0);
	flush_output( side );
    }
    nfound = select( 64, &readfds, 0, 0, 0);
    if ( nfound < 0 ) perror( "In select, will try again" );
    else {
	for_all_sides( side ) {
	    if ( ! active_display(side)) continue;
#ifdef	FD_ZERO
	    if (FD_ISSET( ConnectionNumber(sdd()), &readfds)) {
#else
	    if (readfds & (1 << ConnectionNumber(sdd()))) {
#endif
		show_curside( side );
		process_events( side );
		side->timeleft -= (time(0) - side->lasttime);
		update_clock( side );
		delaymove = FALSE;
		handle_requests( side );
		unshow_curside( side );
	    }
	}
    }
}
