/* Quicky hack to convert old-style maps into new-style.  R/W to stdin/out. */
/* Unit side names evaporate entirely, sigh, and no run-length encoding. */

#include <stdio.h>
#include "misc.h"

#define SEPCHAR '*'

char citybuf[8000];
char *uname[1000], *usname[1000];
/* have to do something about this! */
char terrchars[] = ".,=+%~(^_:";
char terrain[400][400];
int ux[1000], uy[1000], utype[1000];

main()
{
    char ch, *name, *sname, *next;
    int worldwidth, worldheight, worldscale, greenwich, equator;
    int i, j, x, y, terr, x1, numcities = 0;
    
    scanf("M %d %d %d %d %d\n",
	  &worldwidth, &worldheight, &greenwich, &equator, &worldscale);
    for (y = worldheight-1; y >= 0; --y) {
	for (x = 0; x < worldwidth; ++x) {
	    x1 = x - y / 2;  	    /* New x coordinate */
	    if (x1 < 0) x1 += worldwidth;
	    scanf("%c", &ch);
	    terr = iindex(ch, terrchars);
	    if (terr < 0) {
		terr = '+';
		ux[numcities] = x1;  uy[numcities] = y;
		utype[numcities] = ch;
		numcities++;
	    }
	    terrain[x1][y] = terr;
	}
	scanf("\n");
    }
    i = 0;
    while ((ch = getc(stdin)) != EOF) {
	if (ch == ' ' || ch == '\n' || ch == '\t') ch = '\0';
	if (ch == '\\') ch = getc(stdin);
	citybuf[i++] = ch;
    }
    citybuf[i++] = '\0';  /* in case somebody forgot a newline at EOF */
    name = citybuf;
    for (i = 0; i < numcities; ++i) {
	next = (char *) index(name,'\0');
	sname = (char *) index(name, SEPCHAR);
	if (sname != NULL) *sname++ = '\0';
	uname[i] = name;
	usname[i] = sname;
	while (*next++ == '\0');
	name = next-1;
    }
    printf("Xconq 0 -+---+\n");
    printf("Map %d %d %d 1 0\n", worldwidth, worldheight, worldscale);
    for (y = worldheight-1; y >= 0; --y) {
	for (x = 0; x < worldwidth; ++x) {
	    putc(terrchars[(int) terrain[x][y]], stdout);
	}
	printf("\n");
    }
    printf("Units %d 1 0\n", numcities);
    for (i = 0; i < numcities; ++i) {
	if (usname[i] == NULL || strlen(usname[i]) == 1) usname[i] = "*";
	for (j = 0; j < strlen(uname[i]); ++j) {
	    if ((uname[i])[j] == ' ') (uname[i])[j] = '*';
	}
	printf("%c %s %d,%d\n", utype[i], uname[i], ux[i], uy[i]);
    }
}

/* Get a *numeric* index into a string (infinitely more useful than ptr!). */
/* Return -1 on failed search. */

iindex(ch, str)
char ch, *str;
{
    int i;

    if (str == NULL) return (-1);
    for (i = 0; str[i] != '\0'; ++i) {
	if (ch == str[i]) return i;
    }
    return (-1);
}
