/* Copyright (c) 1987, 1988  Stanley T. Shebs, University of Utah. */
/* Copyright 1988 by Chris D. Peterson, MIT. */
/* Many improvements by Tim Moore, University of Utah. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact.  */

/* RCS $Header: /home/users/brossard/X/commands/x11conq/RCS/Xgc.c,v 2.1 90/10/20 16:17:06 brossard Exp Locker: brossard $
 *
 * $Log:	Xgc.c,v $
 * Revision 2.1  90/10/20  16:17:06  brossard
 * Fixed the help screen, inserted the new patches
 * 
 * Revision 2.0  90/10/20  12:48:03  brossard
 * First version that tries to merge changes from 5.4
 * 
 * Revision 1.1  90/07/15  19:17:12  brossard
 * Initial revision
 * 
 */

/* Creation of gc's for the X11 version of xconq. */

#include "config.h"
#include "misc.h"
#include "period.h"
#include "side.h"

/* careful of the path of the X header files. */

#ifdef UNIX
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif UNIX
#include "X11.h"
#include "Xgc.h"

#define arf1x1_width 16
#define arf1x1_height 16

static char arf1x1_bits[] = {
   0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55,
   0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55,
   0xff, 0xff, 0x55, 0x55, 0xff, 0xff, 0x55, 0x55};


/* Do the rigmarole to convert all those short arrays into X-approved */
/* Bitmaps.  Note that this has to be for *each* display separately (!) */
/* Also get the cursor shape.  If the hardware can't hack the desired */
/* cursor size, warn about it and just use the root window's cursor. */
/* 0x0 cursor specs seem to be don't cares - machine can handle any size */
/* X11 also needs gazillions of GCs, since we've got so many fonts and */
/* colors and bitmaps. */

#ifdef __STDC__
void create_gc( register Side *side )
#else
void create_gc(side) register Side *side;
#endif
{
    int u, w, h;
    unsigned long mask;
    XGCValues values;
    Pixmap dots;
    GC gc;

    mask = GCForeground | GCBackground;
    values.foreground = side->fgcolor;
    values.background = side->bgcolor;
    gc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->gc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->flashgc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->textgc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->helpgc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->icongc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->varicongc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->unitgc = XCreateGC(sdd(), side->main, mask, &values);
    sd()->unittextgc = XCreateGC(sdd(), side->main, mask, &values);
    values.foreground = side->bgcolor;
    values.background = side->fgcolor;
    sd()->invicongc = XCreateGC(sdd(), side->main, mask, &values);
    values.function = GXclear;
    mask = GCFunction;
    sd()->cleargc = XCreateGC(sdd(), side->main, mask, &values);

    XSetFont(sdd(), sd()->textgc, sd()->textfont->fid);
    XSetFont(sdd(), sd()->helpgc, sd()->helpfont->fid);
    XSetFont(sdd(), sd()->icongc, sd()->iconfont->fid);
    mask = GCFillStyle | GCGraphicsExposures;
    values.fill_style = FillSolid;
    values.graphics_exposures = FALSE;
    XChangeGC(sdd(), sd()->unitgc, mask, &values);
    XSetFont(sdd(), sd()->unittextgc, sd()->unitfont->fid);
    XSetFont(sdd(), sd()->invicongc, sd()->iconfont->fid);
    XSetFont(sdd(), sd()->varicongc, sd()->iconfont->fid);
    XSetFunction(sdd(), sd()->flashgc, GXinvert);

    dots  = XCreateBitmapFromData(sdd(), side->main, 
				  dots_bits, dots_width, dots_height);

    sd()->bombpics[0] = XCreateBitmapFromData(sdd(), side->main,
	bomb1_bits, bomb1_width, bomb1_height);
    sd()->bombpics[1] = XCreateBitmapFromData(sdd(), side->main,
        bomb2_bits, bomb2_width, bomb2_height);
    sd()->bombpics[2] = XCreateBitmapFromData(sdd(), side->main,
	bomb3_bits, bomb3_width, bomb3_height);
    sd()->bombpics[3] = XCreateBitmapFromData(sdd(), side->main,
	bomb4_bits, bomb4_width, bomb4_height);
    for_all_unit_types(u) {
	if (utypes[u].bitmapname && (strlen(utypes[u].bitmapname) > 0)) {
	    sd()->unitpics[u] = load_bitmap(side, utypes[u].bitmapname);
	} else {
	    utypes[u].bitmapname = NULL;
	}
    }
    if (Debug) printf("Bitmaps stored ...\n");

    sd()->wbdots = XCreatePixmap(sdd(), side->main, dots_width, dots_height,
				 DefaultDepth(sdd(), DefaultScreen(sdd())));
    sd()->bwdots = XCreatePixmap(sdd(), side->main, dots_width, dots_height,
				 DefaultDepth(sdd(), DefaultScreen(sdd())));

    /* Since clearbitgc has to have a depth of 1 we'll */
    /* hang it off bombpics[0] */
    mask = GCFunction;
    values.function = GXclear;
    sd()->clearbitgc = XCreateGC(sdd(), sd()->bombpics[0], mask, &values);

    XSetForeground(sdd(), gc, side->fgcolor);
    XSetBackground(sdd(), gc, side->bgcolor);
    XSetStipple(sdd(), gc, dots);
    XSetFillStyle(sdd(), gc, FillOpaqueStippled);
    XFillRectangle(sdd(), sd()->wbdots, gc, 0, 0, dots_width, dots_height);

    XSetForeground(sdd(), gc, side->bgcolor);
    XSetBackground(sdd(), gc, side->fgcolor);
    XFillRectangle(sdd(), sd()->bwdots, gc, 0, 0, dots_width, dots_height);
    if (Debug) printf("Tiles stored ...\n");

    XFreeGC(sdd(), gc);
    XFreePixmap(sdd(), dots);
    if( side->monochrome ) {
	sd()->gc_neutral = sd()->gc_enemy = sd()->textgc; /* fgcolor */
	gc = xMakeGC();
	XSetFillStyle( sdd(), gc, FillOpaqueStippled );
	XSetStipple( sdd(), gc, XCreateBitmapFromData( sdd(), side->main,
			arf1x1_bits, arf1x1_width, arf1x1_height ));
	sd()->gc_known = gc;
	sd()->gc_us = sd()->gc_allied = 0; /* background */
    } else {
	sd()->gc_enemy = xCMakeGC( side->enemycolor, side->bgcolor );
	sd()->gc_neutral = xCMakeGC( side->graycolor, side->bgcolor );
	sd()->gc_known = xMakeGC( );    /* color is variable */
	sd()->gc_us = xCMakeGC( side->bdcolor, side->bgcolor );
	sd()->gc_allied = xCMakeGC( side->altcolor, side->bgcolor );
    }
}


#ifdef __STDC__
void create_cursor( register Side *side )
#else
void create_cursor(side) register Side *side;
#endif
{
    unint w, h;
    Pixmap mmask, mcurs;

    mmask = XCreateBitmapFromData(sdd(), side->main,
					mask_bits, mask_width, mask_height);
    mcurs = XCreateBitmapFromData(sdd(), side->main,
					curs_bits, curs_width, curs_height);

    XQueryBestCursor(sdd(), side->main, curs_width, curs_height, &w, &h);
    if (Debug) printf("Allowed cursor shape is %dx%d\n", w, h);
    if (w == curs_width && h == curs_height) {
        sd()->curs =
	  make_cursor(sdd(), mcurs, mmask, white_color(side),
		      black_color(side), 7, 7);
	XDefineCursor(sdd(), side->map, sd()->curs);
	   
    } else {
	fprintf(stderr, "Warning: Can't have %dx%d cursors on \"%s\"!\n",
		curs_width, curs_height, side->host);
        fprintf(stderr, "Using default cursor...\n");
    }
    if (Debug) printf("Cursor stored ...\n");
    XFreePixmap(sdd(), mmask);
    XFreePixmap(sdd(), mcurs);
}
/* Since XCreatePixmapCursor() takes XColors and not pixel values we */
/* have to look the colors associated with the foreground and */
/* background pixel values up in the color table and pass them to */
/* XCreatePixmapCursor(). */
   
Cursor make_cursor(dpy, curs, mask, foreground, background, x, y)
Display *dpy;
Pixmap curs, mask;
unsigned long foreground, background;
unsigned int x, y;
{
    XColor defs[2];

    defs[0].pixel = foreground;
    defs[1].pixel = background;
    XQueryColors(dpy, DefaultColormap(dpy, DefaultScreen(dpy)), defs, 2);
    return  XCreatePixmapCursor(dpy, curs, mask, &defs[0], &defs[1], x, y);
}

/* Try to load a bitmap of the given name - can be either X11-only (.b11) */
/* or X10 (.b) bitmaps, but prefer X11 flavor. */

Pixmap
load_bitmap(side, name)
Side *side;
char *name;
{
    unint w, h;
    int junk, a;
    Pixmap rslt;

    make_pathname(NULL, name, "b11", spbuf);
    a = XReadBitmapFile(sdd(), side->main, spbuf, &w, &h, &rslt, &junk, &junk);
    if (a == BitmapSuccess) return rslt;
    make_pathname(NULL, name, "b", spbuf);
    a = XReadBitmapFile(sdd(), side->main, spbuf, &w, &h, &rslt, &junk, &junk);
    if (a == BitmapSuccess) return rslt;
    make_pathname(XCONQLIB, name, "b11", spbuf);
    a = XReadBitmapFile(sdd(), side->main, spbuf, &w, &h, &rslt, &junk, &junk);
    if (a == BitmapSuccess) return rslt;
    make_pathname(XCONQLIB, name, "b", spbuf);
    a = XReadBitmapFile(sdd(), side->main, spbuf, &w, &h, &rslt, &junk, &junk);
    if (a == BitmapSuccess) return rslt;
    fprintf(stderr, "Bitmap name \"%s\" not found anywhere!\n", name);
    return (-1);
}
