/* Copyright (c) 1987, 1988  Stanley T. Shebs, University of Utah. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* RCS $Header: /home/users/brossard/X/commands/x11conq/RCS/X11draw_world.c,v 2.0 90/10/20 12:47:52 brossard Exp $ */

#include "config.h"
#include "misc.h"
#include "side.h"
#include "map.h"

#include <X11/Xlib.h>
#include "X11.h"

/* Compute the color representing a hex from the given side's point of view. */
/* gc == 0 -> background (UNSEEN) -> don't bother drawing it */

#ifdef __STDC__
static void world_color( register Side *side, int x, int y,
			unsigned long *color, GC *gc)
#else
static void
world_color(side, x, y, color, gc)
Side *side;
int x, y;
unsigned long *color;
GC *gc;
#endif
{
    int view = side_view(side, x, y);
    Side *side2;

    if (view == UNSEEN ) { *color = 0; *gc =0; return; }
    if (view == EMPTY) {
	*color = side->hexcolor[terrain_at(x, y)];
	*gc = sd()->gc_known;
	return;
    }
    *color = 0;
    side2 = side_n(vside(view));
    *gc = (side2 == NULL) ? sd()->gc_neutral :
	    (side2 == side) ? sd()->gc_us :
	    allied_side(side2, side) ? sd()->gc_allied : sd()->gc_enemy;
}

/* Redraw the map of the whole world.  We use square blobs instead of icons, */
/* since individual "hexes" may be as little as 1x1 pixels in size, and */
/* there are lots of them.  Algorithm uses run-length encoding to find and */
/* draw bars of constant color.  */

show_world(side)
Side *side;
{
    int x, y, prev_x;
    unsigned long color = 0, prev_color = 0;
    GC gc=(GC)0, prev_gc =  sd()->textgc /* dummy value */;

    if (active_display(side) && world_display(side)) {
	clear_window(side, side->world);
	for (y = world.height-1; y >= 0; --y) {
	    prev_x = 0;
	    world_color(side, prev_x, y, &prev_color, &prev_gc );
	    for ( x = prev_x + 1; x < world.width; ++x) {
		world_color(side, x, y, &color, &gc );
		if (color == prev_color && gc == prev_gc ) continue;
		draw_bar(side, prev_x, y, x - prev_x, prev_color, prev_gc );
		prev_color = color;
		prev_x = x;
		prev_gc = gc;
	    }
	    draw_bar(side, prev_x, y, world.width - prev_x, color, gc );
	}
	if (side->vcy >= 0) draw_box(side);
    }
}

/* Draw an individual detailed hex, as a row of one. */
/* This routine may be called in cases where the hex is not on the main */
/* screen;  if so, then the world map but not the local map is drawn on. */
/* (should the display be shifted to make visible?) */

draw_hex(side, x, y, flushit)
Side *side;
int x, y;
bool flushit;
{
    int sx, sy;
    unsigned long color;
    GC gc;

    if (active_display(side)) {
        if (side->monochrome || side->showmode == TERRICONS) {
            xform(side, unwrap(side, x, y), y, &sx, &sy);
            draw_hex_icon(side, side->map, sx, sy, side->bgcolor, HEX);
        }
        draw_row(side, unwrap(side, x, y), y, 1);
        world_color(side, x, y, &color, &gc );
        draw_bar(side, x, y, 1, color, gc );
        if (flushit) flush_output(side);
    }
}
