/* Copyright (c) 1987, 1988  Stanley T. Shebs, University of Utah. */
/* Copyright 1988 by Chris D. Peterson, MIT. */
/* Many improvements by Tim Moore, University of Utah. */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact.  */

/* RCS $Header: /home/users/brossard/X/commands/x11conq/RCS/X11.h,v 2.1 90/10/20 16:16:02 brossard Exp Locker: brossard $
 *
 * $Log:	X11.h,v $
 * Revision 2.1  90/10/20  16:16:02  brossard
 * Fixed the help screen, inserted the new patches
 * 
 * Revision 2.0  90/10/20  12:50:55  brossard
 * First version that tries to merge changes from 5.4
 * 
 * Revision 1.1  90/07/15  19:16:41  brossard
 * Initial revision
 * 
 */

/*
 *	Maximum size of help window
 */
#define HELP_WINDOW_SIZE	55

/* Use with caution - variable name "side" embedded! */

#define sd() ((Screeno *) side->display)

#define sdd() (((Screeno *) side->display)->disp)

typedef unsigned int unint;

/* GC rules are for different fonts etc, but not colors or bitmaps. */

typedef struct a_screen {
    Display *disp;
    GC gc;			/* a tmp graphics context for this display */
    GC flashgc;			/* The gc for drawing the flash lines. */
    GC textgc;			/* foreground on background text */
    GC helpgc;			/* foreground on background help text */
    GC icongc;			/* icon graphics context */
    GC invicongc;		/* icon gc inverted colors. */
    GC varicongc;		/* This is an icon gc with variable fgcolor. */
    GC unitgc;			/* unit bitmap printing gc. */
    GC unittextgc;		/* unit text printing gc. */
    GC cleargc;			/* The gc to use for clearing areas. */
    GC clearbitgc;              /* gc for clearing bitmaps */
    GC gc_enemy,		/* B/W: ennemy & neutral are the same: fg color */
    gc_neutral,			/* color: neutral territory is gray */
    gc_known,			/* B/W: known territory is gray */
    gc_us,			/* B/W: us: bg color */
    gc_allied;			/* B/W: same as us, color: altcolor */
    XFontStruct *textfont;	/* font for text display */
    XFontStruct *iconfont;	/* utility font with assorted icons */
    XFontStruct *unitfont;	/* font for unit characters */
    XFontStruct *helpfont;	/* font for help text display */
    Pixmap bombpics[4];		/* mushroom clouds */
    Pixmap unitpics[MAXUTYPES];	/* used instead of font sometimes */
    Pixmap wbdots, bwdots;	/* blue border and dotted backgrounds */
    Cursor curs;		/* the cursor object itself */
} Screeno;

/* Random function declarations. */

XFontStruct * open_font();
Pixmap load_bitmap();
void get_font_size();
Cursor make_cursor();
#ifdef  __STDC__
void expose( register Side *, register XEvent *);
void create_gc( register Side * );
void create_cursor( register Side * );
void draw_bar( register Side *, int, int, int, unsigned long, GC );
#else
void expose();
void create_gc();
void create_cursor();
void draw_bar();
#endif


