.rn '' }`
''' $RCSfile$$Revision$$Date$
''' 
''' $Log$
''' 
.de Sh
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb
.ft CW
.nf
.ne \\$1
..
.de Ve
.ft R

.fi
..
'''
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
.if t .ds PI \(*p
.if n .ds PI PI
'br\}
.TH PERLOP 1 "\*(RP"
.UC
.if n .hy 0 
.if n .na
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.de CQ          \" put $1 in typewriter font
.ft CW
'if n "\c
'if t \\&\\$1\c
'if n \\&\\$1\c
'if n \&"
\\&\\$2 \\$3 \\$4 \\$5 \\$6 \\$7
'.ft R
..
.\" @(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2
.	\" AM - accent mark definitions
.bd S B 3
.	\" fudge factors for nroff and troff
.if n \{\
.	ds #H 0
.	ds #V .8m
.	ds #F .3m
.	ds #[ \f1
.	ds #] \fP
.\}
.if t \{\
.	ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.	ds #V .6m
.	ds #F 0
.	ds #[ \&
.	ds #] \&
.\}
.	\" simple accents for nroff and troff
.if n \{\
.	ds ' \&
.	ds ` \&
.	ds ^ \&
.	ds , \&
.	ds ~ ~
.	ds ? ?
.	ds ! !
.	ds / 
.	ds q 
.\}
.if t \{\
.	ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.	ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.	ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.	ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.	ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.	ds ? \s-2c\h'-\w'c'u*7/10'\u\h'\*(#H'\zi\d\s+2\h'\w'c'u*8/10'
.	ds ! \s-2\(or\s+2\h'-\w'\(or'u'\v'-.8m'.\v'.8m'
.	ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.	ds q o\h'-\w'o'u*8/10'\s-4\v'.4m'\z\(*i\v'-.4m'\s+4\h'\w'o'u*8/10'
.\}
.	\" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds v \\k:\h'-(\\n(.wu*9/10-\*(#H)'\v'-\*(#V'\*(#[\s-4v\s0\v'\*(#V'\h'|\\n:u'\*(#]
.ds _ \\k:\h'-(\\n(.wu*9/10-\*(#H+(\*(#F*2/3))'\v'-.4m'\z\(hy\v'.4m'\h'|\\n:u'
.ds . \\k:\h'-(\\n(.wu*8/10)'\v'\*(#V*4/10'\z.\v'-\*(#V*4/10'\h'|\\n:u'
.ds 3 \*(#[\v'.2m'\s-2\&3\s0\v'-.2m'\*(#]
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.ds oe o\h'-(\w'o'u*4/10)'e
.ds Oe O\h'-(\w'O'u*4/10)'E
.	\" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.	\" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.	ds : e
.	ds 8 ss
.	ds v \h'-1'\o'\(aa\(ga'
.	ds _ \h'-1'^
.	ds . \h'-1'.
.	ds 3 3
.	ds o a
.	ds d- d\h'-1'\(ga
.	ds D- D\h'-1'\(hy
.	ds th \o'bp'
.	ds Th \o'LP'
.	ds ae ae
.	ds Ae AE
.	ds oe oe
.	ds Oe OE
.\}
.rm #[ #] #H #V #F C
.SH "NAME"
perlop \- Perl operators and precedence
.SH "SYNOPSIS"
Perl operators have the following associativity and precedence,
listed from highest precedence to lowest.  Note that all operators
borrowed from C keep the same precedence relationship with each other,
even where C's precedence is slightly screwy.  (This makes learning
Perl easier for C folks.)
.PP
.Vb 24
\&    left        terms and list operators (leftward)
\&    left        ->
\&    nonassoc    ++ --
\&    right       **
\&    right       ! ~ \e and unary + and -
\&    left        =~ !~ 
\&    left        * / % x
\&    left        + - .
\&    left        << >>
\&    nonassoc    named unary operators
\&    nonassoc    < > <= >= lt gt le ge
\&    nonassoc    == != <=> eq ne cmp
\&    left        &
\&    left        | ^
\&    left        &&
\&    left        ||
\&    nonassoc    ..
\&    right       ?:
\&    right       = += -= *= etc.
\&    left        , =>
\&    nonassoc    list operators (rightward)
\&    left        not
\&    left        and
\&    left        or xor
.Ve
In the following sections, these operators are covered in precedence order.
.SH "DESCRIPTIONS"
.Sh "Terms and List Operators (Leftward)"
Any \s-1TERM\s0 is of highest precedence of Perl.  These includes variables,
quote and quotelike operators, any expression in parentheses,
and any function whose arguments are parenthesized.  Actually, there
aren't really functions in this sense, just list operators and unary
operators behaving as functions because you put parentheses around
the arguments.  These are all documented in the \fIperlfunc\fR manpage.
.PP
If any list operator (\fIprint()\fR, etc.) or any unary operator (\fIchdir()\fR, etc.)
is followed by a left parenthesis as the next token, the operator and
arguments within parentheses are taken to be of highest precedence,
just like a normal function call.
.PP
In the absence of parentheses, the precedence of list operators such as
\f(CWprint\fR, \f(CWsort\fR, or \f(CWchmod\fR is either very high or very low depending on
whether you look at the left side of operator or the right side of it.
For example, in
.PP
.Vb 2
\&    @ary = (1, 3, sort 4, 2);
\&    print @ary;         # prints 1324
.Ve
the commas on the right of the sort are evaluated before the sort, but
the commas on the left are evaluated after.  In other words, list
operators tend to gobble up all the arguments that follow them, and
then act like a simple \s-1TERM\s0 with regard to the preceding expression.
Note that you have to be careful with parens:
.PP
.Vb 3
\&    # These evaluate exit before doing the print:
\&    print($foo, exit);  # Obviously not what you want.
\&    print $foo, exit;   # Nor is this.
.Ve
.Vb 4
\&    # These do the print before evaluating exit:
\&    (print $foo), exit; # This is what you want.
\&    print($foo), exit;  # Or this.
\&    print ($foo), exit; # Or even this.
.Ve
Also note that
.PP
.Vb 1
\&    print ($foo & 255) + 1, "\en";
.Ve
probably doesn't do what you expect at first glance.  See 
the section on \fINamed Unary Operators\fR for more discussion of this.
.PP
Also parsed as terms are the \f(CWdo {}\fR and \f(CWeval {}\fR constructs, as
well as subroutine and method calls, and the anonymous 
constructors \f(CW[]\fR and \f(CW{}\fR.
.PP
See also the section on \fIQuote and Quotelike Operators\fR toward the end of this section,
as well as the section on \fII/O Operators\fR.
.Sh "The Arrow Operator"
Just as in C and \*(C+, \*(L"\f(CW->\fR\*(R" is an infix dereference operator.  If the
right side is either a \f(CW[...]\fR or \f(CW{...}\fR subscript, then the left side
must be either a hard or symbolic reference to an array or hash (or
a location capable of holding a hard reference, if it's an lvalue (assignable)).
See the \fIperlref\fR manpage.
.PP
Otherwise, the right side is a method name or a simple scalar variable
containing the method name, and the left side must either be an object
(a blessed reference) or a class name (that is, a package name).
See the \fIperlobj\fR manpage.
.Sh "Autoincrement and Autodecrement"
\*(L"++\*(R" and \*(L"--\*(R" work as in C.  That is, if placed before a variable, they
increment or decrement the variable before returning the value, and if
placed after, increment or decrement the variable after returning the value.
.PP
The autoincrement operator has a little extra built-in magic to it.  If
you increment a variable that is numeric, or that has ever been used in
a numeric context, you get a normal increment.  If, however, the
variable has only been used in string contexts since it was set, and
has a value that is not null and matches the pattern
\f(CW/^[a-zA-Z]*[0-9]*$/\fR, the increment is done as a string, preserving each
character within its range, with carry:
.PP
.Vb 4
\&    print ++($foo = '99');      # prints '100'
\&    print ++($foo = 'a0');      # prints 'a1'
\&    print ++($foo = 'Az');      # prints 'Ba'
\&    print ++($foo = 'zz');      # prints 'aaa'
.Ve
The autodecrement operator is not magical.
.Sh "Exponentiation"
Binary \*(L"**\*(R" is the exponentiation operator.  Note that it binds even more
tightly than unary minus, so \-2**4 is \-(2**4), not (\-2)**4.
.Sh "Symbolic Unary Operators"
Unary \*(L"!\*(R" performs logical negation, i.e. \*(L"not\*(R".  See also \f(CWnot\fR for a lower
precedence version of this.
.PP
Unary \*(L"\-\*(R" performs arithmetic negation if the operand is numeric.  If
the operand is an identifier, a string consisting of a minus sign
concatenated with the identifier is returned.  Otherwise, if the string
starts with a plus or minus, a string starting with the opposite sign
is returned.  One effect of these rules is that \f(CW-bareword\fR is equivalent
to \f(CW"-bareword"\fR.
.PP
Unary \*(L"~\*(R" performs bitwise negation, i.e. 1's complement.
.PP
Unary \*(L"+\*(R" has no effect whatsoever, even on strings.  It is useful
syntactically for separating a function name from a parenthesized expression
that would otherwise be interpreted as the complete list of function
arguments.  (See examples above under the section on \fIList Operators\fR.)
.PP
Unary \*(L"\e\*(R" creates a reference to whatever follows it.  See the \fIperlref\fR manpage.
Do not confuse this behavior with the behavior of backslash within a
string, although both forms do convey the notion of protecting the next
thing from interpretation.
.Sh "Binding Operators"
Binary \*(L"=~\*(R" binds an expression to a pattern match.
Certain operations search or modify the string \f(CW$_\fR by default.  This
operator makes that kind of operation work on some other string.  The
right argument is a search pattern, substitution, or translation.  The
left argument is what is supposed to be searched, substituted, or
translated instead of the default \f(CW$_\fR.  The return value indicates the
success of the operation.  (If the right argument is an expression
rather than a search pattern, substitution, or translation, it is
interpreted as a search pattern at run time.  This is less efficient
than an explicit search, since the pattern must be compiled every time
the expression is evaluated\*(--unless you've used \f(CW/o\fR.)
.PP
Binary \*(L"!~\*(R" is just like \*(L"=~\*(R" except the return value is negated in
the logical sense.
.Sh "Multiplicative Operators"
Binary \*(L"*\*(R" multiplies two numbers.
.PP
Binary \*(L"/\*(R" divides two numbers.
.PP
Binary \*(L"%\*(R" computes the modulus of the two numbers.
.PP
Binary \*(L"x\*(R" is the repetition operator.  In a scalar context, it
returns a string consisting of the left operand repeated the number of
times specified by the right operand.  In a list context, if the left
operand is a list in parens, it repeats the list.
.PP
.Vb 1
\&    print '-' x 80;             # print row of dashes
.Ve
.Vb 1
\&    print "\et" x ($tab/8), ' ' x ($tab%8);      # tab over
.Ve
.Vb 2
\&    @ones = (1) x 80;           # a list of 80 1's
\&    @ones = (5) x @ones;        # set all elements to 5
.Ve
.Sh "Additive Operators"
Binary \*(L"+\*(R" returns the sum of two numbers.
.PP
Binary \*(L"\-\*(R" returns the difference of two numbers.
.PP
Binary \*(L".\*(R" concatenates two strings.
.Sh "Shift Operators"
Binary \*(L"<<\*(R" returns the value of its left argument shifted left by the
number of bits specified by the right argument.  Arguments should be 
integers.
.PP
Binary \*(L">>\*(R" returns the value of its left argument shifted right by the
number of bits specified by the right argument.  Arguments should be 
integers.
.Sh "Named Unary Operators"
The various named unary operators are treated as functions with one
argument, with optional parentheses.  These include the filetest
operators, like \f(CW-f\fR, \f(CW-M\fR, etc.  See the \fIperlfunc\fR manpage.
.PP
If any list operator (\fIprint()\fR, etc.) or any unary operator (\fIchdir()\fR, etc.)
is followed by a left parenthesis as the next token, the operator and
arguments within parentheses are taken to be of highest precedence,
just like a normal function call.  Examples:
.PP
.Vb 4
\&    chdir $foo    || die;       # (chdir $foo) || die
\&    chdir($foo)   || die;       # (chdir $foo) || die
\&    chdir ($foo)  || die;       # (chdir $foo) || die
\&    chdir +($foo) || die;       # (chdir $foo) || die
.Ve
but, because * is higher precedence than ||:
.PP
.Vb 4
\&    chdir $foo * 20;    # chdir ($foo * 20)
\&    chdir($foo) * 20;   # (chdir $foo) * 20
\&    chdir ($foo) * 20;  # (chdir $foo) * 20
\&    chdir +($foo) * 20; # chdir ($foo * 20)
.Ve
.Vb 4
\&    rand 10 * 20;       # rand (10 * 20)
\&    rand(10) * 20;      # (rand 10) * 20
\&    rand (10) * 20;     # (rand 10) * 20
\&    rand +(10) * 20;    # rand (10 * 20)
.Ve
See also the section on \fIList Operators\fR.
.Sh "Relational Operators"
Binary \*(L"<\*(R" returns true if the left argument is numerically less than
the right argument.
.PP
Binary \*(L">\*(R" returns true if the left argument is numerically greater
than the right argument.
.PP
Binary \*(L"<=\*(R" returns true if the left argument is numerically less than
or equal to the right argument.
.PP
Binary \*(L">=\*(R" returns true if the left argument is numerically greater
than or equal to the right argument.
.PP
Binary \*(L"lt\*(R" returns true if the left argument is stringwise less than
the right argument.
.PP
Binary \*(L"gt\*(R" returns true if the left argument is stringwise greater
than the right argument.
.PP
Binary \*(L"le\*(R" returns true if the left argument is stringwise less than
or equal to the right argument.
.PP
Binary \*(L"ge\*(R" returns true if the left argument is stringwise greater
than or equal to the right argument.
.Sh "Equality Operators"
Binary \*(L"==\*(R" returns true if the left argument is numerically equal to
the right argument.
.PP
Binary \*(L"!=\*(R" returns true if the left argument is numerically not equal
to the right argument.
.PP
Binary \*(L"<=>\*(R" returns \-1, 0, or 1 depending on whether the left argument is numerically
less than, equal to, or greater than the right argument.
.PP
Binary \*(L"eq\*(R" returns true if the left argument is stringwise equal to
the right argument.
.PP
Binary \*(L"ne\*(R" returns true if the left argument is stringwise not equal
to the right argument.
.PP
Binary \*(L"cmp\*(R" returns \-1, 0, or 1 depending on whether the left argument is stringwise
less than, equal to, or greater than the right argument.
.Sh "Bitwise And"
Binary \*(L"&\*(R" returns its operators ANDed together bit by bit.
.Sh "Bitwise Or and Exclusive Or"
Binary \*(L"|\*(R" returns its operators ORed together bit by bit.
.PP
Binary \*(L"^\*(R" returns its operators XORed together bit by bit.
.Sh "C\-style Logical And"
Binary \*(L"&&\*(R" performs a short-circuit logical \s-1AND\s0 operation.  That is,
if the left operand is false, the right operand is not even evaluated.
Scalar or list context propagates down to the right operand if it
is evaluated.
.Sh "C\-style Logical Or"
Binary \*(L"||\*(R" performs a short-circuit logical \s-1OR\s0 operation.  That is,
if the left operand is true, the right operand is not even evaluated.
Scalar or list context propagates down to the right operand if it
is evaluated.
.PP
The \f(CW||\fR and \f(CW&&\fR operators differ from C's in that, rather than returning
0 or 1, they return the last value evaluated.  Thus, a reasonably portable
way to find out the home directory (assuming it's not \*(L"0") might be:
.PP
.Vb 2
\&    $home = $ENV{'HOME'} || $ENV{'LOGDIR'} ||
\&        (getpwuid($<))[7] || die "You're homeless!\en";
.Ve
As more readable alternatives to \f(CW&&\fR and \f(CW||\fR, Perl provides \*(L"and\*(R" and
\*(L"or\*(R" operators (see below).  The short-circuit behavior is identical.  The
precedence of \*(L"and\*(R" and \*(L"or\*(R" is much lower, however, so that you can
safely use them after a list operator without the need for
parentheses:
.PP
.Vb 2
\&    unlink "alpha", "beta", "gamma"
\&            or gripe(), next LINE;
.Ve
With the C\-style operators that would have been written like this:
.PP
.Vb 2
\&    unlink("alpha", "beta", "gamma")
\&            || (gripe(), next LINE);
.Ve
.Sh "Range Operator"
Binary \*(L"..\*(R" is the range operator, which is really two different
operators depending on the context.  In a list context, it returns an
array of values counting (by ones) from the left value to the right
value.  This is useful for writing \f(CWfor (1..10)\fR loops and for doing
slice operations on arrays.  Be aware that under the current implementation,
a temporary array is created, so you'll burn a lot of memory if you 
write something like this:
.PP
.Vb 3
\&    for (1 .. 1_000_000) {
\&        # code
\&    } 
.Ve
In a scalar context, \*(L"..\*(R" returns a boolean value.  The operator is
bistable, like a flip-flop, and emulates the line-range (comma) operator
of \fBsed\fR, \fBawk\fR, and various editors.  Each \*(L"..\*(R" operator maintains its
own boolean state.  It is false as long as its left operand is false.
Once the left operand is true, the range operator stays true until the
right operand is true, \fI\s-1AFTER\s0\fR which the range operator becomes false
again.  (It doesn't become false till the next time the range operator is
evaluated.  It can test the right operand and become false on the same
evaluation it became true (as in \fBawk\fR), but it still returns true once.
If you don't want it to test the right operand till the next evaluation
(as in \fBsed\fR), use three dots (\*(R"...") instead of two.)  The right
operand is not evaluated while the operator is in the \*(L"false\*(R" state, and
the left operand is not evaluated while the operator is in the \*(L"true\*(R"
state.  The precedence is a little lower than || and &&.  The value
returned is either the null string for false, or a sequence number
(beginning with 1) for true.  The sequence number is reset for each range
encountered.  The final sequence number in a range has the string \*(L"E0\*(R"
appended to it, which doesn't affect its numeric value, but gives you
something to search for if you want to exclude the endpoint.  You can
exclude the beginning point by waiting for the sequence number to be
greater than 1.  If either operand of scalar \*(L"..\*(R" is a numeric literal,
that operand is implicitly compared to the \f(CW$.\fR variable, the current
line number.  Examples:
.PP
As a scalar operator:
.PP
.Vb 3
\&    if (101 .. 200) { print; }  # print 2nd hundred lines
\&    next line if (1 .. /^$/);   # skip header lines
\&    s/^/> / if (/^$/ .. eof()); # quote body
.Ve
As a list operator:
.PP
.Vb 3
\&    for (101 .. 200) { print; } # print $_ 100 times
\&    @foo = @foo[$[ .. $#foo];   # an expensive no-op
\&    @foo = @foo[$#foo-4 .. $#foo];      # slice last 5 items
.Ve
The range operator (in a list context) makes use of the magical
autoincrement algorithm if the operaands are strings.  You
can say
.PP
.Vb 1
\&    @alphabet = ('A' .. 'Z');
.Ve
to get all the letters of the alphabet, or
.PP
.Vb 1
\&    $hexdigit = (0 .. 9, 'a' .. 'f')[$num & 15];
.Ve
to get a hexadecimal digit, or
.PP
.Vb 1
\&    @z2 = ('01' .. '31');  print $z2[$mday];
.Ve
to get dates with leading zeros.  If the final value specified is not
in the sequence that the magical increment would produce, the sequence
goes until the next value would be longer than the final value
specified.
.Sh "Conditional Operator"
Ternary \*(L"?:\*(R" is the conditional operator, just as in C.  It works much
like an if-then-else.  If the argument before the ? is true, the
argument before the : is returned, otherwise the argument after the :
is returned.  Scalar or list context propagates downward into the 2nd
or 3rd argument, whichever is selected.  The operator may be assigned
to if both the 2nd and 3rd arguments are legal lvalues (meaning that you
can assign to them):
.PP
.Vb 1
\&    ($a_or_b ? $a : $b) = $c;
.Ve
Note that this is not guaranteed to contribute to the readability of
your program.
.Sh "Assigment Operators"
\*(L"=\*(R" is the ordinary assignment operator.
.PP
Assignment operators work as in C.  That is,
.PP
.Vb 1
\&    $a += 2;
.Ve
is equivalent to
.PP
.Vb 1
\&    $a = $a + 2;
.Ve
although without duplicating any side effects that dereferencing the lvalue
might trigger, such as from \fItie()\fR.  Other assignment operators work similarly.  
The following are recognized: 
.PP
.Vb 4
\&    **=    +=    *=    &=    <<=    &&=
\&           -=    /=    |=    >>=    ||=
\&           .=    %=    ^=
\&                 x=
.Ve
Note that while these are grouped by family, they all have the precedence
of assignment.
.PP
Unlike in C, the assignment operator produces a valid lvalue.  Modifying
an assignment is equivalent to doing the assignment and then modifying
the variable that was assigned to.  This is useful for modifying
a copy of something, like this:
.PP
.Vb 1
\&    ($tmp = $global) =~ tr [A-Z] [a-z];
.Ve
Likewise,
.PP
.Vb 1
\&    ($a += 2) *= 3;
.Ve
is equivalent to
.PP
.Vb 2
\&    $a += 2;
\&    $a *= 3;
.Ve
.Sh ""
Binary \*(L",\*(R" is the comma operator.  In a scalar context it evaluates
its left argument, throws that value away, then evaluates its right
argument and returns that value.  This is just like C's comma operator.
.PP
In a list context, it's just the list argument separator, and inserts
both its arguments into the list.
.Sh "List Operators (Rightward)"
On the right side of a list operator, it has very low precedence,
such that it controls all comma-separated expressions found there.
The only operators with lower precedence are the logical operators
\*(L"and\*(R", \*(L"or\*(R", and \*(L"not\*(R", which may be used to evaluate calls to list
operators without the need for extra parentheses:
.PP
.Vb 2
\&    open HANDLE, "filename"
\&        or die "Can't open: $!\en";
.Ve
See also discussion of list operators in the section on \fIList Operators (Leftward)\fR.
.Sh "Logical Not"
Unary \*(L"not\*(R" returns the logical negation of the expression to its right.
It's the equivalent of \*(L"!\*(R" except for the very low precedence.
.Sh "Logical And"
Binary \*(L"and\*(R" returns the logical conjunction of the two surrounding
expressions.  It's equivalent to && except for the very low
precedence.  This means that it short-circuits: i.e. the right
expression is evaluated only if the left expression is true.
.Sh "Logical or and Exclusive Or"
Binary \*(L"or\*(R" returns the logical disjunction of the two surrounding
expressions.  It's equivalent to || except for the very low
precedence.  This means that it short-circuits: i.e. the right
expression is evaluated only if the left expression is false.
.PP
Binary \*(L"xor\*(R" returns the exclusive-\s-1OR\s0 of the two surrounding expressions.
It cannot short circuit, of course.
.Sh "C Operators Missing From Perl"
Here is what C has that Perl doesn't:
.Ip "unary &" 8
Address-of operator.  (But see the \*(L"\e\*(R" operator for taking a reference.)
.Ip "unary *" 8
Dereference-address operator. (Perl's prefix dereferencing 
operators are typed: $, @, %, and &.)
.Ip "(\s-1TYPE\s0)" 8
Type casting operator.  
.Sh "Quote and Quotelike Operators"
While we usually think of quotes as literal values, in Perl they
function as operators, providing various kinds of interpolating and
pattern matching capabilities.  Perl provides customary quote characters
for these behaviors, but also provides a way for you to choose your
quote character for any of them.  In the following table, a \f(CW{}\fR represents
any pair of delimiters you choose.  Non-bracketing delimiters use
the same character fore and aft, but the 4 sorts of brackets 
(round, angle, square, curly) will all nest.
.PP
.Vb 8
\&    Customary  Generic     Meaning    Interpolates
\&        ''       q{}       Literal         no
\&        ""      qq{}       Literal         yes
\&        ``      qx{}       Command         yes
\&                qw{}      Word list        no
\&        //       m{}    Pattern match      yes
\&                 s{}{}   Substitution      yes
\&                tr{}{}   Translation       no
.Ve
For constructs that do interpolation, variables beginning with \*(L"\f(CW$\fR or \*(L"\f(CW@\fR\*(R"
are interpolated, as are the following sequences:
.PP
.Vb 17
\&    \et          tab
\&    \en          newline
\&    \er          return
\&    \ef          form feed
\&    \ev          vertical tab, whatever that is
\&    \eb          backspace
\&    \ea          alarm (bell)
\&    \ee          escape
\&    \e033        octal char
\&    \ex1b        hex char
\&    \ec[         control char
\&    \el          lowercase next char
\&    \eu          uppercase next char
\&    \eL          lowercase till \eE
\&    \eU          uppercase till \eE
\&    \eE          end case modification
\&    \eQ          quote regexp metacharacters till \eE
.Ve
Patterns are subject to an additional level of interpretation as a
regular expression.  This is done as a second pass, after variables are
interpolated, so that regular expressions may be incorporated into the
pattern from the variables.  If this is not what you want, use \f(CW\eQ\fR to
interpolate a variable literally.
.PP
Apart from the above, there are no multiple levels of interpolation.  In
particular, contrary to the expectations of shell programmers, backquotes
do \fI\s-1NOT\s0\fR interpolate within double quotes, nor do single quotes impede
evaluation of variables when used within double quotes.
.Ip "?\s-1PATTERN\s0?" 8
This is just like the \f(CW/pattern/\fR search, except that it matches only
once between calls to the \fIreset()\fR operator.  This is a useful
optimization when you only want to see the first occurrence of
something in each file of a set of files, for instance.  Only \f(CW??\fR
patterns local to the current package are reset.
.Sp
This usage is vaguely deprecated, and may be removed in some future
version of Perl.
.Ip "m/\s-1PATTERN/\s0gimosx" 8
.Ip "/\s-1PATTERN/\s0gimosx" 8
Searches a string for a pattern match, and in a scalar context returns
true (1) or false ('').  If no string is specified via the \f(CW=~\fR or
\f(CW!~\fR operator, the \f(CW$_\fR string is searched.  (The string specified with
\f(CW=~\fR need not be an lvalue\*(--it may be the result of an expression
evaluation, but remember the \f(CW=~\fR binds rather tightly.)  See also
the \fIperlre\fR manpage.
.Sp
Options are:
.Sp
.Vb 6
\&    g   Match globally, i.e. find all occurrences.
\&    i   Do case-insensitive pattern matching.
\&    m   Treat string as multiple lines.
\&    o   Only compile pattern once.
\&    s   Treat string as single line.
\&    x   Use extended regular expressions.
.Ve
If \*(L"/\*(R" is the delimiter then the initial \f(CWm\fR is optional.  With the \f(CWm\fR
you can use any pair of non-alphanumeric, non-whitespace characters as
delimiters.  This is particularly useful for matching Unix path names
that contain \*(L"/\*(R", to avoid \s-1LTS\s0 (leaning toothpick syndrome).
.Sp
\s-1PATTERN\s0 may contain variables, which will be interpolated (and the
pattern recompiled) every time the pattern search is evaluated.  (Note
that \f(CW$)\fR and \f(CW$|\fR might not be interpolated because they look like
end-of-string tests.)  If you want such a pattern to be compiled only
once, add a \f(CW/o\fR after the trailing delimiter.  This avoids expensive
run-time recompilations, and is useful when the value you are
interpolating won't change over the life of the script.  However, mentioning
\f(CW/o\fR constitutes a promise that you won't change the variables in the pattern.
If you change them, Perl won't even notice.
.Sp
If the \s-1PATTERN\s0 evaluates to a null string, the most recently executed 
(and successfully compiled) regular expression is used instead.
.Sp
If used in a context that requires a list value, a pattern match returns a
list consisting of the subexpressions matched by the parentheses in the
pattern, i.e. (\f(CW$1\fR, \f(CW$2\fR, \f(CW$3\fR...).  (Note that here \f(CW$1\fR etc. are also set, and
that this differs from Perl 4's behavior.)  If the match fails, a null
array is returned.  If the match succeeds, but there were no parentheses,
a list value of (1) is returned.
.Sp
Examples:
.Sp
.Vb 2
\&    open(TTY, '/dev/tty');
\&    <TTY> =~ /^y/i && foo();    # do foo if desired
.Ve
.Vb 1
\&    if (/Version: *([0-9.]*)/) { $version = $1; }
.Ve
.Vb 1
\&    next if m#^/usr/spool/uucp#;
.Ve
.Vb 5
\&    # poor man's grep
\&    $arg = shift;
\&    while (<>) {
\&        print if /$arg/o;       # compile only once
\&    }
.Ve
.Vb 1
\&    if (($F1, $F2, $Etc) = ($foo =~ /^(\eS+)\es+(\eS+)\es*(.*)/))
.Ve
This last example splits \f(CW$foo\fR into the first two words and the
remainder of the line, and assigns those three fields to \f(CW$F1\fR, \f(CW$F2\fR and
\f(CW$Etc\fR.  The conditional is true if any variables were assigned, i.e. if
the pattern matched.
.Sp
The \f(CW/g\fR modifier specifies global pattern matching\*(--that is, matching
as many times as possible within the string.  How it behaves depends on
the context.  In a list context, it returns a list of all the
substrings matched by all the parentheses in the regular expression.
If there are no parentheses, it returns a list of all the matched
strings, as if there were parentheses around the whole pattern.
.Sp
In a scalar context, \f(CWm//g\fR iterates through the string, returning \s-1TRUE\s0
each time it matches, and \s-1FALSE\s0 when it eventually runs out of
matches.  (In other words, it remembers where it left off last time and
restarts the search at that point.  You can actually find the current
match position of a string using the \fIpos()\fR function\*(--see the \fIperlfunc\fR manpage.)
If you modify the string in any way, the match position is reset to the
beginning.  Examples:
.Sp
.Vb 2
\&    # list context
\&    ($one,$five,$fifteen) = (`uptime` =~ /(\ed+\e.\ed+)/g);
.Ve
.Vb 8
\&    # scalar context
\&    $/ = ""; $* = 1;  # $* deprecated in Perl 5
\&    while ($paragraph = <>) {
\&        while ($paragraph =~ /[a-z]['")]*[.!?]+['")]*\es/g) {
\&            $sentences++;
\&        }
\&    }
\&    print "$sentences\en";
.Ve
.Ip "q/\s-1STRING\s0/" 8
.Ip "\f(CW'STRING'\fR" 8
A single-quoted, literal string.  Backslashes are ignored, unless
followed by the delimiter or another backslash, in which case the
delimiter or backslash is interpolated.
.Sp
.Vb 2
\&    $foo = q!I said, "You said, 'She said it.'"!;
\&    $bar = q('This is it.');
.Ve
.Ip "qq/\s-1STRING\s0/" 8
.Ip "\*(L"\s-1STRING\s0\*(R"" 8
A double-quoted, interpolated string.
.Sp
.Vb 3
\&    $_ .= qq
\&     (*** The previous line contains the naughty word "$1".\en)
\&                if /(tcl|rexx|python)/;      # :-)
.Ve
.Ip "qx/\s-1STRING\s0/" 8
.Ip "`\s-1STRING\s0`" 8
A string which is interpolated and then executed as a system command.
The collected standard output of the command is returned.  In scalar
context, it comes back as a single (potentially multi-line) string.
In list context, returns a list of lines (however you've defined lines
with $/ or \f(CW$INPUT_RECORD_SEPARATOR\fR).
.Sp
.Vb 1
\&    $today = qx{ date };
.Ve
See the section on \fII/O Operators\fR for more discussion.
.Ip "qw/\s-1STRING\s0/" 8
Returns a list of the words extracted out of \s-1STRING\s0, using embedded
whitespace as the word delimiters.  It is exactly equivalent to
.Sp
.Vb 1
\&    split(' ', q/STRING/);
.Ve
Some frequently seen examples:
.Sp
.Vb 2
\&    use POSIX qw( setlocale localeconv )
\&    @EXPORT = qw( foo bar baz );
.Ve
.Ip "s/\s-1PATTERN/REPLACEMENT/\s0egimosx" 8
Searches a string for a pattern, and if found, replaces that pattern
with the replacement text and returns the number of substitutions
made.  Otherwise it returns false (0).
.Sp
If no string is specified via the \f(CW=~\fR or \f(CW!~\fR operator, the \f(CW$_\fR
variable is searched and modified.  (The string specified with \f(CW=~\fR must
be a scalar variable, an array element, a hash element, or an assignment
to one of those, i.e. an lvalue.)
.Sp
If the delimiter chosen is single quote, no variable interpolation is
done on either the \s-1PATTERN\s0 or the \s-1REPLACEMENT\s0.  Otherwise, if the
\s-1PATTERN\s0 contains a $ that looks like a variable rather than an
end-of-string test, the variable will be interpolated into the pattern
at run-time.  If you only want the pattern compiled once the first time
the variable is interpolated, use the \f(CW/o\fR option.  If the pattern
evaluates to a null string, the most recently executed (and successfully compiled) regular
expression is used instead.  See the \fIperlre\fR manpage for further explanation on these.
.Sp
Options are:
.Sp
.Vb 7
\&    e   Evaluate the right side as an expression.
\&    g   Replace globally, i.e. all occurrences.
\&    i   Do case-insensitive pattern matching.
\&    m   Treat string as multiple lines.
\&    o   Only compile pattern once.
\&    s   Treat string as single line.
\&    x   Use extended regular expressions.
.Ve
Any non-alphanumeric, non-whitespace delimiter may replace the
slashes.  If single quotes are used, no interpretation is done on the
replacement string (the \f(CW/e\fR modifier overrides this, however).  If
backquotes are used, the replacement string is a command to execute
whose output will be used as the actual replacement text.  If the
\s-1PATTERN\s0 is delimited by bracketing quotes, the \s-1REPLACEMENT\s0 has its own
pair of quotes, which may or may not be bracketing quotes, e.g.
\f(CWs(foo)(bar)\fR or \f(CWs<foo>/bar/\fR.  A \f(CW/e\fR will cause the
replacement portion to be interpreter as a full-fledged Perl expression
and \fIeval()\fRed right then and there.  It is, however, syntax checked at
compile-time.
.Sp
Examples:
.Sp
.Vb 1
\&    s/\ebgreen\eb/mauve/g;                # don't change wintergreen
.Ve
.Vb 1
\&    $path =~ s|/usr/bin|/usr/local/bin|;
.Ve
.Vb 1
\&    s/Login: $foo/Login: $bar/; # run-time pattern
.Ve
.Vb 1
\&    ($foo = $bar) =~ s/this/that/;
.Ve
.Vb 1
\&    $count = ($paragraph =~ s/Mister\eb/Mr./g);
.Ve
.Vb 4
\&    $_ = 'abc123xyz';
\&    s/\ed+/$&*2/e;               # yields 'abc246xyz'
\&    s/\ed+/sprintf("%5d",$&)/e;  # yields 'abc  246xyz'
\&    s/\ew/$& x 2/eg;             # yields 'aabbcc  224466xxyyzz'
.Ve
.Vb 3
\&    s/%(.)/$percent{$1}/g;      # change percent escapes; no /e
\&    s/%(.)/$percent{$1} || $&/ge;       # expr now, so /e
\&    s/^=(\ew+)/&pod($1)/ge;      # use function call
.Ve
.Vb 3
\&    # /e's can even nest;  this will expand
\&    # simple embedded variables in $_
\&    s/(\e$\ew+)/$1/eeg;
.Ve
.Vb 6
\&    # Delete C comments.
\&    $program =~ s {
\&        /\e*     (?# Match the opening delimiter.)
\&        .*?     (?# Match a minimal number of characters.)
\&        \e*/     (?# Match the closing delimiter.)
\&    } []gsx;
.Ve
.Vb 1
\&    s/^\es*(.*?)\es*$/$1/;        # trim white space
.Ve
.Vb 1
\&    s/([^ ]*) *([^ ]*)/$2 $1/;  # reverse 1st two fields
.Ve
Note the use of $ instead of \e in the last example.  Unlike 
\fBsed\fR, we only use the \e<\fIdigit\fR> form in the left hand side.
Anywhere else it's $<\fIdigit\fR>.
.Sp
Occasionally, you can't just use a \f(CW/g\fR to get all the changes
to occur.  Here are two common cases:
.Sp
.Vb 3
\&    # put commas in the right places in an integer
\&    1 while s/(.*\ed)(\ed\ed\ed)/$1,$2/g;      # perl4
\&    1 while s/(\ed)(\ed\ed\ed)(?!\ed)/$1,$2/g;  # perl5
.Ve
.Vb 2
\&    # expand tabs to 8-column spacing
\&    1 while s/\et+/' ' x (length($&)*8 - length($`)%8)/e;
.Ve
.Ip "tr/\s-1SEARCHLIST/REPLACEMENTLIST/\s0cds" 8
.Ip "y/\s-1SEARCHLIST/REPLACEMENTLIST/\s0cds" 8
Translates all occurrences of the characters found in the search list
with the corresponding character in the replacement list.  It returns
the number of characters replaced or deleted.  If no string is
specified via the =~ or !~ operator, the \f(CW$_\fR string is translated.  (The
string specified with =~ must be a scalar variable, an array element,
or an assignment to one of those, i.e. an lvalue.)  For \fBsed\fR devotees,
\f(CWy\fR is provided as a synonym for \f(CWtr\fR.  If the \s-1SEARCHLIST\s0 is
delimited by bracketing quotes, the \s-1REPLACEMENTLIST\s0 has its own pair of
quotes, which may or may not be bracketing quotes, e.g. \f(CWtr[A-Z][a-z]\fR
or \f(CWtr(+-*/)/ABCD/\fR.
.Sp
Options:
.Sp
.Vb 3
\&    c   Complement the SEARCHLIST.
\&    d   Delete found but unreplaced characters.
\&    s   Squash duplicate replaced characters.
.Ve
If the \f(CW/c\fR modifier is specified, the \s-1SEARCHLIST\s0 character set is
complemented.  If the \f(CW/d\fR modifier is specified, any characters specified
by \s-1SEARCHLIST\s0 not found in \s-1REPLACEMENTLIST\s0 are deleted.  (Note
that this is slightly more flexible than the behavior of some \fBtr\fR
programs, which delete anything they find in the \s-1SEARCHLIST\s0, period.)
If the \f(CW/s\fR modifier is specified, sequences of characters that were
translated to the same character are squashed down to a single instance of the
character.
.Sp
If the \f(CW/d\fR modifier is used, the \s-1REPLACEMENTLIST\s0 is always interpreted
exactly as specified.  Otherwise, if the \s-1REPLACEMENTLIST\s0 is shorter
than the \s-1SEARCHLIST\s0, the final character is replicated till it is long
enough.  If the \s-1REPLACEMENTLIST\s0 is null, the \s-1SEARCHLIST\s0 is replicated.
This latter is useful for counting characters in a class or for
squashing character sequences in a class.
.Sp
Examples:
.Sp
.Vb 1
\&    $ARGV[1] =~ tr/A-Z/a-z/;    # canonicalize to lower case
.Ve
.Vb 1
\&    $cnt = tr/*/*/;             # count the stars in $_
.Ve
.Vb 1
\&    $cnt = $sky =~ tr/*/*/;     # count the stars in $sky
.Ve
.Vb 1
\&    $cnt = tr/0-9//;            # count the digits in $_
.Ve
.Vb 1
\&    tr/a-zA-Z//s;               # bookkeeper -> bokeper
.Ve
.Vb 1
\&    ($HOST = $host) =~ tr/a-z/A-Z/;
.Ve
.Vb 1
\&    tr/a-zA-Z/ /cs;             # change non-alphas to single space
.Ve
.Vb 2
\&    tr [\e200-\e377]
\&       [\e000-\e177];             # delete 8th bit
.Ve
Note that because the translation table is built at compile time, neither
the \s-1SEARCHLIST\s0 nor the \s-1REPLACEMENTLIST\s0 are subjected to double quote
interpolation.  That means that if you want to use variables, you must use
an \fIeval()\fR:
.Sp
.Vb 2
\&    eval "tr/$oldlist/$newlist/";
\&    die $@ if $@;
.Ve
.Vb 1
\&    eval "tr/$oldlist/$newlist/, 1" or die $@;
.Ve
.Sh "I/O Operators"
There are several I/O operators you should know about.  
A string is enclosed by backticks (grave accents) first undergoes
variable substitution just like a double quoted string.  It is then
interpreted as a command, and the output of that command is the value
of the pseudo-literal, like in a shell.  In a scalar context, a single
string consisting of all the output is returned.  In a list context,
a list of values is returned, one for each line of output.  (You can
set \f(CW$/\fR to use a different line terminator.)  The command is executed
each time the pseudo-literal is evaluated.  The status value of the
command is returned in \f(CW$?\fR (see the \fIperlvar\fR manpage for the interpretation
of \f(CW$?\fR).  Unlike in \fBcsh\fR, no translation is done on the return
data\*(--newlines remain newlines.  Unlike in any of the shells, single
quotes do not hide variable names in the command from interpretation.
To pass a $ through to the shell you need to hide it with a backslash.
The generalized form of backticks is \f(CWqx//\fR.
.PP
Evaluating a filehandle in angle brackets yields the next line from
that file (newline included, so it's never false until end of file, at which
time an undefined value is returned).  Ordinarily you must assign that
value to a variable, but there is one situation where an automatic
assignment happens.  \fIIf and \s-1ONLY\s0 if\fR the input symbol is the only
thing inside the conditional of a \f(CWwhile\fR loop, the value is
automatically assigned to the variable \f(CW$_\fR.  (This may seem like an
odd thing to you, but you'll use the construct in almost every Perl
script you write.)  Anyway, the following lines are equivalent to each
other:
.PP
.Vb 5
\&    while ($_ = <STDIN>) { print; }
\&    while (<STDIN>) { print; }
\&    for (;<STDIN>;) { print; }
\&    print while $_ = <STDIN>;
\&    print while <STDIN>;
.Ve
The filehandles \s-1STDIN\s0, \s-1STDOUT\s0 and \s-1STDERR\s0 are predefined.  (The
filehandles \f(CWstdin\fR, \f(CWstdout\fR and \f(CWstderr\fR will also work except in
packages, where they would be interpreted as local identifiers rather
than global.)  Additional filehandles may be created with the \fIopen()\fR
function.
.PP
If a <\s-1FILEHANDLE\s0> is used in a context that is looking for a list, a
list consisting of all the input lines is returned, one line per list
element.  It's easy to make a \fI\s-1LARGE\s0\fR data space this way, so use with
care.
.PP
The null filehandle <> is special and can be used to emulate the
behavior of \fBsed\fR and \fBawk\fR.  Input from <> comes either from
standard input, or from each file listed on the command line.  Here's
how it works: the first time <> is evaluated, the \f(CW@ARGV\fR array is
checked, and if it is null, \f(CW$ARGV[0]\fR is set to \*(L"\-\*(R", which when opened
gives you standard input.  The \f(CW@ARGV\fR array is then processed as a list
of filenames.  The loop
.PP
.Vb 3
\&    while (<>) {
\&        ...                     # code for each line
\&    }
.Ve
is equivalent to the following Perl-like pseudo code:
.PP
.Vb 7
\&    unshift(@ARGV, '-') if $#ARGV < $[;
\&    while ($ARGV = shift) {
\&        open(ARGV, $ARGV);
\&        while (<ARGV>) {
\&            ...         # code for each line
\&        }
\&    }
.Ve
except that it isn't so cumbersome to say, and will actually work.  It
really does shift array \f(CW@ARGV\fR and put the current filename into variable
\f(CW$ARGV\fR.  It also uses filehandle \fI\s-1ARGV\s0\fR internally--<> is just a synonym
for <\s-1ARGV\s0>, which is magical.  (The pseudo code above doesn't work
because it treats <\s-1ARGV\s0> as non-magical.)
.PP
You can modify \f(CW@ARGV\fR before the first <> as long as the array ends up
containing the list of filenames you really want.  Line numbers (\f(CW$.\fR)
continue as if the input were one big happy file.  (But see example
under \fIeof()\fR for how to reset line numbers on each file.)
.PP
If you want to set \f(CW@ARGV\fR to your own list of files, go right ahead.  If
you want to pass switches into your script, you can use one of the 
Getopts modules or put a loop on the front like this:
.PP
.Vb 10
\&    while ($_ = $ARGV[0], /^-/) {
\&        shift;
\&        last if /^--$/;
\&        if (/^-D(.*)/) { $debug = $1 }
\&        if (/^-v/)     { $verbose++  }
\&        ...             # other switches
\&    }
\&    while (<>) {
\&        ...             # code for each line
\&    }
.Ve
The <> symbol will return \s-1FALSE\s0 only once.  If you call it again after
this it will assume you are processing another \f(CW@ARGV\fR list, and if you
haven't set \f(CW@ARGV\fR, will input from \s-1STDIN\s0.
.PP
If the string inside the angle brackets is a reference to a scalar
variable (e.g. <\f(CW$foo\fR>), then that variable contains the name of the
filehandle to input from.
.PP
If the string inside angle brackets is not a filehandle, it is
interpreted as a filename pattern to be globbed, and either a list of
filenames or the next filename in the list is returned, depending on
context.  One level of $ interpretation is done first, but you can't
say \f(CW<\f(CW$foo\fR>\fR because that's an indirect filehandle as explained in the
previous paragraph.  You could insert curly brackets to force
interpretation as a filename glob: \f(CW<${foo}>\fR.  (Alternately, you can
call the internal function directly as \f(CWglob($foo)\fR, which is probably
the right way to have done it in the first place.)  Example:
.PP
.Vb 3
\&    while (<*.c>) {
\&        chmod 0644, $_;
\&    }
.Ve
is equivalent to
.PP
.Vb 5
\&    open(FOO, "echo *.c | tr -s ' \et\er\ef' '\e\e012\e\e012\e\e012\e\e012'|");
\&    while (<FOO>) {
\&        chop;
\&        chmod 0644, $_;
\&    }
.Ve
In fact, it's currently implemented that way.  (Which means it will not
work on filenames with spaces in them unless you have \fIcsh\fR\|(1) on your
machine.)  Of course, the shortest way to do the above is:
.PP
.Vb 1
\&    chmod 0644, <*.c>;
.Ve
Because globbing invokes a shell, it's often faster to call \fIreaddir()\fR yourself
and just do your own \fIgrep()\fR on the filenames.  Furthermore, due to its current
implementation of using a shell, the \fIglob()\fR routine may get \*(L"Arg list too 
long\*(R" errors (unless you've installed \fItcsh\fR\|(1L) as \fI/bin/csh\fR).
.Sh "Constant Folding"
Like C, Perl does a certain amount of expression evaluation at
compile time, whenever it determines that all of the arguments to an
operator are static and have no side effects.  In particular, string
concatenation happens at compile time between literals that don't do
variable substitution.  Backslash interpretation also happens at
compile time.  You can say
.PP
.Vb 2
\&    'Now is the time for all' . "\en" .
\&        'good men to come to.'
.Ve
and this all reduces to one string internally.  Likewise, if 
you say
.PP
.Vb 3
\&    foreach $file (@filenames) {
\&        if (-s $file > 5 + 100 * 2**16) { ... }
\&    } 
.Ve
the compiler will pre-compute the number that
expression represents so that the interpreter
won't have to.
.Sh "Integer arithmetic"
By default Perl assumes that it must do most of its arithmetic in
floating point.  But by saying
.PP
.Vb 1
\&    use integer;
.Ve
you may tell the compiler that it's okay to use integer operations
from here to the end of the enclosing \s-1BLOCK\s0.  An inner \s-1BLOCK\s0 may
countermand this by saying 
.PP
.Vb 1
\&    no integer;
.Ve
which lasts until the end of that \s-1BLOCK\s0.

.rn }` ''
