.rn '' }`
''' $RCSfile$$Revision$$Date$
''' 
''' $Log$
''' 
.de Sh
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb
.ft CW
.nf
.ne \\$1
..
.de Ve
.ft R

.fi
..
'''
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
.if t .ds PI \(*p
.if n .ds PI PI
'br\}
.TH PERLFUNC 1 "\*(RP"
.UC
.if n .hy 0 
.if n .na
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.de CQ          \" put $1 in typewriter font
.ft CW
'if n "\c
'if t \\&\\$1\c
'if n \\&\\$1\c
'if n \&"
\\&\\$2 \\$3 \\$4 \\$5 \\$6 \\$7
'.ft R
..
.\" @(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2
.	\" AM - accent mark definitions
.bd S B 3
.	\" fudge factors for nroff and troff
.if n \{\
.	ds #H 0
.	ds #V .8m
.	ds #F .3m
.	ds #[ \f1
.	ds #] \fP
.\}
.if t \{\
.	ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.	ds #V .6m
.	ds #F 0
.	ds #[ \&
.	ds #] \&
.\}
.	\" simple accents for nroff and troff
.if n \{\
.	ds ' \&
.	ds ` \&
.	ds ^ \&
.	ds , \&
.	ds ~ ~
.	ds ? ?
.	ds ! !
.	ds / 
.	ds q 
.\}
.if t \{\
.	ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.	ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.	ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.	ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.	ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.	ds ? \s-2c\h'-\w'c'u*7/10'\u\h'\*(#H'\zi\d\s+2\h'\w'c'u*8/10'
.	ds ! \s-2\(or\s+2\h'-\w'\(or'u'\v'-.8m'.\v'.8m'
.	ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.	ds q o\h'-\w'o'u*8/10'\s-4\v'.4m'\z\(*i\v'-.4m'\s+4\h'\w'o'u*8/10'
.\}
.	\" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds v \\k:\h'-(\\n(.wu*9/10-\*(#H)'\v'-\*(#V'\*(#[\s-4v\s0\v'\*(#V'\h'|\\n:u'\*(#]
.ds _ \\k:\h'-(\\n(.wu*9/10-\*(#H+(\*(#F*2/3))'\v'-.4m'\z\(hy\v'.4m'\h'|\\n:u'
.ds . \\k:\h'-(\\n(.wu*8/10)'\v'\*(#V*4/10'\z.\v'-\*(#V*4/10'\h'|\\n:u'
.ds 3 \*(#[\v'.2m'\s-2\&3\s0\v'-.2m'\*(#]
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.ds oe o\h'-(\w'o'u*4/10)'e
.ds Oe O\h'-(\w'O'u*4/10)'E
.	\" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.	\" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.	ds : e
.	ds 8 ss
.	ds v \h'-1'\o'\(aa\(ga'
.	ds _ \h'-1'^
.	ds . \h'-1'.
.	ds 3 3
.	ds o a
.	ds d- d\h'-1'\(ga
.	ds D- D\h'-1'\(hy
.	ds th \o'bp'
.	ds Th \o'LP'
.	ds ae ae
.	ds Ae AE
.	ds oe oe
.	ds Oe OE
.\}
.rm #[ #] #H #V #F C
.SH "NAME"
perlfunc \- Perl builtin functions
.SH "DESCRIPTION"
The functions in this section can serve as terms in an expression.
They fall into two major categories: list operators and named unary
operators.  These differ in their precedence relationship with a
following comma.  (See the precedence table in the \fIperlop\fR manpage.)  List
operators take more than one argument, while unary operators can never
take more than one argument.  Thus, a comma terminates the argument of
a unary operator, but merely separates the arguments of a list
operator.  A unary operator generally provides a scalar context to its
argument, while a list operator may provide either scalar and list
contexts for its arguments.  If it does both, the scalar arguments will
be first, and the list argument will follow.  (Note that there can only
ever be one list argument.)  For instance, \fIsplice()\fR has three scalar
arguments followed by a list.
.PP
In the syntax descriptions that follow, list operators that expect a
list (and provide list context for the elements of the list) are shown
with LIST as an argument.  Such a list may consist of any combination
of scalar arguments or list values; the list values will be included
in the list as if each individual element were interpolated at that
point in the list, forming a longer single-dimensional list value.
Elements of the LIST should be separated by commas.
.PP
Any function in the list below may be used either with or without
parentheses around its arguments.  (The syntax descriptions omit the
parens.)  If you use the parens, the simple (but occasionally
surprising) rule is this: It \fILOOKS\fR like a function, therefore it \fIIS\fR a
function, and precedence doesn't matter.  Otherwise it's a list
operator or unary operator, and precedence does matter.  And whitespace
between the function and left parenthesis doesn't count\*(--so you need to
be careful sometimes:
.PP
.Vb 5
\&    print 1+2+3;        # Prints 6.
\&    print(1+2) + 3;     # Prints 3.
\&    print (1+2)+3;      # Also prints 3!
\&    print +(1+2)+3;     # Prints 6.
\&    print ((1+2)+3);    # Prints 6.
.Ve
If you run Perl with the \fB\-w\fR switch it can warn you about this.  For
example, the third line above produces:
.PP
.Vb 2
\&    print (...) interpreted as function at - line 1.
\&    Useless use of integer addition in void context at - line 1.
.Ve
For functions that can be used in either a scalar or list context,
non-abortive failure is generally indicated in a scalar context by
returning the undefined value, and in a list context by returning the
null list.
.PP
Remember the following rule:
.Ip "\(bu" 5
\fI\s-1THERE\s0 \s-1IS\s0 \s-1NO\s0 \s-1GENERAL\s0 \s-1RULE\s0 \s-1FOR\s0 \s-1CONVERTING\s0 A \s-1LIST\s0 \s-1INTO\s0 A \s-1SCALAR\s0!\fR
.PP
Each operator and function decides which sort of value it would be most
appropriate to return in a scalar context.  Some operators return the
length of the list that would have been returned in a list context.  Some
operators return the first value in the list.  Some operators return the
last value in the list.  Some operators return a count of successful
operations.  In general, they do what you want, unless you want
consistency.
.Ip "-X \s-1FILEHANDLE\s0" 8
.Ip "-X \s-1EXPR\s0" 8
.Ip "-X" 8
A file test, where X is one of the letters listed below.  This unary
operator takes one argument, either a filename or a filehandle, and
tests the associated file to see if something is true about it.  If the
argument is omitted, tests \f(CW$_\fR, except for \f(CW-t\fR, which tests \s-1STDIN\s0.
Unless otherwise documented, it returns \f(CW1\fR for \s-1TRUE\s0 and \f(CW''\fR for \s-1FALSE\s0, or
the undefined value if the file doesn't exist.  Despite the funny
names, precedence is the same as any other named unary operator, and
the argument may be parenthesized like any other unary operator.  The
operator may be any of:
.Sp
.Vb 4
\&    -r  File is readable by effective uid/gid.
\&    -w  File is writable by effective uid/gid.
\&    -x  File is executable by effective uid/gid.
\&    -o  File is owned by effective uid.
.Ve
.Vb 4
\&    -R  File is readable by real uid/gid.
\&    -W  File is writable by real uid/gid.
\&    -X  File is executable by real uid/gid.
\&    -O  File is owned by real uid.
.Ve
.Vb 3
\&    -e  File exists.
\&    -z  File has zero size.
\&    -s  File has non-zero size (returns size).
.Ve
.Vb 8
\&    -f  File is a plain file.
\&    -d  File is a directory.
\&    -l  File is a symbolic link.
\&    -p  File is a named pipe (FIFO).
\&    -S  File is a socket.
\&    -b  File is a block special file.
\&    -c  File is a character special file.
\&    -t  Filehandle is opened to a tty.
.Ve
.Vb 3
\&    -u  File has setuid bit set.
\&    -g  File has setgid bit set.
\&    -k  File has sticky bit set.
.Ve
.Vb 2
\&    -T  File is a text file.
\&    -B  File is a binary file (opposite of -T).
.Ve
.Vb 3
\&    -M  Age of file in days when script started.
\&    -A  Same for access time.
\&    -C  Same for inode change time.
.Ve
The interpretation of the file permission operators \f(CW-r\fR, \f(CW-R\fR, \f(CW-w\fR,
\f(CW-W\fR, \f(CW-x\fR and \f(CW-X\fR is based solely on the mode of the file and the
uids and gids of the user.  There may be other reasons you can't actually
read, write or execute the file.  Also note that, for the superuser,
\f(CW-r\fR, \f(CW-R\fR, \f(CW-w\fR and \f(CW-W\fR always return 1, and \f(CW-x\fR and \f(CW-X\fR return
1 if any execute bit is set in the mode.  Scripts run by the superuser may
thus need to do a \fIstat()\fR in order to determine the actual mode of the
file, or temporarily set the uid to something else.
.Sp
Example:
.Sp
.Vb 5
\&    while (<>) {
\&        chop;
\&        next unless -f $_;      # ignore specials
\&        ...
\&    }
.Ve
Note that \f(CW-s/a/b/\fR does not do a negated substitution.  Saying
\f(CW-exp($foo)\fR still works as expected, however\*(--only single letters
following a minus are interpreted as file tests.
.Sp
The \f(CW-T\fR and \f(CW-B\fR switches work as follows.  The first block or so of the
file is examined for odd characters such as strange control codes or
characters with the high bit set.  If too many odd characters (>30%)
are found, it's a \f(CW-B\fR file, otherwise it's a \f(CW-T\fR file.  Also, any file
containing null in the first block is considered a binary file.  If \f(CW-T\fR
or \f(CW-B\fR is used on a filehandle, the current stdio buffer is examined
rather than the first block.  Both \f(CW-T\fR and \f(CW-B\fR return \s-1TRUE\s0 on a null
file, or a file at \s-1EOF\s0 when testing a filehandle.
.Sp
If any of the file tests (or either the \fIstat()\fR or \fIlstat()\fR operators) are given the
special filehandle consisting of a solitary underline, then the stat
structure of the previous file test (or stat operator) is used, saving
a system call.  (This doesn't work with \f(CW-t\fR, and you need to remember
that \fIlstat()\fR and \f(CW-l\fR will leave values in the stat structure for the
symbolic link, not the real file.)  Example:
.Sp
.Vb 1
\&    print "Can do.\en" if -r $a || -w _ || -x _;
.Ve
.Vb 9
\&    stat($filename);
\&    print "Readable\en" if -r _;
\&    print "Writable\en" if -w _;
\&    print "Executable\en" if -x _;
\&    print "Setuid\en" if -u _;
\&    print "Setgid\en" if -g _;
\&    print "Sticky\en" if -k _;
\&    print "Text\en" if -T _;
\&    print "Binary\en" if -B _;
.Ve
.Ip "abs \s-1VALUE\s0" 8
Returns the absolute value of its argument.
.Ip "accept \s-1NEWSOCKET\s0,\s-1GENERICSOCKET\s0" 8
Accepts an incoming socket connect, just as the \fIaccept\fR\|(2) system call
does.  Returns the packed address if it succeeded, \s-1FALSE\s0 otherwise.
See example in the \fIperlipc\fR manpage.
.Ip "alarm \s-1SECONDS\s0" 8
Arranges to have a \s-1SIGALRM\s0 delivered to this process after the
specified number of seconds have elapsed.  (On some machines,
unfortunately, the elapsed time may be up to one second less than you
specified because of how seconds are counted.)  Only one timer may be
counting at once.  Each call disables the previous timer, and an
argument of 0 may be supplied to cancel the previous timer without
starting a new one.  The returned value is the amount of time remaining
on the previous timer.
.Sp
For sleeps of finer granularity than one second, you may use Perl's
\fIsyscall()\fR interface to access \fIsetitimer\fR\|(2) if your system supports it, 
or else see the \f(CWselect()\fR entry elsewhere in this documentbelow.
.Ip "atan2 Y,X" 8
Returns the arctangent of Y/X in the range \-\*(PI to \*(PI.
.Ip "bind \s-1SOCKET\s0,\s-1NAME\s0" 8
Binds a network address to a socket, just as the bind system call
does.  Returns \s-1TRUE\s0 if it succeeded, \s-1FALSE\s0 otherwise.  \s-1NAME\s0 should be a
packed address of the appropriate type for the socket.  See example in
the \fIperlipc\fR manpage.
.Ip "binmode \s-1FILEHANDLE\s0" 8
Arranges for the file to be read or written in \*(L"binary\*(R" mode in
operating systems that distinguish between binary and text files.
Files that are not in binary mode have \s-1CR\s0 \s-1LF\s0 sequences translated to \s-1LF\s0
on input and \s-1LF\s0 translated to \s-1CR\s0 \s-1LF\s0 on output.  Binmode has no effect
under Unix; in \s-1DOS\s0, it may be imperative.  If \s-1FILEHANDLE\s0 is an expression,
the value is taken as the name of the filehandle.
.Ip "bless \s-1REF\s0,\s-1PACKAGE\s0" 8
.Ip "bless \s-1REF\s0" 8
This function tells the referenced object (passed as \s-1REF\s0) that it is now
an object in \s-1PACKAGE\s0\*(--or the current package if no \s-1PACKAGE\s0 is specified,
which is the usual case.  It returns the reference for convenience, since
a \fIbless()\fR is often the last thing in a constructor.  See the \fIperlobj\fR manpage for
more about the blessing (and blessings) of objects.
.Ip "caller \s-1EXPR\s0" 8
.Ip "caller" 8
Returns the context of the current subroutine call.  In a scalar context,
returns \s-1TRUE\s0 if there is a caller, that is, if we're in a subroutine or
\fIeval()\fR or \fIrequire()\fR, and \s-1FALSE\s0 otherwise.  In a list context, returns
.Sp
.Vb 1
\&    ($package,$filename,$line) = caller;
.Ve
With \s-1EXPR\s0, it returns some extra information that the debugger uses to
print a stack trace.  The value of \s-1EXPR\s0 indicates how many call frames
to go back before the current one.
.Ip "chdir \s-1EXPR\s0" 8
Changes the working directory to \s-1EXPR\s0, if possible.  If \s-1EXPR\s0 is
omitted, changes to home directory.  Returns \s-1TRUE\s0 upon success, \s-1FALSE\s0
otherwise.  See example under \fIdie()\fR.
.Ip "chmod \s-1LIST\s0" 8
Changes the permissions of a list of files.  The first element of the
list must be the numerical mode.  Returns the number of files
successfully changed.
.Sp
.Vb 2
\&    $cnt = chmod 0755, 'foo', 'bar';
\&    chmod 0755, @executables;
.Ve
.Ip "chomp \s-1VARIABLE\s0" 8
.Ip "chomp \s-1LIST\s0" 8
.Ip "chomp" 8
This is a slightly safer version of chop (see below).  It removes any
line ending that corresponds to the current value of \f(CW$/\fR (also known as
\f(CW$INPUT_RECORD_SEPARATOR\fR in the \f(CWEnglish\fR module).  It returns the number
of characters removed.  It's often used to remove the newline from the
end of an input record when you're worried that the final record may be
missing its newline.  When in paragraph mode (\f(CW$/ = ""\fR), it removes all
trailing newlines from the string.  If \s-1VARIABLE\s0 is omitted, it chomps
\f(CW$_\fR.  Example:
.Sp
.Vb 5
\&    while (<>) {
\&        chomp;  # avoid \en on last field
\&        @array = split(/:/);
\&        ...
\&    }
.Ve
You can actually chomp anything that's an lvalue, including an assignment:
.Sp
.Vb 2
\&    chomp($cwd = `pwd`);
\&    chomp($answer = <STDIN>);
.Ve
If you chomp a list, each element is chomped, and the total number of
characters removed is returned.
.Ip "chop \s-1VARIABLE\s0" 8
.Ip "chop \s-1LIST\s0" 8
.Ip "chop" 8
Chops off the last character of a string and returns the character
chopped.  It's used primarily to remove the newline from the end of an
input record, but is much more efficient than \f(CWs/\en//\fR because it neither
scans nor copies the string.  If \s-1VARIABLE\s0 is omitted, chops \f(CW$_\fR.
Example:
.Sp
.Vb 5
\&    while (<>) {
\&        chop;   # avoid \en on last field
\&        @array = split(/:/);
\&        ...
\&    }
.Ve
You can actually chop anything that's an lvalue, including an assignment:
.Sp
.Vb 2
\&    chop($cwd = `pwd`);
\&    chop($answer = <STDIN>);
.Ve
If you chop a list, each element is chopped.  Only the value of the
last chop is returned.
.Ip "chown \s-1LIST\s0" 8
Changes the owner (and group) of a list of files.  The first two
elements of the list must be the \fI\s-1NUMERICAL\s0\fR uid and gid, in that order.
Returns the number of files successfully changed.
.Sp
.Vb 2
\&    $cnt = chown $uid, $gid, 'foo', 'bar';
\&    chown $uid, $gid, @filenames;
.Ve
Here's an example that looks up non-numeric uids in the passwd file:
.Sp
.Vb 4
\&    print "User: ";
\&    chop($user = <STDIN>);
\&    print "Files: "
\&    chop($pattern = <STDIN>);
.Ve
.Vb 2
\&    ($login,$pass,$uid,$gid) = getpwnam($user)
\&        or die "$user not in passwd file";
.Ve
.Vb 2
\&    @ary = <${pattern}>;        # expand filenames
\&    chown $uid, $gid, @ary;
.Ve
.Ip "chr \s-1NUMBER\s0" 8
Returns the character represented by that \s-1NUMBER\s0 in the character set.
For example, \f(CWchr(65)\fR is \*(L"A\*(R" in \s-1ASCII\s0.
.Ip "chroot \s-1FILENAME\s0" 8
Does the same as the system call of that name.  If you don't know what
it does, don't worry about it.  If \s-1FILENAME\s0 is omitted, does chroot to
\f(CW$_\fR.
.Ip "close \s-1FILEHANDLE\s0" 8
Closes the file or pipe associated with the file handle, returning \s-1TRUE\s0
only if stdio successfully flushes buffers and closes the system file
descriptor.  You don't have to close \s-1FILEHANDLE\s0 if you are immediately
going to do another open on it, since open will close it for you.  (See
\fIopen()\fR.)  However, an explicit close on an input file resets the line
counter ($.), while the implicit close done by \fIopen()\fR does not.  Also,
closing a pipe will wait for the process executing on the pipe to
complete, in case you want to look at the output of the pipe
afterwards.  Closing a pipe explicitly also puts the status value of
the command into \f(CW$?\fR.  Example:
.Sp
.Vb 4
\&    open(OUTPUT, '|sort >foo'); # pipe to sort
\&    ...                         # print stuff to output
\&    close OUTPUT;               # wait for sort to finish
\&    open(INPUT, 'foo');         # get sort's results
.Ve
\s-1FILEHANDLE\s0 may be an expression whose value gives the real filehandle name.
.Ip "closedir \s-1DIRHANDLE\s0" 8
Closes a directory opened by \fIopendir()\fR.
.Ip "connect \s-1SOCKET\s0,\s-1NAME\s0" 8
Attempts to connect to a remote socket, just as the connect system call
does.  Returns \s-1TRUE\s0 if it succeeded, \s-1FALSE\s0 otherwise.  \s-1NAME\s0 should be a
package address of the appropriate type for the socket.  See example in
the \fIperlipc\fR manpage.
.Ip "cos \s-1EXPR\s0" 8
Returns the cosine of \s-1EXPR\s0 (expressed in radians).  If \s-1EXPR\s0 is omitted
takes cosine of \f(CW$_\fR.
.Ip "crypt \s-1PLAINTEXT\s0,\s-1SALT\s0" 8
Encrypts a string exactly like the \fIcrypt\fR\|(3) function in the C library.
Useful for checking the password file for lousy passwords, amongst
other things.  Only the guys wearing white hats should do this.  
.Sp
Here's an example that makes sure that whoever runs this program knows
their own password:
.Sp
.Vb 2
\&    $pwd = (getpwuid($<))[1];
\&    $salt = substr($pwd, 0, 2);
.Ve
.Vb 5
\&    system "stty -echo";
\&    print "Password: ";
\&    chop($word = <STDIN>);
\&    print "\en";
\&    system "stty echo";
.Ve
.Vb 5
\&    if (crypt($word, $salt) ne $pwd) {
\&        die "Sorry...\en";
\&    } else {
\&        print "ok\en";
\&    } 
.Ve
Of course, typing in your own password to whoever asks you 
for it is unwise at best.
.Ip "dbmclose \s-1ASSOC_ARRAY\s0" 8
[This function has been superseded by the \fIuntie()\fR function.]
.Sp
Breaks the binding between a \s-1DBM\s0 file and an associative array.
.Ip "dbmopen \s-1ASSOC\s0,\s-1DBNAME\s0,\s-1MODE\s0" 8
[This function has been superseded by the \fItie()\fR function.]
.Sp
This binds a \fIdbm\fR\|(3) or \fIndbm\fR\|(3) file to an associative array.  \s-1ASSOC\s0 is the
name of the associative array.  (Unlike normal open, the first argument
is \fI\s-1NOT\s0\fR a filehandle, even though it looks like one).  \s-1DBNAME\s0 is the
name of the database (without the \fI.dir\fR or \fI.pag\fR extension).  If the
database does not exist, it is created with protection specified by
\s-1MODE\s0 (as modified by the \fIumask()\fR).  If your system only supports the
older \s-1DBM\s0 functions, you may perform only one \fIdbmopen()\fR in your program.
If your system has neither \s-1DBM\s0 nor ndbm, calling \fIdbmopen()\fR produces a
fatal error.
.Sp
If you don't have write access to the \s-1DBM\s0 file, you can only read
associative array variables, not set them.  If you want to test whether
you can write, either use file tests or try setting a dummy array entry
inside an \fIeval()\fR, which will trap the error.
.Sp
Note that functions such as \fIkeys()\fR and \fIvalues()\fR may return huge array
values when used on large \s-1DBM\s0 files.  You may prefer to use the \fIeach()\fR
function to iterate over large \s-1DBM\s0 files.  Example:
.Sp
.Vb 6
\&    # print out history file offsets
\&    dbmopen(%HIST,'/usr/lib/news/history',0666);
\&    while (($key,$val) = each %HIST) {
\&        print $key, ' = ', unpack('L',$val), "\en";
\&    }
\&    dbmclose(%HIST);
.Ve
.Ip "defined \s-1EXPR\s0" 8
Returns a boolean value saying whether the lvalue \s-1EXPR\s0 has a real value
or not.  Many operations return the undefined value under exceptional
conditions, such as end of file, uninitialized variable, system error
and such.  This function allows you to distinguish between an undefined
null scalar and a defined null scalar with operations that might return
a real null string, such as referencing elements of an array.  You may
also check to see if arrays or subroutines exist.  Use of defined on
predefined variables is not guaranteed to produce intuitive results.
.Sp
When used on a hash array element, it tells you whether the value
is defined, not whether the key exists in the hash.  Use \fIexists()\fR for that.
.Sp
Examples:
.Sp
.Vb 7
\&    print if defined $switch{'D'};
\&    print "$val\en" while defined($val = pop(@ary));
\&    die "Can't readlink $sym: $!"
\&        unless defined($value = readlink $sym);
\&    eval '@foo = ()' if defined(@foo);
\&    die "No XYZ package defined" unless defined %_XYZ;
\&    sub foo { defined &$bar ? &$bar(@_) : die "No bar"; }
.Ve
See also \fIundef()\fR.
.Ip "delete \s-1EXPR\s0" 8
Deletes the specified value from its hash array.  Returns the deleted
value, or the undefined value if nothing was deleted.  Deleting from
\f(CW$ENV{}\fR modifies the environment.  Deleting from an array tied to a \s-1DBM\s0
file deletes the entry from the \s-1DBM\s0 file.  (But deleting from a \fItie()\fRd
hash doesn't necessarily return anything.)
.Sp
The following deletes all the values of an associative array:
.Sp
.Vb 3
\&    foreach $key (keys %ARRAY) {
\&        delete $ARRAY{$key};
\&    }
.Ve
(But it would be faster to use the \fIundef()\fR command.)  Note that the
\s-1EXPR\s0 can be arbitrarily complicated as long as the final operation is
a hash key lookup:
.Sp
.Vb 1
\&    delete $ref->[$x][$y]{$key};
.Ve
.Ip "die \s-1LIST\s0" 8
Outside of an \fIeval()\fR, prints the value of \s-1LIST\s0 to \f(CWSTDERR\fR and exits with
the current value of $!  (errno).  If $! is 0, exits with the value of
\f(CW($? >> 8)\fR (`command` status).  If \f(CW($? >> 8)\fR is 0,
exits with 255.  Inside an \fIeval()\fR, the error message is stuffed into \f(CW$@\fR.
and the \fIeval()\fR is terminated with the undefined value.
.Sp
Equivalent examples:
.Sp
.Vb 2
\&    die "Can't cd to spool: $!\en" unless chdir '/usr/spool/news';
\&    chdir '/usr/spool/news' or die "Can't cd to spool: $!\en" 
.Ve
If the value of \s-1EXPR\s0 does not end in a newline, the current script line
number and input line number (if any) are also printed, and a newline
is supplied.  Hint: sometimes appending \*(L", stopped\*(R" to your message
will cause it to make better sense when the string \*(L"at foo line 123\*(R" is
appended.  Suppose you are running script \*(L"canasta\*(R".
.Sp
.Vb 2
\&    die "/etc/games is no good";
\&    die "/etc/games is no good, stopped";
.Ve
produce, respectively
.Sp
.Vb 2
\&    /etc/games is no good at canasta line 123.
\&    /etc/games is no good, stopped at canasta line 123.
.Ve
See also \fIexit()\fR and \fIwarn()\fR.
.Ip "do \s-1BLOCK\s0" 8
Not really a function.  Returns the value of the last command in the
sequence of commands indicated by \s-1BLOCK\s0.  When modified by a loop
modifier, executes the \s-1BLOCK\s0 once before testing the loop condition.
(On other statements the loop modifiers test the conditional first.)
.Ip "do \s-1SUBROUTINE\s0(\s-1LIST\s0)" 8
A deprecated form of subroutine call.  See the \fIperlsub\fR manpage.
.Ip "do \s-1EXPR\s0" 8
Uses the value of \s-1EXPR\s0 as a filename and executes the contents of the
file as a Perl script.  Its primary use is to include subroutines
from a Perl subroutine library.
.Sp
.Vb 1
\&    do 'stat.pl';
.Ve
is just like
.Sp
.Vb 1
\&    eval `cat stat.pl`;
.Ve
except that it's more efficient, more concise, keeps track of the
current filename for error messages, and searches all the \fB\-I\fR
libraries if the file isn't in the current directory (see also the \f(CW@INC\fR
array in the section on \fIPredefined Names\fR in the \fIperlvar\fR manpage).  It's the same, however, in that it does
reparse the file every time you call it, so you probably don't want to
do this inside a loop.
.Sp
Note that inclusion of library modules is better done with the
\fIuse()\fR and \fIrequire()\fR operators.
.Ip "dump \s-1LABEL\s0" 8
This causes an immediate core dump.  Primarily this is so that you can
use the \fBundump\fR program to turn your core dump into an executable binary
after having initialized all your variables at the beginning of the
program.  When the new binary is executed it will begin by executing a
\f(CWgoto LABEL\fR (with all the restrictions that \f(CWgoto\fR suffers).  Think of
it as a goto with an intervening core dump and reincarnation.  If \s-1LABEL\s0
is omitted, restarts the program from the top.  \s-1WARNING\s0: any files
opened at the time of the dump will \s-1NOT\s0 be open any more when the
program is reincarnated, with possible resulting confusion on the part
of Perl.  See also \fB\-u\fR option in the \fIperlrun\fR manpage.
.Sp
Example:
.Sp
.Vb 12
\&    #!/usr/bin/perl
\&    require 'getopt.pl';
\&    require 'stat.pl';
\&    %days = (
\&        'Sun' => 1,
\&        'Mon' => 2,
\&        'Tue' => 3,
\&        'Wed' => 4,
\&        'Thu' => 5,
\&        'Fri' => 6,
\&        'Sat' => 7,
\&    );
.Ve
.Vb 1
\&    dump QUICKSTART if $ARGV[0] eq '-d';
.Ve
.Vb 2
\&    QUICKSTART:
\&    Getopt('f');
.Ve
.Ip "each \s-1ASSOC_ARRAY\s0" 8
Returns a 2 element array consisting of the key and value for the next
value of an associative array, so that you can iterate over it.
Entries are returned in an apparently random order.  When the array is
entirely read, a null array is returned (which when assigned produces a
\s-1FALSE\s0 (0) value).  The next call to \fIeach()\fR after that will start
iterating again.  The iterator can be reset only by reading all the
elements from the array.  You should not add elements to an array while
you're iterating over it.  There is a single iterator for each
associative array, shared by all \fIeach()\fR, \fIkeys()\fR and \fIvalues()\fR function
calls in the program.  The following prints out your environment like
the \fIprintenv\fR\|(1) program, only in a different order:
.Sp
.Vb 3
\&    while (($key,$value) = each %ENV) {
\&        print "$key=$value\en";
\&    }
.Ve
See also \fIkeys()\fR and \fIvalues()\fR.
.Ip "eof \s-1FILEHANDLE\s0" 8
.Ip "eof" 8
Returns 1 if the next read on \s-1FILEHANDLE\s0 will return end of file, or if
\s-1FILEHANDLE\s0 is not open.  \s-1FILEHANDLE\s0 may be an expression whose value
gives the real filehandle name.  (Note that this function actually
reads a character and then \fIungetc()\fRs it, so it is not very useful in an
interactive context.)  An \f(CWeof\fR without an argument returns the eof status
for the last file read.  Empty parentheses () may be used to indicate
the pseudo file formed of the files listed on the command line, i.e.
\f(CWeof()\fR is reasonable to use inside a while (<>) loop to detect the end
of only the last file.  Use \f(CWeof(ARGV)\fR or eof without the parentheses to
test \fI\s-1EACH\s0\fR file in a while (<>) loop.  Examples:
.Sp
.Vb 7
\&    # insert dashes just before last line of last file
\&    while (<>) {
\&        if (eof()) {
\&            print "--------------\en";
\&        }
\&        print;
\&    }
.Ve
.Vb 7
\&    # reset line numbering on each input file
\&    while (<>) {
\&        print "$.\et$_";
\&        if (eof) {      # Not eof().
\&            close(ARGV);
\&        }
\&    }
.Ve
Practical hint: you almost never need to use \f(CWeof\fR in Perl, because the
input operators return undef when they run out of data.
.Ip "eval \s-1EXPR\s0" 8
.Ip "eval \s-1BLOCK\s0" 8
\s-1EXPR\s0 is parsed and executed as if it were a little Perl program.  It
is executed in the context of the current Perl program, so that any
variable settings, subroutine or format definitions remain afterwards.
The value returned is the value of the last expression evaluated, or a
return statement may be used, just as with subroutines.
.Sp
If there is a syntax error or runtime error, or a \fIdie()\fR statement is
executed, an undefined value is returned by \fIeval()\fR, and \f(CW$@\fR is set to the
error message.  If there was no error, \f(CW$@\fR is guaranteed to be a null
string.  If \s-1EXPR\s0 is omitted, evaluates \f(CW$_\fR.  The final semicolon, if
any, may be omitted from the expression.
.Sp
Note that, since \fIeval()\fR traps otherwise-fatal errors, it is useful for
determining whether a particular feature (such as \fIdbmopen()\fR or \fIsymlink()\fR)
is implemented.  It is also Perl's exception trapping mechanism, where
the die operator is used to raise exceptions.
.Sp
If the code to be executed doesn't vary, you may use the eval-\s-1BLOCK\s0
form to trap run-time errors without incurring the penalty of
recompiling each time.  The error, if any, is still returned in \f(CW$@\fR.
Examples:
.Sp
.Vb 2
\&    # make divide-by-zero non-fatal
\&    eval { $answer = $a / $b; }; warn $@ if $@;
.Ve
.Vb 2
\&    # same thing, but less efficient
\&    eval '$answer = $a / $b'; warn $@ if $@;
.Ve
.Vb 2
\&    # a compile-time error
\&    eval { $answer = };
.Ve
.Vb 2
\&    # a run-time error
\&    eval '$answer =';   # sets $@
.Ve
With an \fIeval()\fR, you should be especially careful to remember what's 
being looked at when:
.Sp
.Vb 2
\&    eval $x;            # CASE 1
\&    eval "$x";          # CASE 2
.Ve
.Vb 2
\&    eval '$x';          # CASE 3
\&    eval { $x };        # CASE 4
.Ve
.Vb 2
\&    eval "\e$$x++"       # CASE 5
\&    $$x++;              # CASE 6
.Ve
Cases 1 and 2 above behave identically: they run the code contained in the
variable \f(CW$x\fR.  (Although case 2 has misleading double quotes making the
reader wonder what else might be happening (nothing is).) Cases 3 and 4
likewise behave in the same way: they run the code <\f(CW$x\fR>, which does
nothing at all.  (Case 4 is preferred for purely visual reasons.) Case 5
is a place where normally you \fI\s-1WOULD\s0\fR like to use double quotes, except
that in particular situation, you can just use symbolic references
instead, as in case 6.
.Ip "exec \s-1LIST\s0" 8
The \fIexec()\fR function executes a system command \fI\s-1AND\s0 \s-1NEVER\s0 \s-1RETURNS\s0\fR.  Use
the \fIsystem()\fR function if you want it to return.
.Sp
If there is more than one argument in \s-1LIST\s0, or if \s-1LIST\s0 is an array with
more than one value, calls \fIexecvp\fR\|(3) with the arguments in \s-1LIST\s0.  If
there is only one scalar argument, the argument is checked for shell
metacharacters.  If there are any, the entire argument is passed to
\f(CW/bin/sh -c\fR for parsing.  If there are none, the argument is split
into words and passed directly to \fIexecvp()\fR, which is more efficient.
Note: \fIexec()\fR (and \fIsystem\fR\|(0) do not flush your output buffer, so you may
need to set \f(CW$|\fR to avoid lost output.  Examples:
.Sp
.Vb 2
\&    exec '/bin/echo', 'Your arguments are: ', @ARGV;
\&    exec "sort $outfile | uniq";
.Ve
If you don't really want to execute the first argument, but want to lie
to the program you are executing about its own name, you can specify
the program you actually want to run as an \*(L"indirect object\*(R" (without a
comma) in front of the \s-1LIST\s0.  (This always forces interpretation of the
\s-1LIST\s0 as a multi-valued list, even if there is only a single scalar in
the list.)  Example:
.Sp
.Vb 2
\&    $shell = '/bin/csh';
\&    exec $shell '-sh';          # pretend it's a login shell
.Ve
or, more directly,
.Sp
.Vb 1
\&    exec {'/bin/csh'} '-sh';    # pretend it's a login shell
.Ve
.Ip "exists \s-1EXPR\s0" 8
Returns \s-1TRUE\s0 if the specified hash key exists in its hash array, even
if the corresponding value is undefined.
.Sp
.Vb 3
\&    print "Exists\en" if exists $array{$key};
\&    print "Defined\en" if defined $array{$key};
\&    print "True\en" if $array{$key};
.Ve
A hash element can only be \s-1TRUE\s0 if it's defined, and defined if
it exists, but the reverse doesn't necessarily hold true.
.Sp
Note that the \s-1EXPR\s0 can be arbitrarily complicated as long as the final
operation is a hash key lookup:
.Sp
.Vb 1
\&    if (exists $ref->[$x][$y]{$key}) { ... }
.Ve
.Ip "exit \s-1EXPR\s0" 8
Evaluates \s-1EXPR\s0 and exits immediately with that value.  (Actually, it
calls any defined \f(CWEND\fR routines first, but the \f(CWEND\fR routines may not
abort the exit.  Likewise any object destructors that need to be called
are called before exit.)  Example:
.Sp
.Vb 2
\&    $ans = <STDIN>;
\&    exit 0 if $ans =~ /^[Xx]/;
.Ve
See also \fIdie()\fR.  If \s-1EXPR\s0 is omitted, exits with 0 status.
.Ip "exp \s-1EXPR\s0" 8
Returns \fIe\fR (the natural logarithm base) to the power of \s-1EXPR\s0.  
If \s-1EXPR\s0 is omitted, gives \f(CWexp($_)\fR.
.Ip "fcntl \s-1FILEHANDLE\s0,\s-1FUNCTION\s0,\s-1SCALAR\s0" 8
Implements the \fIfcntl\fR\|(2) function.  You'll probably have to say
.Sp
.Vb 1
\&    use Fcntl;
.Ve
first to get the correct function definitions.  Argument processing and
value return works just like \fIioctl()\fR below.  Note that \fIfcntl()\fR will produce
a fatal error if used on a machine that doesn't implement \fIfcntl\fR\|(2).
For example:
.Sp
.Vb 2
\&    use Fcntl;
\&    fcntl($filehandle, F_GETLK, $packed_return_buffer);
.Ve
.Ip "fileno \s-1FILEHANDLE\s0" 8
Returns the file descriptor for a filehandle.  This is useful for
constructing bitmaps for \fIselect()\fR.  If \s-1FILEHANDLE\s0 is an expression, the
value is taken as the name of the filehandle.
.Ip "flock \s-1FILEHANDLE\s0,\s-1OPERATION\s0" 8
Calls \fIflock\fR\|(2) on \s-1FILEHANDLE\s0.  See the \fIflock(2)\fR manpage for
definition of \s-1OPERATION\s0.  Returns \s-1TRUE\s0 for success, \s-1FALSE\s0 on failure.
Will produce a fatal error if used on a machine that doesn't implement
\fIflock\fR\|(2).  Here's a mailbox appender for \s-1BSD\s0 systems.
.Sp
.Vb 4
\&    $LOCK_SH = 1;
\&    $LOCK_EX = 2;
\&    $LOCK_NB = 4;
\&    $LOCK_UN = 8;
.Ve
.Vb 6
\&    sub lock {
\&        flock(MBOX,$LOCK_EX);
\&        # and, in case someone appended
\&        # while we were waiting...
\&        seek(MBOX, 0, 2);
\&    }
.Ve
.Vb 3
\&    sub unlock {
\&        flock(MBOX,$LOCK_UN);
\&    }
.Ve
.Vb 2
\&    open(MBOX, ">>/usr/spool/mail/$ENV{'USER'}")
\&            or die "Can't open mailbox: $!";
.Ve
.Vb 3
\&    lock();
\&    print MBOX $msg,"\en\en";
\&    unlock();
.Ve
Note that \fIflock()\fR can't lock things over the network.  You need to do
locking with \fIfcntl()\fR for that.
.Ip "fork" 8
Does a \fIfork\fR\|(2) system call.  Returns the child pid to the parent process
and 0 to the child process, or undef if the fork is unsuccessful.
Note: unflushed buffers remain unflushed in both processes, which means
you may need to set \f(CW$|\fR (\f(CW$AUTOFLUSH\fR in English) or call the 
\fIautoflush()\fR FileHandle method to avoid duplicate output.
.Sp
If you \fIfork()\fR without ever waiting on your children, you will accumulate
zombies:
.Sp
.Vb 1
\&    $SIG{'CHLD'} = sub { wait };
.Ve
There's also the double-fork trick (error checking on 
\fIfork()\fR returns omitted);
.Sp
.Vb 11
\&    unless ($pid = fork) {
\&        unless (fork) {
\&            exec "what you really wanna do";
\&            die "no exec";
\&            # ... or ...
\&            some_perl_code_here;
\&            exit 0;
\&        }
\&        exit 0;
\&    }
\&    waitpid($pid,0);
.Ve
.Ip "formline \s-1PICTURE\s0, \s-1LIST\s0" 8
This is an internal function used by formats, though you may call it
too.  It formats (see the \fIperlform\fR manpage) a list of values according to the
contents of \s-1PICTURE\s0, placing the output into the format output
accumulator, \f(CW$^A\fR.  Eventually, when a \fIwrite()\fR is done, the contents of
\f(CW$^A\fR are written to some filehandle, but you could also read \f(CW$^A\fR
yourself and then set \f(CW$^A\fR back to "".  Note that a format typically
does one \fIformline()\fR per line of form, but the \fIformline()\fR function itself
doesn't care how many newlines are embedded in the \s-1PICTURE\s0.  Be careful
if you put double quotes around the picture, since an "\f(CW@\fR" character may
be taken to mean the beginning of an array name.  \fIformline()\fR always
returns \s-1TRUE\s0.
.Ip "getc \s-1FILEHANDLE\s0" 8
.Ip "getc" 8
Returns the next character from the input file attached to \s-1FILEHANDLE\s0,
or a null string at end of file.  If \s-1FILEHANDLE\s0 is omitted, reads from \s-1STDIN\s0.
.Ip "getlogin" 8
Returns the current login from \fI/etc/utmp\fR, if any.  If null, use
\fIgetpwuid()\fR.
.Sp
.Vb 1
\&    $login = getlogin || (getpwuid($<))[0] || "Kilroy";
.Ve
.Ip "getpeername \s-1SOCKET\s0" 8
Returns the packed sockaddr address of other end of the \s-1SOCKET\s0 connection.
.Sp
.Vb 4
\&    # An internet sockaddr
\&    $sockaddr = 'S n a4 x8';
\&    $hersockaddr = getpeername(S);
\&    ($family, $port, $heraddr) = unpack($sockaddr,$hersockaddr);
.Ve
.Ip "getpgrp \s-1PID\s0" 8
Returns the current process group for the specified \s-1PID\s0, 0 for the
current process.  Will produce a fatal error if used on a machine that
doesn't implement \fIgetpgrp\fR\|(2).  If \s-1PID\s0 is omitted, returns process
group of current process.
.Ip "getppid" 8
Returns the process id of the parent process.
.Ip "getpriority \s-1WHICH\s0,\s-1WHO\s0" 8
Returns the current priority for a process, a process group, or a
user.  (See the \fIgetpriority(2)\fR manpage.)  Will produce a fatal error if used on a
machine that doesn't implement \fIgetpriority\fR\|(2).
.Ip "getpwnam \s-1NAME\s0" 8
.Ip "getgrnam \s-1NAME\s0" 8
.Ip "gethostbyname \s-1NAME\s0" 8
.Ip "getnetbyname \s-1NAME\s0" 8
.Ip "getprotobyname \s-1NAME\s0" 8
.Ip "getpwuid \s-1UID\s0" 8
.Ip "getgrgid \s-1GID\s0" 8
.Ip "getservbyname \s-1NAME\s0,\s-1PROTO\s0" 8
.Ip "gethostbyaddr \s-1ADDR\s0,\s-1ADDRTYPE\s0" 8
.Ip "getnetbyaddr \s-1ADDR\s0,\s-1ADDRTYPE\s0" 8
.Ip "getprotobynumber \s-1NUMBER\s0" 8
.Ip "getservbyport \s-1PORT\s0,\s-1PROTO\s0" 8
.Ip "getpwent" 8
.Ip "getgrent" 8
.Ip "gethostent" 8
.Ip "getnetent" 8
.Ip "getprotoent" 8
.Ip "getservent" 8
.Ip "setpwent" 8
.Ip "setgrent" 8
.Ip "sethostent \s-1STAYOPEN\s0" 8
.Ip "setnetent \s-1STAYOPEN\s0" 8
.Ip "setprotoent \s-1STAYOPEN\s0" 8
.Ip "setservent \s-1STAYOPEN\s0" 8
.Ip "endpwent" 8
.Ip "endgrent" 8
.Ip "endhostent" 8
.Ip "endnetent" 8
.Ip "endprotoent" 8
.Ip "endservent" 8
These routines perform the same functions as their counterparts in the
system library.  Within a list context, the return values from the
various get routines are as follows:
.Sp
.Vb 7
\&    ($name,$passwd,$uid,$gid,
\&       $quota,$comment,$gcos,$dir,$shell) = getpw*
\&    ($name,$passwd,$gid,$members) = getgr*
\&    ($name,$aliases,$addrtype,$length,@addrs) = gethost*
\&    ($name,$aliases,$addrtype,$net) = getnet*
\&    ($name,$aliases,$proto) = getproto*
\&    ($name,$aliases,$port,$proto) = getserv*
.Ve
(If the entry doesn't exist you get a null list.)
.Sp
Within a scalar context, you get the name, unless the function was a
lookup by name, in which case you get the other thing, whatever it is.
(If the entry doesn't exist you get the undefined value.)  For example:
.Sp
.Vb 7
\&    $uid = getpwnam
\&    $name = getpwuid
\&    $name = getpwent
\&    $gid = getgrnam
\&    $name = getgrgid
\&    $name = getgrent
\&    etc.
.Ve
The \f(CW$members\fR value returned by \fIgetgr*()\fR is a space separated list of
the login names of the members of the group.
.Sp
For the \fIgethost*()\fR functions, if the \f(CWh_errno\fR variable is supported in
C, it will be returned to you via \f(CW$?\fR if the function call fails.  The
\f(CW@addrs\fR value returned by a successful call is a list of the raw
addresses returned by the corresponding system library call.  In the
Internet domain, each address is four bytes long and you can unpack it
by saying something like:
.Sp
.Vb 1
\&    ($a,$b,$c,$d) = unpack('C4',$addr[0]);
.Ve
.Ip "getsockname \s-1SOCKET\s0" 8
Returns the packed sockaddr address of this end of the \s-1SOCKET\s0 connection.
.Sp
.Vb 5
\&    # An internet sockaddr
\&    $sockaddr = 'S n a4 x8';
\&    $mysockaddr = getsockname(S);
\&    ($family, $port, $myaddr) =
\&                    unpack($sockaddr,$mysockaddr);
.Ve
.Ip "getsockopt \s-1SOCKET\s0,\s-1LEVEL\s0,\s-1OPTNAME\s0" 8
Returns the socket option requested, or undefined if there is an error.
.Ip "glob \s-1EXPR\s0" 8
Returns the value of \s-1EXPR\s0 with filename expansions such as a shell
would do.  This is the internal function implementing the <*.*>
operator.
.Ip "gmtime \s-1EXPR\s0" 8
Converts a time as returned by the time function to a 9-element array
with the time analyzed for the Greenwich timezone.  Typically used as
follows:
.Sp
.Vb 2
\&    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
\&                                            gmtime(time);
.Ve
All array elements are numeric, and come straight out of a struct tm.
In particular this means that \f(CW$mon\fR has the range 0..11 and \f(CW$wday\fR has
the range 0..6.  If \s-1EXPR\s0 is omitted, does \f(CWgmtime(time())\fR.
.Ip "goto \s-1LABEL\s0" 8
.Ip "goto &\s-1NAME\s0" 8
The goto-\s-1LABEL\s0 form finds the statement labeled with \s-1LABEL\s0 and resumes
execution there.  It may not be used to go into any construct that
requires initialization, such as a subroutine or a foreach loop.  It
also can't be used to go into a construct that is optimized away.  It
can be used to go almost anywhere else within the dynamic scope,
including out of subroutines, but it's usually better to use some other
construct such as last or die.  The author of Perl has never felt the
need to use this form of goto (in Perl, that is\*(--C is another matter).
.Sp
The goto-&\s-1NAME\s0 form is highly magical, and substitutes a call to the
named subroutine for the currently running subroutine.  This is used by
\s-1AUTOLOAD\s0 subroutines that wish to load another subroutine and then
pretend that the other subroutine had been called in the first place
(except that any modifications to \f(CW@_\fR in the current subroutine are
propagated to the other subroutine.)  After the goto, not even \fIcaller()\fR
will be able to tell that this routine was called first.
.Ip "grep \s-1BLOCK\s0 \s-1LIST\s0" 8
.Ip "grep \s-1EXPR\s0,\s-1LIST\s0" 8
Evaluates the \s-1BLOCK\s0 or \s-1EXPR\s0 for each element of \s-1LIST\s0 (locally setting
\f(CW$_\fR to each element) and returns the list value consisting of those
elements for which the expression evaluated to \s-1TRUE\s0.  In a scalar
context, returns the number of times the expression was \s-1TRUE\s0.
.Sp
.Vb 1
\&    @foo = grep(!/^#/, @bar);    # weed out comments
.Ve
or equivalently,
.Sp
.Vb 1
\&    @foo = grep {!/^#/} @bar;    # weed out comments
.Ve
Note that, since \f(CW$_\fR is a reference into the list value, it can be used
to modify the elements of the array.  While this is useful and
supported, it can cause bizarre results if the \s-1LIST\s0 is not a named
array.
.Ip "hex \s-1EXPR\s0" 8
Returns the decimal value of \s-1EXPR\s0 interpreted as an hex string.  (To
interpret strings that might start with 0 or 0x see \fIoct()\fR.)  If \s-1EXPR\s0 is
omitted, uses \f(CW$_\fR.
.Ip "import" 8
There is no built-in \fIimport()\fR function.  It is merely an ordinary
method subroutine defined (or inherited) by modules that wish to export
names to another module.  The \fIuse()\fR function calls the \fIimport()\fR method
for the package used.  See also the \f(CWuse\fR entry elsewhere in this documentbelow and the \fIperlmod\fR manpage.
.Ip "index \s-1STR\s0,\s-1SUBSTR\s0,\s-1POSITION\s0" 8
.Ip "index \s-1STR\s0,\s-1SUBSTR\s0" 8
Returns the position of the first occurrence of \s-1SUBSTR\s0 in \s-1STR\s0 at or
after \s-1POSITION\s0.  If \s-1POSITION\s0 is omitted, starts searching from the
beginning of the string.  The return value is based at 0, or whatever
you've set the $[ variable to.  If the substring is not found, returns
one less than the base, ordinarily \-1.
.Ip "int \s-1EXPR\s0" 8
Returns the integer portion of \s-1EXPR\s0.  If \s-1EXPR\s0 is omitted, uses \f(CW$_\fR.
.Ip "ioctl \s-1FILEHANDLE\s0,\s-1FUNCTION\s0,\s-1SCALAR\s0" 8
Implements the \fIioctl\fR\|(2) function.  You'll probably have to say
.Sp
.Vb 1
\&    require "ioctl.ph"; # probably /usr/local/lib/perl/ioctl.ph
.Ve
first to get the correct function definitions.  If ioctl.ph doesn't
exist or doesn't have the correct definitions you'll have to roll your
own, based on your C header files such as <sys/ioctl.h>.  (There is a
Perl script called \fBh2ph\fR that comes with the Perl kit which may help you
in this.)  \s-1SCALAR\s0 will be read and/or written depending on the
\s-1FUNCTION\s0\*(--a pointer to the string value of \s-1SCALAR\s0 will be passed as the
third argument of the actual ioctl call.  (If \s-1SCALAR\s0 has no string
value but does have a numeric value, that value will be passed rather
than a pointer to the string value.  To guarantee this to be \s-1TRUE\s0, add
a 0 to the scalar before using it.)  The \fIpack()\fR and \fIunpack()\fR functions
are useful for manipulating the values of structures used by \fIioctl()\fR.
The following example sets the erase character to \s-1DEL\s0.
.Sp
.Vb 9
\&    require 'ioctl.ph';
\&    $sgttyb_t = "ccccs";                # 4 chars and a short
\&    if (ioctl(STDIN,$TIOCGETP,$sgttyb)) {
\&        @ary = unpack($sgttyb_t,$sgttyb);
\&        $ary[2] = 127;
\&        $sgttyb = pack($sgttyb_t,@ary);
\&        ioctl(STDIN,$TIOCSETP,$sgttyb)
\&            || die "Can't ioctl: $!";
\&    }
.Ve
The return value of ioctl (and fcntl) is as follows:
.Sp
.Vb 4
\&        if OS returns:          then Perl returns:
\&            -1                    undefined value
\&             0                  string "0 but true"
\&        anything else               that number
.Ve
Thus Perl returns \s-1TRUE\s0 on success and \s-1FALSE\s0 on failure, yet you can
still easily determine the actual value returned by the operating
system:
.Sp
.Vb 2
\&    ($retval = ioctl(...)) || ($retval = -1);
\&    printf "System returned %d\en", $retval;
.Ve
.Ip "join \s-1EXPR\s0,\s-1LIST\s0" 8
Joins the separate strings of \s-1LIST\s0 or \s-1ARRAY\s0 into a single string with
fields separated by the value of \s-1EXPR\s0, and returns the string.
Example:
.Sp
.Vb 1
\&    $_ = join(':', $login,$passwd,$uid,$gid,$gcos,$home,$shell);
.Ve
See the \f(CWsplit\fR entry in the \fIperlfunc\fR manpage.
.Ip "keys \s-1ASSOC_ARRAY\s0" 8
Returns a normal array consisting of all the keys of the named
associative array.  (In a scalar context, returns the number of keys.)
The keys are returned in an apparently random order, but it is the same
order as either the \fIvalues()\fR or \fIeach()\fR function produces (given that
the associative array has not been modified).  Here is yet another way
to print your environment:
.Sp
.Vb 5
\&    @keys = keys %ENV;
\&    @values = values %ENV;
\&    while ($#keys >= 0) {
\&        print pop(@keys), '=', pop(@values), "\en";
\&    }
.Ve
or how about sorted by key:
.Sp
.Vb 3
\&    foreach $key (sort(keys %ENV)) {
\&        print $key, '=', $ENV{$key}, "\en";
\&    }
.Ve
.Ip "kill \s-1LIST\s0" 8
Sends a signal to a list of processes.  The first element of the list
must be the signal to send.  Returns the number of processes
successfully signaled.
.Sp
.Vb 2
\&    $cnt = kill 1, $child1, $child2;
\&    kill 9, @goners;
.Ve
Unlike in the shell, in Perl
if the \fI\s-1SIGNAL\s0\fR is negative, it kills process groups instead of processes.
(On System V, a negative \fI\s-1PROCESS\s0\fR number will also kill process
groups, but that's not portable.)  That means you usually want to use
positive not negative signals.  You may also use a signal name in quotes.
.Ip "last \s-1LABEL\s0" 8
.Ip "last" 8
The \f(CWlast\fR command is like the \f(CWbreak\fR statement in C (as used in
loops); it immediately exits the loop in question.  If the \s-1LABEL\s0 is
omitted, the command refers to the innermost enclosing loop.  The
\f(CWcontinue\fR block, if any, is not executed:
.Sp
.Vb 4
\&    line: while (<STDIN>) {
\&        last line if /^$/;      # exit when done with header
\&        ...
\&    }
.Ve
.Ip "lc \s-1EXPR\s0" 8
Returns an lowercased version of \s-1EXPR\s0.  This is the internal function
implementing the \eL escape in double-quoted strings.
.Ip "lcfirst \s-1EXPR\s0" 8
Returns the value of \s-1EXPR\s0 with the first character lowercased.  This is
the internal function implementing the \el escape in double-quoted strings.
.Ip "length \s-1EXPR\s0" 8
Returns the length in characters of the value of \s-1EXPR\s0.  If \s-1EXPR\s0 is
omitted, returns length of \f(CW$_\fR.
.Ip "link \s-1OLDFILE\s0,\s-1NEWFILE\s0" 8
Creates a new filename linked to the old filename.  Returns 1 for
success, 0 otherwise.
.Ip "listen \s-1SOCKET\s0,\s-1QUEUESIZE\s0" 8
Does the same thing that the listen system call does.  Returns \s-1TRUE\s0 if
it succeeded, \s-1FALSE\s0 otherwise.  See example in the \fIperlipc\fR manpage.
.Ip "local \s-1EXPR\s0" 8
In general, you should be using \*(L"my\*(R" instead of \*(L"local\*(R", because it's
faster and safer.  Format variables have to use \*(L"local\*(R" though, as
do any other variables whose local value must be visible to called
subroutines.  This is known as dynamic scoping.  Lexical scoping is
done with \*(L"my\*(R", which works more like C's auto declarations.
.Sp
A local modifies the listed variables to be local to the enclosing block,
subroutine, eval or \*(L"do\*(R".  If more than one value is listed, the list
must be placed in parens.  All the listed elements must be legal
lvalues.  This operator works by saving the current values of those
variables in \s-1LIST\s0 on a hidden stack and restoring them upon exiting the
block, subroutine or eval.  This means that called subroutines can also
reference the local variable, but not the global one.  The \s-1LIST\s0 may be
assigned to if desired, which allows you to initialize your local
variables.  (If no initializer is given for a particular variable, it
is created with an undefined value.)  Commonly this is used to name the
parameters to a subroutine.  Examples:
.Sp
.Vb 4
\&    sub RANGEVAL {
\&        local($min, $max, $thunk) = @_;
\&        local $result = '';
\&        local $i;
.Ve
.Vb 1
\&        # Presumably $thunk makes reference to $i
.Ve
.Vb 3
\&        for ($i = $min; $i < $max; $i++) {
\&            $result .= eval $thunk;
\&        }
.Ve
.Vb 2
\&        $result;
\&    }
.Ve
.Vb 7
\&    if ($sw eq '-v') {
\&        # init local array with global array
\&        local @ARGV = @ARGV;
\&        unshift(@ARGV,'echo');
\&        system @ARGV;
\&    }
\&    # @ARGV restored
.Ve
.Vb 6
\&    # temporarily add to digits associative array
\&    if ($base12) {
\&        # (NOTE: not claiming this is efficient!)
\&        local(%digits) = (%digits,'t',10,'e',11);
\&        parse_num();
\&    }
.Ve
Note that \fIlocal()\fR is a run-time command, and so gets executed every
time through a loop.  In Perl 4 it used  up more stack storage each
time until the loop was exited.  Perl 5 reclaims the space each time
through, but it's still more efficient to declare your variables
outside the loop.
.Sp
When you assign to a localized \s-1EXPR\s0, the local doesn't change whether
\s-1EXPR\s0 is viewed as a scalar or an array.  So
.Sp
.Vb 2
\&    local($foo) = <STDIN>;
\&    local @FOO = <STDIN>;
.Ve
both supply a list context to the righthand side, while
.Sp
.Vb 1
\&    local $foo = <STDIN>;
.Ve
supplies a scalar context.
.Ip "localtime \s-1EXPR\s0" 8
Converts a time as returned by the time function to a 9-element array
with the time analyzed for the local timezone.  Typically used as
follows:
.Sp
.Vb 2
\&    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
\&                                                localtime(time);
.Ve
All array elements are numeric, and come straight out of a struct tm.
In particular this means that \f(CW$mon\fR has the range 0..11 and \f(CW$wday\fR has
the range 0..6.  If \s-1EXPR\s0 is omitted, does \fIlocaltime\fR\|(time).
.Sp
In a scalar context, prints out the \fIctime\fR\|(3) value:
.Sp
.Vb 1
\&    $now_string = localtime;  # e.g. "Thu Oct 13 04:54:34 1994"
.Ve
See also the \f(CWtimelocal\fR entry in the \fIperlmod\fR manpage and the \fIstrftime\fR\|(3) function available
via the \s-1POSIX\s0 modulie.
.Ip "log \s-1EXPR\s0" 8
Returns logarithm (base \fIe\fR) of \s-1EXPR\s0.  If \s-1EXPR\s0 is omitted, returns log
of \f(CW$_\fR.
.Ip "lstat \s-1FILEHANDLE\s0" 8
.Ip "lstat \s-1EXPR\s0" 8
Does the same thing as the \fIstat()\fR function, but stats a symbolic link
instead of the file the symbolic link points to.  If symbolic links are
unimplemented on your system, a normal \fIstat()\fR is done.
.Ip "m//" 8
The match operator.  See the \fIperlop\fR manpage.
.Ip "map \s-1BLOCK\s0 \s-1LIST\s0" 8
.Ip "map \s-1EXPR\s0,\s-1LIST\s0" 8
Evaluates the \s-1BLOCK\s0 or \s-1EXPR\s0 for each element of \s-1LIST\s0 (locally setting \f(CW$_\fR to each
element) and returns the list value composed of the results of each such
evaluation.  Evaluates \s-1BLOCK\s0 or \s-1EXPR\s0 in a list context, so each element of \s-1LIST\s0
may produce zero, one, or more elements in the returned value.
.Sp
.Vb 1
\&    @chars = map(chr, @nums);
.Ve
translates a list of numbers to the corresponding characters.  And
.Sp
.Vb 1
\&    %hash = map {&key($_), $_} @array;
.Ve
is just a funny way to write
.Sp
.Vb 4
\&    %hash = ();
\&    foreach $_ (@array) {
\&        $hash{&key($_)} = $_;
\&    }
.Ve
.Ip "mkdir \s-1FILENAME\s0,\s-1MODE\s0" 8
Creates the directory specified by \s-1FILENAME\s0, with permissions specified
by \s-1MODE\s0 (as modified by umask).  If it succeeds it returns 1, otherwise
it returns 0 and sets $! (errno).
.Ip "msgctl \s-1ID\s0,\s-1CMD\s0,\s-1ARG\s0" 8
Calls the System V \s-1IPC\s0 function msgctl.  If \s-1CMD\s0 is &\s-1IPC_STAT\s0, then \s-1ARG\s0
must be a variable which will hold the returned msqid_ds structure.
Returns like ioctl: the undefined value for error, \*(L"0 but true\*(R" for
zero, or the actual return value otherwise.
.Ip "msgget \s-1KEY\s0,\s-1FLAGS\s0" 8
Calls the System V \s-1IPC\s0 function msgget.  Returns the message queue id,
or the undefined value if there is an error.
.Ip "msgsnd \s-1ID\s0,\s-1MSG\s0,\s-1FLAGS\s0" 8
Calls the System V \s-1IPC\s0 function msgsnd to send the message \s-1MSG\s0 to the
message queue \s-1ID\s0.  \s-1MSG\s0 must begin with the long integer message type,
which may be created with \f(CWpack("L", $type)\fR.  Returns \s-1TRUE\s0 if
successful, or \s-1FALSE\s0 if there is an error.
.Ip "msgrcv \s-1ID\s0,\s-1VAR\s0,\s-1SIZE\s0,\s-1TYPE\s0,\s-1FLAGS\s0" 8
Calls the System V \s-1IPC\s0 function msgrcv to receive a message from
message queue \s-1ID\s0 into variable \s-1VAR\s0 with a maximum message size of
\s-1SIZE\s0.  Note that if a message is received, the message type will be the
first thing in \s-1VAR\s0, and the maximum length of \s-1VAR\s0 is \s-1SIZE\s0 plus the size
of the message type.  Returns \s-1TRUE\s0 if successful, or \s-1FALSE\s0 if there is
an error.
.Ip "my \s-1EXPR\s0" 8
A \*(L"my\*(R" declares the listed variables to be local (lexically) to the
enclosing block, subroutine, eval or \*(L"do\*(R".  If more than one value is
listed, the list must be placed in parens.  All the listed elements
must be legal lvalues.  Only alphanumeric identifiers may be lexically
scoped\*(--magical builtins like $/ must be localized with \*(L"local\*(R"
instead.  In particular, you're not allowed to say
.Sp
.Vb 1
\&    my $_;      # Illegal.
.Ve
Unlike the \*(L"local\*(R" declaration, variables declared with \*(L"my\*(R"
are totally hidden from the outside world, including any called
subroutines (even if it's the same subroutine\*(--every call gets its own
copy).
.Sp
(An \fIeval()\fR, however, can see the lexical variables of the scope it is
being evaluated in so long as the names aren't hidden by declarations within
the \fIeval()\fR itself.  See the \fIperlref\fR manpage.)
.Sp
The \s-1EXPR\s0 may be assigned to if desired, which allows you to initialize
your variables.  (If no initializer is given for a particular
variable, it is created with an undefined value.)  Commonly this is
used to name the parameters to a subroutine.  Examples:
.Sp
.Vb 4
\&    sub RANGEVAL {
\&        my($min, $max, $thunk) = @_;
\&        my $result = '';
\&        my $i;
.Ve
.Vb 1
\&        # Presumably $thunk makes reference to $i
.Ve
.Vb 3
\&        for ($i = $min; $i < $max; $i++) {
\&            $result .= eval $thunk;
\&        }
.Ve
.Vb 2
\&        $result;
\&    }
.Ve
.Vb 7
\&    if ($sw eq '-v') {
\&        # init my array with global array
\&        my @ARGV = @ARGV;
\&        unshift(@ARGV,'echo');
\&        system @ARGV;
\&    }
\&    # Outer @ARGV again visible
.Ve
When you assign to the \s-1EXPR\s0, the \*(L"my\*(R" doesn't change whether
\s-1EXPR\s0 is viewed as a scalar or an array.  So
.Sp
.Vb 2
\&    my($foo) = <STDIN>;
\&    my @FOO = <STDIN>;
.Ve
both supply a list context to the righthand side, while
.Sp
.Vb 1
\&    my $foo = <STDIN>;
.Ve
supplies a scalar context.
.Sp
Some users may wish to encourage the use of lexically scoped variables.
As an aid to catching implicit references to package variables,
if you say
.Sp
.Vb 1
\&    use strict 'vars';
.Ve
then any variable reference from there to the end of the enclosing
block must either refer to a lexical variable, or must be fully
qualified with the package name.  A compilation error results
otherwise.  An inner block may countermand this with \*(L"no\ strict\ \*(L'vars'\*(R".
.Ip "next \s-1LABEL\s0" 8
.Ip "next" 8
The \f(CWnext\fR command is like the \f(CWcontinue\fR statement in C; it starts
the next iteration of the loop:
.Sp
.Vb 4
\&    line: while (<STDIN>) {
\&        next line if /^#/;      # discard comments
\&        ...
\&    }
.Ve
Note that if there were a \f(CWcontinue\fR block on the above, it would get
executed even on discarded lines.  If the \s-1LABEL\s0 is omitted, the command
refers to the innermost enclosing loop.
.Ip "no Module \s-1LIST\s0" 8
See the \*(L"use\*(R" function, which \*(L"no\*(R" is the opposite of.
.Ip "oct \s-1EXPR\s0" 8
Returns the decimal value of \s-1EXPR\s0 interpreted as an octal string.  (If
\s-1EXPR\s0 happens to start off with 0x, interprets it as a hex string
instead.)  The following will handle decimal, octal, and hex in the
standard Perl or C notation:
.Sp
.Vb 1
\&    $val = oct($val) if $val =~ /^0/;
.Ve
If \s-1EXPR\s0 is omitted, uses \f(CW$_\fR.
.Ip "open \s-1FILEHANDLE\s0,\s-1EXPR\s0" 8
.Ip "open \s-1FILEHANDLE\s0" 8
Opens the file whose filename is given by \s-1EXPR\s0, and associates it with
\s-1FILEHANDLE\s0.  If \s-1FILEHANDLE\s0 is an expression, its value is used as the
name of the real filehandle wanted.  If \s-1EXPR\s0 is omitted, the scalar
variable of the same name as the \s-1FILEHANDLE\s0 contains the filename.  If
the filename begins with \*(L"<\*(R" or nothing, the file is opened for input.
If the filename begins with \*(L">\*(R", the file is opened for output.  If the
filename begins with \*(L">>\*(R", the file is opened for appending.  (You can
put a \*(L'+\*(R' in front of the \*(L'>\*(R' or \*(L'<\*(R' to indicate that you want both
read and write access to the file.)  If the filename begins with \*(L"|\*(R",
the filename is interpreted as a command to which output is to be
piped, and if the filename ends with a \*(L"|\*(R", the filename is interpreted
as command which pipes input to us.  (You may not have a command that
pipes both in and out.)  Opening \*(L'\-\*(R' opens \s-1STDIN\s0 and opening \*(L'>\-\*(R'
opens \s-1STDOUT\s0.  Open returns non-zero upon success, the undefined
value otherwise.  If the open involved a pipe, the return value happens
to be the pid of the subprocess.  Examples:
.Sp
.Vb 3
\&    $ARTICLE = 100;
\&    open ARTICLE or die "Can't find article $ARTICLE: $!\en";
\&    while (<ARTICLE>) {...
.Ve
.Vb 1
\&    open(LOG, '>>/usr/spool/news/twitlog'); # (log is reserved)
.Ve
.Vb 1
\&    open(article, "caesar <$article |");    # decrypt article
.Ve
.Vb 1
\&    open(extract, "|sort >/tmp/Tmp$$");     # $$ is our process id
.Ve
.Vb 1
\&    # process argument list of files along with any includes
.Ve
.Vb 3
\&    foreach $file (@ARGV) {
\&        process($file, 'fh00');
\&    }
.Ve
.Vb 7
\&    sub process {
\&        local($filename, $input) = @_;
\&        $input++;               # this is a string increment
\&        unless (open($input, $filename)) {
\&            print STDERR "Can't open $filename: $!\en";
\&            return;
\&        }
.Ve
.Vb 8
\&        while (<$input>) {              # note use of indirection
\&            if (/^#include "(.*)"/) {
\&                process($1, $input);
\&                next;
\&            }
\&            ...         # whatever
\&        }
\&    }
.Ve
You may also, in the Bourne shell tradition, specify an \s-1EXPR\s0 beginning
with \*(L">&\*(R", in which case the rest of the string is interpreted as the
name of a filehandle (or file descriptor, if numeric) which is to be
duped and opened.  You may use & after >, >>, <, +>, +>> and +<.  The
mode you specify should match the mode of the original filehandle.
Here is a script that saves, redirects, and restores \s-1STDOUT\s0 and
\s-1STDERR\s0:
.Sp
.Vb 3
\&    #!/usr/bin/perl
\&    open(SAVEOUT, ">&STDOUT");
\&    open(SAVEERR, ">&STDERR");
.Ve
.Vb 2
\&    open(STDOUT, ">foo.out") || die "Can't redirect stdout";
\&    open(STDERR, ">&STDOUT") || die "Can't dup stdout";
.Ve
.Vb 2
\&    select(STDERR); $| = 1;     # make unbuffered
\&    select(STDOUT); $| = 1;     # make unbuffered
.Ve
.Vb 2
\&    print STDOUT "stdout 1\en";  # this works for
\&    print STDERR "stderr 1\en";  # subprocesses too
.Ve
.Vb 2
\&    close(STDOUT);
\&    close(STDERR);
.Ve
.Vb 2
\&    open(STDOUT, ">&SAVEOUT");
\&    open(STDERR, ">&SAVEERR");
.Ve
.Vb 2
\&    print STDOUT "stdout 2\en";
\&    print STDERR "stderr 2\en";
.Ve
If you specify \*(L"<&=N\*(R", where N is a number, then Perl will do an
equivalent of C's \fIfdopen()\fR of that file descriptor.  For example:
.Sp
.Vb 1
\&    open(FILEHANDLE, "<&=$fd")
.Ve
If you open a pipe on the command \*(L"\-\*(R", i.e. either \*(L"|\-\*(R" or \*(L"\-|\*(R", then
there is an implicit fork done, and the return value of open is the pid
of the child within the parent process, and 0 within the child
process.  (Use \fIdefined\fR\|(\f(CW$pid\fR) to determine whether the open was successful.)
The filehandle behaves normally for the parent, but i/o to that
filehandle is piped from/to the \s-1STDOUT/STDIN\s0 of the child process.
In the child process the filehandle isn't opened\*(--i/o happens from/to
the new \s-1STDOUT\s0 or \s-1STDIN\s0.  Typically this is used like the normal
piped open when you want to exercise more control over just how the
pipe command gets executed, such as when you are running setuid, and
don't want to have to scan shell commands for metacharacters.  The
following pairs are more or less equivalent:
.Sp
.Vb 2
\&    open(FOO, "|tr '[a-z]' '[A-Z]'");
\&    open(FOO, "|-") || exec 'tr', '[a-z]', '[A-Z]';
.Ve
.Vb 2
\&    open(FOO, "cat -n '$file'|");
\&    open(FOO, "-|") || exec 'cat', '-n', $file;
.Ve
Explicitly closing any piped filehandle causes the parent process to
wait for the child to finish, and returns the status value in $?.
Note: on any operation which may do a fork, unflushed buffers remain
unflushed in both processes, which means you may need to set $| to
avoid duplicate output.
.Sp
The filename that is passed to open will have leading and trailing
whitespace deleted.  In order to open a file with arbitrary weird
characters in it, it's necessary to protect any leading and trailing
whitespace thusly:
.Sp
.Vb 2
\&        $file =~ s#^(\es)#./$1#;
\&        open(FOO, "< $file\e0");
.Ve
.Ip "opendir \s-1DIRHANDLE\s0,\s-1EXPR\s0" 8
Opens a directory named \s-1EXPR\s0 for processing by \fIreaddir()\fR, \fItelldir()\fR,
\fIseekdir()\fR, \fIrewinddir()\fR and \fIclosedir()\fR.  Returns \s-1TRUE\s0 if successful.
DIRHANDLEs have their own namespace separate from FILEHANDLEs.
.Ip "ord \s-1EXPR\s0" 8
Returns the numeric ascii value of the first character of \s-1EXPR\s0.  If
\s-1EXPR\s0 is omitted, uses \f(CW$_\fR.
.Ip "pack \s-1TEMPLATE\s0,\s-1LIST\s0" 8
Takes an array or list of values and packs it into a binary structure,
returning the string containing the structure.  The \s-1TEMPLATE\s0 is a
sequence of characters that give the order and type of values, as
follows:
.Sp
.Vb 6
\&    A   An ascii string, will be space padded.
\&    a   An ascii string, will be null padded.
\&    b   A bit string (ascending bit order, like vec()).
\&    B   A bit string (descending bit order).
\&    h   A hex string (low nybble first).
\&    H   A hex string (high nybble first).
.Ve
.Vb 8
\&    c   A signed char value.
\&    C   An unsigned char value.
\&    s   A signed short value.
\&    S   An unsigned short value.
\&    i   A signed integer value.
\&    I   An unsigned integer value.
\&    l   A signed long value.
\&    L   An unsigned long value.
.Ve
.Vb 4
\&    n   A short in "network" order.
\&    N   A long in "network" order.
\&    v   A short in "VAX" (little-endian) order.
\&    V   A long in "VAX" (little-endian) order.
.Ve
.Vb 2
\&    f   A single-precision float in the native format.
\&    d   A double-precision float in the native format.
.Ve
.Vb 2
\&    p   A pointer to a null-terminated string.
\&    P   A pointer to a structure (fixed-length string).
.Ve
.Vb 1
\&    u   A uuencoded string.
.Ve
.Vb 3
\&    x   A null byte.
\&    X   Back up a byte.
\&    @   Null fill to absolute position.
.Ve
Each letter may optionally be followed by a number which gives a repeat
count.  With all types except \*(L"a\*(R", \*(L"A\*(R", \*(L"b\*(R", \*(L"B\*(R", \*(L"h\*(R" and \*(L"H\*(R", and \*(L"P\*(R" the
pack function will gobble up that many values from the \s-1LIST\s0.  A * for the
repeat count means to use however many items are left.  The \*(L"a\*(R" and \*(L"A\*(R"
types gobble just one value, but pack it as a string of length count,
padding with nulls or spaces as necessary.  (When unpacking, \*(L"A\*(R" strips
trailing spaces and nulls, but \*(L"a\*(R" does not.)  Likewise, the \*(L"b\*(R" and \*(L"B\*(R"
fields pack a string that many bits long.  The \*(L"h\*(R" and \*(L"H\*(R" fields pack a
string that many nybbles long.  The \*(L"P\*(R" packs a pointer to a structure of
the size indicated by the length.  Real numbers (floats and doubles) are
in the native machine format only; due to the multiplicity of floating
formats around, and the lack of a standard \*(L"network\*(R" representation, no
facility for interchange has been made.  This means that packed floating
point data written on one machine may not be readable on another \- even if
both use \s-1IEEE\s0 floating point arithmetic (as the endian-ness of the memory
representation is not part of the \s-1IEEE\s0 spec).  Note that Perl uses doubles
internally for all numeric calculation, and converting from double into
float and thence back to double again will lose precision (i.e.
\f(CWunpack("f", pack("f", $foo)\fR) will not in general equal \f(CW$foo\fR).
.Sp
Examples:
.Sp
.Vb 4
\&    $foo = pack("cccc",65,66,67,68);
\&    # foo eq "ABCD"
\&    $foo = pack("c4",65,66,67,68);
\&    # same thing
.Ve
.Vb 2
\&    $foo = pack("ccxxcc",65,66,67,68);
\&    # foo eq "AB\e0\e0CD"
.Ve
.Vb 3
\&    $foo = pack("s2",1,2);
\&    # "\e1\e0\e2\e0" on little-endian
\&    # "\e0\e1\e0\e2" on big-endian
.Ve
.Vb 2
\&    $foo = pack("a4","abcd","x","y","z");
\&    # "abcd"
.Ve
.Vb 2
\&    $foo = pack("aaaa","abcd","x","y","z");
\&    # "axyz"
.Ve
.Vb 2
\&    $foo = pack("a14","abcdefg");
\&    # "abcdefg\e0\e0\e0\e0\e0\e0\e0"
.Ve
.Vb 2
\&    $foo = pack("i9pl", gmtime);
\&    # a real struct tm (on my system anyway)
.Ve
.Vb 3
\&    sub bintodec {
\&        unpack("N", pack("B32", substr("0" x 32 . shift, -32)));
\&    }
.Ve
The same template may generally also be used in the unpack function.
.Ip "pipe \s-1READHANDLE\s0,\s-1WRITEHANDLE\s0" 8
Opens a pair of connected pipes like the corresponding system call.
Note that if you set up a loop of piped processes, deadlock can occur
unless you are very careful.  In addition, note that Perl's pipes use
stdio buffering, so you may need to set $| to flush your \s-1WRITEHANDLE\s0
after each command, depending on the application.
.Ip "pop \s-1ARRAY\s0" 8
Pops and returns the last value of the array, shortening the array by
1.  Has a similar effect to
.Sp
.Vb 1
\&    $tmp = $ARRAY[$#ARRAY--];
.Ve
If there are no elements in the array, returns the undefined value.
.Ip "pos \s-1SCALAR\s0" 8
Returns the offset of where the last m//g search left off for the variable
in question.  May be modified to change that offset.
.Ip "print \s-1FILEHANDLE\s0 \s-1LIST\s0" 8
.Ip "print \s-1LIST\s0" 8
.Ip "print" 8
Prints a string or a comma-separated list of strings.  Returns non-zero
if successful.  \s-1FILEHANDLE\s0 may be a scalar variable name, in which case
the variable contains the name of the filehandle, thus introducing one
level of indirection.  (\s-1NOTE\s0: If \s-1FILEHANDLE\s0 is a variable and the next
token is a term, it may be misinterpreted as an operator unless you
interpose a + or put parens around the arguments.)  If \s-1FILEHANDLE\s0 is
omitted, prints by default to standard output (or to the last selected
output channel\*(--see \fIselect()\fR).  If \s-1LIST\s0 is also omitted, prints \f(CW$_\fR to
\s-1STDOUT\s0.  To set the default output channel to something other than
\s-1STDOUT\s0 use the select operation.  Note that, because print takes a
\s-1LIST\s0, anything in the \s-1LIST\s0 is evaluated in a list context, and any
subroutine that you call will have one or more of its expressions
evaluated in a list context.  Also be careful not to follow the print
keyword with a left parenthesis unless you want the corresponding right
parenthesis to terminate the arguments to the print\*(--interpose a + or
put parens around all the arguments.
.Ip "printf \s-1FILEHANDLE\s0 \s-1LIST\s0" 8
.Ip "printf \s-1LIST\s0" 8
Equivalent to a \*(L"print \s-1FILEHANDLE\s0 \fIsprintf\fR\|(\s-1LIST\s0)\*(R".  The first argument
of the list will be interpreted as the printf format.
.Ip "push \s-1ARRAY\s0,\s-1LIST\s0" 8
Treats \s-1ARRAY\s0 as a stack, and pushes the values of \s-1LIST\s0
onto the end of \s-1ARRAY\s0.  The length of \s-1ARRAY\s0 increases by the length of
\s-1LIST\s0.  Has the same effect as
.Sp
.Vb 3
\&    for $value (LIST) {
\&        $ARRAY[++$#ARRAY] = $value;
\&    }
.Ve
but is more efficient.  Returns the new number of elements in the array.
.Ip "q/\s-1STRING\s0/" 8
.Ip "qq/\s-1STRING\s0/" 8
.Ip "qx/\s-1STRING\s0/" 8
.Ip "qw/\s-1STRING\s0/" 8
Generalized quotes.  See the \fIperlop\fR manpage.
.Ip "quotemeta \s-1EXPR\s0" 8
Returns the value of \s-1EXPR\s0 with with all regular expression
metacharacters backslashed.  This is the internal function implementing
the \eQ escape in double-quoted strings.
.Ip "rand \s-1EXPR\s0" 8
.Ip "rand" 8
Returns a random fractional number between 0 and the value of \s-1EXPR\s0.
(\s-1EXPR\s0 should be positive.)  If \s-1EXPR\s0 is omitted, returns a value between 
0 and 1.  This function produces repeatable sequences unless \fIsrand()\fR 
is invoked.  See also \fIsrand()\fR.
.Sp
(Note: if your rand function consistently returns numbers that are too
large or too small, then your version of Perl was probably compiled
with the wrong number of \s-1RANDBITS\s0.  As a workaround, you can usually
multiply \s-1EXPR\s0 by the correct power of 2 to get the range you want.
This will make your script unportable, however.  It's better to recompile
if you can.)
.Ip "read \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0,\s-1OFFSET\s0" 8
.Ip "read \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0" 8
Attempts to read \s-1LENGTH\s0 bytes of data into variable \s-1SCALAR\s0 from the
specified \s-1FILEHANDLE\s0.  Returns the number of bytes actually read, or
undef if there was an error.  \s-1SCALAR\s0 will be grown or shrunk to the
length actually read.  An \s-1OFFSET\s0 may be specified to place the read
data at some other place than the beginning of the string.  This call
is actually implemented in terms of stdio's fread call.  To get a true
read system call, see \fIsysread()\fR.
.Ip "readdir \s-1DIRHANDLE\s0" 8
Returns the next directory entry for a directory opened by \fIopendir()\fR.
If used in a list context, returns all the rest of the entries in the
directory.  If there are no more entries, returns an undefined value in
a scalar context or a null list in a list context.
.Ip "readlink \s-1EXPR\s0" 8
Returns the value of a symbolic link, if symbolic links are
implemented.  If not, gives a fatal error.  If there is some system
error, returns the undefined value and sets $! (errno).  If \s-1EXPR\s0 is
omitted, uses \f(CW$_\fR.
.Ip "recv \s-1SOCKET\s0,\s-1SCALAR\s0,\s-1LEN\s0,\s-1FLAGS\s0" 8
Receives a message on a socket.  Attempts to receive \s-1LENGTH\s0 bytes of
data into variable \s-1SCALAR\s0 from the specified \s-1SOCKET\s0 filehandle.
Actually does a C \fIrecvfrom()\fR, so that it can returns the address of the
sender.  Returns the undefined value if there's an error.  \s-1SCALAR\s0 will
be grown or shrunk to the length actually read.  Takes the same flags
as the system call of the same name.
.Ip "redo \s-1LABEL\s0" 8
.Ip "redo" 8
The \f(CWredo\fR command restarts the loop block without evaluating the
conditional again.  The \f(CWcontinue\fR block, if any, is not executed.  If
the \s-1LABEL\s0 is omitted, the command refers to the innermost enclosing
loop.  This command is normally used by programs that want to lie to
themselves about what was just input:
.Sp
.Vb 16
\&    # a simpleminded Pascal comment stripper
\&    # (warning: assumes no { or } in strings)
\&    line: while (<STDIN>) {
\&        while (s|({.*}.*){.*}|$1 |) {}
\&        s|{.*}| |;
\&        if (s|{.*| |) {
\&            $front = $_;
\&            while (<STDIN>) {
\&                if (/}/) {      # end of comment?
\&                    s|^|$front{|;
\&                    redo line;
\&                }
\&            }
\&        }
\&        print;
\&    }
.Ve
.Ip "ref \s-1EXPR\s0" 8
Returns a \s-1TRUE\s0 value if \s-1EXPR\s0 is a reference, \s-1FALSE\s0 otherwise.  The value
returned depends on the type of thing the reference is a reference to.
Builtin types include:
.Sp
.Vb 6
\&    REF
\&    SCALAR
\&    ARRAY
\&    HASH
\&    CODE
\&    GLOB
.Ve
If the referenced object has been blessed into a package, then that package 
name is returned instead.  You can think of \fIref()\fR as a \fItypeof()\fR operator.
.Sp
.Vb 6
\&    if (ref($r) eq "HASH") {
\&        print "r is a reference to an associative array.\en";
\&    } 
\&    if (!ref ($r) {
\&        print "r is not a reference at all.\en";
\&    } 
.Ve
See also the \fIperlref\fR manpage.
.Ip "rename \s-1OLDNAME\s0,\s-1NEWNAME\s0" 8
Changes the name of a file.  Returns 1 for success, 0 otherwise.  Will
not work across filesystem boundaries.
.Ip "require \s-1EXPR\s0" 8
.Ip "require" 8
Demands some semantics specified by \s-1EXPR\s0, or by \f(CW$_\fR if \s-1EXPR\s0 is not
supplied.  If \s-1EXPR\s0 is numeric, demands that the current version of Perl
($] or \f(CW$PERL_VERSION\fR) be equal or greater than \s-1EXPR\s0.
.Sp
Otherwise, demands that a library file be included if it hasn't already
been included.  The file is included via the do-\s-1FILE\s0 mechanism, which is
essentially just a variety of \fIeval()\fR.  Has semantics similar to the following
subroutine:
.Sp
.Vb 19
\&    sub require {
\&        local($filename) = @_;
\&        return 1 if $INC{$filename};
\&        local($realfilename,$result);
\&        ITER: {
\&            foreach $prefix (@INC) {
\&                $realfilename = "$prefix/$filename";
\&                if (-f $realfilename) {
\&                    $result = do $realfilename;
\&                    last ITER;
\&                }
\&            }
\&            die "Can't find $filename in \e@INC";
\&        }
\&        die $@ if $@;
\&        die "$filename did not return true value" unless $result;
\&        $INC{$filename} = $realfilename;
\&        $result;
\&    }
.Ve
Note that the file will not be included twice under the same specified
name.  The file must return \s-1TRUE\s0 as the last statement to indicate
successful execution of any initialization code, so it's customary to
end such a file with \*(L"1;\*(R" unless you're sure it'll return \s-1TRUE\s0
otherwise.  But it's better just to put the \*(L"\f(CW1;\fR\*(R", in case you add more
statements.
.Sp
If \s-1EXPR\s0 is a bare word, the require assumes a \*(L"\fI.pm\fR\*(R" extension for you,
to make it easy to load standard modules.  This form of loading of 
modules does not risk altering your namespace.
.Sp
For a yet more powerful import facility, see the the \f(CWuse()\fR entry elsewhere in this documentbelow, and 
also the \fIperlmod\fR manpage.
.Ip "reset \s-1EXPR\s0" 8
.Ip "reset" 8
Generally used in a \f(CWcontinue\fR block at the end of a loop to clear
variables and reset ?? searches so that they work again.  The
expression is interpreted as a list of single characters (hyphens
allowed for ranges).  All variables and arrays beginning with one of
those letters are reset to their pristine state.  If the expression is
omitted, one-match searches (?pattern?) are reset to match again.  Only
resets variables or searches in the current package.  Always returns
1.  Examples:
.Sp
.Vb 3
\&    reset 'X';          # reset all X variables
\&    reset 'a-z';        # reset lower case variables
\&    reset;              # just reset ?? searches
.Ve
Resetting \*(L"A\-Z\*(R" is not recommended since you'll wipe out your
\s-1ARGV\s0 and \s-1ENV\s0 arrays.  Only resets package variables\*(--lexical variables
are unaffected, but they clean themselves up on scope exit anyway,
so anymore you probably want to use them instead.  See the \f(CWmy\fR entry elsewhere in this document.
.Ip "return \s-1LIST\s0" 8
Returns from a subroutine or eval with the value specified.  (Note that
in the absence of a return a subroutine or eval will automatically
return the value of the last expression evaluated.)
.Ip "reverse \s-1LIST\s0" 8
In a list context, returns a list value consisting of the elements
of \s-1LIST\s0 in the opposite order.  In a scalar context, returns a string
value consisting of the bytes of the first element of \s-1LIST\s0 in the
opposite order.
.Ip "rewinddir \s-1DIRHANDLE\s0" 8
Sets the current position to the beginning of the directory for the
\fIreaddir()\fR routine on \s-1DIRHANDLE\s0.
.Ip "rindex \s-1STR\s0,\s-1SUBSTR\s0,\s-1POSITION\s0" 8
.Ip "rindex \s-1STR\s0,\s-1SUBSTR\s0" 8
Works just like index except that it returns the position of the \s-1LAST\s0
occurrence of \s-1SUBSTR\s0 in \s-1STR\s0.  If \s-1POSITION\s0 is specified, returns the
last occurrence at or before that position.
.Ip "rmdir \s-1FILENAME\s0" 8
Deletes the directory specified by \s-1FILENAME\s0 if it is empty.  If it
succeeds it returns 1, otherwise it returns 0 and sets $! (errno).  If
\s-1FILENAME\s0 is omitted, uses \f(CW$_\fR.
.Ip "s///" 8
The substitution operator.  See the \fIperlop\fR manpage.
.Ip "scalar \s-1EXPR\s0" 8
Forces \s-1EXPR\s0 to be interpreted in a scalar context and returns the value
of \s-1EXPR\s0.
.Ip "seek \s-1FILEHANDLE\s0,\s-1POSITION\s0,\s-1WHENCE\s0" 8
Randomly positions the file pointer for \s-1FILEHANDLE\s0, just like the \fIfseek()\fR
call of stdio.  \s-1FILEHANDLE\s0 may be an expression whose value gives the name
of the filehandle.  The values for \s-1WHENCE\s0 are 0 to set the file pointer to
\s-1POSITION\s0, 1 to set the it to current plus \s-1POSITION\s0, and 2 to set it to \s-1EOF\s0
plus offset.  You may use the values \s-1SEEK_SET\s0, \s-1SEEK_CUR\s0, and \s-1SEEK_END\s0 for
this is usin the \s-1POSIX\s0 module.  Returns 1 upon success, 0 otherwise.
.Ip "seekdir \s-1DIRHANDLE\s0,\s-1POS\s0" 8
Sets the current position for the \fIreaddir()\fR routine on \s-1DIRHANDLE\s0.  \s-1POS\s0
must be a value returned by \fItelldir()\fR.  Has the same caveats about
possible directory compaction as the corresponding system library
routine.
.Ip "select \s-1FILEHANDLE\s0" 8
.Ip "select" 8
Returns the currently selected filehandle.  Sets the current default
filehandle for output, if \s-1FILEHANDLE\s0 is supplied.  This has two
effects: first, a \f(CWwrite\fR or a \f(CWprint\fR without a filehandle will
default to this \s-1FILEHANDLE\s0.  Second, references to variables related to
output will refer to this output channel.  For example, if you have to
set the top of form format for more than one output channel, you might
do the following:
.Sp
.Vb 4
\&    select(REPORT1);
\&    $^ = 'report1_top';
\&    select(REPORT2);
\&    $^ = 'report2_top';
.Ve
\s-1FILEHANDLE\s0 may be an expression whose value gives the name of the
actual filehandle.  Thus:
.Sp
.Vb 1
\&    $oldfh = select(STDERR); $| = 1; select($oldfh);
.Ve
With Perl 5, filehandles are objects with methods, and the last example
is preferably written
.Sp
.Vb 2
\&    use FileHandle;
\&    STDERR->autoflush(1);
.Ve
.Ip "select \s-1RBITS\s0,\s-1WBITS\s0,\s-1EBITS\s0,\s-1TIMEOUT\s0" 8
This calls the select \fIsystem\fR\|(2) call with the bitmasks specified, which
can be constructed using \fIfileno()\fR and \fIvec()\fR, along these lines:
.Sp
.Vb 4
\&    $rin = $win = $ein = '';
\&    vec($rin,fileno(STDIN),1) = 1;
\&    vec($win,fileno(STDOUT),1) = 1;
\&    $ein = $rin | $win;
.Ve
If you want to select on many filehandles you might wish to write a
subroutine:
.Sp
.Vb 9
\&    sub fhbits {
\&        local(@fhlist) = split(' ',$_[0]);
\&        local($bits);
\&        for (@fhlist) {
\&            vec($bits,fileno($_),1) = 1;
\&        }
\&        $bits;
\&    }
\&    $rin = &fhbits('STDIN TTY SOCK');
.Ve
The usual idiom is:
.Sp
.Vb 2
\&    ($nfound,$timeleft) =
\&      select($rout=$rin, $wout=$win, $eout=$ein, $timeout);
.Ve
or to block until something becomes ready:
.Sp
.Vb 1
\&    $nfound = select($rout=$rin, $wout=$win, $eout=$ein, undef);
.Ve
Any of the bitmasks can also be undef.  The timeout, if specified, is
in seconds, which may be fractional.  Note: not all implementations are
capable of returning the \f(CW$timeleft\fR.  If not, they always return
\f(CW$timeleft\fR equal to the supplied \f(CW$timeout\fR.
.Sp
You can effect a 250 microsecond sleep this way:
.Sp
.Vb 1
\&    select(undef, undef, undef, 0.25);
.Ve
.Ip "semctl \s-1ID\s0,\s-1SEMNUM\s0,\s-1CMD\s0,\s-1ARG\s0" 8
Calls the System V \s-1IPC\s0 function semctl.  If \s-1CMD\s0 is &\s-1IPC_STAT\s0 or
&\s-1GETALL\s0, then \s-1ARG\s0 must be a variable which will hold the returned
semid_ds structure or semaphore value array.  Returns like ioctl: the
undefined value for error, \*(L"0 but true\*(R" for zero, or the actual return
value otherwise.
.Ip "semget \s-1KEY\s0,\s-1NSEMS\s0,\s-1FLAGS\s0" 8
Calls the System V \s-1IPC\s0 function semget.  Returns the semaphore id, or
the undefined value if there is an error.
.Ip "semop \s-1KEY\s0,\s-1OPSTRING\s0" 8
Calls the System V \s-1IPC\s0 function semop to perform semaphore operations
such as signaling and waiting.  \s-1OPSTRING\s0 must be a packed array of
semop structures.  Each semop structure can be generated with
\f(CWpack("sss", $semnum, $semop, $semflag)\fR.  The number of semaphore
operations is implied by the length of \s-1OPSTRING\s0.  Returns \s-1TRUE\s0 if
successful, or \s-1FALSE\s0 if there is an error.  As an example, the
following code waits on semaphore \f(CW$semnum\fR of semaphore id \f(CW$semid:\fR
.Sp
.Vb 2
\&    $semop = pack("sss", $semnum, -1, 0);
\&    die "Semaphore trouble: $!\en" unless semop($semid, $semop);
.Ve
To signal the semaphore, replace \*(L"\-1\*(R" with \*(L"1\*(R".
.Ip "send \s-1SOCKET\s0,\s-1MSG\s0,\s-1FLAGS\s0,\s-1TO\s0" 8
.Ip "send \s-1SOCKET\s0,\s-1MSG\s0,\s-1FLAGS\s0" 8
Sends a message on a socket.  Takes the same flags as the system call
of the same name.  On unconnected sockets you must specify a
destination to send \s-1TO\s0, in which case it does a C \fIsendto()\fR.  Returns
the number of characters sent, or the undefined value if there is an
error.
.Ip "setpgrp \s-1PID\s0,\s-1PGRP\s0" 8
Sets the current process group for the specified \s-1PID\s0, 0 for the current
process.  Will produce a fatal error if used on a machine that doesn't
implement \fIsetpgrp\fR\|(2).
.Ip "setpriority \s-1WHICH\s0,\s-1WHO\s0,\s-1PRIORITY\s0" 8
Sets the current priority for a process, a process group, or a user.
(See \fILsetpriority\fR\|(2)>.)  Will produce a fatal error if used on a machine
that doesn't implement \fIsetpriority\fR\|(2).
.Ip "setsockopt \s-1SOCKET\s0,\s-1LEVEL\s0,\s-1OPTNAME\s0,\s-1OPTVAL\s0" 8
Sets the socket option requested.  Returns undefined if there is an
error.  \s-1OPTVAL\s0 may be specified as undef if you don't want to pass an
argument.
.Ip "shift \s-1ARRAY\s0" 8
.Ip "shift" 8
Shifts the first value of the array off and returns it, shortening the
array by 1 and moving everything down.  If there are no elements in the
array, returns the undefined value.  If \s-1ARRAY\s0 is omitted, shifts the
\f(CW@ARGV\fR array in the main program, and the \f(CW@_\fR array in subroutines.
(This is determined lexically.)  See also \fIunshift()\fR, \fIpush()\fR, and \fIpop()\fR.
\fIShift()\fR and \fIunshift()\fR do the same thing to the left end of an array
that \fIpush()\fR and \fIpop()\fR do to the right end.
.Ip "shmctl \s-1ID\s0,\s-1CMD\s0,\s-1ARG\s0" 8
Calls the System V \s-1IPC\s0 function shmctl.  If \s-1CMD\s0 is &\s-1IPC_STAT\s0, then \s-1ARG\s0
must be a variable which will hold the returned shmid_ds structure.
Returns like ioctl: the undefined value for error, \*(L"0 but true\*(R" for
zero, or the actual return value otherwise.
.Ip "shmget \s-1KEY\s0,\s-1SIZE\s0,\s-1FLAGS\s0" 8
Calls the System V \s-1IPC\s0 function shmget.  Returns the shared memory
segment id, or the undefined value if there is an error.
.Ip "shmread \s-1ID\s0,\s-1VAR\s0,\s-1POS\s0,\s-1SIZE\s0" 8
.Ip "shmwrite \s-1ID\s0,\s-1STRING\s0,\s-1POS\s0,\s-1SIZE\s0" 8
Reads or writes the System V shared memory segment \s-1ID\s0 starting at
position \s-1POS\s0 for size \s-1SIZE\s0 by attaching to it, copying in/out, and
detaching from it.  When reading, \s-1VAR\s0 must be a variable which will
hold the data read.  When writing, if \s-1STRING\s0 is too long, only \s-1SIZE\s0
bytes are used; if \s-1STRING\s0 is too short, nulls are written to fill out
\s-1SIZE\s0 bytes.  Return \s-1TRUE\s0 if successful, or \s-1FALSE\s0 if there is an error.
.Ip "shutdown \s-1SOCKET\s0,\s-1HOW\s0" 8
Shuts down a socket connection in the manner indicated by \s-1HOW\s0, which
has the same interpretation as in the system call of the same name.
.Ip "sin \s-1EXPR\s0" 8
Returns the sine of \s-1EXPR\s0 (expressed in radians).  If \s-1EXPR\s0 is omitted,
returns sine of \f(CW$_\fR.
.Ip "sleep \s-1EXPR\s0" 8
.Ip "sleep" 8
Causes the script to sleep for \s-1EXPR\s0 seconds, or forever if no \s-1EXPR\s0.
May be interrupted by sending the process a \s-1SIGALRM\s0.  Returns the
number of seconds actually slept.  You probably cannot mix \fIalarm()\fR and
\fIsleep()\fR calls, since \fIsleep()\fR is often implemented using \fIalarm()\fR.
.Sp
On some older systems, it may sleep up to a full second less than what
you requested, depending on how it counts seconds.  Most modern systems
always sleep the full amount.
.Ip "socket \s-1SOCKET\s0,\s-1DOMAIN\s0,\s-1TYPE\s0,\s-1PROTOCOL\s0" 8
Opens a socket of the specified kind and attaches it to filehandle
\s-1SOCKET\s0.  \s-1DOMAIN\s0, \s-1TYPE\s0 and \s-1PROTOCOL\s0 are specified the same as for the
system call of the same name.  You should \*(L"use Socket;\*(R" first to get
the proper definitions imported.  See the example in the \fIperlipc\fR manpage.
.Ip "socketpair \s-1SOCKET1\s0,\s-1SOCKET2\s0,\s-1DOMAIN\s0,\s-1TYPE\s0,\s-1PROTOCOL\s0" 8
Creates an unnamed pair of sockets in the specified domain, of the
specified type.  \s-1DOMAIN\s0, \s-1TYPE\s0 and \s-1PROTOCOL\s0 are specified the same as
for the system call of the same name.  If unimplemented, yields a fatal
error.  Returns \s-1TRUE\s0 if successful.
.Ip "sort \s-1SUBNAME\s0 \s-1LIST\s0" 8
.Ip "sort \s-1BLOCK\s0 \s-1LIST\s0" 8
.Ip "sort \s-1LIST\s0" 8
Sorts the \s-1LIST\s0 and returns the sorted list value.  Nonexistent values
of arrays are stripped out.  If \s-1SUBNAME\s0 or \s-1BLOCK\s0 is omitted, sorts
in standard string comparison order.  If \s-1SUBNAME\s0 is specified, it
gives the name of a subroutine that returns an integer less than, equal
to, or greater than 0, depending on how the elements of the array are
to be ordered.  (The <=> and cmp operators are extremely useful in such
routines.)  \s-1SUBNAME\s0 may be a scalar variable name, in which case the
value provides the name of the subroutine to use.  In place of a
\s-1SUBNAME\s0, you can provide a \s-1BLOCK\s0 as an anonymous, in-line sort
subroutine.
.Sp
In the interests of efficiency the normal calling code for subroutines
is bypassed, with the following effects: the subroutine may not be a
recursive subroutine, and the two elements to be compared are passed
into the subroutine not via \f(CW@_\fR but as \f(CW$a\fR and \f(CW$b\fR (see example below).
They are passed by reference, so don't modify \f(CW$a\fR and \f(CW$b\fR.
.Sp
Examples:
.Sp
.Vb 2
\&    # sort lexically
\&    @articles = sort @files;
.Ve
.Vb 2
\&    # same thing, but with explicit sort routine
\&    @articles = sort {$a cmp $b} @files;
.Ve
.Vb 2
\&    # same thing in reversed order
\&    @articles = sort {$b cmp $a} @files;
.Ve
.Vb 2
\&    # sort numerically ascending
\&    @articles = sort {$a <=> $b} @files;
.Ve
.Vb 2
\&    # sort numerically descending
\&    @articles = sort {$b <=> $a} @files;
.Ve
.Vb 5
\&    # sort using explicit subroutine name
\&    sub byage {
\&        $age{$a} <=> $age{$b};  # presuming integers
\&    }
\&    @sortedclass = sort byage @class;
.Ve
.Vb 9
\&    sub backwards { $b cmp $a; }
\&    @harry = ('dog','cat','x','Cain','Abel');
\&    @george = ('gone','chased','yz','Punished','Axed');
\&    print sort @harry;
\&            # prints AbelCaincatdogx
\&    print sort backwards @harry;
\&            # prints xdogcatCainAbel
\&    print sort @george, 'to', @harry;
\&            # prints AbelAxedCainPunishedcatchaseddoggonetoxyz
.Ve
.Ip "splice \s-1ARRAY\s0,\s-1OFFSET\s0,\s-1LENGTH\s0,\s-1LIST\s0" 8
.Ip "splice \s-1ARRAY\s0,\s-1OFFSET\s0,\s-1LENGTH\s0" 8
.Ip "splice \s-1ARRAY\s0,\s-1OFFSET\s0" 8
Removes the elements designated by \s-1OFFSET\s0 and \s-1LENGTH\s0 from an array, and
replaces them with the elements of \s-1LIST\s0, if any.  Returns the elements
removed from the array.  The array grows or shrinks as necessary.  If
\s-1LENGTH\s0 is omitted, removes everything from \s-1OFFSET\s0 onward.  The
following equivalencies hold (assuming $[ == 0):
.Sp
.Vb 5
\&    push(@a,$x,$y)      splice(@a,$#a+1,0,$x,$y)
\&    pop(@a)             splice(@a,-1)
\&    shift(@a)           splice(@a,0,1)
\&    unshift(@a,$x,$y)   splice(@a,0,0,$x,$y)
\&    $a[$x] = $y         splice(@a,$x,1,$y);
.Ve
Example, assuming array lengths are passed before arrays:
.Sp
.Vb 10
\&    sub aeq {   # compare two list values
\&        local(@a) = splice(@_,0,shift);
\&        local(@b) = splice(@_,0,shift);
\&        return 0 unless @a == @b;       # same len?
\&        while (@a) {
\&            return 0 if pop(@a) ne pop(@b);
\&        }
\&        return 1;
\&    }
\&    if (&aeq($len,@foo[1..$len],0+@bar,@bar)) { ... }
.Ve
.Ip "split /\s-1PATTERN\s0/,\s-1EXPR\s0,\s-1LIMIT\s0" 8
.Ip "split /\s-1PATTERN\s0/,\s-1EXPR\s0" 8
.Ip "split /\s-1PATTERN\s0/" 8
.Ip "split" 8
Splits a string into an array of strings, and returns it.
.Sp
If not in a list context, returns the number of fields found and splits into
the \f(CW@_\fR array.  (In a list context, you can force the split into \f(CW@_\fR by
using \f(CW??\fR as the pattern delimiters, but it still returns the array
value.)  The use of implicit split to \f(CW@_\fR is deprecated, however.
.Sp
If \s-1EXPR\s0 is omitted, splits the \f(CW$_\fR string.  If \s-1PATTERN\s0 is also omitted,
splits on whitespace (\f(CW/[ \et\en]+/\fR).  Anything matching \s-1PATTERN\s0 is taken
to be a delimiter separating the fields.  (Note that the delimiter may
be longer than one character.)  If \s-1LIMIT\s0 is specified and is not
negative, splits into no more than that many fields (though it may
split into fewer).  If \s-1LIMIT\s0 is unspecified, trailing null fields are
stripped (which potential users of \fIpop()\fR would do well to remember).
If \s-1LIMIT\s0 is negative, it is treated as if an arbitrarily large \s-1LIMIT\s0
had been specified.
.Sp
A pattern matching the null string (not to be confused with
a null pattern C<//., which is just one member of the set of patterns
matching a null string) will split the value of \s-1EXPR\s0 into separate
characters at each point it matches that way.  For example:
.Sp
.Vb 1
\&    print join(':', split(/ */, 'hi there'));
.Ve
produces the output \*(L'h:i:t:h:e:r:e\*(R'.
.Sp
The \s-1LIMIT\s0 parameter can be used to partially split a line
.Sp
.Vb 1
\&    ($login, $passwd, $remainder) = split(/:/, $_, 3);
.Ve
When assigning to a list, if \s-1LIMIT\s0 is omitted, Perl supplies a \s-1LIMIT\s0
one larger than the number of variables in the list, to avoid
unnecessary work.  For the list above \s-1LIMIT\s0 would have been 4 by
default.  In time critical applications it behooves you not to split
into more fields than you really need.
.Sp
If the \s-1PATTERN\s0 contains parentheses, additional array elements are
created from each matching substring in the delimiter.
.Sp
.Vb 1
\&    split(/([,-])/, "1-10,20");
.Ve
produces the list value
.Sp
.Vb 1
\&    (1, '-', 10, ',', 20)
.Ve
The pattern \f(CW/PATTERN/\fR may be replaced with an expression to specify
patterns that vary at runtime.  (To do runtime compilation only once,
use \f(CW/$variable/o\fR.)  As a special case, specifying a space (\*(R'\ \*(L') will
split on white space just as split with no arguments does, but leading
white space does \fI\s-1NOT\s0\fR produce a null first field.  Thus, split(' \*(L') can
be used to emulate \fBawk\fR's default behavior, whereas \f(CWsplit(/ /)\fR will
give you as many null initial fields as there are leading spaces.
.Sp
Example:
.Sp
.Vb 5
\&    open(passwd, '/etc/passwd');
\&    while (<passwd>) {
\&        ($login, $passwd, $uid, $gid, $gcos, $home, $shell) = split(/:/);
\&        ...
\&    }
.Ve
(Note that \f(CW$shell\fR above will still have a newline on it.  See the \f(CWchop\fR, \f(CWchomp\fR,  and \f(CWjoin\fR entries elsewhere in this document.)
.Ip "sprintf \s-1FORMAT\s0,\s-1LIST\s0" 8
Returns a string formatted by the usual printf conventions of the C
language.  (The * character for an indirectly specified length is not
supported, but you can get the same effect by interpolating a variable
into the pattern.)
.Ip "sqrt \s-1EXPR\s0" 8
Return the square root of \s-1EXPR\s0.  If \s-1EXPR\s0 is omitted, returns square
root of \f(CW$_\fR.
.Ip "srand \s-1EXPR\s0" 8
Sets the random number seed for the \f(CWrand\fR operator.  If \s-1EXPR\s0 is
omitted, does \f(CWsrand(time)\fR.  Of course, you'd need something much more
random than that for cryptographic purposes, since it's easy to guess
the current time.  Checksumming the compressed output of rapidly
changing operating system status programs is the usual method.
Examples are posted regularly to comp.security.unix.
.Ip "stat \s-1FILEHANDLE\s0" 8
.Ip "stat \s-1EXPR\s0" 8
Returns a 13-element array giving the status info for a file, either the
file opened via \s-1FILEHANDLE\s0, or named by \s-1EXPR\s0.  Returns a null list if
the stat fails.  Typically used as follows:
.Sp
.Vb 3
\&    ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
\&       $atime,$mtime,$ctime,$blksize,$blocks)
\&           = stat($filename);
.Ve
If stat is passed the special filehandle consisting of an underline, no
stat is done, but the current contents of the stat structure from the
last stat or filetest are returned.  Example:
.Sp
.Vb 3
\&    if (-x $file && (($d) = stat(_)) && $d < 0) {
\&        print "$file is executable NFS file\en";
\&    }
.Ve
(This only works on machines for which the device number is negative under \s-1NFS\s0.)
.Ip "study \s-1SCALAR\s0" 8
.Ip "study" 8
Takes extra time to study \s-1SCALAR\s0 (\f(CW$_\fR if unspecified) in anticipation of
doing many pattern matches on the string before it is next modified.
This may or may not save time, depending on the nature and number of
patterns you are searching on, and on the distribution of character
frequencies in the string to be searched\*(--you probably want to compare
runtimes with and without it to see which runs faster.  Those loops
which scan for many short constant strings (including the constant
parts of more complex patterns) will benefit most.  You may have only
one study active at a time\*(--if you study a different scalar the first
is \*(L"unstudied\*(R".  (The way study works is this: a linked list of every
character in the string to be searched is made, so we know, for
example, where all the \*(L'k\*(R' characters are.  From each search string,
the rarest character is selected, based on some static frequency tables
constructed from some C programs and English text.  Only those places
that contain this \*(L"rarest\*(R" character are examined.)
.Sp
For example, here is a loop which inserts index producing entries
before any line containing a certain pattern:
.Sp
.Vb 8
\&    while (<>) {
\&        study;
\&        print ".IX foo\en" if /\ebfoo\eb/;
\&        print ".IX bar\en" if /\ebbar\eb/;
\&        print ".IX blurfl\en" if /\ebblurfl\eb/;
\&        ...
\&        print;
\&    }
.Ve
In searching for /\ebfoo\eb/, only those locations in \f(CW$_\fR that contain \*(L"f\*(R"
will be looked at, because \*(L"f\*(R" is rarer than \*(L"o\*(R".  In general, this is
a big win except in pathological cases.  The only question is whether
it saves you more time than it took to build the linked list in the
first place.
.Sp
Note that if you have to look for strings that you don't know till
runtime, you can build an entire loop as a string and eval that to
avoid recompiling all your patterns all the time.  Together with
undefining $/ to input entire files as one record, this can be very
fast, often faster than specialized programs like \fIfgrep\fR\|(1).  The following
scans a list of files (\f(CW@files\fR) for a list of words (\f(CW@words\fR), and prints
out the names of those files that contain a match:
.Sp
.Vb 12
\&    $search = 'while (<>) { study;';
\&    foreach $word (@words) {
\&        $search .= "++\e$seen{\e$ARGV} if /\e\eb$word\e\eb/;\en";
\&    }
\&    $search .= "}";
\&    @ARGV = @files;
\&    undef $/;
\&    eval $search;               # this screams
\&    $/ = "\en";          # put back to normal input delim
\&    foreach $file (sort keys(%seen)) {
\&        print $file, "\en";
\&    }
.Ve
.Ip "substr \s-1EXPR\s0,\s-1OFFSET\s0,\s-1LEN\s0" 8
.Ip "substr \s-1EXPR\s0,\s-1OFFSET\s0" 8
Extracts a substring out of \s-1EXPR\s0 and returns it.  First character is at
offset 0, or whatever you've set $[ to.  If \s-1OFFSET\s0 is negative, starts
that far from the end of the string.  If \s-1LEN\s0 is omitted, returns
everything to the end of the string.  You can use the \fIsubstr()\fR function
as an lvalue, in which case \s-1EXPR\s0 must be an lvalue.  If you assign
something shorter than \s-1LEN\s0, the string will shrink, and if you assign
something longer than \s-1LEN\s0, the string will grow to accommodate it.  To
keep the string the same length you may need to pad or chop your value
using \fIsprintf()\fR.
.Ip "symlink \s-1OLDFILE\s0,\s-1NEWFILE\s0" 8
Creates a new filename symbolically linked to the old filename.
Returns 1 for success, 0 otherwise.  On systems that don't support
symbolic links, produces a fatal error at run time.  To check for that,
use eval:
.Sp
.Vb 1
\&    $symlink_exists = (eval 'symlink("","");', $@ eq '');
.Ve
.Ip "syscall \s-1LIST\s0" 8
Calls the system call specified as the first element of the list,
passing the remaining elements as arguments to the system call.  If
unimplemented, produces a fatal error.  The arguments are interpreted
as follows: if a given argument is numeric, the argument is passed as
an int.  If not, the pointer to the string value is passed.  You are
responsible to make sure a string is pre-extended long enough to
receive any result that might be written into a string.  If your
integer arguments are not literals and have never been interpreted in a
numeric context, you may need to add 0 to them to force them to look
like numbers.
.Sp
.Vb 2
\&    require 'syscall.ph';               # may need to run h2ph
\&    syscall(&SYS_write, fileno(STDOUT), "hi there\en", 9);
.Ve
Note that Perl only supports passing of up to 14 arguments to your system call,
which in practice should usually suffice.
.Ip "sysread \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0,\s-1OFFSET\s0" 8
.Ip "sysread \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0" 8
Attempts to read \s-1LENGTH\s0 bytes of data into variable \s-1SCALAR\s0 from the
specified \s-1FILEHANDLE\s0, using the system call \fIread\fR\|(2).  It bypasses
stdio, so mixing this with other kinds of reads may cause confusion.
Returns the number of bytes actually read, or undef if there was an
error.  \s-1SCALAR\s0 will be grown or shrunk to the length actually read.  An
\s-1OFFSET\s0 may be specified to place the read data at some other place than
the beginning of the string.
.Ip "system \s-1LIST\s0" 8
Does exactly the same thing as \*(L"exec \s-1LIST\s0\*(R" except that a fork is done
first, and the parent process waits for the child process to complete.
Note that argument processing varies depending on the number of
arguments.  The return value is the exit status of the program as
returned by the \fIwait()\fR call.  To get the actual exit value divide by
256.  See also the \f(CWexec\fR entry elsewhere in this document.
.Ip "syswrite \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0,\s-1OFFSET\s0" 8
.Ip "syswrite \s-1FILEHANDLE\s0,\s-1SCALAR\s0,\s-1LENGTH\s0" 8
Attempts to write \s-1LENGTH\s0 bytes of data from variable \s-1SCALAR\s0 to the
specified \s-1FILEHANDLE\s0, using the system call \fIwrite\fR\|(2).  It bypasses
stdio, so mixing this with prints may cause confusion.  Returns the
number of bytes actually written, or undef if there was an error.  An
\s-1OFFSET\s0 may be specified to place the read data at some other place than
the beginning of the string.
.Ip "tell \s-1FILEHANDLE\s0" 8
.Ip "tell" 8
Returns the current file position for \s-1FILEHANDLE\s0.  \s-1FILEHANDLE\s0 may be an
expression whose value gives the name of the actual filehandle.  If
\s-1FILEHANDLE\s0 is omitted, assumes the file last read.
.Ip "telldir \s-1DIRHANDLE\s0" 8
Returns the current position of the \fIreaddir()\fR routines on \s-1DIRHANDLE\s0.
Value may be given to \fIseekdir()\fR to access a particular location in a
directory.  Has the same caveats about possible directory compaction as
the corresponding system library routine.
.Ip "tie \s-1VARIABLE\s0,\s-1PACKAGENAME\s0,\s-1LIST\s0" 8
This function binds a variable to a package that will provide the
implementation for the variable.  \s-1VARIABLE\s0 is the name of the variable
to be enchanted.  \s-1PACKAGENAME\s0 is the name of a package implementing
objects of correct type.  Any additional arguments are passed to the
\*(L"new\*(R" method of the package.  Typically these are arguments such as
might be passed to the \fIdbm_open()\fR function of C.
.Sp
Note that functions such as \fIkeys()\fR and \fIvalues()\fR may return huge array
values when used on large \s-1DBM\s0 files.  You may prefer to use the \fIeach()\fR
function to iterate over large \s-1DBM\s0 files.  Example:
.Sp
.Vb 6
\&    # print out history file offsets
\&    tie(%HIST, NDBM_File, '/usr/lib/news/history', 1, 0);
\&    while (($key,$val) = each %HIST) {
\&        print $key, ' = ', unpack('L',$val), "\en";
\&    }
\&    untie(%HIST);
.Ve
A package implementing an associative array should have the following
methods:
.Sp
.Vb 8
\&    TIEHASH objectname, LIST
\&    DESTROY this
\&    FETCH this, key
\&    STORE this, key, value
\&    DELETE this, key
\&    EXISTS this, key
\&    FIRSTKEY this
\&    NEXTKEY this, lastkey
.Ve
A package implementing an ordinary array should have the following methods:
.Sp
.Vb 5
\&    TIEARRAY objectname, LIST
\&    DESTROY this
\&    FETCH this, key
\&    STORE this, key, value
\&    [others TBD]
.Ve
A package implementing a scalar should have the following methods:
.Sp
.Vb 4
\&    TIESCALAR objectname, LIST
\&    DESTROY this
\&    FETCH this, 
\&    STORE this, value
.Ve
.Ip "time" 8
Returns the number of non-leap seconds since 00:00:00 \s-1UTC\s0, January 1,
1970.  Suitable for feeding to \fIgmtime()\fR and \fIlocaltime()\fR.
.Ip "times" 8
Returns a four-element array giving the user and system times, in
seconds, for this process and the children of this process.
.Sp
.Vb 1
\&    ($user,$system,$cuser,$csystem) = times;
.Ve
.Ip "tr///" 8
The translation operator.  See the \fIperlop\fR manpage.
.Ip "truncate \s-1FILEHANDLE\s0,\s-1LENGTH\s0" 8
.Ip "truncate \s-1EXPR\s0,\s-1LENGTH\s0" 8
Truncates the file opened on \s-1FILEHANDLE\s0, or named by \s-1EXPR\s0, to the
specified length.  Produces a fatal error if truncate isn't implemented
on your system.
.Ip "uc \s-1EXPR\s0" 8
Returns an uppercased version of \s-1EXPR\s0.  This is the internal function
implementing the \eU escape in double-quoted strings.
.Ip "ucfirst \s-1EXPR\s0" 8
Returns the value of \s-1EXPR\s0 with the first character uppercased.  This is
the internal function implementing the \eu escape in double-quoted strings.
.Ip "umask \s-1EXPR\s0" 8
.Ip "umask" 8
Sets the umask for the process and returns the old one.  If \s-1EXPR\s0 is
omitted, merely returns current umask.
.Ip "undef \s-1EXPR\s0" 8
.Ip "undef" 8
Undefines the value of \s-1EXPR\s0, which must be an lvalue.  Use only on a
scalar value, an entire array, or a subroutine name (using \*(L"&").  (Using \fIundef()\fR
will probably not do what you expect on most predefined variables or
\s-1DBM\s0 list values, so don't do that.)  Always returns the undefined value.  You can omit
the \s-1EXPR\s0, in which case nothing is undefined, but you still get an
undefined value that you could, for instance, return from a
subroutine.  Examples:
.Sp
.Vb 6
\&    undef $foo;
\&    undef $bar{'blurfl'};
\&    undef @ary;
\&    undef %assoc;
\&    undef &mysub;
\&    return (wantarray ? () : undef) if $they_blew_it;
.Ve
.Ip "unlink \s-1LIST\s0" 8
Deletes a list of files.  Returns the number of files successfully
deleted.
.Sp
.Vb 3
\&    $cnt = unlink 'a', 'b', 'c';
\&    unlink @goners;
\&    unlink <*.bak>;
.Ve
Note: unlink will not delete directories unless you are superuser and
the \fB\-U\fR flag is supplied to Perl.  Even if these conditions are
met, be warned that unlinking a directory can inflict damage on your
filesystem.  Use rmdir instead.
.Ip "unpack \s-1TEMPLATE\s0,\s-1EXPR\s0" 8
Unpack does the reverse of pack: it takes a string representing a
structure and expands it out into a list value, returning the array
value.  (In a scalar context, it merely returns the first value
produced.)  The \s-1TEMPLATE\s0 has the same format as in the pack function.
Here's a subroutine that does substring:
.Sp
.Vb 4
\&    sub substr {
\&        local($what,$where,$howmuch) = @_;
\&        unpack("x$where a$howmuch", $what);
\&    }
.Ve
and then there's
.Sp
.Vb 1
\&    sub ordinal { unpack("c",$_[0]); } # same as ord()
.Ve
In addition, you may prefix a field with a %<number> to indicate that
you want a <number>\-bit checksum of the items instead of the items
themselves.  Default is a 16-bit checksum.  For example, the following
computes the same number as the System V sum program:
.Sp
.Vb 4
\&    while (<>) {
\&        $checksum += unpack("%16C*", $_);
\&    }
\&    $checksum %= 65536;
.Ve
The following efficiently counts the number of set bits in a bit vector:
.Sp
.Vb 1
\&    $setbits = unpack("%32b*", $selectmask);
.Ve
.Ip "untie \s-1VARIABLE\s0" 8
Breaks the binding between a variable and a package.  (See \fItie()\fR.)
.Ip "unshift \s-1ARRAY\s0,\s-1LIST\s0" 8
Does the opposite of a \f(CWshift\fR.  Or the opposite of a \f(CWpush\fR,
depending on how you look at it.  Prepends list to the front of the
array, and returns the new number of elements in the array.
.Sp
.Vb 1
\&    unshift(ARGV, '-e') unless $ARGV[0] =~ /^-/;
.Ve
Note the \s-1LIST\s0 is prepended whole, not one element at a time, so the
prepended elements stay in the same order.  Use reverse to do the
reverse.
.Ip "use Module \s-1LIST\s0" 8
.Ip "use Module" 8
Imports some semantics into the current package from the named module,
generally by aliasing certain subroutine or variable names into your
package.  It is exactly equivalent to
.Sp
.Vb 1
\&    BEGIN { require Module; import Module LIST; }
.Ve
If you don't want your namespace altered, use require instead.
.Sp
The \s-1BEGIN\s0 forces the require and import to happen at compile time.  The
require makes sure the module is loaded into memory if it hasn't been
yet.  The import is not a builtin\*(--it's just an ordinary static method
call into the \*(L"Module\*(R" package to tell the module to import the list of
features back into the current package.  The module can implement its
import method any way it likes, though most modules just choose to
derive their import method via inheritance from the Exporter class that
is defined in the Exporter module.
.Sp
Because this is a wide-open interface, pragmas (compiler directives)
are also implemented this way.  Currently implemented pragmas are:
.Sp
.Vb 4
\&    use integer;
\&    use sigtrap qw(SEGV BUS);
\&    use strict  qw(subs vars refs);
\&    use subs    qw(afunc blurfl);
.Ve
These pseudomodules import semantics into the current block scope, unlike
ordinary modules, which import symbols into the current package (which are
effective through the end of the file).
.Sp
There's a corresponding \*(L"no\*(R" command that unimports meanings imported
by use.
.Sp
.Vb 2
\&    no integer;
\&    no strict 'refs';
.Ve
See the \fIperlmod\fR manpage for a list of standard modules and pragmas.
.Ip "utime \s-1LIST\s0" 8
Changes the access and modification times on each file of a list of
files.  The first two elements of the list must be the \s-1NUMERICAL\s0 access
and modification times, in that order.  Returns the number of files
successfully changed.  The inode modification time of each file is set
to the current time.  Example of a \*(L"touch\*(R" command:
.Sp
.Vb 3
\&    #!/usr/bin/perl
\&    $now = time;
\&    utime $now, $now, @ARGV;
.Ve
.Ip "values \s-1ASSOC_ARRAY\s0" 8
Returns a normal array consisting of all the values of the named
associative array.  (In a scalar context, returns the number of
values.)  The values are returned in an apparently random order, but it
is the same order as either the \fIkeys()\fR or \fIeach()\fR function would produce
on the same array.  See also \fIkeys()\fR and \fIeach()\fR.
.Ip "vec \s-1EXPR\s0,\s-1OFFSET\s0,\s-1BITS\s0" 8
Treats a string as a vector of unsigned integers, and returns the value
of the bitfield specified.  May also be assigned to.  \s-1BITS\s0 must be a
power of two from 1 to 32.
.Sp
Vectors created with \fIvec()\fR can also be manipulated with the logical
operators |, & and ^, which will assume a bit vector operation is
desired when both operands are strings.
.Sp
To transform a bit vector into a string or array of 0's and 1's, use these:
.Sp
.Vb 2
\&    $bits = unpack("b*", $vector);
\&    @bits = split(//, unpack("b*", $vector));
.Ve
If you know the exact length in bits, it can be used in place of the *.
.Ip "wait" 8
Waits for a child process to terminate and returns the pid of the
deceased process, or \-1 if there are no child processes.  The status is
returned in $?.
.Ip "waitpid \s-1PID\s0,\s-1FLAGS\s0" 8
Waits for a particular child process to terminate and returns the pid
of the deceased process, or \-1 if there is no such child process.  The
status is returned in $?.  If you say
.Sp
.Vb 3
\&    use POSIX "wait_h";
\&    ...
\&    waitpid(-1,&WNOHANG);
.Ve
then you can do a non-blocking wait for any process.  Non-blocking wait
is only available on machines supporting either the \fIwaitpid\fR\|(2) or
\fIwait4\fR\|(2) system calls.  However, waiting for a particular pid with
\s-1FLAGS\s0 of 0 is implemented everywhere.  (Perl emulates the system call
by remembering the status values of processes that have exited but have
not been harvested by the Perl script yet.)
.Ip "wantarray" 8
Returns \s-1TRUE\s0 if the context of the currently executing subroutine is
looking for a list value.  Returns \s-1FALSE\s0 if the context is looking
for a scalar.
.Sp
.Vb 1
\&    return wantarray ? () : undef;
.Ve
.Ip "warn \s-1LIST\s0" 8
Produces a message on \s-1STDERR\s0 just like \fIdie()\fR, but doesn't exit or
throw an exception.
.Ip "write \s-1FILEHANDLE\s0" 8
.Ip "write \s-1EXPR\s0" 8
.Ip "write" 8
Writes a formatted record (possibly multi-line) to the specified file,
using the format associated with that file.  By default the format for
a file is the one having the same name is the filehandle, but the
format for the current output channel (see the \fIselect()\fR function) may be set
explicitly by assigning the name of the format to the $~ variable.
.Sp
Top of form processing is handled automatically:  if there is
insufficient room on the current page for the formatted record, the
page is advanced by writing a form feed, a special top-of-page format
is used to format the new page header, and then the record is written.
By default the top-of-page format is the name of the filehandle with
\*(L"_TOP\*(R" appended, but it may be dynamically set to the format of your
choice by assigning the name to the $^ variable while the filehandle is
selected.  The number of lines remaining on the current page is in
variable $\-, which can be set to 0 to force a new page.
.Sp
If \s-1FILEHANDLE\s0 is unspecified, output goes to the current default output
channel, which starts out as \s-1STDOUT\s0 but may be changed by the
\f(CWselect\fR operator.  If the \s-1FILEHANDLE\s0 is an \s-1EXPR\s0, then the expression
is evaluated and the resulting string is used to look up the name of
the \s-1FILEHANDLE\s0 at run time.  For more on formats, see the \fIperlform\fR manpage.
.Sp
Note that write is \fI\s-1NOT\s0\fR the opposite of read.  Unfortunately.
.Ip "y///" 8
The translation operator.  See the section on \fItr///\fR in the \fIperlop\fR manpage.

.rn }` ''
