#!../../perl
#	%W%	%G%

BEGIN {unshift @INC, "../../lib";}

use ExtUtils::MakeMaker;

#####
### Configure
#####

# DB-Library version
$DBLIBVS = 461;

# CT-Library version (set to 0 if you do  not have CT-Library)
# Leave this at 0 until Sybase::CTlib actually exists! :-)
$CTLIBVS = 0;

# The Sybase home directory. This is normally taken from the environment
if(!defined($SYBASE = $ENV{SYBASE})) {
    warn "Makefile.PL: \$SYBASE not defined - guessing...\n";
    $SYBASE = '/usr/local/sybase';
}

# Extra flags to pass to CPP
$inc_string = "-I$SYBASE/include";
$def_string = "-DDBLIBVS=$DBLIBVS -DSYBPLVER='\"\${VERSION}\"'";
$lib_string = "-L$SYBASE/lib -lsybdb -lm";

@SubDirs = qw(CTlib DBlib Sybperl);

$ExtUtils::MakeMaker::Subdirs = 1; # recursively do other Makefile.PLs

#####
### Configure End
#####


&writeMakefile("potential_libs" => $lib_string,
               "INC" => $inc_string,
	       "DISTNAME" => "sybperl",
	       "VERSION" => "2a7",
	       "DEFINE" => $def_string
		);

sub MY::post_initialize {
    shift(@SubDirs) if !$CTLIBVS;
    
    '';
}
    
sub MY::subdir {
    my(@m);
    foreach $subdir (@SubDirs){
	push @m, "
all ::
	cd $subdir ; \$(MAKE) all

config ::
	\@cd $subdir ; \\
	if test ! -f Makefile; then \\
	test -f Makefile.PL  && \$(PERL) -I\$(ABSTOP)/lib Makefile.PL TOP=\$(ABSTOP) INC=\$(INC) DEFINE=\$(DEFINE) VERSION=\$(VERSION) potential_libs='$lib_string'; \\
	fi

";

    }
    join('',@m);
}

sub MY::distclean
{
    '
distclean:     clean
	rm -f Makefile *~ t/*~ lib/*~ eg/*~
	cd ..; tar cfF $(DISTNAME)-$(VERSION).tar $(FULLEXT)
	cd ..; gzip $(DISTNAME)-$(VERSION).tar
'
}

sub MY::clean {
    my(@m);
    
    push(@m, '
clean::
	rm -f *.o *.a mon.out core $(BASEEXT).c so_locations
	rm -f makefile Makefile $(BOOTSTRAP) $(BASEEXT).bso
	rm -f *~ t/*~ lib/*~ eg/*~ pod/*~
');
    foreach $sub (@SubDirs)
    {
	push(@m, "	cd $sub; \$(MAKE) clean
");
    }
    join('',@m);
}

sub MY::dynamic {
    '
all::	config $(ABSTOP)/lib/sybutil.pl

dynamic::	$(ABSTOP)/lib/sybutil.pl

$(ABSTOP)/lib/sybutil.pl: lib/sybutil.pl
	cp lib/sybutil.pl $(ABSTOP)/lib/sybutil.pl
	chmod 644 $(ABSTOP)/lib/sybutil.pl
';
}

sub MY::static {
    '
static::	$(ABSTOP)/lib/sybutil.pl
';
}

sub MY::c {
    '';
}
sub MY::installpm {
    '';
}
sub MY::test {
    my(@m);
    push(@m, 'test: all
');
    foreach $subdir (@SubDirs){
	push @m, "	cd $subdir ; \$(MAKE) test
";
    }
    join('',@m);
}
    
