package Msql;

use Carp;
require Exporter;
require AutoLoader;
require DynaLoader;
@ISA = (Exporter, AutoLoader, DynaLoader);
@EXPORT = qw(
        CHAR_TYPE
        INT_TYPE
        REAL_TYPE
);

sub AUTOLOAD {
    if (@_ > 1) {
	$AutoLoader::AUTOLOAD = $AUTOLOAD;
	goto &AutoLoader::AUTOLOAD;
    }
    local($constname);
    ($constname = $AUTOLOAD) =~ s/.*:://;
    $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
	    ($pack,$file,$line) = caller;
	    die "Your vendor has not defined Msql macro $constname, used at $file line $line.
";
	}
    }
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}

bootstrap Msql;

# Preloaded methods go here.  Autoload methods go after __END__, and are
# processed by the autosplit program.

sub  Insert {
    my $self = shift;
    my $table = shift;
    my $sth;
    $sth = $self->ListFields($table);
    unless ($sth){
      Carp::croak
	  ("ListFields didn't return for $table: $Msql::db_errstr");
    }
    unless (@_ == @{$sth->{"NAME"}}){
	print join (":", @_), "--", join ("!", @namearr), "in $table\n";
      Carp::croak("$table needs ", 
		  scalar @{$sth->{"NAME"}}, 
		  " fields, got ", 
		  scalar @_, "\n");
    }
    my $query = "insert into $table ( ";
    $query .= join ",", @{$sth->{"NAME"}};
    my @arr=();
    $query .= " ) values (";
    foreach (@_){
	push @arr,
	(/^([+-]?)(\d*)(\.(\d*))?([Ee]([+-]?\d+))?$/ && "$2$4" ne '')
	    ?  $_  :  "'$_'";
    }
    $query .= join ",", @arr;
    $query .= ")";
    $self->Query($query);
}


1;
__END__

