h04733
s 00013/00004/00535
d D 1.12 91/07/24 08:16:07 geoff 12 11
c lint fixes, add watchdog to crowbar runaway subpprocesses, 
c also make sure that aliases (virtual printers) show up in the 
c printer list
e
s 00002/00002/00537
d D 1.11 91/05/02 10:34:16 geoff 11 10
c snapshort after SVR4 checkout
e
s 00002/00103/00537
d D 1.10 91/04/15 15:53:51 geoff 10 9
c consolidate stuff
e
s 00003/00003/00637
d D 1.9 91/04/12 14:16:05 geoff 9 8
c change msgout to msg_out for SVR4
e
s 00080/00024/00560
d D 1.8 91/03/11 16:00:26 geoff 8 7
c another snapshot
e
s 00094/00000/00490
d D 1.7 91/03/11 04:24:02 geoff 7 6
c snapshot
e
s 00024/00005/00466
d D 1.6 91/03/07 14:59:25 geoff 6 5
c add su_popen support; status check, new lp-based startprint
e
s 00114/00006/00357
d D 1.5 91/03/06 16:21:36 geoff 5 4
c snapshot before doing more status stuff
e
s 00014/00000/00349
d D 1.4 91/03/05 17:18:50 geoff 4 3
c print queues now returned ok; some tests in harness
e
s 00002/00002/00347
d D 1.3 91/03/05 10:46:12 geoff 3 2
c clean up last delta
e
s 00269/00002/00080
d D 1.2 91/03/04 16:21:40 geoff 2 1
c basic functionality replicated
e
s 00082/00000/00000
d D 1.1 91/03/04 11:54:12 geoff 1 0
c date and time created 91/03/04 11:54:12 by geoff
e
u
U
f e 0
t
T
I 2
/*
**=====================================================================
** Copyright (c) 1986,1987,1988,1989,1990,1991 by Sun Microsystems, Inc.
I 10
**	%W%	%G%
E 10
**=====================================================================
*/
D 10

E 10
I 10
#include "common.h"
E 10
/*
**=====================================================================
D 10
**             C U S T O M I Z A T I O N   S E C T I O N              *
**                                                                    *
** You should not uncomment these #defines in this version of pcnfsd  *
** Instead you should edit the makefile CDEFS variable.               *
**                                                                    *
**=====================================================================
*/

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to enable the use of a 
** shadow password file
**---------------------------------------------------------------------
**/

/* #define SHADOW_SUPPORT */

/*
I 5
**---------------------------------------------------------------------
I 7
** Define (via Makefile) the following symbol to enable the logging 
** of authentication requests to /usr/adm/wtmp
**---------------------------------------------------------------------
**/

/* #define WTMP */

/*
**---------------------------------------------------------------------
E 7
** Define (via Makefile) the following symbol to enable the use of the 
** YP (NIS) auto.home map to find the home directory
**---------------------------------------------------------------------
**/

#define USE_YP

/*
E 5
**------------------------------------------------------------------------
** Define (via Makefile) the following symbol conform to Interactive
** System's 2.0
**------------------------------------------------------------------------
*/

/* #define ISC_2_0 */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to use a cache of recently-used
** user names. This has certain uses in university and other settings
** where (1) the pasword file is very large, and (2) a group of users
** frequently logs in together using the same account (for example,
** a class userid).
**---------------------------------------------------------------------
*/

/* #define USER_CACHE */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a System V version
**---------------------------------------------------------------------
*/

/* #define SYSV */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a version that uses
** System V style "lp" instead of BSD-style "lpr" to print
**---------------------------------------------------------------------
*/

/* #define USE_LP */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a typical
** "local feature": in this case recognizing the special printer
** names "rotated" and "2column" and using the Adobe "enscript"
** command to format the output appropriately.
**---------------------------------------------------------------------
*/

/* #define HACK_FOR_ROTATED_TRANSCRIPT */

/*
**---------------------------------------------------------------------
** The following should force the right things for Interactive 2.0
**---------------------------------------------------------------------
*/
#ifdef ISC_2_0
#define SYSV
#define USE_LP
#define SHADOW_SUPPORT
#endif

/*
**=====================================================================
E 10
**             I N C L U D E   F I L E   S E C T I O N                *
**                                                                    *
** If your port requires different include files, add a suitable      *
** #define in the customization section, and make the inclusion or    *
** exclusion of the files conditional on this.                        *
**=====================================================================
*/
E 2
I 1
#include "pcnfsd.h"

I 2
#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <string.h>

I 5
#ifdef USE_YP
#include <rpcsvc/ypclnt.h>
#endif

E 5
#ifndef SYSV
#include <sys/wait.h>
#endif

#ifdef ISC_2_0
#include <sys/fcntl.h>
#endif

#ifdef SHADOW_SUPPORT
#include <shadow.h>
#endif

/*
**---------------------------------------------------------------------
** Other #define's 
**---------------------------------------------------------------------
*/
D 10

#define assert(ex) {if (!(ex)) \
    {(void)fprintf(stderr,"pcnfsd: Assertion failed: line %d of %s: \"%s\"\n", \
    __LINE__, __FILE__, "ex"); \
    sleep (30); exit(1);}}
E 10

void            fillin_extra_groups();
extern void     scramble();
I 8
extern void    *grab();
E 8
extern char    *crypt();
I 4
extern int      build_pr_list();
extern pirstat  build_pr_queue();
I 6
extern psrstat  pr_start();
extern psrstat  pr_start2();
I 7
extern pcrstat  pr_cancel();
E 7
extern pirstat  get_pr_status();
E 6
E 4

extern struct passwd  *get_password();

I 7
#ifdef WTMP
extern void wlogin();
#endif

E 7
I 5
#ifdef USE_YP
char *find_entry();
#endif

E 5
/*
**---------------------------------------------------------------------
**                       Misc. variable definitions
**---------------------------------------------------------------------
*/

I 4
extern pr_list         printers;
extern pr_queue        queue;
E 4

/*
**=====================================================================
**                      C O D E   S E C T I O N                       *                    **=====================================================================
*/


static char no_comment[] = "No comment";
I 7
static char not_supported[] = "Not supported";
E 7
I 6
D 12
static char pcnfsd_version[] = "rpc.pcnfsd V2.0 Sun Microsystems %W%";
E 12
I 12
static char pcnfsd_version[] = "%W% - rpc.pcnfsd V2.0 (c) 1991 Sun Technology Enterprises, Inc.";
E 12
E 6

I 12
/*ARGSUSED*/
E 12
E 2
void *pcnfsd2_null_2(arg)
void*arg;
{
static char dummy;
return((void *)&dummy);
}

v2_auth_results *pcnfsd2_auth_2(arg)
v2_auth_args *arg;
{
D 2
static v2_auth_results res;
E 2
I 2
static v2_auth_results  r;
E 2

I 2
char            uname[32];
char            pw[64];
int             c1, c2;
struct passwd  *p;
u_int           extra_gids[EXTRAGIDLEN];
I 5
static char     home[256];
I 12
#ifdef USE_YP
E 12
char           *yphome;
char           *cp;
I 12
#endif /*USE_YP*/
E 12
E 5
E 2

D 2
return(&res);
E 2
I 2

	r.stat = AUTH_RES_FAIL;	/* assume failure */
D 12
	r.uid = -2;
	r.gid = -2;
E 12
I 12
	r.uid = (int)-2;
	r.gid = (int)-2;
E 12
	r.cm = &no_comment[0];
	r.gids.gids_len = 0;
	r.gids.gids_val = &extra_gids[0];
I 5
	home[0] = '\0';
	r.home = &home[0];
I 6
	r.def_umask = umask(0);
	(void)umask(r.def_umask);	/* or use 022 */
E 6
E 5

	scramble(arg->id, uname);
	scramble(arg->pw, pw);

#ifdef USER_CACHE
	if(check_cache(uname, pw, &r.uid, &r.gid)) {
		 r.stat = AUTH_RES_OK;
I 7
#ifdef WTMP
D 11
		wlogin(uname, arg->system);
E 11
I 11
		wlogin(uname);
E 11
#endif
E 7
                 fillin_extra_groups
			(uname, r.gid, &r.gids.gids_len, extra_gids);
I 5
#ifdef USE_YP
		yphome = find_entry(uname, "auto.home");
		if(yphome) {
			strcpy(home, yphome);
			free(yphome);
			cp = strchr(home, ':');
			cp++;
			cp = strchr(cp, ':');
			if(cp)
				*cp = '/';
		}
#endif
E 5
		 return (&r);
   }
#endif

	p = get_password(uname);
	if (p == (struct passwd *)NULL)
	   return (&r);

	c1 = strlen(pw);
	c2 = strlen(p->pw_passwd);
	if ((c1 && !c2) || (c2 && !c1) ||
	   (strcmp(p->pw_passwd, crypt(pw, p->pw_passwd)))) 
           {
	   return (&r);
	   }
	r.stat = AUTH_RES_OK;
	r.uid = p->pw_uid;
	r.gid = p->pw_gid;
I 7
#ifdef WTMP
D 11
	wlogin(uname, arg->system);
E 11
I 11
	wlogin(uname);
E 11
#endif
E 7
        fillin_extra_groups(uname, r.gid, &r.gids.gids_len, extra_gids);

I 5
#ifdef USE_YP
	yphome = find_entry(uname, "auto.home");
	if(yphome) {
		strcpy(home, yphome);
		free(yphome);
		cp = strchr(home, ':');
		cp++;
		cp = strchr(cp, ':');
		if(cp)
			*cp = '/';
	}
#endif

E 5
#ifdef USER_CACHE
	add_cache_entry(p);
#endif

return(&r);

E 2
}

v2_pr_init_results *pcnfsd2_pr_init_2(arg)
v2_pr_init_args *arg;
{
static v2_pr_init_results res;

I 2
	res.stat = 
D 3
	 (pirstat) pr_initarg->system, arg->pn, &res.dir);
E 3
I 3
	 (pirstat) pr_init(arg->system, arg->pn, &res.dir);
E 3
	res.cm = &no_comment[0];
E 2

I 2

E 2
return(&res);
}

v2_pr_start_results *pcnfsd2_pr_start_2(arg)
v2_pr_start_args *arg;
{
static v2_pr_start_results res;

I 2
	res.stat =
D 6
	  (psrstat) pr_start(arg->system, arg->pr, arg->user,
E 6
I 6
	  (psrstat) pr_start2(arg->system, arg->pn, arg->user,
E 6
	  arg ->file, arg->opts, &res.id);
	res.cm = &no_comment[0];
E 2

return(&res);
}

I 12
/*ARGSUSED*/
E 12
v2_pr_list_results *pcnfsd2_pr_list_2(arg)
void *arg;
{
static v2_pr_list_results res;

I 4
	if(printers == NULL)
		(void)build_pr_list();
	res.cm = &no_comment[0];
	res.printers = printers;
E 4

return(&res);
}

v2_pr_queue_results *pcnfsd2_pr_queue_2(arg)
v2_pr_queue_args *arg;
{
static v2_pr_queue_results res;

I 4
	res.stat = build_pr_queue(arg->pn, arg->user,
		arg->just_mine, &res.qlen, &res.qshown);
	res.cm = &no_comment[0];
	res.just_yours = arg->just_mine;
	res.jobs = queue;
	
E 4

return(&res);
}

v2_pr_status_results *pcnfsd2_pr_status_2(arg)
v2_pr_status_args *arg;
{
static v2_pr_status_results res;
I 6
static char status[128];
E 6

I 6
	res.stat = get_pr_status(arg->pn, &res.avail, &res.printing,
		&res.qlen, &res.needs_operator, &status[0]);
	res.status = &status[0];	
	res.cm = &no_comment[0];
E 6

return(&res);
}

v2_pr_cancel_results *pcnfsd2_pr_cancel_2(arg)
v2_pr_cancel_args *arg;
{
static v2_pr_cancel_results res;

I 7
	res.stat = pr_cancel(arg->pn, arg->user, arg->id);
	res.cm = &no_comment[0];
E 7

return(&res);
}

I 12
/*ARGSUSED*/
E 12
I 7
v2_pr_requeue_results *pcnfsd2_pr_requeue_2(arg)
v2_pr_requeue_args *arg;
{
static v2_pr_requeue_results res;
	res.stat = PC_RES_FAIL;
	res.cm = &not_supported[0];

return(&res);
}

I 12
/*ARGSUSED*/
E 12
v2_pr_hold_results *pcnfsd2_pr_hold_2(arg)
v2_pr_hold_args *arg;
{
static v2_pr_hold_results res;

	res.stat = PC_RES_FAIL;
	res.cm = &not_supported[0];

return(&res);
}

I 12
/*ARGSUSED*/
E 12
v2_pr_release_results *pcnfsd2_pr_release_2(arg)
v2_pr_release_args *arg;
{
static v2_pr_release_results res;

	res.stat = PC_RES_FAIL;
	res.cm = &not_supported[0];

return(&res);
}

I 12
/*ARGSUSED*/
E 12
E 7
v2_pr_admin_results *pcnfsd2_pr_admin_2(arg)
v2_pr_admin_args *arg;
{
static v2_pr_admin_results res;
I 5
/*
** The default action for admin is to fail.
** If someone wishes to implement an administration
** mechanism, and isn't worried about the security
** holes, go right ahead.
*/
E 5

I 7
	res.cm = &not_supported[0];
E 7
	res.stat = PI_RES_FAIL;

return(&res);
}
I 2

I 8
void
free_mapreq_results(p)
mapreq_res p;
{
	if(p->mapreq_next)
		free_mapreq_results(p->mapreq_next); /* recurse */
	if(p->name)
		(void)free(p->name);
	(void)free(p);
	return;
}

static char *
my_strdup(s)
char *s;
{
char *r;
	r = (char *)grab(strlen(s)+1);
	strcpy(r, s);
	return(r);
}

E 8
v2_mapid_results *pcnfsd2_mapid_2(arg)
v2_mapid_args *arg;
{
static v2_mapid_results res;
D 8
static char u[USERNAMELEN+1];
static char g[USERNAMELEN+1];
E 8
D 5
int i;
int j;
E 5
I 5
D 12
unsigned int i;
E 12
struct passwd *p_passwd;
struct group  *p_group;
E 5

I 5
D 8
#define SKIP ((unsigned int)-1)
E 8
I 8
mapreq_arg a;
mapreq_res next_r;
mapreq_res last_r = NULL;
E 8

E 5
D 8
	u[0] = '\0';
	g[0] = '\0';
E 8

D 8
/*	res.uid = arg->uid;
	res.gid = arg->gid; */

	i = arg->uid;
	res.uid = i;
I 5

	if(i !=SKIP) {
		p_passwd = getpwuid((uid_t)i);
		if(p_passwd)
			strcpy(u, p_passwd->pw_name);
E 8
I 8
	if(res.res_list) {
		free_mapreq_results(res.res_list);
		res.res_list = NULL;
E 8
	}

E 5
D 8
 	i = arg->gid;
	res.gid = i;
E 8
I 8
	a = arg->req_list;
	while(a) {
		next_r = (struct mapreq_res_item *)
			grab(sizeof(struct mapreq_res_item));
		next_r->stat = MAP_RES_UNKNOWN;
		next_r->req = a->req;
		next_r->id = a->id;
		next_r->name = NULL;
		next_r->mapreq_next = NULL;
E 8

I 5
D 8
	if(i != SKIP) {
D 6
		p_group = getgrid((gid_t)i);
E 6
I 6
		p_group = getgrgid((gid_t)i);
E 6
		if(p_group)
			strcpy(g, p_group->gr_name);
E 8
I 8
		if(last_r == NULL)
			res.res_list = next_r;
		else
			last_r->mapreq_next = next_r;
		last_r = next_r;
		switch(a->req) {
		case MAP_REQ_UID:
			p_passwd = getpwuid((uid_t)a->id);
			if(p_passwd) {
				next_r->name = my_strdup(p_passwd->pw_name);
				next_r->stat = MAP_RES_OK;
			}
			break;
		case MAP_REQ_GID:
			p_group = getgrgid((gid_t)a->id);
			if(p_group) {
				next_r->name = my_strdup(p_group->gr_name);
				next_r->stat = MAP_RES_OK;
			}
			break;
		case MAP_REQ_UNAME:
			next_r->name = my_strdup(a->name);
			p_passwd = getpwnam(a->name);
			if(p_passwd) {
				next_r->id = p_passwd->pw_uid;
				next_r->stat = MAP_RES_OK;
			}
			break;
		case MAP_REQ_GNAME:
			next_r->name = my_strdup(a->name);
			p_group = getgrnam(a->name);
			if(p_group) {
				next_r->id = p_group->gr_gid;
				next_r->stat = MAP_RES_OK;
			}
			break;
		}
		if(next_r->name == NULL)
			next_r->name = my_strdup("");
		a = a->mapreq_next;
E 8
	}

E 5
D 8
	res.user = &u[0];
	res.group = &g[0];
E 8
	res.cm = &no_comment[0];
D 6
/*
** Add logic to map uid or gid if not equal to -1
*/
E 6
I 6

return(&res);
}

I 8
	
I 12
/*ARGSUSED*/
E 12
E 8
I 7
v2_alert_results *pcnfsd2_alert_2(arg)
v2_alert_args *arg;
{
static v2_alert_results res;

	res.stat = ALERT_RES_FAIL;
D 8
	res.cm = &no_supported[0];
E 8
I 8
	res.cm = &not_supported[0];
E 8

return(&res);
}

I 12
/*ARGSUSED*/
E 12
E 7
v2_info_results *pcnfsd2_info_2(arg)
v2_info_args *arg;
{
static v2_info_results res;
I 7
static int facilities[FACILITIESMAX];
static int onetime = 1;
E 7

I 7
#define UNSUPPORTED -1
#define QUICK 100
#define SLOW 2000

	if(onetime) {
		onetime = 0;
		facilities[PCNFSD2_NULL] = QUICK;
		facilities[PCNFSD2_INFO] = QUICK;
		facilities[PCNFSD2_PR_INIT] = QUICK;
		facilities[PCNFSD2_PR_START] = SLOW;
		facilities[PCNFSD2_PR_LIST] = QUICK; /* except first time */
		facilities[PCNFSD2_PR_QUEUE] = SLOW;
		facilities[PCNFSD2_PR_STATUS] = SLOW;
		facilities[PCNFSD2_PR_CANCEL] = SLOW;
		facilities[PCNFSD2_PR_ADMIN] = UNSUPPORTED;
		facilities[PCNFSD2_PR_REQUEUE] = UNSUPPORTED;
		facilities[PCNFSD2_PR_HOLD] = UNSUPPORTED;
		facilities[PCNFSD2_PR_RELEASE] = UNSUPPORTED;
		facilities[PCNFSD2_MAPID] = QUICK;
		facilities[PCNFSD2_AUTH] = QUICK;
		facilities[PCNFSD2_ALERT] = QUICK;
	}
	res.facilities.facilities_len = PCNFSD2_ALERT+1;
	res.facilities.facilities_val = facilities;
	
E 7
	res.vers = &pcnfsd_version[0];
	res.cm = &no_comment[0];
E 6

return(&res);
}



void
fillin_extra_groups(uname, main_gid, len, extra_gids)
char *uname;
u_int main_gid;
int *len;
u_int extra_gids[EXTRAGIDLEN];
{
struct group *grp;
char **members;
int n = 0;

	setgrent();

	while(n < EXTRAGIDLEN) {
		grp = getgrent();
		if(grp == NULL)
			break;
D 5
		if(grp ->gr_gid == main_gid)
E 5
I 5
		if(grp->gr_gid == main_gid)
E 5
			continue;
D 5
		members = grp->gr_mem;
		while(*members) {
E 5
I 5
		for(members = grp->gr_mem; members && *members; members++) {
E 5
			if(!strcmp(*members, uname)) {
D 3
				extra_gids[n++] = gro->gr_gid;
E 3
I 3
				extra_gids[n++] = grp->gr_gid;
E 3
				break;
			}
D 5
			members++;
E 5
		}
	}
	endgrent();
	*len = n;
}

I 5
#ifdef USE_YP
/* the following is from rpcsvc/yp_prot.h */
#define YPMAXDOMAIN 64
/*
 * find_entry returns NULL on any error (printing a message) and
 * otherwise returns a pointer to the malloc'd result. The caller
 * is responsible for free()ing the result string.
 */
char *
find_entry(key, map)
char *key;
char *map;
{
	int err;
	char *val = NULL;
	char *cp;
	int len = 0;
	static char domain[YPMAXDOMAIN+1];
E 5
E 2

I 5
	if(getdomainname(domain, YPMAXDOMAIN) ) {
D 9
		msgout("rpc.pcnfsd: getdomainname failed");
E 9
I 9
		msg_out("rpc.pcnfsd: getdomainname failed");
E 9
		return(NULL);
	}

	if (err = yp_bind(domain)) {
D 9
		msgout("rpc.pcnfsd: yp_bind failed");
E 9
I 9
		msg_out("rpc.pcnfsd: yp_bind failed");
E 9
		return(NULL);
	}

	err = yp_match(domain, map, key, strlen(key), &val, &len);

	if (err) {
D 9
		msgout("rpc.pcnfsd: yp_match failed");
E 9
I 9
		msg_out("rpc.pcnfsd: yp_match failed");
E 9
		return(NULL);
	}

	if(cp = strchr(val, '\n'))
			*cp = '\0';		/* in case we get an extra NL at the end */
	return(val);
}

#endif
E 5
E 1
