h54081
s 00005/00003/00150
d D 1.8 91/07/24 08:16:05 geoff 8 7
c lint fixes, add watchdog to crowbar runaway subpprocesses, 
c also make sure that aliases (virtual printers) show up in the 
c printer list
e
s 00002/00002/00151
d D 1.7 91/05/02 10:34:14 geoff 7 6
c snapshort after SVR4 checkout
e
s 00003/00138/00150
d D 1.6 91/04/15 15:53:48 geoff 6 5
c consolidate stuff
e
s 00021/00000/00267
d D 1.5 91/03/11 04:23:57 geoff 5 4
c snapshot
e
s 00001/00001/00266
d D 1.4 91/03/07 14:59:23 geoff 4 3
c add su_popen support; status check, new lp-based startprint
e
s 00006/00313/00261
d D 1.3 91/03/04 16:21:37 geoff 3 2
c basic functionality replicated
e
s 00005/00069/00569
d D 1.2 91/03/04 13:59:40 geoff 2 1
c migrate cache logic to pcnfsd_cache.c
e
s 00638/00000/00000
d D 1.1 91/03/04 11:54:11 geoff 1 0
c date and time created 91/03/04 11:54:11 by geoff
e
u
U
f e 0
t
T
I 1
/*
**=====================================================================
** Copyright (c) 1986,1987,1988,1989,1990,1991 by Sun Microsystems, Inc.
D 6
**
**         D I S C L A I M E R   S E C T I O N ,   E T C .
**
** pcnfsd is copyrighted software, but is freely licensed. This
** means that you are free to redistribute it, modify it, ship it
** in binary with your system, whatever, provided:
**
** - you leave the Sun copyright notice in the source code
** - you make clear what changes you have introduced and do
**   not represent them as being supported by Sun.
** - you do not charge money for the source code (unlikely, given
**   its free availability)
**
** If you make changes to this software, we ask that you do so in
** a way which allows you to build either the "standard" version or
** your custom version from a single source file. Test it, lint
** it (it won't lint 100%, very little does, and there are bugs in
** some versions of lint :-), and send it back to Sun via email
** so that we can roll it into the source base and redistribute
** it. We'll try to make sure your contributions are acknowledged
** in the source, but after all these years it's getting hard to
** remember who did what.
**
** The main contributors have been (in no special order):
**
** Glen Eustace <G.Eustace@massey.ac.nz>
**    user name caching for b-i-g password files
** Paul Emerson <paul@sdgsun.uucp>
**    cleaning up Interactive 386/ix handling, fixing the lp
**    interface, and generally tidying up the sources
** Keith Ericson <keithe@sail.labs.tek.com>
**    more 386/ix fixes
** Jeff Stearns <jeff@tc.fluke.com>
**    setuid/setgid for lpr
** Peter Van Campen <petervc@sci.kun.nl>
**    fixing setuid/gid stuff, syslog
I 5
** Ted Nolan <ted@usasoc.soc.mil>
**    /usr/adm/wtmp, other security suggestions
E 5
**
** Thanks to everyone who has contributed.
**
**    Geoff Arnold, PC-NFS architect <geoff@East.Sun.COM>
E 6
I 6
**	%W%	%G%
E 6
**=====================================================================
*/
D 6
char *sccsid="@(#)pcnfsd.c	1.5 Version 1.5";
E 6
I 6
#include "common.h"
E 6

/*
**=====================================================================
D 6
**             C U S T O M I Z A T I O N   S E C T I O N              *
**                                                                    *
** You should not uncomment these #defines in this version of pcnfsd  *
** Instead you should edit the makefile CDEFS variable.               *
**                                                                    *
**=====================================================================
*/

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to enable the use of a 
** shadow password file
**---------------------------------------------------------------------
**/

/* #define SHADOW_SUPPORT */

/*
I 5
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to enable the logging 
** of authentication requests to /usr/adm/wtmp
**---------------------------------------------------------------------
**/

/* #define WTMP */

/*
E 5
**------------------------------------------------------------------------
** Define (via Makefile) the following symbol conform to Interactive
** System's 2.0
**------------------------------------------------------------------------
*/

/* #define ISC_2_0 */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to use a cache of recently-used
** user names. This has certain uses in university and other settings
** where (1) the pasword file is very large, and (2) a group of users
** frequently logs in together using the same account (for example,
** a class userid).
**---------------------------------------------------------------------
*/

/* #define USER_CACHE */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a System V version
**---------------------------------------------------------------------
*/

/* #define SYSV */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a version that uses
** System V style "lp" instead of BSD-style "lpr" to print
**---------------------------------------------------------------------
*/

/* #define USE_LP */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a typical
** "local feature": in this case recognizing the special printer
** names "rotated" and "2column" and using the Adobe "enscript"
** command to format the output appropriately.
**---------------------------------------------------------------------
*/

/* #define HACK_FOR_ROTATED_TRANSCRIPT */

/*
**---------------------------------------------------------------------
D 3
** The following definitions may be overridden if desired.
**---------------------------------------------------------------------
*/

#ifndef SPOOLDIR
#define SPOOLDIR	"/usr/spool/pcnfs"
#endif	

/*
**---------------------------------------------------------------------
E 3
** The following should force the right things for Interactive 2.0
**---------------------------------------------------------------------
*/
#ifdef ISC_2_0
#define SYSV
#define USE_LP
#define SHADOW_SUPPORT
#endif

/*
**=====================================================================
E 6
**             I N C L U D E   F I L E   S E C T I O N                *
**                                                                    *
** If your port requires different include files, add a suitable      *
** #define in the customization section, and make the inclusion or    *
** exclusion of the files conditional on this.                        *
**=====================================================================
*/
#include "pcnfsd.h"

#include <stdio.h>
#include <pwd.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netdb.h>
D 3
#include <errno.h>
E 3
#include <string.h>

#ifndef SYSV
#include <sys/wait.h>
#endif

#ifdef ISC_2_0
#include <sys/fcntl.h>
#endif

#ifdef SHADOW_SUPPORT
#include <shadow.h>
#endif

/*
**---------------------------------------------------------------------
** Other #define's 
**---------------------------------------------------------------------
*/
D 3
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
E 3

D 6
#define assert(ex) {if (!(ex)) \
    {(void)fprintf(stderr,"pcnfsd: Assertion failed: line %d of %s: \"%s\"\n", \
    __LINE__, __FILE__, "ex"); \
    sleep (30); exit(1);}}


E 6
D 2
#ifdef USER_CACHE
#define CACHE_SIZE 16		/* keep it small, as linear searches are
				 * done */
struct cache 
       {
       int   cuid;
       int   cgid;
       char  cpw[32];
       char  cuname[10];	/* keep this even for machines
				 * with alignment problems */
       }User_cache[CACHE_SIZE];

#endif

E 2
extern void     scramble();
D 3
extern void     free_child();
extern void     run_ps630();
E 3
extern char    *crypt();

I 5
#ifdef WTMP
extern void wlogin();
#endif

E 5
D 3
#ifdef SYSV
struct passwd  *getpwnam();
#endif

E 3
extern struct passwd  *get_password();

/*
**---------------------------------------------------------------------
**                       Misc. variable definitions
**---------------------------------------------------------------------
*/

D 3
extern int      errno;
E 3
int             buggit = 0;
D 3
struct stat     statbuf;
char            pathname[MAXPATHLEN];
char            new_pathname[MAXPATHLEN];
char            sp_name[MAXPATHLEN] = SPOOLDIR;
char            tempstr[256];
E 3

/*
**=====================================================================
D 8
**                      C O D E   S E C T I O N                       *                    **=====================================================================
E 8
I 8
**                      C O D E   S E C T I O N                       *
**=====================================================================
E 8
*/


I 8
/*ARGSUSED*/
E 8
void *pcnfsd_null_1(arg)
void *arg;
{
static char dummy;
return((void *)&dummy);
}

auth_results *pcnfsd_auth_1(arg)
auth_args *arg;
{
static auth_results r;

char            uname[32];
char            pw[64];
int             c1, c2;
struct passwd  *p;

D 2
#ifdef USER_CACHE
int             cache_entry;;
#endif
E 2

	r.stat = AUTH_RES_FAIL;	/* assume failure */
D 8
	r.uid = -2;
	r.gid = -2;
E 8
I 8
	r.uid = (int)-2;
	r.gid = (int)-2;
E 8

	scramble(arg->id, uname);
	scramble(arg->pw, pw);

#ifdef USER_CACHE
D 2
	cache_entry = check_cache(uname);
	if (cache_entry >= 0) 
	   {
	      c1 = strlen(pw);
	      c2 = strlen(User_cache[cache_entry].cpw);
	      if ((!c1 && !c2) ||
	  	 !(strcmp(User_cache[cache_entry].cpw,
		  crypt(pw, User_cache[cache_entry].cpw)))) 
                 {
		 r.ar_stat = AUTH_RES_OK;
		 r.ar_uid = User_cache[cache_entry].cuid;
		 r.ar_gid = User_cache[cache_entry].cgid;
		 return ((char *) &r);
		 }
		User_cache[cache_entry].cuname[0] = '\0'; /* nuke entry */
	    }
E 2
I 2
	if(check_cache(uname, pw, &r.uid, &r.gid)) {
		 r.stat = AUTH_RES_OK;
I 5
#ifdef WTMP
D 7
		wlogin(uname, "?unknown?");
E 7
I 7
		wlogin(uname);
E 7
#endif
E 5
		 return (&r);
   }
E 2
#endif
I 2

E 2
	p = get_password(uname);
	if (p == (struct passwd *)NULL)
	   return (&r);

	c1 = strlen(pw);
	c2 = strlen(p->pw_passwd);
	if ((c1 && !c2) || (c2 && !c1) ||
	   (strcmp(p->pw_passwd, crypt(pw, p->pw_passwd)))) 
           {
	   return (&r);
	   }
	r.stat = AUTH_RES_OK;
	r.uid = p->pw_uid;
	r.gid = p->pw_gid;
I 5
#ifdef WTMP
D 7
		wlogin(uname, "?unknown?");
E 7
I 7
		wlogin(uname);
E 7
#endif
E 5

#ifdef USER_CACHE
	add_cache_entry(p);
#endif

return(&r);
}

pr_init_results *pcnfsd_pr_init_1(pi_arg)
pr_init_args *pi_arg;
{
static pr_init_results pi_res;
D 3
int    dir_mode = 0777;
E 3

D 3
#ifdef USE_LP
#ifndef SYSV
union wait      status;
#else
unsigned int    status;
#endif
#endif
E 3
I 3
	pi_res.stat =
	  (pirstat) pr_init(pi_arg->system, pi_arg->pn, &pi_res.dir);
E 3

D 3
	(void)mkdir(sp_name, dir_mode);	/* just in case, ignoring the result */
	(void)chmod(sp_name, dir_mode);

	/* get pathname of current directory and return to client */

	(void)sprintf(pathname,"%s/%s",sp_name,pi_arg->system);
	(void)mkdir(pathname, dir_mode);	/* ignore the return code */

	if (stat(pathname, &statbuf) || !(statbuf.st_mode & S_IFDIR)) 
           {
	   (void)sprintf(tempstr,
		         "rpc.pcnfsd: unable to create spool directory %s\n",
		 	  pathname);
            msgout(tempstr);
	    pathname[0] = 0;/* null to tell client bad vibes */
	    pi_res.stat = PI_RES_FAIL;
	    } 
	else 
	   {
	   pi_res.stat = PI_RES_OK;
	   }
	pi_res.dir = &pathname[0];
	(void)chmod(pathname, dir_mode);


E 3
return(&pi_res);
}

pr_start_results *pcnfsd_pr_start_1(ps_arg)
pr_start_args *ps_arg;
{
static pr_start_results ps_res;
D 3
int             pid;
char            printer_opt[64];
char            jobname_opt[64];
char            clientname_opt[64];
char            snum[20];
E 3
I 3
char *dummyptr;
E 3

D 3
#ifdef HACK_FOR_ROTATED_TRANSCRIPT
char            scratch[512];
#endif


	/* 
	**--------------------------------------------------------------
	** When child terminates it sends a signal which we must catch 
	**--------------------------------------------------------------
	*/

	(void)signal(SIGCHLD, free_child);	
	(void)sprintf(pathname,"%s/%s/%s",sp_name,
	                         ps_arg->system,
	                         ps_arg->file);	


	if (stat(pathname, &statbuf)) 
           {
	   /*
           **-----------------------------------------------------------------
	   ** We can't stat the file. Let's try appending '.spl' and
	   ** see if it's already in progress.
           **-----------------------------------------------------------------
	   */

	   (void)strcat(pathname, ".spl");
	   if (stat(pathname, &statbuf)) 
	      {
	      /*
              **----------------------------------------------------------------
	      ** It really doesn't exist.
              **----------------------------------------------------------------
	      */


	      ps_res.stat = PS_RES_NO_FILE;
	      return (&ps_res);
	      }
	      /*
              **-------------------------------------------------------------
	      ** It is already on the way.
              **-------------------------------------------------------------
	      */


		ps_res.stat = PS_RES_ALREADY;
		return (&ps_res);
	     }

	if (statbuf.st_size == 0) 
	   {
	   /*
           **-------------------------------------------------------------
	   ** Null file - don't print it, just kill it.
           **-------------------------------------------------------------
	   */
	   (void)unlink(pathname);

	    ps_res.stat = PS_RES_NULL;
	    return (&ps_res);
	    }
	 /*
         **-------------------------------------------------------------
	 ** The file is real, has some data, and is not already going out.
	 ** We rename it by appending '.spl' and exec "lpr" to do the
	 ** actual work.
         **-------------------------------------------------------------
	 */
	(void)strcpy(new_pathname, pathname);
	(void)strcat(new_pathname, ".spl");

	/*
        **-------------------------------------------------------------
	** See if the new filename exists so as not to overwrite it.
        **-------------------------------------------------------------
	*/


	if (!stat(new_pathname, &statbuf)) 
	   {
	   (void)strcpy(new_pathname, pathname);  /* rebuild a new name */
	   (void)sprintf(snum, "%d", rand());	  /* get some number */
	   (void)strncat(new_pathname, snum, 3);
	   (void)strcat(new_pathname, ".spl");	  /* new spool file */
	    }
	if (rename(pathname, new_pathname)) 
	   {
	   /*
           **---------------------------------------------------------------
	   ** Should never happen.
           **---------------------------------------------------------------
           */
	   (void)sprintf(tempstr, "rpc.pcnfsd: spool file rename (%s->%s) failed.\n",
			pathname, new_pathname);
                msgout(tempstr);
		ps_res.stat = PS_RES_FAIL;
		return (&ps_res);
	    }
	pid = fork();
	if (pid == 0) 
	   {
	   /*
           **---------------------------------------------------------------
	   ** FLUKE jps 28-jul-86 - Invoke lpr as the requesting user.
	   ** 
	   ** If possible, invoke lpr under the user-id/group-id of the
	   ** person (apparently) making this RPC request.  Good for
	   ** accounting, proper banner page, etc.  It is not
	   ** mandatory.
           **---------------------------------------------------------------
	   */
	   struct passwd  *pw = getpwnam(ps_arg->user);

	   if (pw) 
	      {
		/*
                **-----------------------------------------------------------
		** Note fix: we must set our GID before our UID,
		** otherwise we don't have the privilege of setting
		** our GID!!!
                **-----------------------------------------------------------
		*/
	      (void)setregid(pw->pw_gid, pw->pw_gid);
	      (void)setreuid(pw->pw_uid, pw->pw_uid);
		/*
                **-----------------------------------------------------------
		** PC-NFS doesn't pass us any filename to show on
		** the banner page, so we blank this field out.
		** That's batter than showing the pseudo-random
		** temporary file name used internally (or the
		** UNIX-ism "(stdin)").
                **-----------------------------------------------------------
		*/
		(void)sprintf(printer_opt, "-P%s", ps_arg->pr);
		(void)sprintf(jobname_opt, "-J ");
		(void)sprintf(clientname_opt, "-C%s", ps_arg->system);
		} 
	     else 
	        {
		/*
                **--------------------------------------------------------
		** We don't know the user's identity, so the
		** printout will end up being enqueued by root.
		** We do want the user's name to appear on the
		** banner page, so we slip it in via the -J
		** option.
                **--------------------------------------------------------
		*/
		(void)sprintf(printer_opt, "-P%s", ps_arg->pr);
		(void)sprintf(jobname_opt, "-J%s", ps_arg->user);
		(void)sprintf(clientname_opt, "-C%s", ps_arg->system);
		}

#ifdef HACK_FOR_ROTATED_TRANSCRIPT
		if (!strcmp(ps_arg->pr, "rotated")) {
		   (void)sprintf(scratch, "enscript -lrq -fCourier7  %s",
		  	             new_pathname);
		system(scratch);
		(void)unlink(new_pathname);
		exit(0);
		}
		if (!strcmp(ps_arg->pr, "2column")) 
	           {
		   (void)sprintf(scratch, "enscript -2rqG -J\"PC-NFS spool file\" %s",
				new_pathname);
			system(scratch);
			(void)unlink(new_pathname);
			exit(0);
		    }
#endif

		if (ps_arg->opts[1] == 'd') 
	           {
		   /*
                   **------------------------------------------------------
		   ** This is a Diablo print stream. Apply the ps630
		   ** filter with the appropriate arguments.
                   **------------------------------------------------------
		   */
		   (void)run_ps630(new_pathname, ps_arg->opts);
		   }
		/*
                **----------------------------------------------------------
		** New - let's close up 0, 1 and 2 to force getlogin to
		** fail in lpr
                **----------------------------------------------------------
		*/
		(void)close(0);
		(void)close(1);
		(void)close(2);

#ifdef USE_LP 
	        /*
                **----------------------------------------------------------
	        **  What lpr hasn't been port to SYSV ? 
	        **  I like lpr, but I haven't got around to porting it yet
                **  and I doubt Interactive would even have a clue.  So use
	        **  System V lp.   Add your own options, these are the min.
	        **  that make it work. 
	        **  Use the copy option so we can remove the orignal spooled
	        **  nfs file from the spool directory.
                **----------------------------------------------------------
	        */
		(void)execlp("/usr/bin/lp",
			"lp",
	                "-c",           /* Copy the file     */
	                "-s",           /* Suppress messages */ 
			new_pathname,
			0);
		msgout("rpc.pcnfsd: exec lp failed");
		exit(1);	
#else
		(void)execlp("/usr/ucb/lpr",
			"lpr",
			"-s",
			"-r",
			printer_opt,
			jobname_opt,
			clientname_opt,
			new_pathname,
			0);
		msgout("rpc.pcnfsd: exec lpr failed");
		exit(1);	/* end of child process */
#endif
	   } 
	   else 
	      if (pid == -1) 
	         {
		    msgout("rpc.pcnfsd: fork failed");

		 ps_res.stat = PS_RES_FAIL;
	         } 
	      else 
	         {
		 ps_res.stat = PS_RES_OK;
#ifdef USE_LP 

	         /* 
                 **-------------------------------------------------------
	         ** We must wait until the file has been copied  
	         ** before we remove it.
                 **-------------------------------------------------------
	         */ 
	         pid = wait(&status);
	         (void)unlink(new_pathname);
#endif
	         }

E 3
I 3
	ps_res.stat =
D 4
	  (psrstat) pr_start(ps_arg->system, ps_arg->pr, ps_arg->user,
E 4
I 4
D 6
	  (psrstat) pr_start(ps_arg->system, ps_arg->pn, ps_arg->user,
E 6
I 6
	  (psrstat) pr_start2(ps_arg->system, ps_arg->pn, ps_arg->user,
E 6
E 4
	  ps_arg ->file, ps_arg->opts, &dummyptr);
E 3

return(&ps_res);
}

D 2
/*
**---------------------------------------------------------------------
**                 User cache support procedures 
**---------------------------------------------------------------------
*/


#ifdef USER_CACHE
int
check_cache(name)
	char           *name;
{
	int             i;

	for (i = 0; i < CACHE_SIZE; i++) {
		if (!strcmp(User_cache[i].cuname, name))
			return (i);
	}
	return (-1);
}

add_cache_entry(p)
	struct passwd  *p;
{
	int             i;

	for (i = CACHE_SIZE - 1; i > 0; i--)
		User_cache[i] = User_cache[i - 1];
	User_cache[0].cuid = p->pw_uid;
	User_cache[0].cgid = p->pw_gid;
	(void)strcpy(User_cache[0].cpw, p->pw_passwd);
	(void)strcpy(User_cache[0].cuname, p->pw_name);
}


#endif				/* USER_CACHE */
E 2
E 1
