h42740
s 00023/00016/00543
d D 1.8 91/07/24 08:16:10 geoff 8 7
c lint fixes, add watchdog to crowbar runaway subpprocesses, 
c also make sure that aliases (virtual printers) show up in the 
c printer list
e
s 00040/00040/00519
d D 1.7 91/05/02 10:34:22 geoff 7 6
c snapshort after SVR4 checkout
e
s 00057/00000/00502
d D 1.6 91/03/11 16:00:29 geoff 6 5
c another snapshot
e
s 00170/00018/00332
d D 1.5 91/03/11 04:24:19 geoff 5 4
c snapshot
e
s 00102/00007/00248
d D 1.4 91/03/07 14:59:31 geoff 4 3
c add su_popen support; status check, new lp-based startprint
e
s 00067/00000/00188
d D 1.3 91/03/06 16:21:39 geoff 3 2
c snapshot before doing more status stuff
e
s 00086/00009/00102
d D 1.2 91/03/05 17:18:53 geoff 2 1
c print queues now returned ok; some tests in harness
e
s 00111/00000/00000
d D 1.1 91/03/05 13:35:58 geoff 1 0
c date and time created 91/03/05 13:35:58 by geoff
e
u
U
f e 0
t
T
I 1
#include <stdio.h>
#include <rpc/rpc.h>
I 8
#include <malloc.h>
E 8
#include "pcnfsd.h"

I 3
CLIENT *cl;
E 3
CLIENT *cl2;
char *server;
I 5
char spooldirbuff[256];
E 5
I 4
char filenamebuff[256];
I 5
char last_id[32] = "";
E 5
E 4

void free_pr_list_item();
I 2
void free_pr_queue_item();
I 8
void good();
void bad();
E 8
E 2

I 5

E 5
main(argc, argv)
int argc;
char *argv[];
{

I 4
D 7
char *host;
E 7
I 7
char *host_name;
E 7
char *printer;
D 7
char *user;
E 7
I 7
char *user_name;
E 7
char *passwd;

E 4
	if(argc != 6) {
		fprintf(stderr, "usage: %s server host printer user password\n",
			argv[0]);
		exit(1);
	}

	server = argv[1];
I 4
D 7
	host = argv[2];
E 7
I 7
	host_name = argv[2];
E 7
	printer = argv[3];
D 7
	user = argv[4];
E 7
I 7
	user_name = argv[4];
E 7
	passwd = argv[5];
E 4

I 3
	cl = clnt_create(server, PCNFSDPROG, PCNFSDVERS, "udp");
	if(cl == NULL) {
		clnt_pcreateerror(server);
		exit(1);
	}
E 3
	cl2 = clnt_create(server, PCNFSDPROG, PCNFSDV2, "udp");
	if(cl2 == NULL) {
		clnt_pcreateerror(server);
		exit(1);
	}
I 3
D 4
	test_v2_auth(argv[4], argv[5]);
E 3
	test_v2_init(argv[2], argv[3]);
E 4
I 4
D 5
	test_v2_auth(user, passwd);
E 5
I 5
	good();
	test_v2_info();
	good();
D 7
	test_v2_auth(host, user, passwd);
E 7
I 7
	test_v2_auth(host_name, user_name, passwd);
E 7
D 8
	bad();
E 8
I 8
	bad("Invalid password");
E 8
D 7
	test_v2_auth(host, user, "bogus");
E 7
I 7
	test_v2_auth(host_name, user_name, "bogus");
E 7
	good();
E 5
E 4
	test_v2_list();
I 5
	good();
E 5
I 2
D 4
	test_v2_queue(argv[3], argv[4], FALSE);
	test_v2_queue(argv[3], argv[4], TRUE);
E 4
I 4
D 7
	test_v2_init(host, printer);
E 7
I 7
	test_v2_init(host_name, printer);
E 7
D 5
	test_v2_start(host, printer, user);
E 5
I 5
	good();
D 7
	test_v2_start(host, printer, user, "foo", "foo");
E 7
I 7
	test_v2_start(host_name, printer, user_name, "foo", "foo");
E 7
	good();
D 7
	test_v2_start(host, printer, user, "bar", "bar");
E 7
I 7
	test_v2_start(host_name, printer, user_name, "bar", "bar");
E 7
D 8
	bad();
E 8
I 8
	bad("No such file to print");
E 8
D 7
	test_v2_start(host, printer, user, "bletch", "gack");
E 7
I 7
	test_v2_start(host_name, printer, user_name, "bletch", "gack");
E 7
	good();
E 5
D 7
	test_v2_queue(printer, user, FALSE);
E 7
I 7
	test_v2_queue(printer, user_name, FALSE);
E 7
I 5
	if(strlen(last_id)) {
D 8
	good();
E 8
I 8
		bad("Cancelling job with bad username");
		test_v2_cancel(host_name, printer, "nosuchuser", last_id);
		good();
E 8
D 7
		test_v2_cancel(host, printer, user, last_id);
E 7
I 7
		test_v2_cancel(host_name, printer, user_name, last_id);
E 7
	}
D 8
	bad();
E 8
I 8
	bad("Cancelling unknown job");
E 8
D 7
	test_v2_cancel(host, printer, user, "99999");
E 7
I 7
	test_v2_cancel(host_name, printer, user_name, "99999");
E 7
D 8
	bad();
D 7
	test_v2_cancel(host, printer, "nosuchuser", last_id);
E 7
I 7
	test_v2_cancel(host_name, printer, "nosuchuser", last_id);
E 7
	bad();
E 8
I 8
	bad("Cancelling job on invalid printer");
E 8
D 7
	test_v2_cancel(host, "nosuchprinter", user, last_id);
E 7
I 7
	test_v2_cancel(host_name, "nosuchprinter", user_name, last_id);
E 7
	good();
E 5
D 7
	test_v2_queue(printer, user, TRUE);
E 7
I 7
	test_v2_queue(printer, user_name, TRUE);
E 7
I 5
D 8
	bad();
E 8
I 8
	bad("Checking queue on invalid printer");
E 8
D 7
	test_v2_queue("nosuchprinter", user, TRUE);
E 7
I 7
	test_v2_queue("nosuchprinter", user_name, TRUE);
E 7
	good();
E 5
	test_v2_stat(printer);
I 5
D 8
	bad();
E 8
I 8
	bad("Checking status of invalid printer");
E 8
	test_v2_stat("nosuchprinter");
I 6
	good();
	test_v2_map();
I 8
	exit(0);
/*NOTREACHED*/
E 8
E 6
E 5
E 4
I 3
}

#define zchar           0x5b

void
scramble(s1, s2)
char           *s1;
char           *s2;
{
        while (*s1) 
              {
              *s2++ = (*s1 ^ zchar) & 0x7f;
              s1++;
              }
        *s2 = 0;
}



D 5
test_v2_auth(user, password)
E 5
I 5
test_v2_info()
{
v2_info_args a;
v2_info_results *rp;
int          *gp;
int             i;

	a.vers = "Sun Microsystems PCNFSD test subsystem V1";
	a.cm = "-";
	printf("\ninvoking pr_info_2\n");

	rp = pcnfsd2_info_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	
	printf("results: vers = '%s', cm = '%s'\n",
		rp->vers, rp->cm);
	printf("facilities_len = %d\n", rp->facilities.facilities_len);
	if (rp->facilities.facilities_len) {
		gp = rp->facilities.facilities_val;
		for(i = 0; i < rp->facilities.facilities_len; i++)
			printf(" procedure %2d: %6d\n", i, *gp++);
		printf("\n");
	}
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	if(rp->facilities.facilities_val)
		free(rp->facilities.facilities_val);
	if(rp->vers)
		free(rp->vers);
	
	return(0);
}

D 7
test_v2_auth(host, user, password)
char *host;
E 5
char *user;
char *password;
E 7
I 7
test_v2_auth(host_name, user_name , pwrd)
char *host_name;
char *user_name;
char *pwrd;
E 7
{
v2_auth_args a;
v2_auth_results *rp;
char            uname[32];
char            pw[64];
u_int          *gp;
int             i;

D 7
	scramble(user, uname);
	scramble(password, pw);
D 5

E 5
I 5
	a.system = host;
E 7
I 7
	scramble(user_name, uname);
	scramble(pwrd, pw);
	a.system = host_name;
E 7
E 5
	a.id = uname;
	a.pw = pw;
	a.cm = "-";
D 5
	printf("\n**********************************************************************\n");
E 5
	printf("\ninvoking pr_auth_2\n");

	rp = pcnfsd2_auth_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	
	if(rp->stat == AUTH_RES_FAIL)
		printf("results: stat = AUTH_RES_FAIL\n");
	else {
D 5
	printf("results: stat = %d, uid = %u, gid = %u, homedir= '%s', cm = '%s'\n",
E 5
I 5
	printf("results: stat = %d, uid = %u, gid = %u,\n homedir= '%s', cm = '%s'\n",
E 5
		rp->stat, rp->uid, rp->gid, rp->home, rp->cm);
	printf("gids_len = %d", rp->gids.gids_len);
	if (rp->gids.gids_len) {
		gp = rp->gids.gids_val;
		for(i = 0; i < rp->gids.gids_len; i++)
			printf(" %u", *gp++);
		printf("\n");
	}
D 5
	}	
E 5
I 5
	}
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	if(rp->gids.gids_val)
		free(rp->gids.gids_val);
	if(rp->home)
		free(rp->home);
	
E 5
	return(0);
E 3
E 2
}

D 5

E 5
D 7
test_v2_init(host, printer)
char *host;
E 7
I 7
test_v2_init(host_name, printer)
char *host_name;
E 7
char *printer;
{
v2_pr_init_args a;
v2_pr_init_results *rp;

D 7
	a.system = host;
E 7
I 7
	a.system = host_name;
E 7
	a.pn = printer;
	a.cm = "-";
D 2

E 2
I 2
D 5
	printf("\n**********************************************************************\n");
E 5
E 2
	printf("\ninvoking pr_init_2\n");

	rp = pcnfsd2_pr_init_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: stat = %d, dir = '%s', cm = '%s'\n",
		rp->stat, rp->dir, rp->cm);
I 4
D 5
	strcpy(filenamebuff, rp->dir);
E 5
I 5
	strcpy(spooldirbuff, rp->dir);
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	if(rp->dir)
		free(rp->dir);
E 5
E 4
	return(0);
}


I 4
D 5
test_v2_start(host, printer, user)
E 5
I 5
D 7
test_v2_start(host, printer, user, tag1, tag2)
E 5
char *host;
E 7
I 7
test_v2_start(host_name, printer, user_name, tag1, tag2)
char *host_name;
E 7
char *printer;
D 7
char *user;
E 7
I 7
char *user_name;
E 7
I 5
char *tag1;
char *tag2;
E 5
{
v2_pr_start_args a;
v2_pr_start_results *rp;
FILE *fp;
D 5
printf("\n**********************************************************************\n");
E 5
	printf("\ntesting start print v2\n");

	if(strcmp(server, "localhost")) {
		printf("sorry - can only test start print on 'localhost'\n");
D 8
		return;
E 8
I 8
		return(1);
E 8
	}

D 5
	strcat(filenamebuff, "/");
	strcat(filenamebuff, "foo");
E 5
I 5
	sprintf(filenamebuff, "%s/%s", spooldirbuff, tag1);
E 5

	fp = fopen(filenamebuff, "w");
	if(fp == NULL) {
		perror("creating test file");
D 8
		return;
E 8
I 8
		return(1);
E 8
	}
	(void)fputs("foo bar bletch\n", fp);
	(void)fclose(fp);

D 7
	a.system = host;
E 7
I 7
	a.system = host_name;
E 7
	a.pn = printer;
D 7
	a.user = user;
E 7
I 7
	a.user = user_name;
E 7
D 5
	a.file = "foo";
E 5
I 5
	a.file = tag2;
E 5
	a.opts = "xxxx";
I 5
	a.copies = 1;
E 5
	a.cm = "-";

	printf("\ninvoking pr_start_2\n");

	rp = pcnfsd2_pr_start_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: stat = %d, jobid = '%s', cm = '%s'\n",
		rp->stat, rp->id, rp->cm);
I 5
	if(rp->stat == PS_RES_OK)
		strcpy(last_id, rp->id);
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	if(rp->id)
		free(rp->id);
E 5
	return(0);
}


I 5
D 7
test_v2_cancel(host, printer, user, id)
char *host;
E 7
I 7
test_v2_cancel(host_name, printer, user_name, id)
char *host_name;
E 7
char *printer;
D 7
char *user;
E 7
I 7
char *user_name;
E 7
char *id;
{
v2_pr_cancel_args a;
v2_pr_cancel_results *rp;
D 8
FILE *fp;
E 8
	printf("\ntesting cancel print v2\n");

D 7
	a.system = host;
E 7
I 7
	a.system = host_name;
E 7
	a.pn = printer;
D 7
	a.user = user;
E 7
I 7
	a.user = user_name;
E 7
	a.id = id;
	a.cm = "-";

	printf("\ninvoking pr_cancel_2 for job %s on printer %s\n",
		id, printer);

	rp = pcnfsd2_pr_cancel_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: stat = %d, cm = '%s'\n",
		rp->stat, rp->cm);
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	return(0);
}
E 5
E 4
test_v2_list()
{
char a;
v2_pr_list_results *rp;
pr_list curr;

I 2
D 5
	printf("\n**********************************************************************\n");
E 5
E 2

	printf("\ninvoking pr_list_2\n");

	rp = pcnfsd2_pr_list_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: cm = '%s', printerlist:\n", rp->cm);
	curr = rp->printers;
	while(curr) {
D 4
		printf("  name '%s' ", curr->pr);
E 4
I 4
		printf("  name '%s' ", curr->pn);
E 4
D 2
		if(curr->location.is_remote)
E 2
I 2
		if(strlen(curr->remhost))
E 2
			printf("remote: srvr '%s', name '%s'",
D 2
				curr->location.loc_info_u.rem.remhost,
				curr->location.loc_info_u.rem.rempr);
E 2
I 2
				curr->remhost,
				curr->device);
E 2
		else
D 2
			printf("local");
E 2
I 2
			printf("local device = '%s'", curr->device);
E 2
		printf(", cm = '%s'\n", curr->cm);
		curr = curr->pr_next;
	}
	printf("end of list\n");
I 5
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
E 5
	if(rp->printers) {
		printf("freeing results\n");
		free_pr_list_item(rp->printers);
	}
	return(0);
}


void
free_pr_list_item(curr)
pr_list curr;
{
D 4
	if(curr->pr)
		free(curr->pr);
E 4
I 4
	if(curr->pn)
		free(curr->pn);
E 4
D 2
	if(curr->location.loc_info_u.rem.remhost)
		free(curr->location.loc_info_u.rem.remhost);
	if(curr->location.loc_info_u.rem.rempr)
		free(curr->location.loc_info_u.rem.rempr);
E 2
I 2
	if(curr->remhost)
		free(curr->remhost);
	if(curr->device)
		free(curr->device);
E 2
	if(curr->cm)
		free(curr->cm);
	if(curr->pr_next)
		free_pr_list_item(curr->pr_next); /* recurse */
	free(curr);
}

I 2


D 7
test_v2_queue(printer, user, private)
E 7
I 7
test_v2_queue(printer, user_name, private)
E 7
char *printer;
D 7
char *user;
E 7
I 7
char *user_name;
E 7
int private;
{
struct v2_pr_queue_args a;
v2_pr_queue_results *rp;
pr_queue curr;

	a.pn = printer;
	a.system = "foo";
D 7
	a.user = user;
E 7
I 7
	a.user = user_name;
E 7
	a.just_mine = private;
	a.cm = "no";
D 5
	printf("\n**********************************************************************\n");
E 5

	printf("\ninvoking pr_queue_2 (just_mine = %d)\n", private);

	rp = pcnfsd2_pr_queue_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: stat = %d, qlen = %d, qshown = %d cm = '%s', queue:\n",
		rp->stat, rp->qlen, rp->qshown, rp->cm);
	curr = rp->jobs;
	while(curr) {
		printf("rank = %2d, id = '%s', size = '%s', status = '%s'\n",
			curr->position,
			curr->id,
			curr->size,
			curr->status);
		printf("            user = '%s', file = '%s', cm = '%s'\n",
			curr->user,
			curr->file,
			curr->cm);
		curr = curr->pr_next;
	}
	printf("end of list\n");
I 5
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
E 5
	if(rp->jobs) {
		printf("freeing results\n");
		free_pr_queue_item(rp->jobs);
	}
	return(0);
}



void
free_pr_queue_item(curr)
pr_queue curr;
{
	if(curr->id)
		free(curr->id);
	if(curr->size)
		free(curr->size);
	if(curr->status)
		free(curr->status);
	if(curr->system)
		free(curr->system);
	if(curr->user)
		free(curr->user);
	if(curr->file)
		free(curr->file);
	if(curr->cm)
		free(curr->cm);
	if(curr->pr_next)
		free_pr_queue_item(curr->pr_next); /* recurse */
	free(curr);
}
I 4



test_v2_stat(printer)
char *printer;
{
v2_pr_status_args a;
v2_pr_status_results *rp;

D 5
printf("\n**********************************************************************\n");
E 5
	printf("\ntesting status print v2\n");

	a.pn = printer;
	a.cm = "-";

	printf("\ninvoking pr_status_2\n");

	rp = pcnfsd2_pr_status_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: stat = %d, cm = '%s'\n",
		rp->stat, rp->cm);
	if(rp->stat == PI_RES_OK) {
		printf("avail = %s, ", (rp->avail ? "YES" : "NO"));
		printf("printing = %s, ", (rp->printing ? "YES" : "NO"));
		printf("needs_operator = %s, ", (rp->needs_operator ? "YES" : "NO"));
		printf("qlen = %d, status = '%s'\n", rp->qlen, rp->status);
	}
I 5
/* free up allocated strings */
	if(rp->cm)
		free(rp->cm);
	if(rp->status)
		free(rp->status);
D 8
	if(rp->needs_operator)
		free(rp->needs_operator);

E 8
E 5
	return(0);
I 6
}

struct mapreq_arg_item * make_mapreq_entry(t, i, n, next)
mapreq	t;
int i;
char *n;
struct mapreq_arg_item *next;
{
struct mapreq_arg_item *x;
	x = (struct mapreq_arg_item *)malloc(sizeof(struct mapreq_arg_item));
	if(x == NULL) {
		fprintf(stderr, "out of memory\n");
		exit(123);
	}
	x->req = t;
	x->id = i;
	x->name = (n ? n : "");
	x->mapreq_next = next;
	return(x);
}

test_v2_map()
{
v2_mapid_args a;
v2_mapid_results *rp;
struct mapreq_res_item *rip;

	a.cm = "-";
	a.req_list = make_mapreq_entry(MAP_REQ_UID, 906, NULL,
		make_mapreq_entry(MAP_REQ_GID, 1, NULL,
		 make_mapreq_entry(MAP_REQ_UNAME, 0, "root",
		   make_mapreq_entry(MAP_REQ_GNAME, 0, "wheel", 
		      make_mapreq_entry(MAP_REQ_UNAME, 0, "bogus", NULL)))));

	printf("\ninvoking pr_mapid_2\n");
	rp = pcnfsd2_mapid_2(&a, cl2);

	if(rp == NULL) {
		clnt_perror(cl2, server);
		return(1);
	}
	printf("results: cm = '%s', result list %s\n",
		rp->cm, rp->res_list ? "follows" : "omitted");
	rip = rp->res_list;
	while(rip) {
		printf("request type = %d, status = %d, id = %d, name = '%s'\n",
			rip->req, rip->stat, rip->id, 
			(rip->name ? rip->name : "(NULL)"));
		rip = rip->mapreq_next;
	}
/* XXX should free up results */



return(0);
E 6
}

I 5

I 8
void
E 8
good()
{
printf("\n");
printf("********************************************************\n");
printf("********************************************************\n");
printf("**      The following test is expected to SUCCEED     **\n");
printf("********************************************************\n");
printf("********************************************************\n");
}
D 8
bad()
E 8
I 8

void
bad(reason)
char *reason;
E 8
{
printf("\n");
printf("********************************************************\n");
printf("********************************************************\n");
printf("**      The following test is expected to FAIL        **\n");
I 8
printf("**                    Reason:                         **\n");
printf("** %50s **\n", reason);
E 8
printf("********************************************************\n");
printf("********************************************************\n");
}
E 5
E 4
E 2
E 1
