h47694
s 00412/00030/00808
d D 1.9 91/07/24 08:16:12 geoff 9 8
c lint fixes, add watchdog to crowbar runaway subpprocesses, 
c also make sure that aliases (virtual printers) show up in the 
c printer list
e
s 00176/00015/00662
d D 1.8 91/05/02 10:34:26 geoff 8 7
c snapshort after SVR4 checkout
e
s 00006/00339/00671
d D 1.7 91/04/15 15:53:59 geoff 7 6
c consolidate stuff
e
s 00014/00014/00996
d D 1.6 91/04/12 14:16:12 geoff 6 5
c change msgout to msg_out for SVR4
e
s 00039/00002/00971
d D 1.5 91/03/11 04:24:28 geoff 5 4
c snapshot
e
s 00208/00012/00765
d D 1.4 91/03/07 14:59:35 geoff 4 3
c add su_popen support; status check, new lp-based startprint
e
s 00050/00000/00727
d D 1.3 91/03/06 16:21:41 geoff 3 2
c snapshot before doing more status stuff
e
s 00276/00001/00451
d D 1.2 91/03/05 17:18:55 geoff 2 1
c print queues now returned ok; some tests in harness
e
s 00452/00000/00000
d D 1.1 91/03/04 16:21:08 geoff 1 0
c date and time created 91/03/04 16:21:08 by geoff
e
u
U
f e 0
t
T
I 1
/*
**=====================================================================
** Copyright (c) 1986,1987,1988,1989,1990,1991 by Sun Microsystems, Inc.
I 7
D 8
**	%W% %G%
E 8
I 8
**	%W%	%G%
E 8
E 7
**=====================================================================
*/
D 7

E 7
I 7
#include "common.h"
E 7
/*
**=====================================================================
D 7
**             C U S T O M I Z A T I O N   S E C T I O N              *
**                                                                    *
** You should not uncomment these #defines in this version of pcnfsd  *
** Instead you should edit the makefile CDEFS variable.               *
**                                                                    *
**=====================================================================
*/

/*
**------------------------------------------------------------------------
** Define (via Makefile) the following symbol conform to Interactive
** System's 2.0
**------------------------------------------------------------------------
*/

/* #define ISC_2_0 */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a System V version
**---------------------------------------------------------------------
*/

/* #define SYSV */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a version that uses
** System V style "lp" instead of BSD-style "lpr" to print
**---------------------------------------------------------------------
*/

/* #define USE_LP */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a typical
** "local feature": in this case recognizing the special printer
** names "rotated" and "2column" and using the Adobe "enscript"
** command to format the output appropriately.
**---------------------------------------------------------------------
*/

/* #define HACK_FOR_ROTATED_TRANSCRIPT */

/*
**---------------------------------------------------------------------
** The following definitions may be overridden if desired.
**---------------------------------------------------------------------
*/

#ifndef SPOOLDIR
#define SPOOLDIR	"/usr/spool/pcnfs"
#endif	

/*
**---------------------------------------------------------------------
** The following should force the right things for Interactive 2.0
**---------------------------------------------------------------------
*/
#ifdef ISC_2_0
#define SYSV
#define USE_LP
#endif

/*
**=====================================================================
E 7
**             I N C L U D E   F I L E   S E C T I O N                *
**                                                                    *
** If your port requires different include files, add a suitable      *
** #define in the customization section, and make the inclusion or    *
** exclusion of the files conditional on this.                        *
**=====================================================================
*/
#include "pcnfsd.h"
D 8

E 8
I 8
#include <malloc.h>
E 8
#include <stdio.h>
#include <pwd.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>

#ifndef SYSV
#include <sys/wait.h>
#endif

#ifdef ISC_2_0
#include <sys/fcntl.h>
#endif

#ifdef SHADOW_SUPPORT
#include <shadow.h>
#endif

/*
**---------------------------------------------------------------------
** Other #define's 
**---------------------------------------------------------------------
*/
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

I 7
#ifndef SPOOLDIR
D 9
#define SPOOLDIR        "/usr/spool/pcnfs"
E 9
I 9
#define SPOOLDIR        "/var/spool/pcnfs"
E 9
#endif

I 9
/*
** The following defintions give the maximum time allowed for
** an external command to run (in seconds)
*/
#define MAXTIME_FOR_PRINT	10
#define MAXTIME_FOR_QUEUE	10
#define MAXTIME_FOR_CANCEL	10
#define MAXTIME_FOR_STATUS	10

E 9
E 7
I 2
#define QMAX 50

/*
** The following is derived from ucb/lpd/displayq.c
*/
#define SIZECOL 62
#define FILECOL 24

D 9
#define LPSTATCOM "/usr/bin/lpstat -s"

E 2
D 7
#define assert(ex) {if (!(ex)) \
    {(void)fprintf(stderr,"pcnfsd: Assertion failed: line %d of %s: \"%s\"\n", \
    __LINE__, __FILE__, "ex"); \
    sleep (30); exit(1);}}
E 7

E 9
D 7

E 7
extern void     scramble();
D 8
extern void     free_child();
E 8
extern void     run_ps630();
extern char    *crypt();
I 4
extern FILE    *su_popen();
extern int      su_pclose();
E 4
I 2
int             build_pr_list();
I 8
char 	       *map_printer_name();
char	       *expand_alias();
E 8
void           *grab();
void            free_pr_list_item();
void            free_pr_queue_item();
I 9
pr_list		list_virtual_printers();
E 9
E 2

/*
**---------------------------------------------------------------------
**                       Misc. variable definitions
**---------------------------------------------------------------------
*/

extern int      errno;
I 9
extern int	interrupted;	/* in pcnfsd_misc.c */
E 9
struct stat     statbuf;
char            pathname[MAXPATHLEN];
char            new_pathname[MAXPATHLEN];
char            sp_name[MAXPATHLEN] = SPOOLDIR;
char            tempstr[256];
I 2
D 9
char            delims[] = " \t\r\n";
E 9
I 9
char            delims[] = " \t\r\n:()";
E 9
E 2

I 2
pr_list         printers = NULL;
pr_queue        queue = NULL;

E 2
/*
**=====================================================================
D 9
**                      C O D E   S E C T I O N                       *                    **=====================================================================
E 9
I 9
**                      C O D E   S E C T I O N                       *
**=====================================================================
E 9
*/


int
valid_pr(pr)
char *pr;
{
D 2
return(1);
E 2
I 2
D 8
	if(printers != NULL || build_pr_list()) {
	}
E 8
I 8
char *p;
pr_list curr;
	if(printers == NULL)
		build_pr_list();
E 8

D 8
	return(1);
E 8
I 8
	if(printers == NULL)
		return(1); /* can't tell - assume it's good */

	p = map_printer_name(pr);
	if (p == NULL)
		return(1);	/* must be ok is maps to NULL! */
	curr = printers;
	while(curr) {
		if(!strcmp(p, curr->pn))
			return(1);
		curr = curr->pr_next;
	}
		
	return(0);
E 8
E 2
}

pirstat pr_init(sys, pr, sp)
char *sys;
char *pr;
char**sp;
{
int    dir_mode = 0777;

	*sp = &pathname[0];

	/* get pathname of current directory and return to client */

	(void)sprintf(pathname,"%s/%s",sp_name, sys);
	(void)mkdir(pathname, dir_mode);	/* ignore the return code */
	(void)chmod(pathname, dir_mode);

	if (stat(pathname, &statbuf) || !(statbuf.st_mode & S_IFDIR)) 
           {
	   (void)sprintf(tempstr,
		         "rpc.pcnfsd: unable to create spool directory %s\n",
		 	  pathname);
D 6
            msgout(tempstr);
E 6
I 6
            msg_out(tempstr);
E 6
	    pathname[0] = '\0';	/* null to tell client bad vibes */
	    return(PI_RES_FAIL);
	    }
 	if (!valid_pr(pr)) 
           {
	    pathname[0] = '\0';	/* null to tell client bad vibes */
	    return(PI_RES_NO_SUCH_PRINTER);
	    } 
	return(PI_RES_OK);

D 7
}

psrstat pr_start(system, pr, user, file, opts, id)
char *system;
char *pr;
char *user;
char *file;
char *opts;
char **id;
{
int             pid;
psrstat         res;
char            printer_opt[64];
char            jobname_opt[64];
char            clientname_opt[64];
char            snum[20];
static char     null_id[2] = "";

#ifdef HACK_FOR_ROTATED_TRANSCRIPT
char            scratch[512];
#endif


	/* 
	**--------------------------------------------------------------
	** When child terminates it sends a signal which we must catch 
	**--------------------------------------------------------------
	*/

	(void)signal(SIGCHLD, free_child);	
	(void)sprintf(pathname,"%s/%s/%s",sp_name,
	                         system,
	                         file);	

	*id = &null_id[0];

D 4

E 4
	if (stat(pathname, &statbuf)) 
           {
	   /*
           **-----------------------------------------------------------------
	   ** We can't stat the file. Let's try appending '.spl' and
	   ** see if it's already in progress.
           **-----------------------------------------------------------------
	   */

	   (void)strcat(pathname, ".spl");
	   if (stat(pathname, &statbuf)) 
	      {
	      /*
              **----------------------------------------------------------------
	      ** It really doesn't exist.
              **----------------------------------------------------------------
	      */


	      return(PS_RES_NO_FILE);
	      }
	      /*
              **-------------------------------------------------------------
	      ** It is already on the way.
              **-------------------------------------------------------------
	      */


		return(PS_RES_ALREADY);
	     }

	if (statbuf.st_size == 0) 
	   {
	   /*
           **-------------------------------------------------------------
	   ** Null file - don't print it, just kill it.
           **-------------------------------------------------------------
	   */
	   (void)unlink(pathname);

	    return(PS_RES_NULL);
	    }
	 /*
         **-------------------------------------------------------------
	 ** The file is real, has some data, and is not already going out.
	 ** We rename it by appending '.spl' and exec "lpr" to do the
	 ** actual work.
         **-------------------------------------------------------------
	 */
	(void)strcpy(new_pathname, pathname);
	(void)strcat(new_pathname, ".spl");

	/*
        **-------------------------------------------------------------
	** See if the new filename exists so as not to overwrite it.
        **-------------------------------------------------------------
	*/


	if (!stat(new_pathname, &statbuf)) 
	   {
	   (void)strcpy(new_pathname, pathname);  /* rebuild a new name */
	   (void)sprintf(snum, "%d", rand());	  /* get some number */
	   (void)strncat(new_pathname, snum, 3);
	   (void)strcat(new_pathname, ".spl");	  /* new spool file */
	    }
	if (rename(pathname, new_pathname)) 
	   {
	   /*
           **---------------------------------------------------------------
	   ** Should never happen.
           **---------------------------------------------------------------
           */
	   (void)sprintf(tempstr, "rpc.pcnfsd: spool file rename (%s->%s) failed.\n",
			pathname, new_pathname);
D 6
                msgout(tempstr);
E 6
I 6
                msg_out(tempstr);
E 6
		return(PS_RES_FAIL);
	    }
	pid = fork();
	if (pid == 0) 
	   {
	   /*
           **---------------------------------------------------------------
	   ** FLUKE jps 28-jul-86 - Invoke lpr as the requesting user.
	   ** 
	   ** If possible, invoke lpr under the user-id/group-id of the
	   ** person (apparently) making this RPC request.  Good for
	   ** accounting, proper banner page, etc.  It is not
	   ** mandatory.
           **---------------------------------------------------------------
	   */
	   struct passwd  *pw = getpwnam(user);

	   if (pw) 
	      {
		/*
                **-----------------------------------------------------------
		** Note fix: we must set our GID before our UID,
		** otherwise we don't have the privilege of setting
		** our GID!!!
                **-----------------------------------------------------------
		*/
	      (void)setregid(pw->pw_gid, pw->pw_gid);
	      (void)setreuid(pw->pw_uid, pw->pw_uid);
		/*
                **-----------------------------------------------------------
		** PC-NFS doesn't pass us any filename to show on
		** the banner page, so we blank this field out.
		** That's batter than showing the pseudo-random
		** temporary file name used internally (or the
		** UNIX-ism "(stdin)").
                **-----------------------------------------------------------
		*/
		(void)sprintf(printer_opt, "-P%s",pr);
		(void)sprintf(jobname_opt, "-J ");
		(void)sprintf(clientname_opt, "-C%s", system);
		} 
	     else 
	        {
		/*
                **--------------------------------------------------------
		** We don't know the user's identity, so the
		** printout will end up being enqueued by root.
		** We do want the user's name to appear on the
		** banner page, so we slip it in via the -J
		** option.
                **--------------------------------------------------------
		*/
		(void)sprintf(printer_opt, "-P%s", pr);
		(void)sprintf(jobname_opt, "-J%s", user);
		(void)sprintf(clientname_opt, "-C%s", system);
		}

#ifdef HACK_FOR_ROTATED_TRANSCRIPT
		if (!strcmp(ps_arg->pr, "rotated")) {
		   (void)sprintf(scratch, "enscript -lrq -fCourier7  %s",
		  	             new_pathname);
		system(scratch);
		(void)unlink(new_pathname);
		exit(0);
		}
		if (!strcmp(ps_arg->pr, "2column")) 
	           {
		   (void)sprintf(scratch, "enscript -2rqG -J\"PC-NFS spool file\" %s",
				new_pathname);
			system(scratch);
			(void)unlink(new_pathname);
			exit(0);
		    }
#endif

		if (*opts == 'd') 
	           {
		   /*
                   **------------------------------------------------------
		   ** This is a Diablo print stream. Apply the ps630
		   ** filter with the appropriate arguments.
                   **------------------------------------------------------
		   */
		   (void)run_ps630(new_pathname, opts);
		   }
		/*
                **----------------------------------------------------------
		** New - let's close up 0, 1 and 2 to force getlogin to
		** fail in lpr
                **----------------------------------------------------------
		*/
		(void)close(0);
		(void)close(1);
		(void)close(2);

#ifdef USE_LP 
	        /*
                **----------------------------------------------------------
	        **  What lpr hasn't been port to SYSV ? 
	        **  I like lpr, but I haven't got around to porting it yet
                **  and I doubt Interactive would even have a clue.  So use
	        **  System V lp.   Add your own options, these are the min.
	        **  that make it work. 
	        **  Use the copy option so we can remove the orignal spooled
	        **  nfs file from the spool directory.
                **----------------------------------------------------------
	        */
		(void)execlp("/usr/bin/lp",
			"lp",
	                "-c",           /* Copy the file     */
	                "-s",           /* Suppress messages */ 
			new_pathname,
			0);
D 6
		msgout("rpc.pcnfsd: exec lp failed");
E 6
I 6
		msg_out("rpc.pcnfsd: exec lp failed");
E 6
		exit(1);	
#else
		(void)execlp("/usr/ucb/lpr",
			"lpr",
			"-s",
			"-r",
			printer_opt,
			jobname_opt,
			clientname_opt,
			new_pathname,
			0);
D 6
		msgout("rpc.pcnfsd: exec lpr failed");
E 6
I 6
		msg_out("rpc.pcnfsd: exec lpr failed");
E 6
		exit(1);	/* end of child process */
#endif
	   } 
	   else 
	      if (pid == -1) 
	         {
D 6
		    msgout("rpc.pcnfsd: fork failed");
E 6
I 6
		    msg_out("rpc.pcnfsd: fork failed");
E 6

		 res = PS_RES_FAIL;
	         } 
	      else 
	         {
		 res = PS_RES_OK;
#ifdef USE_LP 

	         /* 
                 **-------------------------------------------------------
	         ** We must wait until the file has been copied  
	         ** before we remove it.
                 **-------------------------------------------------------
	         */ 
	         pid = wait(&status);
	         (void)unlink(new_pathname);
#endif
	         }


return(res);
E 7
I 2
}


I 4
D 8
psrstat pr_start2(system, pr, user, file, opts, id)
E 8
I 8
psrstat pr_start2(system, pr, user, fname, opts, id)
E 8
char *system;
char *pr;
char *user;
D 8
char *file;
E 8
I 8
char *fname;
E 8
char *opts;
char **id;
{
char            snum[20];
static char     req_id[256];
char            cmdbuf[256];
char            resbuf[256];
FILE *fd;
int i;
I 8
char *xcmd;
E 8


#ifdef HACK_FOR_ROTATED_TRANSCRIPT
char            scratch[512];
#endif



	(void)sprintf(pathname,"%s/%s/%s",sp_name,
	                         system,
D 8
	                         file);	
E 8
I 8
	                         fname);	
E 8

	*id = &req_id[0];
	req_id[0] = '\0';

	if (stat(pathname, &statbuf)) 
           {
	   /*
           **-----------------------------------------------------------------
	   ** We can't stat the file. Let's try appending '.spl' and
	   ** see if it's already in progress.
           **-----------------------------------------------------------------
	   */

	   (void)strcat(pathname, ".spl");
	   if (stat(pathname, &statbuf)) 
	      {
	      /*
              **----------------------------------------------------------------
	      ** It really doesn't exist.
              **----------------------------------------------------------------
	      */


	      return(PS_RES_NO_FILE);
	      }
	      /*
              **-------------------------------------------------------------
	      ** It is already on the way.
              **-------------------------------------------------------------
	      */


		return(PS_RES_ALREADY);
	     }

	if (statbuf.st_size == 0) 
	   {
	   /*
           **-------------------------------------------------------------
	   ** Null file - don't print it, just kill it.
           **-------------------------------------------------------------
	   */
	   (void)unlink(pathname);

	    return(PS_RES_NULL);
	    }
	 /*
         **-------------------------------------------------------------
	 ** The file is real, has some data, and is not already going out.
	 ** We rename it by appending '.spl' and exec "lpr" to do the
	 ** actual work.
         **-------------------------------------------------------------
	 */
	(void)strcpy(new_pathname, pathname);
	(void)strcat(new_pathname, ".spl");

	/*
        **-------------------------------------------------------------
	** See if the new filename exists so as not to overwrite it.
        **-------------------------------------------------------------
	*/


	if (!stat(new_pathname, &statbuf)) 
	   {
	   (void)strcpy(new_pathname, pathname);  /* rebuild a new name */
	   (void)sprintf(snum, "%d", rand());	  /* get some number */
	   (void)strncat(new_pathname, snum, 3);
	   (void)strcat(new_pathname, ".spl");	  /* new spool file */
	    }
	if (rename(pathname, new_pathname)) 
	   {
	   /*
           **---------------------------------------------------------------
	   ** Should never happen.
           **---------------------------------------------------------------
           */
	   (void)sprintf(tempstr, "rpc.pcnfsd: spool file rename (%s->%s) failed.\n",
			pathname, new_pathname);
D 6
                msgout(tempstr);
E 6
I 6
                msg_out(tempstr);
E 6
		return(PS_RES_FAIL);
	    }

		if (*opts == 'd') 
	           {
		   /*
                   **------------------------------------------------------
		   ** This is a Diablo print stream. Apply the ps630
		   ** filter with the appropriate arguments.
                   **------------------------------------------------------
		   */
		   (void)run_ps630(new_pathname, opts);
		   }
I 8
		/*
		** Try to match to an aliased printer
		*/
		xcmd = expand_alias(pr, new_pathname, user, system);
E 8
	        /*
                **----------------------------------------------------------
	        **  Use the copy option so we can remove the orignal spooled
	        **  nfs file from the spool directory.
                **----------------------------------------------------------
	        */
D 8
		sprintf(cmdbuf, "/usr/bin/lp -c -d%s %s", pr, new_pathname);
		if ((fd = su_popen(user, cmdbuf)) == NULL) {
E 8
I 8
		if(!xcmd) {
			sprintf(cmdbuf, "/usr/bin/lp -c -d%s %s",
				pr, new_pathname);
			xcmd = cmdbuf;
		}
D 9
		if ((fd = su_popen(user, xcmd)) == NULL) {
E 9
I 9
		if ((fd = su_popen(user, xcmd, MAXTIME_FOR_PRINT)) == NULL) {
E 9
E 8
D 6
			msgout("rpc.pcnfsd: su_popen failed");
E 6
I 6
			msg_out("rpc.pcnfsd: su_popen failed");
E 6
			return(PS_RES_FAIL);
		}
I 8
		req_id[0] = '\0';	/* asume failure */
E 8
		while(fgets(resbuf, 255, fd) != NULL) {
			i = strlen(resbuf);
			if(i)
				resbuf[i-1] = '\0'; /* trim NL */
			if(!strncmp(resbuf, "request id is ", 14))
D 9
				strcpy(req_id, &resbuf[14]);
E 9
I 9
				/* New - just the first word is needed */
				strcpy(req_id, strtok(&resbuf[14], delims));
E 9
		}
D 5
		if(su_pclose(fd))
E 5
I 5
		if(su_pclose(fd) == 255)
E 5
D 6
			msgout("rpc.pcnfsd: su_pclose alert");
E 6
I 6
			msg_out("rpc.pcnfsd: su_pclose alert");
E 6
		(void)unlink(new_pathname);
D 9
		return(PS_RES_OK);
E 9
I 9
		return(interrupted? PS_RES_FAIL : PS_RES_OK);
E 9
}


E 4
int
build_pr_list()
{
pr_list last = NULL;
pr_list curr = NULL;
char buff[256];
FILE *p;
char *cp;
I 9
int saw_system;
E 9

D 9
	p = popen(LPSTATCOM, "r");
E 9
I 9
/*
 * In SVR4 the command to determine which printers are
 * valid is lpstat -v. The output is something like this:
 *
 * device for lp: /dev/lp0
 * system for pcdslw: hinode
 * system for bletch: hinode (as printer hisname)
 *
 * On SunOS using the SysV compatibility package, the output
 * is more like:
 *
 * device for lp is /dev/lp0
 * device for pcdslw is the remote printer pcdslw on hinode
 * device for bletch is the remote printer hisname on hinode
 *
 * It is fairly simple to create logic that will handle either
 * possibility:
 */

	p = popen("lpstat -v", "r");
E 9
	if(p == NULL) {
D 6
		msgout("rpc.pcnfsd: unable to popen() lp status");
E 6
I 6
		msg_out("rpc.pcnfsd: unable to popen() lp status");
E 6
		return(0);
	}
	
	while(fgets(buff, 255, p) != NULL) {
		cp = strtok(buff, delims);
D 9
		if(!cp || strcmp(cp, "device"))
E 9
I 9
		if(!cp)
E 9
			continue;
I 9
		if(!strcmp(cp, "device"))
			saw_system = 0;
		else if (!strcmp(cp, "system"))
			saw_system = 1;
		else
			continue;
E 9
		cp = strtok(NULL, delims);
		if(!cp || strcmp(cp, "for"))
			continue;
		cp = strtok(NULL, delims);
		if(!cp)
			continue;
		curr = (struct pr_list_item *)
			grab(sizeof (struct pr_list_item));

D 4
		curr->pr = strdup(cp);
E 4
I 4
		curr->pn = strdup(cp);
E 4
		curr->device = NULL;
		curr->remhost = NULL;
		curr->cm = strdup("-");
		curr->pr_next = NULL;

		cp = strtok(NULL, delims);
D 9
		if(!cp || strcmp(cp, "is")) {
			free_pr_list_item(curr);
			continue;
		}
E 9

D 9
		cp = strtok(NULL, delims);
E 9
I 9
		if(cp && !strcmp(cp, "is")) 
			cp = strtok(NULL, delims);

E 9
		if(!cp) {
			free_pr_list_item(curr);
			continue;
		}

D 9
		if(!strcmp(cp, "the")) {
E 9
I 9
		if(saw_system) {
			/* "system" OR "system (as printer pname)" */ 
			curr->remhost = strdup(cp);
			cp = strtok(NULL, delims);
			if(!cp) {
				/* simple format */
				curr->device = strdup(curr->pn);
			} else {
				/* "sys (as printer pname)" */
				if (strcmp(cp, "as")) {
					free_pr_list_item(curr);
					continue;
				}
				cp = strtok(NULL, delims);
				if (!cp || strcmp(cp, "printer")) {
					free_pr_list_item(curr);
					continue;
				}
				cp = strtok(NULL, delims);
				if(!cp) {
					free_pr_list_item(curr);
					continue;
				}
				curr->device = strdup(cp);
			}
		}
		else if(!strcmp(cp, "the")) {
E 9
			/* start of "the remote printer foo on bar" */
			cp = strtok(NULL, delims);
			if(!cp || strcmp(cp, "remote")) {
				free_pr_list_item(curr);
				continue;
			}
			cp = strtok(NULL, delims);
			if(!cp || strcmp(cp, "printer")) {
				free_pr_list_item(curr);
				continue;
			}
			cp = strtok(NULL, delims);
			if(!cp) {
				free_pr_list_item(curr);
				continue;
			}
			curr->device = strdup(cp);
			cp = strtok(NULL, delims);
			if(!cp || strcmp(cp, "on")) {
				free_pr_list_item(curr);
				continue;
			}
			cp = strtok(NULL, delims);
			if(!cp) {
				free_pr_list_item(curr);
				continue;
			}
			curr->remhost = strdup(cp);
		} else {
			/* the local name */
			curr->device = strdup(cp);
			curr->remhost = strdup("");
		}

		if(last == NULL)
			printers = curr;
		else
			last->pr_next = curr;
		last = curr;

	}
	(void) pclose(p);
I 9
/*
** Now add on the virtual printers, if any
*/
	if(last == NULL)
		printers = list_virtual_printers();
	else
		last->pr_next = list_virtual_printers();

E 9
	return(1);
}

void *grab(n)
int n;
{
void *p;

D 8
	p = malloc(n);
E 8
I 8
	p = (void *)malloc(n);
E 8
	if(p == NULL) {
D 6
		msgout("rpc.pcnfsd: malloc failure");
E 6
I 6
		msg_out("rpc.pcnfsd: malloc failure");
E 6
		exit(1);
	}
	return(p);
}

void
free_pr_list_item(curr)
pr_list curr;
{
D 4
	if(curr->pr)
		free(curr->pr);
E 4
I 4
	if(curr->pn)
		free(curr->pn);
E 4
	if(curr->device)
		free(curr->device);
	if(curr->remhost)
		free(curr->remhost);
	if(curr->cm)
		free(curr->cm);
	if(curr->pr_next)
		free_pr_list_item(curr->pr_next); /* recurse */
	free(curr);
}
/*
** Print queue handling.
**
** Note that the first thing we do is to discard any
** existing queue.
*/
I 9
#ifdef SVR4
E 9

pirstat
build_pr_queue(pn, user, just_mine, p_qlen, p_qshown)
printername     pn;
username        user;
int            just_mine;
int            *p_qlen;
int            *p_qshown;
{
pr_queue last = NULL;
pr_queue curr = NULL;
char buff[256];
FILE *p;
I 9
char *owner;
char *job;
char *totsize;

	if(queue) {
		free_pr_queue_item(queue);
		queue = NULL;
	}
	*p_qlen = 0;
	*p_qshown = 0;

	pn = map_printer_name(pn);
	if(pn == NULL || !valid_pr(pn))
		return(PI_RES_NO_SUCH_PRINTER);


/*
** In SVR4 the command to list the print jobs for printer
** lp is "lpstat lp" (or, equivalently, "lpstat -p lp").
** The output looks like this:
** 
** lp-2                    root               939   Jul 10 21:56
** lp-5                    geoff               15   Jul 12 23:23
** lp-6                    geoff               15   Jul 12 23:23
** 
** If the first job is actually printing the first line
** is modified, as follows:
**
** lp-2                    root               939   Jul 10 21:56 on lp
** 
** I don't yet have any info on what it looks like if the printer
** is remote and we're spooling over the net. However for
** the purposes of rpc.pcnfsd we can simply say that field 1 is the
** job ID, field 2 is the submitter, and field 3 is the size.
** We can check for the presence of the string " on " in the
** first record to determine if we should count it as rank 0 or rank 1,
** but it won't hurt if we get it wrong.
**/
	sprintf(buff, "/usr/bin/lpstat %s", pn);
	p = su_popen(user, buff, MAXTIME_FOR_QUEUE);
	if(p == NULL) {
		msg_out("rpc.pcnfsd: unable to popen() lpstat queue query");
		return(PI_RES_FAIL);
	}
	
	while(fgets(buff, 255, p) != NULL) {
		job = strtok(buff, delims);
		if(!job)
			continue;

		owner = strtok(NULL, delims);
		if(!owner)
			continue;

		totsize = strtok(NULL, delims);
		if(!totsize)
			continue;

		*p_qlen += 1;

		if(*p_qshown > QMAX)
			continue;

		if(just_mine && mystrcasecmp(owner, user))
			continue;

		*p_qshown += 1;

		curr = (struct pr_queue_item *)
			grab(sizeof (struct pr_queue_item));

		curr->position = *p_qlen;
		curr->id = strdup(job);
		curr->size = strdup(totsize);
		curr->status = strdup("");
		curr->system = strdup("");
		curr->user = strdup(owner);
		curr->file = strdup("");
		curr->cm = strdup("-");
		curr->pr_next = NULL;

		if(last == NULL)
			queue = curr;
		else
			last->pr_next = curr;
		last = curr;

	}
	(void) su_pclose(p);
	return(PI_RES_OK);
}

#else /* SVR4 */

pirstat
build_pr_queue(pn, user, just_mine, p_qlen, p_qshown)
printername     pn;
username        user;
int            just_mine;
int            *p_qlen;
int            *p_qshown;
{
pr_queue last = NULL;
pr_queue curr = NULL;
char buff[256];
FILE *p;
E 9
char *cp;
int i;
char *rank;
char *owner;
char *job;
char *files;
char *totsize;

	if(queue) {
		free_pr_queue_item(queue);
		queue = NULL;
	}
	*p_qlen = 0;
	*p_qshown = 0;
I 8
	pn = map_printer_name(pn);
	if(pn == NULL)
		return(PI_RES_NO_SUCH_PRINTER);
E 8

	sprintf(buff, "/usr/ucb/lpq -P%s", pn);

D 4
	p = popen(buff, "r");
E 4
I 4
D 9
/*	p = popen(buff, "r"); */
	p = su_popen(user, buff);
E 9
I 9
	p = su_popen(user, buff, MAXTIME_FOR_QUEUE);
E 9
E 4
	if(p == NULL) {
D 6
		msgout("rpc.pcnfsd: unable to popen() lpq");
E 6
I 6
		msg_out("rpc.pcnfsd: unable to popen() lpq");
E 6
		return(PI_RES_FAIL);
	}
	
	while(fgets(buff, 255, p) != NULL) {
		i = strlen(buff) - 1;
		buff[i] = '\0';		/* zap trailing NL */
		if(i < SIZECOL)
			continue;
D 8
		if(!strncasecmp(buff, "rank", 4))
E 8
I 8
		if(!mystrncasecmp(buff, "rank", 4))
E 8
			continue;

		totsize = &buff[SIZECOL-1];
		files = &buff[FILECOL-1];
		cp = totsize;
		cp--;
		while(cp > files && isspace(*cp))
			*cp-- = '\0';

		buff[FILECOL-2] = '\0';

		cp = strtok(buff, delims);
		if(!cp)
			continue;
		rank = cp;

		cp = strtok(NULL, delims);
		if(!cp)
			continue;
		owner = cp;

		cp = strtok(NULL, delims);
		if(!cp)
			continue;
		job = cp;

		*p_qlen += 1;

		if(*p_qshown > QMAX)
			continue;

D 8
		if(just_mine && strcasecmp(owner, user))
E 8
I 8
		if(just_mine && mystrcasecmp(owner, user))
E 8
			continue;

		*p_qshown += 1;

		curr = (struct pr_queue_item *)
			grab(sizeof (struct pr_queue_item));

		curr->position = atoi(rank); /* active -> 0 */
		curr->id = strdup(job);
		curr->size = strdup(totsize);
		curr->status = strdup(rank);
		curr->system = strdup("");
		curr->user = strdup(owner);
		curr->file = strdup(files);
		curr->cm = strdup("-");
		curr->pr_next = NULL;

		if(last == NULL)
			queue = curr;
		else
			last->pr_next = curr;
		last = curr;

	}
D 4
	(void) pclose(p);
E 4
I 4
D 9
/*	(void) pclose(p); */
E 9
	(void) su_pclose(p);
E 4
	return(PI_RES_OK);
}
I 9
#endif /* SVR4 */
E 9

D 9

E 9
void
free_pr_queue_item(curr)
pr_queue curr;
{
	if(curr->id)
		free(curr->id);
	if(curr->size)
		free(curr->size);
	if(curr->status)
		free(curr->status);
	if(curr->system)
		free(curr->system);
	if(curr->user)
		free(curr->user);
	if(curr->file)
		free(curr->file);
	if(curr->cm)
		free(curr->cm);
	if(curr->pr_next)
		free_pr_queue_item(curr->pr_next); /* recurse */
	free(curr);
E 2
}

I 3


I 9
#ifdef SVR4
pirstat
get_pr_status(pn, avail, printing, qlen, needs_operator, status)
printername   pn;
bool_t       *avail;
bool_t       *printing;
int          *qlen;
bool_t       *needs_operator;
char         *status;
{
char buff[256];
char cmd[64];
FILE *p;
int n;
pirstat stat = PI_RES_NO_SUCH_PRINTER;
E 9

I 9
/*
** New - SVR4 printer status handling.
**
** The command we'll use for checking the status of printer "lp"
** is "lpstat -a lp -p lp". Here are some sample outputs:
**
** 
** lp accepting requests since Wed Jul 10 21:49:25 EDT 1991
** printer lp disabled since Thu Feb 21 22:52:36 EST 1991. available.
** 	new printer
** ---
** pcdslw not accepting requests since Fri Jul 12 22:30:00 EDT 1991 -
** 	unknown reason
** printer pcdslw disabled since Fri Jul 12 22:15:37 EDT 1991. available.
** 	new printer
** ---
** lp accepting requests since Wed Jul 10 21:49:25 EDT 1991
** printer lp now printing lp-2. enabled since Sat Jul 13 12:02:17 EDT 1991. available.
** ---
** lp accepting requests since Wed Jul 10 21:49:25 EDT 1991
** printer lp now printing lp-2. enabled since Sat Jul 13 12:02:17 EDT 1991. available.
** ---
** lp accepting requests since Wed Jul 10 21:49:25 EDT 1991
** printer lp disabled since Sat Jul 13 12:05:20 EDT 1991. available.
** 	unknown reason
** ---
** pcdslw not accepting requests since Fri Jul 12 22:30:00 EDT 1991 -
** 	unknown reason
** printer pcdslw is idle. enabled since Sat Jul 13 12:05:28 EDT 1991. available.
**
** Note that these are actual outputs. The format (which is totally
** different from the lpstat in SunOS) seems to break down as
** follows:
** (1) The first line has the form "printername [not] accepting requests,,,"
**    This is trivial to decode.
** (2) The second line has several forms, all beginning "printer printername":
** (2.1) "... disabled"
** (2.2) "... is idle"
** (2.3) "... now printing jobid"
** The "available" comment seems to be meaningless. The next line
** is the "reason" code which the operator can supply when issuing
** a "disable" or "reject" command.
** Note that there is no way to check the number of entries in the
** queue except to ask for the queue and count them.
*/
	/* assume the worst */
	*avail = FALSE;
	*printing = FALSE;
	*needs_operator = FALSE;
	*qlen = 0;
	*status = '\0';

	pn = map_printer_name(pn);
	if(pn == NULL || !valid_pr(pn))
		return(PI_RES_NO_SUCH_PRINTER);
	n = strlen(pn);

	sprintf(cmd, "/usr/bin/lpstat -a %s -p %s", pn, pn);

	p = popen(cmd, "r");
	if(p == NULL) {
		msg_out("rpc.pcnfsd: unable to popen() lp status");
		return(PI_RES_FAIL);
	}
	
	stat = PI_RES_OK;

	while(fgets(buff, 255, p) != NULL) {
		if(!strncmp(buff, pn, n)) {
			if(!strstr(buff, "not accepting"))
			*avail = TRUE;
			continue;
		}
		if(!strncmp(buff, "printer ", 8)) {
			if(!strstr(buff, "disabled"))
				*printing = TRUE;
			if(strstr(buff, "printing"))
				strcpy(status, "printing");
			else if (strstr(buff, "idle"))
				strcpy(status, "idle");
			continue;
		}
		if(!strncmp(buff, "UX:", 3)) {
			stat = PI_RES_NO_SUCH_PRINTER;
		}
	}
	(void) pclose(p);
	return(stat);
}

#else /* SVR4 */

E 9
pirstat
D 4
get_pr_status(pn, stat, avail, printing, needs_operator, cm)
E 4
I 4
get_pr_status(pn, avail, printing, qlen, needs_operator, status)
E 4
printername   pn;
D 4
bool_t       *stat;
E 4
bool_t       *avail;
bool_t       *printing;
I 4
int          *qlen;
E 4
bool_t       *needs_operator;
D 4
char         *cm;
E 4
I 4
char         *status;
E 4
{
char buff[256];
I 4
char buff2[256];
E 4
char pname[64];
FILE *p;
char *cp;
I 4
char *cp1;
char *cp2;
E 4
int n;
I 4
pirstat stat = PI_RES_NO_SUCH_PRINTER;
E 4

	/* assume the worst */
D 4
	*stat = PI_RES_NO_SUCH_PRINTER;
E 4
	*avail = FALSE;
	*printing = FALSE;
	*needs_operator = FALSE;
D 4
	*cm = '\0';
E 4
I 4
	*qlen = 0;
	*status = '\0';
E 4

I 8
	pn = map_printer_name(pn);
	if(pn == NULL)
		return(PI_RES_NO_SUCH_PRINTER);
E 8
I 4

E 4
	sprintf(pname, "%s:", pn);
	n = strlen(pname);

	p = popen("/usr/bin/lpstat -a", "r");
	if(p == NULL) {
D 6
		msgout("rpc.pcnfsd: unable to popen() lp status");
E 6
I 6
		msg_out("rpc.pcnfsd: unable to popen() lp status");
E 6
		return(PI_RES_FAIL);
	}
	
	while(fgets(buff, 255, p) != NULL) {
		if(strncmp(buff, pname, n))
			continue;
/*
I 4
** We have a match. The only failure now is PI_RES_FAIL if
** lpstat output cannot be decoded
*/
		stat = PI_RES_FAIL;
/*
E 4
** The next four lines are usually if the form
**
**     queuing is [enabled|disabled]
**     printing is [enabled|disabled]
**     [no entries | N entr[y|ies] in spool area]
**     <status message, may include the word "attention">
*/
I 4
		while(fgets(buff, 255, p) != NULL && isspace(buff[0])) {
			cp = buff;
			while(isspace(*cp))
				cp++;
			if(*cp == '\0')
				break;
			cp1 = cp;
			cp2 = buff2;
			while(*cp1 && *cp1 != '\n') {
				*cp2++ = tolower(*cp1);
				cp1++;
			}
			*cp1 = '\0';
			*cp2 = '\0';
/*
** Now buff2 has a lower-cased copy and cp points at the original;
** both are null terminated without any newline
*/			
			if(!strncmp(buff2, "queuing", 7)) {
				*avail = (strstr(buff2, "enabled") != NULL);
				continue;
			}
			if(!strncmp(buff2, "printing", 8)) {
				*printing = (strstr(buff2, "enabled") != NULL);
				continue;
			}
D 5
msgout(buff2);
E 5
			if(isdigit(buff2[0]) && (strstr(buff2, "entr") !=NULL)) {

				*qlen = atoi(buff2);
				continue;
			}
			if(strstr(buff2, "attention") != NULL ||
			   strstr(buff2, "error") != NULL)
				*needs_operator = TRUE;
			if(*needs_operator || strstr(buff2, "waiting") != NULL)
				strcpy(status, cp);
		}
		stat = PI_RES_OK;
		break;
E 4
	}
	(void) pclose(p);
D 4
	return(1);
E 4
I 4
	return(stat);
E 4
}
I 9
#endif /* SVR4 */
E 9

I 9
#ifdef SVR4

E 9
I 5
pcrstat pr_cancel(pr, user, id)
char *pr;
char *user;
char *id;
{
char            cmdbuf[256];
char            resbuf[256];
FILE *fd;
D 9
int i;
E 9
pcrstat stat = PC_RES_NO_SUCH_JOB;
I 8

	pr = map_printer_name(pr);
	if(pr == NULL)
		return(PC_RES_NO_SUCH_PRINTER);

I 9
	sprintf(cmdbuf, "/usr/bin/cancel %s", id);
	if ((fd = su_popen(user, cmdbuf, MAXTIME_FOR_CANCEL)) == NULL) {
		msg_out("rpc.pcnfsd: su_popen failed");
		return(PC_RES_FAIL);
	}
E 9
E 8
/*
D 9
** Eventually we'll use cancel here, but right now
** it coredumps on 4.1BETA
E 9
I 9
** For SVR4 we have to be prepared for the following kinds of output:
** 
** # cancel lp-6
** request "lp-6" cancelled
** # cancel lp-33
** UX:cancel: WARNING: Request "lp-33" doesn't exist.
** # cancel foo-88
** UX:cancel: WARNING: Request "foo-88" doesn't exist.
** # cancel foo
** UX:cancel: WARNING: "foo" is not a request id or a printer.
**             TO FIX: Cancel requests by id or by
**                     name of printer where printing.
** # su geoff
** $ cancel lp-2
** UX:cancel: WARNING: Can't cancel request "lp-2".
**             TO FIX: You are not allowed to cancel
**                     another's request.
**
** There are probably other variations for remote printers.
** Basically, if the reply begins with the string
**          "UX:cancel: WARNING: "
** we can strip this off and look for one of the following
** (1) 'R' - should be part of "Request "xxxx" doesn't exist."
** (2) '"' - should be start of ""foo" is not a request id or..."
** (3) 'C' - should be start of "Can't cancel request..."
**
** The fly in the ointment: all of this can change if these
** messages are localized..... :-(
E 9
*/
D 9
#ifdef USE_CANCEL
		sprintf(cmdbuf, "/usr/bin/cancel %s", id);
#else
E 9
I 9
	if(fgets(resbuf, 255, fd) == NULL) 
		stat = PC_RES_FAIL;
	else if(!strstr(resbuf, "UX:"))
		stat = PC_RES_OK;
	else if(strstr(resbuf, "doesn't exist"))
		stat = PC_RES_NO_SUCH_JOB;
	else if(strstr(resbuf, "not a request id"))
		stat = PC_RES_NO_SUCH_JOB;
	else if(strstr(resbuf, "Can't cancel request"))
		stat = PC_RES_NOT_OWNER;
	else	stat = PC_RES_FAIL;

	if(su_pclose(fd) == 255)
		msg_out("rpc.pcnfsd: su_pclose alert");
	return(stat);
}

#else /* SVR4 */

pcrstat pr_cancel(pr, user, id)
char *pr;
char *user;
char *id;
{
char            cmdbuf[256];
char            resbuf[256];
FILE *fd;
int i;
pcrstat stat = PC_RES_NO_SUCH_JOB;

	pr = map_printer_name(pr);
	if(pr == NULL)
		return(PC_RES_NO_SUCH_PRINTER);

E 9
		sprintf(cmdbuf, "/usr/ucb/lprm -P%s %s", pr, id);
D 9
#endif
		if ((fd = su_popen(user, cmdbuf)) == NULL) {
E 9
I 9
		if ((fd = su_popen(user, cmdbuf, MAXTIME_FOR_CANCEL)) == NULL) {
E 9
D 6
			msgout("rpc.pcnfsd: su_popen failed");
E 6
I 6
			msg_out("rpc.pcnfsd: su_popen failed");
E 6
D 8
			return(PS_RES_FAIL);
E 8
I 8
			return(PC_RES_FAIL);
E 8
		}
		while(fgets(resbuf, 255, fd) != NULL) {
			i = strlen(resbuf);
			if(i)
				resbuf[i-1] = '\0'; /* trim NL */
			if(strstr(resbuf, "dequeued") != NULL)
				stat = PC_RES_OK;
			if(strstr(resbuf, "unknown printer") != NULL)
				stat = PC_RES_NO_SUCH_PRINTER;
			if(strstr(resbuf, "Permission denied") != NULL)
				stat = PC_RES_NOT_OWNER;
		}
		if(su_pclose(fd) == 255)
D 6
			msgout("rpc.pcnfsd: su_pclose alert");
E 6
I 6
			msg_out("rpc.pcnfsd: su_pclose alert");
E 6
		return(stat);
}
I 8
D 9

E 9
I 9
#endif /* SVR4 */
E 9

/*
** New subsystem here. We allow the administrator to define
** up to NPRINTERDEFS aliases for printer names. This is done
** using the "/etc/pcnfsd.conf" file, which is read at startup.
** There are three entry points to this subsystem
**
** void add_printer_alias(char *printer, char *alias_for, char *command)
**
** This is invoked from "config_from_file()" for each
** "printer" line. "printer" is the name of a printer; note that
** it is possible to redefine an existing printer. "alias_for"
** is the name of the underlying printer, used for queue listing
** and other control functions. If it is "-", there is no
** underlying printer, or the administrative functions are
** not applicable to this printer. "command"
** is the command which should be run (via "su_popen()") if a
** job is printed on this printer. The following tokens may be
** embedded in the command, and are substituted as follows:
**
** $FILE	-	path to the file containing the print data
** $USER	-	login of user
** $HOST	-	hostname from which job originated
**
** Tokens may occur multiple times. If The command includes no
** $FILE token, the string " $FILE" is silently appended.
**
I 9
** pr_list list_virtual_printers()
**
** This is invoked from build_pr_list to generate a list of aliased
** printers, so that the client that asks for a list of valid printers
** will see these ones.
**
E 9
** char *map_printer_name(char *printer)
**
** If "printer" identifies an aliased printer, this function returns
** the "alias_for" name, or NULL if the "alias_for" was given as "-".
** Otherwise it returns its argument.
**
** char *expand_alias(char *printer, char *file, char *user, char *host)
**
** If "printer" is an aliased printer, this function returns a
** pointer to a static string in which the corresponding command
** has been expanded. Otherwise ot returns NULL.
*/
#define NPRINTERDEFS	16
int num_aliases = 0;
struct {
	char *a_printer;
	char *a_alias_for;
	char *a_command;
} alias [NPRINTERDEFS];



void
add_printer_alias(printer, alias_for, command)
char *printer;
char *alias_for;
char *command;
{
	if(num_aliases < NPRINTERDEFS) {
		alias[num_aliases].a_printer = strdup(printer);
		alias[num_aliases].a_alias_for =
			(strcmp(alias_for,  "-") ? strdup(alias_for) : NULL);
		if(strstr(command, "$FILE"))
			alias[num_aliases].a_command = strdup(command);
		else {
			alias[num_aliases].a_command = (char *)grab(strlen(command) + 8);
			strcpy(alias[num_aliases].a_command, command);
			strcat(alias[num_aliases].a_command, " $FILE");
		}
		num_aliases++;
	}
I 9
}

pr_list list_virtual_printers()
{
pr_list first = NULL;
pr_list last = NULL;
pr_list curr = NULL;
int i;


	if(num_aliases == 0)
		return(NULL);

	for (i = 0; i < num_aliases; i++) {
		curr = (struct pr_list_item *)
			grab(sizeof (struct pr_list_item));

		curr->pn = strdup(alias[i].a_printer);
		if(alias[i].a_alias_for == NULL)
			curr->device = strdup("");
		else
			curr->device = strdup(alias[i].a_alias_for);
		curr->remhost = strdup("");
		curr->cm = strdup("(alias)");
		curr->pr_next = NULL;
		if(last == NULL)
			first = curr;
		else
			last->pr_next = curr;
		last = curr;

	}
	return(first);
E 9
}


char *
map_printer_name(printer)
char *printer;
{
int i;
	for (i = 0; i < num_aliases; i++){
		if(!strcmp(printer, alias[i].a_printer))
			return(alias[i].a_alias_for);
	}
	return(printer);
}

static void
substitute(string, token, data)
char *string;
char *token;
char *data;
{
char temp[512];
char *c;

	while(c = strstr(string, token)) {
		*c = '\0';
		strcpy(temp, string);
		strcat(temp, data);
		c += strlen(token);
		strcat(temp, c);
		strcpy(string, temp);
	}
}

char *
expand_alias(printer, file, user, host)
char *printer;
char *file;
char *user;
char *host;
{
static char expansion[512];
int i;
	for (i = 0; i < num_aliases; i++){
		if(!strcmp(printer, alias[i].a_printer)) {
			strcpy(expansion, alias[i].a_command);
			substitute(expansion, "$FILE", file);
			substitute(expansion, "$USER", user);
			substitute(expansion, "$HOST", host);
			return(expansion);
		}
	}
	return(NULL);
}

E 8
E 5
E 3
E 1
