h34477
s 00004/00001/00530
d D 1.8 91/08/06 07:41:49 geoff 8 7
c make watchdog signal logic SVR4 compatible
e
s 00069/00013/00462
d D 1.7 91/07/24 08:16:08 geoff 7 6
c lint fixes, add watchdog to crowbar runaway subpprocesses, 
c also make sure that aliases (virtual printers) show up in the 
c printer list
e
s 00133/00049/00342
d D 1.6 91/05/02 10:34:18 geoff 6 5
c snapshort after SVR4 checkout
e
s 00101/00121/00290
d D 1.5 91/04/15 15:53:53 geoff 5 4
c consolidate stuff
e
s 00001/00001/00410
d D 1.4 91/04/12 14:16:08 geoff 4 3
c change msgout to msg_out for SVR4
e
s 00034/00000/00377
d D 1.3 91/03/11 04:24:09 geoff 3 2
c snapshot
e
s 00000/00000/00377
d D 1.2 91/03/07 14:59:27 geoff 2 1
c add su_popen support; status check, new lp-based startprint
e
s 00377/00000/00000
d D 1.1 91/03/04 11:54:14 geoff 1 0
c date and time created 91/03/04 11:54:14 by geoff
e
u
U
f e 0
t
T
I 1
/*
**=====================================================================
** Copyright (c) 1986,1987,1988,1989,1990,1991 by Sun Microsystems, Inc.
D 5
**
**         D I S C L A I M E R   S E C T I O N ,   E T C .
**
** pcnfsd is copyrighted software, but is freely licensed. This
** means that you are free to redistribute it, modify it, ship it
** in binary with your system, whatever, provided:
**
** - you leave the Sun copyright notice in the source code
** - you make clear what changes you have introduced and do
**   not represent them as being supported by Sun.
** - you do not charge money for the source code (unlikely, given
**   its free availability)
E 5
I 5
**	%W%	%G%
E 5
**=====================================================================
*/
D 5

E 5
I 5
#include "common.h"
E 5
/*
**=====================================================================
D 5
**             C U S T O M I Z A T I O N   S E C T I O N              *
**                                                                    *
** You should not uncomment these #defines in this version of pcnfsd  *
** Instead you should edit the makefile CDEFS variable.               *
**                                                                    *
**=====================================================================
*/

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to enable the use of a 
** shadow password file
**---------------------------------------------------------------------
**/

/* #define SHADOW_SUPPORT */

/*
I 3
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to enable the logging 
** of authentication requests to /usr/adm/wtmp
**---------------------------------------------------------------------
**/

/* #define WTMP */

/*
E 3
**------------------------------------------------------------------------
** Define (via Makefile) the following symbol conform to Interactive
** System's 2.0
**------------------------------------------------------------------------
*/

/* #define ISC_2_0 */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to use a cache of recently-used
** user names. This has certain uses in university and other settings
** where (1) the pasword file is very large, and (2) a group of users
** frequently logs in together using the same account (for example,
** a class userid).
**---------------------------------------------------------------------
*/

/* #define USER_CACHE */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a System V version
**---------------------------------------------------------------------
*/

/* #define SYSV */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a version that uses
** System V style "lp" instead of BSD-style "lpr" to print
**---------------------------------------------------------------------
*/

/* #define USE_LP */

/*
**---------------------------------------------------------------------
** Define (via Makefile) the following symbol to build a typical
** "local feature": in this case recognizing the special printer
** names "rotated" and "2column" and using the Adobe "enscript"
** command to format the output appropriately.
**---------------------------------------------------------------------
*/

/* #define HACK_FOR_ROTATED_TRANSCRIPT */

/*
**---------------------------------------------------------------------
** The following definitions may be overridden if desired.
**---------------------------------------------------------------------
*/

#ifndef SPOOLDIR
#define SPOOLDIR	"/usr/spool/pcnfs"
#endif	

/*
**---------------------------------------------------------------------
** The following should force the right things for Interactive 2.0
**---------------------------------------------------------------------
*/
#ifdef ISC_2_0
#define SYSV
#define USE_LP
#define SHADOW_SUPPORT
#endif

/*
**=====================================================================
E 5
**             I N C L U D E   F I L E   S E C T I O N                *
**                                                                    *
** If your port requires different include files, add a suitable      *
** #define in the customization section, and make the inclusion or    *
** exclusion of the files conditional on this.                        *
**=====================================================================
*/
#include "pcnfsd.h"

#include <stdio.h>
#include <pwd.h>
#include <sys/file.h>
#include <signal.h>
I 7
#include <sys/time.h>
E 7
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>
I 6
#include <ctype.h>
E 6

D 6
#ifndef SYSV
#include <sys/wait.h>
#endif

E 6
#ifdef ISC_2_0
#include <sys/fcntl.h>
#endif

#ifdef SHADOW_SUPPORT
#include <shadow.h>
#endif

I 6
#ifdef WTMP
int wtmp_enabled = 1;
#endif

E 6
/*
**---------------------------------------------------------------------
** Other #define's 
**---------------------------------------------------------------------
*/
D 5
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
E 5

D 5
#define assert(ex) {if (!(ex)) \
    {(void)fprintf(stderr,"pcnfsd: Assertion failed: line %d of %s: \"%s\"\n", \
    __LINE__, __FILE__, "ex"); \
    sleep (30); exit(1);}}


E 5
#define	zchar		0x5b

char            tempstr[256];
I 6
extern char	sp_name[1024]; /* in pcnfsd_print.c */
E 6

/*
**=====================================================================
**                      C O D E   S E C T I O N                       *                    **=====================================================================
*/
/*
**---------------------------------------------------------------------
**                          Support procedures 
**---------------------------------------------------------------------
*/


void
scramble(s1, s2)
char           *s1;
char           *s2;
{
	while (*s1) 
	      {
	      *s2++ = (*s1 ^ zchar) & 0x7f;
	      s1++;
	      }
	*s2 = 0;
}



struct passwd  *
D 6
get_password(username)
char           *username;
E 6
I 6
get_password(usrnam)
char           *usrnam;
E 6
{
struct passwd  *p;
static struct passwd localp;
char           *pswd;

#ifdef SHADOW_SUPPORT
struct spwd    *sp;
int             shadowfile;
#endif

#ifdef SHADOW_SUPPORT
	/*
        **--------------------------------------------------------------
	** Check the existence of SHADOW.  If it is there, then we are
	** running a two-password-file system.
        **--------------------------------------------------------------
	*/
	if (access(SHADOW, 0))
	   shadowfile = 0;	/* SHADOW is not there */
	else
	   shadowfile = 1;

	setpwent();
	if (shadowfile)
	   (void) setspent();	/* Setting the shadow password
					 * file */
D 6
	if ((p = getpwnam(username)) == (struct passwd *)NULL ||
	   (shadowfile && (sp = getspnam(username)) == (struct spwd *)NULL))
E 6
I 6
	if ((p = getpwnam(usrnam)) == (struct passwd *)NULL ||
	   (shadowfile && (sp = getspnam(usrnam)) == (struct spwd *)NULL))
E 6
	return ((struct passwd *)NULL);

	if (shadowfile) 
           {
	   pswd = sp->sp_pwdp;
	   (void) endspent();
	   } 
        else
	   pswd = p->pw_passwd;

#else
D 6
	p = getpwnam(username);
E 6
I 6
	p = getpwnam(usrnam);
E 6
	if (p == (struct passwd *)NULL)
		return ((struct passwd *)NULL);
	pswd = p->pw_passwd;
#endif

#ifdef ISC_2_0
	/* 
        **-----------------------------------------------------------
	** We may have an 'x' in which case look in /etc/shadow ..
        **-----------------------------------------------------------
        */
	if (((strlen(pswd)) == 1) && pswd[0] == 'x') 
	   {
D 6
	   struct spwd    *shadow = getspnam(username);
E 6
I 6
	   struct spwd    *shadow = getspnam(usrnam);
E 6

	   if (!shadow)
	      return ((struct passwd *)NULL);
	   pswd = shadow->sp_pwdp;
	   }
#endif
	localp = *p;
	localp.pw_passwd = pswd;
	return (&localp);
}

D 5

E 5
I 5

E 5
/*
**---------------------------------------------------------------------
**                      Print support procedures 
**---------------------------------------------------------------------
*/

char           *
mapfont(f, i, b)
	char            f;
	char            i;
	char            b;
{
	static char     fontname[64];

	fontname[0] = 0;	/* clear it out */

	switch (f) {
	case 'c':
		(void)strcpy(fontname, "Courier");
		break;
	case 'h':
		(void)strcpy(fontname, "Helvetica");
		break;
	case 't':
		(void)strcpy(fontname, "Times");
		break;
	default:
		(void)strcpy(fontname, "Times-Roman");
		goto finis ;
	}
	if (i != 'o' && b != 'b') {	/* no bold or oblique */
		if (f == 't')	/* special case Times */
			(void)strcat(fontname, "-Roman");
		goto finis;
	}
	(void)strcat(fontname, "-");
	if (b == 'b')
		(void)strcat(fontname, "Bold");
	if (i == 'o')		/* o-blique */
		(void)strcat(fontname, f == 't' ? "Italic" : "Oblique");

finis:	return (&fontname[0]);
}

/*
 * run_ps630 performs the Diablo 630 emulation filtering process. ps630
 * was broken in certain Sun releases: it would not accept point size or
 * font changes. If your version is fixed, undefine the symbol
 * PS630_IS_BROKEN and rebuild pc-nfsd.
 */
/* #define PS630_IS_BROKEN 1 */

void
D 6
run_ps630(file, options)
	char           *file;
	char           *options;
E 6
I 6
run_ps630(f, opts)
	char           *f;
	char           *opts;
E 6
{
	char            temp_file[256];
	char            commbuf[256];
	int             i;

D 6
	(void)strcpy(temp_file, file);
E 6
I 6
	(void)strcpy(temp_file, f);
E 6
	(void)strcat(temp_file, "X");	/* intermediate file name */

#ifndef PS630_IS_BROKEN
	(void)sprintf(commbuf, "ps630 -s %c%c -p %s -f ",
D 6
		options[2], options[3], temp_file);
	(void)strcat(commbuf, mapfont(options[4], options[5], options[6]));
E 6
I 6
		opts[2], opts[3], temp_file);
	(void)strcat(commbuf, mapfont(opts[4], opts[5], opts[6]));
E 6
	(void)strcat(commbuf, " -F ");
D 6
	(void)strcat(commbuf, mapfont(options[7], options[8], options[9]));
E 6
I 6
	(void)strcat(commbuf, mapfont(opts[7], opts[8], opts[9]));
E 6
	(void)strcat(commbuf, "  ");
D 6
	(void)strcat(commbuf, file);
E 6
I 6
	(void)strcat(commbuf, f);
E 6
#else	/* PS630_IS_BROKEN */
	/*
	 * The pitch and font features of ps630 appear to be broken at
	 * this time.
	 */
D 6
	(void)sprintf(commbuf, "ps630 -p %s %s", temp_file, file);
E 6
I 6
	(void)sprintf(commbuf, "ps630 -p %s %s", temp_file, f);
E 6
#endif	/* PS630_IS_BROKEN */


	if (i = system(commbuf)) {
		/*
		 * Under (un)certain conditions, ps630 may return -1 even
		 * if it worked. Hence the commenting out of this error
		 * report.
		 */
		 /* (void)fprintf(stderr, "\n\nrun_ps630 rc = %d\n", i) */ ;
		/* exit(1); */
	}
D 6
	if (rename(temp_file, file)) {
E 6
I 6
	if (rename(temp_file, f)) {
E 6
		perror("run_ps630: rename");
		exit(1);
	}
	return;
}



D 6
void
free_child()
{
int             pid;
#ifndef SYSV
union wait      child_status;
#else
unsigned int    child_status;
#endif


	while ((pid = wait(&child_status)) != -1) 
	      {
#ifndef SYSV
	      if (child_status.w_retcode) {
		 (void) sprintf(tempstr,
                        "rpc.pcnfsd: FREE_CHILD: process #%d exited with status 0X%x\n",
	                 pid, child_status.w_retcode);
D 4
                  msgout(tempstr);
E 4
I 4
                  msg_out(tempstr);
E 4
		}
#endif
	      }
}
E 6
I 5

/*
**---------------------------------------------------------------------
**                      WTMP update support 
**---------------------------------------------------------------------
*/
E 5

I 5

E 5
I 3
#ifdef WTMP
#define _PATH_WTMP "/usr/adm/wtmp"

#include <utmp.h>
void
D 6
wlogin(name,host)
E 6
I 6
wlogin(name)
E 6
        char *name;
D 6
        char *host;
E 6
{

I 6
extern char *getcallername();

E 6
        struct utmp ut;
        int fd;

D 6
        (void) strcpy(ut.ut_line, "PCNFS");
E 6
I 6
	if(!wtmp_enabled)
		return;
        (void) strcpy(ut.ut_line, "PC-NFS");
E 6
        (void) strncpy(ut.ut_name,name,sizeof ut.ut_name);
D 6
        (void) strncpy(ut.ut_host,host, sizeof ut.ut_host);
E 6
I 6
        (void) strncpy(ut.ut_host, getcallername(), sizeof ut.ut_host);
E 6
        ut.ut_time = time( (time_t *) 0);


        if ((fd = open(_PATH_WTMP, O_WRONLY|O_APPEND, 0)) >= 0) {
                (void)write(fd, (char *)&ut, sizeof(struct utmp));
                (void)close(fd);
        }
}
#endif WTMP
I 5

/*
**---------------------------------------------------------------------
**                      Run-process-as-user procedures 
**---------------------------------------------------------------------
*/


#define	READER_FD	0
#define	WRITER_FD	1

static int      child_pid;

static char     cached_user[64] = "";
static uid_t    cached_uid;
static gid_t    cached_gid;

I 7
static	struct sigaction old_action;
static	struct sigaction new_action;
static	struct itimerval timer;

int interrupted = 0;
static	FILE *pipe_handle;

static	void myhandler()
{
 interrupted = 1;
 fclose(pipe_handle);
 kill(child_pid, SIGKILL);
 msg_out("rpc.pcnfsd: su_popen timeout - killed child process");
}

void start_watchdog(n)
int n;
{
	/*
	 * Setup SIGALRM handler, force interrupt of ongoing syscall
	 */

	new_action.sa_handler = myhandler;
	sigemptyset(&(new_action.sa_mask));
D 8
	new_action.sa_flags = SA_INTERRUPT;
E 8
I 8
	new_action.sa_flags = 0;
#ifdef SA_INTERRUPT
	new_action.sa_flags |= SA_INTERRUPT;
#endif
E 8
	sigaction(SIGALRM, &new_action, &old_action);

	/*
	 * Set interval timer for n seconds
	 */
	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;
	timer.it_value.tv_sec = n;
	timer.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL, &timer, NULL);
	interrupted = 0;

}

void stop_watchdog()
{
	/*
	 * Cancel timer
	 */

	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;
	timer.it_value.tv_sec = 0;
	timer.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL, &timer, NULL);

	/*
 	 * restore old signal handling
	 */
	sigaction(SIGALRM, &old_action, NULL);
}



E 7
FILE           *
D 7
su_popen(user, cmd)
E 7
I 7
su_popen(user, cmd, maxtime)
E 7
	char           *user;
	char           *cmd;
I 7
	int		maxtime;
E 7
{
	int             p[2];
	int             parent_fd, child_fd, pid;
D 7
	uid_t           uid;
	gid_t           gid;
	struct passwd  *pw;
E 7
I 7
	struct passwd *pw;
E 7

	if (strcmp(cached_user, user)) {
		pw = getpwnam(user);
		if (!pw)
			pw = getpwnam("nobody");
		if (pw) {
			cached_uid = pw->pw_uid;
			cached_gid = pw->pw_gid;
			strcpy(cached_user, user);
		} else {
			cached_uid = (uid_t) (-2);
			cached_gid = (gid_t) (-2);
			cached_user[0] = '\0';
		}
	}
	if (pipe(p) < 0) {
		msg_out("rpc.pcnfsd: unable to create pipe in su_popen");
		return (NULL);
	}
	parent_fd = p[READER_FD];
	child_fd = p[WRITER_FD];
	if ((pid = fork()) == 0) {
		int             i;

		for (i = 0; i < 10; i++)
			if (i != child_fd)
				(void) close(i);
		if (child_fd != 1) {
			(void) dup2(child_fd, 1);
			(void) close(child_fd);
		}
		dup2(1, 2);	/* let's get stderr as well */

D 6
		(void) setregid(cached_gid, cached_gid);
		(void) setreuid(cached_uid, cached_uid);
E 6
I 6
		(void) setgid(cached_gid);
		(void) setuid(cached_uid);
E 6

		(void) execl("/bin/sh", "sh", "-c", cmd, (char *) NULL);
		_exit(255);
	}
	if (pid == -1) {
		msg_out("rpc.pcnfsd: fork failed");
		close(parent_fd);
		close(child_fd);
		return (NULL);
	}
	child_pid = pid;
	close(child_fd);
D 7
	return (fdopen(parent_fd, "r"));
E 7
I 7
	start_watchdog(maxtime);
	pipe_handle = fdopen(parent_fd, "r");
	return (pipe_handle);
E 7
}

int
su_pclose(ptr)
	FILE           *ptr;
{
D 7
	int             pid, status, omask;
E 7
I 7
	int             pid, status;
E 7

I 7
	stop_watchdog();

E 7
	fclose(ptr);
	if (child_pid == -1)
		return (-1);
I 6
D 7
#ifdef questionable
E 6
	omask = sigblock(sigmask(SIGINT) | sigmask(SIGQUIT) | sigmask(SIGHUP));
I 6
#endif /* questionable */
E 7
E 6
	while ((pid = wait(&status)) != child_pid && pid != -1);
I 6
D 7
#ifdef questionable
E 6
	(void) sigsetmask(omask);
I 6
#endif /* questionable */
E 7
E 6
	return (pid == -1 ? -1 : status);
I 6
}


/*
** The following routine reads a file "/etc/pcnfsd.conf" if present,
** and uses it to replace certain builtin elements, like the
** name of the print spool directory. The configuration file
** Is the usual kind: Comments begin with '#', blank lines are ignored,
** and valid lines are of the form
**
**	<keyword><whitespace><value>
**
** The following keywords are recognized:
**
**	spooldir
**	printer name alias-for command
**	wtmp yes|no
*/
void
config_from_file()
{
FILE *fd;
char buff[1024];
char *cp;
char *kw;
char *val;
char *arg1;
char *arg2;
D 7
char *arg3;
E 7

	if((fd = fopen("/etc/pcnfsd.conf", "r")) == NULL)
		return;
	while(fgets(buff, 1024, fd)) {
		cp = strchr(buff, '\n');
		*cp = '\0';
		cp = strchr(buff, '#');
		if(cp)
			*cp = '\0';
		kw = strtok(buff, " \t");
		if(kw == NULL)
			continue;
		val = strtok(NULL, " \t");
		if(val == NULL)
			continue;
		if(!mystrcasecmp(kw, "spooldir")) {
			strcpy(sp_name, val);
			continue;
		}
#ifdef WTMP
		if(!mystrcasecmp(kw, "wtmp")) {
			/* assume default is YES, just look for negatives */
			if(!mystrcasecmp(val, "no") ||
			   !mystrcasecmp(val, "off") ||
			   !mystrcasecmp(val, "disable") ||
			   !strcmp(val, "0"))
				wtmp_enabled = 0;;
			continue;
		}
#endif	
		if(!mystrcasecmp(kw, "printer")) {
			arg1 = strtok(NULL, " \t");
			arg2 = strtok(NULL, "");
			(void)add_printer_alias(val, arg1, arg2);
			continue;
		}
/*
** Add new cases here
*/
	}
	fclose(fd);
}


/*
** The following are replacements for the SunOS library
** routines strcasecmp and strncasecmp, which SVR4 doesn't
** include.
*/

mystrcasecmp(s1, s2)
	char *s1, *s2;
{

	while (toupper(*s1) == toupper(*s2++))
		if (*s1++ == '\0')
			return(0);
	return(toupper(*s1) - toupper(*--s2));
}

mystrncasecmp(s1, s2, n)
	char *s1, *s2;
	int n;
{

	while (--n >= 0 && toupper(*s1) == toupper(*s2++))
		if (*s1++ == '\0')
			return(0);
	return(n < 0 ? 0 : toupper(*s1) - toupper(*--s2));
E 6
}
E 5
E 3
E 1
