.TH MFSM 1 24/3/1995 mfsm mfsm
.SH NAME
mfsm \- file system and disk quota monitor for X-Motif

.SH SYNOPSIS
.B mfsm
[
.B -a
] [
.B -fs
filesystem[:filesystem ...] ] [
.B -fn
font ] [
.B -int
seconds ] [
.B -bellint
seconds ] [
.B -gacol
colour ] [
.B -yacol
colour ] [
.B -racol
colour ] [
.B -pacol
colour ] [
.B -yalim
% ] [
.B -ralim
% ] [
.B -paniclim
% ] [
.B -t
] [
.B -u
] [
.B -v
] [
.B -width
pixels ]

.SH DESCRIPTION
Mfsm is a X-Windows Motif utility that monitors freespace and user
quotas of filesystems. The program displays a drive icon, a usage
bar chart, and an alert bell toggle. The drive icon displays the type
of filesystem being monitored (e.g. floppy, disk, cdrom, user
account). The usage bar gives a display of the percentage use of the
filesystem and displays the amount of space remaining in
megabytes. If the file system is a user account with quotas enabled,
then the usage bar will display remaining quota space available. A
"(Q)" will be displayed if quotas are being used. The usage bar
changes colour depending the amount of file system use. The alert bell
toggle is used to disable the alert bell that sounds when the file
system is full.

.SH OPTIONS
.B -a
.RS 3
This option causes all mounted file systems to be monitored. The 
option can be used inconjunction with the
.B -fs
option. One or either must be specified.
.RE

.B -fs
filesystem[:filesystem ...]
.RS 3
filesystem denotes a mounted file system (e.g. /usr or /tmp), or user
account (e.g. /home/guest). This option can be used inconjunction with
the
.B -a
option. One or either options must be used.
.RE

.B -fn
font
.RS 3
This option overrides the default font used to display file system
information within the usage bar. The default is
.B 8x13.
.RE

.B -int
seconds
.RS 3
This option sets the usage bar refresh rate in seconds. Fractions of
seconds may be used (e.g. 0.5). The default is
.B 1
second.
.RE

.B -bellint
seconds
.RS 3
This option sets the rate at which the alert bell will sound when a
file system becomes full. The default is
.B 1
second.
.RE

.B -gacol
colour
.RS 3
This option sets the colour of the usage bar when the percentage use
of the file system is below the value set by the yellow alert limit
.B yalim.
The default colour is
.B green.
.RE

.B -yacol
colour
.RS 3
This option sets the colour of the usage bar when the percentage use
of the file system is below the value set by the red alert limit
.B ralim.
The default colour is
.B yellow.
.RE

.B -racol
colour
.RS 3
This option sets the colour of the usage bar when the percentage use
of the file system is below the value set by the panic alert limit
.B paniclim.
The default colour is
.B red.
.RE

.B -pacol
colour
.RS 3
This option sets the colour of the usage bar when the file system is full.
The default is colour is
.B gold3.
.RE

.B -yalim
%
.RS 3
This option sets the file system usage limit in % for the yellow alert
coloured usage bar. The usage bar will change to colour
.B yacol
when this limit is reached. The default is
.B 75.
.RE

.B -ralim
%
.RS 3
This option sets the file system usage limit in % for the red alert
coloured usage bar. The usage bar will change to colour
.B racol
when this limit is reached. The default is
.B 95.
.RE

.B -paniclim
%
.RS 3
This option sets the file system usage limit in % for the panic alert
coloured usage bar. The usage bar will change to colour
.B pacol
when this limit is reached. The default is
.B 99.
.RE

.B -t
.RS 3
This option removes the window manager's title bar from the window.
.RE

.B -u
.RS 3
This option displays file system usage rather than free space. This
may be selected at run-time by pressing the
.B u
key. Free space can be displayed by pressing the
.B f
key.
.RE


.B -v
.RS 3
This option produces verbose comment to stdout about the mfsm
monitoring system. Good for debugging perposes.
.RE

.B -width
pixels
.RS 3
This option sets the width of the usage bar in pixels. The default is
.B 400.
.RE

.SH EXAMPLES
mfsm -a
.RS 3
Tells
.B mfsm
 to monitor all mounted file systems.
.RE

mfsm -fs /home/guest:/tmp
.RS 3
Tells
.B mfsm
to monitor the user account /home/guest and the temporary file system
space /tmp. If quotas are enabled for
.I guest,
then quota information will be used.
.RE

.SH KEYBOARD COMMANDS
A number of keyboard keys are associated with display functions. These
are:

.B a
.RS 3
This key will display the about dialog window.
.RE

.B f
.RS 3
This key will set the display to show free space in MegaBytes.
.RE

.B q
.RS 3
This key will quit the Mfsm program.
.RE

.B u
.RS 3
This key will set the display to show file system usage in MegaBytes.
.RE

.B v
.RS 3
This key will toggle the verbose information support on and off.
.RE

.SH XDEFAULTS
This program understands the core resource names and classes as well
as:
.PP
.B bellInterval (\fPclass\fB BellInterval)
.RS 3
Float that specifies the alert bell interval. The default is
.B 1.
.RE

.B fileSystem (\fPclass\fB FileSystem)
.RS 3
String that specifies the default files systems to monitor. The default is
.B NULL.
.RE

.B greenAlertColor (\fPclass\fB GreenAlertColor)
.RS 3
String that specifies the colour of the green alert usage bar. The
default is
.B green.
.RE

.B interval (\fPclass\fB Interval)
.RS 3
Float that specifies the refresh interval for the usage bar. The default is
.B 1.
.RE

.B panicAlertColor (\fPclass\fB PanicAlertColor)
.RS 3
String that specifies the colour of the panic alert usage bar. The
default is
.B gold3.
.RE

.B panicAlertLimit (\fPclass\fB PanicAlertLimit)
.RS 3
Integer that specifies the percentage limit of the panic alert usage
bar. The default is
.B 99.
.RE

.B redAlertColor (\fPclass\fB RedAlertColor)
.RS 3
String that specifies the colour of the red alert usage bar. The
default is
.B red.
.RE

.B redAlertLimit (\fPclass\fB RedAlertLimit)
.RS 3
Integer that specifies the percentage limit of the red alert usage
bar. The default is
.B 95.
.RE

.B showAllDrives (\fPclass\fB ShowAllDrives)
.RS 3
Boolean that specifies if all mounted file systems will be
monitored. Default is
.B False.
.RE

.B showDiskUsed (\fPclass\fB ShowDiskUsed)
.RS 3
Boolean that specifies if file system (disk) usage is to be displayed
rather than free space. The default is
.B False.
.RE

.B showTitleBar (\fPclass\fB ShowTitleBar)
.RS 3
Boolean that specifies whether or not the window manager will display
the title bar. The default is
.B True.
.RE

.B verbose (\fPclass\fB Verbose)
.RS 3
Boolean that specifies whether or not the verbose comment mode will be
used. The default is
.B False.
.RE

.B yellowAlertColor (\fPclass\fB YellowAlertColor)
.RS 3
String that specifies the colour of the yellow alert usage bar. The
default is
.B yellow.
.RE

.B yellowAlertLimit (\fPclass\fB YellowAlertLimit)
.RS 3
Integer that specifies the percentage limit of the yellow alert usage
bar. The default is
.B 75.
.RE

.SH VERSION
Mfsm V-1.1

.SH COPYRIGHT
Copyright 1995 by Shane D. Hill. All rights reserved.

.SH AUTHOR
Shane D. Hill (Shane.Hill@dsto.defence.gov.au)

.SH "SEE ALSO"
df(1), getpwent(2), ioctl(2), quotactl(2), setpwent(2), statfs(2)
