/***************************************************************************
 * This program is Copyright (C) 1986, 1987, 1988 by Jonathan Payne.  JOVE *
 * is provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is    *
 * included in all the files.                                              *
 ***************************************************************************/

/* keys.c is derived from keys.txt by setmaps */

/* Only edit keys.txt, not keys.c.
 *
 * keys.txt is processed as text by setmaps.  This means that what follows
 * is a very restricted subset of C.
 *
 * - Lines beginning with "#if", "#else", and "#endif" are understood
 *   to be the parts of conditional compilation.
 *   They will not be recognized if they are "spelled" differently
 *   (say, with whitespace).  Generally, there ought to be the same
 *   number of table entries in each branch of the if.
 *
 * - On a Mac, lines begining with "#MENU" are used to specify that
 *   the table is for a menu.
 *
 * - Lines begining with a tab followed by a " are treated as table entries.
 *
 * - Other lines are passed through, and are assumed to delimit tables.
 *   This means that they must not be within tables.
 */

#include "jove.h"
#include "commands.h"

data_obj *MainKeys[NCHARS] = {
	(data_obj *) &commands[171],	/* C-@ */
	(data_obj *) &commands[16],	/* C-A */
	(data_obj *) &commands[7],	/* C-B */
	(data_obj *) NULL,		/* C-C */
	(data_obj *) &commands[44],	/* C-D */
	(data_obj *) &commands[68],	/* C-E */
	(data_obj *) &commands[84],	/* C-F */
	(data_obj *) NULL,		/* C-G */
	(data_obj *) &commands[46],	/* C-H */
	(data_obj *) &commands[96],	/* C-I */
	(data_obj *) &commands[121],	/* C-J */
	(data_obj *) &commands[109],	/* C-K */
	(data_obj *) &commands[154],	/* C-L */
	(data_obj *) &commands[119],	/* C-M */
	(data_obj *) &commands[123],	/* C-N */
	(data_obj *) &commands[120],	/* C-O */
	(data_obj *) &commands[136],	/* C-P */
	(data_obj *) &commands[150],	/* C-Q */
	(data_obj *) &commands[166],	/* C-R */
	(data_obj *) &commands[164],	/* C-S */
	(data_obj *) &commands[188],	/* C-T */
	(data_obj *) &commands[91],	/* C-U */
	(data_obj *) &commands[124],	/* C-V */
	(data_obj *) &commands[105],	/* C-W */
	(data_obj *) NULL,		/* C-X */
	(data_obj *) &commands[201],	/* C-Y */
	(data_obj *) &commands[163],	/* C-Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) &commands[164],	/* C-\ */
	(data_obj *) NULL,		/* C-] */
	(data_obj *) &commands[150],	/* C-^ */
	(data_obj *) NULL,		/* C-_ */
	(data_obj *) &commands[169],	/*   */
	(data_obj *) &commands[169],	/* ! */
	(data_obj *) &commands[169],	/* " */
	(data_obj *) &commands[169],	/* # */
	(data_obj *) &commands[169],	/* $ */
	(data_obj *) &commands[169],	/* % */
	(data_obj *) &commands[169],	/* & */
	(data_obj *) &commands[169],	/* ' */
	(data_obj *) &commands[169],	/* ( */
	(data_obj *) &commands[129],	/* ) */
	(data_obj *) &commands[169],	/* * */
	(data_obj *) &commands[169],	/* + */
	(data_obj *) &commands[169],	/* , */
	(data_obj *) &commands[169],	/* - */
	(data_obj *) &commands[169],	/* . */
	(data_obj *) &commands[169],	/* / */
	(data_obj *) &commands[169],	/* 0 */
	(data_obj *) &commands[169],	/* 1 */
	(data_obj *) &commands[169],	/* 2 */
	(data_obj *) &commands[169],	/* 3 */
	(data_obj *) &commands[169],	/* 4 */
	(data_obj *) &commands[169],	/* 5 */
	(data_obj *) &commands[169],	/* 6 */
	(data_obj *) &commands[169],	/* 7 */
	(data_obj *) &commands[169],	/* 8 */
	(data_obj *) &commands[169],	/* 9 */
	(data_obj *) &commands[169],	/* : */
	(data_obj *) &commands[169],	/* ; */
	(data_obj *) &commands[169],	/* < */
	(data_obj *) &commands[169],	/* = */
	(data_obj *) &commands[169],	/* > */
	(data_obj *) &commands[169],	/* ? */
	(data_obj *) &commands[169],	/* @ */
	(data_obj *) &commands[169],	/* A */
	(data_obj *) &commands[169],	/* B */
	(data_obj *) &commands[169],	/* C */
	(data_obj *) &commands[169],	/* D */
	(data_obj *) &commands[169],	/* E */
	(data_obj *) &commands[169],	/* F */
	(data_obj *) &commands[169],	/* G */
	(data_obj *) &commands[169],	/* H */
	(data_obj *) &commands[169],	/* I */
	(data_obj *) &commands[169],	/* J */
	(data_obj *) &commands[169],	/* K */
	(data_obj *) &commands[169],	/* L */
	(data_obj *) &commands[169],	/* M */
	(data_obj *) &commands[169],	/* N */
	(data_obj *) &commands[169],	/* O */
	(data_obj *) &commands[169],	/* P */
	(data_obj *) &commands[169],	/* Q */
	(data_obj *) &commands[169],	/* R */
	(data_obj *) &commands[169],	/* S */
	(data_obj *) &commands[169],	/* T */
	(data_obj *) &commands[169],	/* U */
	(data_obj *) &commands[169],	/* V */
	(data_obj *) &commands[169],	/* W */
	(data_obj *) &commands[169],	/* X */
	(data_obj *) &commands[169],	/* Y */
	(data_obj *) &commands[169],	/* Z */
	(data_obj *) &commands[169],	/* [ */
	(data_obj *) &commands[169],	/* \ */
	(data_obj *) &commands[129],	/* ] */
	(data_obj *) &commands[169],	/* ^ */
	(data_obj *) &commands[169],	/* _ */
	(data_obj *) &commands[169],	/* ` */
	(data_obj *) &commands[169],	/* a */
	(data_obj *) &commands[169],	/* b */
	(data_obj *) &commands[169],	/* c */
	(data_obj *) &commands[169],	/* d */
	(data_obj *) &commands[169],	/* e */
	(data_obj *) &commands[169],	/* f */
	(data_obj *) &commands[169],	/* g */
	(data_obj *) &commands[169],	/* h */
	(data_obj *) &commands[169],	/* i */
	(data_obj *) &commands[169],	/* j */
	(data_obj *) &commands[169],	/* k */
	(data_obj *) &commands[169],	/* l */
	(data_obj *) &commands[169],	/* m */
	(data_obj *) &commands[169],	/* n */
	(data_obj *) &commands[169],	/* o */
	(data_obj *) &commands[169],	/* p */
	(data_obj *) &commands[169],	/* q */
	(data_obj *) &commands[169],	/* r */
	(data_obj *) &commands[169],	/* s */
	(data_obj *) &commands[169],	/* t */
	(data_obj *) &commands[169],	/* u */
	(data_obj *) &commands[169],	/* v */
	(data_obj *) &commands[169],	/* w */
	(data_obj *) &commands[169],	/* x */
	(data_obj *) &commands[169],	/* y */
	(data_obj *) &commands[169],	/* z */
	(data_obj *) &commands[169],	/* { */
	(data_obj *) &commands[169],	/* | */
	(data_obj *) &commands[129],	/* } */
	(data_obj *) &commands[169],	/* ~ */
	(data_obj *) &commands[46],	/* ^? */
#ifndef	ASCII7
	(data_obj *) &commands[169],	/* M-C-@ */
	(data_obj *) &commands[169],	/* M-C-A */
	(data_obj *) &commands[169],	/* M-C-B */
	(data_obj *) &commands[169],	/* M-C-C */
	(data_obj *) &commands[169],	/* M-C-D */
	(data_obj *) &commands[169],	/* M-C-E */
	(data_obj *) &commands[169],	/* M-C-F */
	(data_obj *) &commands[169],	/* M-C-G */
	(data_obj *) &commands[169],	/* M-C-H */
	(data_obj *) &commands[169],	/* M-C-I */
	(data_obj *) &commands[169],	/* M-C-J */
	(data_obj *) &commands[169],	/* M-C-K */
	(data_obj *) &commands[169],	/* M-C-L */
	(data_obj *) &commands[169],	/* M-C-M */
	(data_obj *) &commands[169],	/* M-C-N */
	(data_obj *) &commands[169],	/* M-C-O */
	(data_obj *) &commands[169],	/* M-C-P */
	(data_obj *) &commands[169],	/* M-C-Q */
	(data_obj *) &commands[169],	/* M-C-R */
	(data_obj *) &commands[169],	/* M-C-S */
	(data_obj *) &commands[169],	/* M-C-T */
	(data_obj *) &commands[169],	/* M-C-U */
	(data_obj *) &commands[169],	/* M-C-V */
	(data_obj *) &commands[169],	/* M-C-W */
	(data_obj *) &commands[169],	/* M-C-X */
	(data_obj *) &commands[169],	/* M-C-Y */
	(data_obj *) &commands[169],	/* M-C-Z */
	(data_obj *) &commands[169],	/* M-ESC */
	(data_obj *) &commands[169],	/* M-C-\ */
	(data_obj *) &commands[169],	/* M-C-] */
	(data_obj *) &commands[169],	/* M-C-^ */
	(data_obj *) &commands[169],	/* M-C-_ */
	(data_obj *) &commands[169],	/* M-  */
	(data_obj *) &commands[169],	/* M-! */
	(data_obj *) &commands[169],	/* M-" */
	(data_obj *) &commands[169],	/* M-# */
	(data_obj *) &commands[169],	/* M-$ */
	(data_obj *) &commands[169],	/* M-% */
	(data_obj *) &commands[169],	/* M-& */
	(data_obj *) &commands[169],	/* M-' */
	(data_obj *) &commands[169],	/* M-( */
	(data_obj *) &commands[169],	/* M-) */
	(data_obj *) &commands[169],	/* M-* */
	(data_obj *) &commands[169],	/* M-+ */
	(data_obj *) &commands[169],	/* M-, */
	(data_obj *) &commands[169],	/* M-- */
	(data_obj *) &commands[169],	/* M-. */
	(data_obj *) &commands[169],	/* M-/ */
	(data_obj *) &commands[169],	/* M-0 */
	(data_obj *) &commands[169],	/* M-1 */
	(data_obj *) &commands[169],	/* M-2 */
	(data_obj *) &commands[169],	/* M-3 */
	(data_obj *) &commands[169],	/* M-4 */
	(data_obj *) &commands[169],	/* M-5 */
	(data_obj *) &commands[169],	/* M-6 */
	(data_obj *) &commands[169],	/* M-7 */
	(data_obj *) &commands[169],	/* M-8 */
	(data_obj *) &commands[169],	/* M-9 */
	(data_obj *) &commands[169],	/* M-: */
	(data_obj *) &commands[169],	/* M-; */
	(data_obj *) &commands[169],	/* M-< */
	(data_obj *) &commands[169],	/* M-= */
	(data_obj *) &commands[169],	/* M-> */
	(data_obj *) &commands[169],	/* M-? */
	(data_obj *) &commands[169],	/* M-@ */
	(data_obj *) &commands[169],	/* M-A */
	(data_obj *) &commands[169],	/* M-B */
	(data_obj *) &commands[169],	/* M-C */
	(data_obj *) &commands[169],	/* M-D */
	(data_obj *) &commands[169],	/* M-E */
	(data_obj *) &commands[169],	/* M-F */
	(data_obj *) &commands[169],	/* M-G */
	(data_obj *) &commands[169],	/* M-H */
	(data_obj *) &commands[169],	/* M-I */
	(data_obj *) &commands[169],	/* M-J */
	(data_obj *) &commands[169],	/* M-K */
	(data_obj *) &commands[169],	/* M-L */
	(data_obj *) &commands[169],	/* M-M */
	(data_obj *) &commands[169],	/* M-N */
	(data_obj *) &commands[169],	/* M-O */
	(data_obj *) &commands[169],	/* M-P */
	(data_obj *) &commands[169],	/* M-Q */
	(data_obj *) &commands[169],	/* M-R */
	(data_obj *) &commands[169],	/* M-S */
	(data_obj *) &commands[169],	/* M-T */
	(data_obj *) &commands[169],	/* M-U */
	(data_obj *) &commands[169],	/* M-V */
	(data_obj *) &commands[169],	/* M-W */
	(data_obj *) &commands[169],	/* M-X */
	(data_obj *) &commands[169],	/* M-Y */
	(data_obj *) &commands[169],	/* M-Z */
	(data_obj *) &commands[169],	/* M-[ */
	(data_obj *) &commands[169],	/* M-\ */
	(data_obj *) &commands[169],	/* M-] */
	(data_obj *) &commands[169],	/* M-^ */
	(data_obj *) &commands[169],	/* M-_ */
	(data_obj *) &commands[169],	/* M-` */
	(data_obj *) &commands[169],	/* M-a */
	(data_obj *) &commands[169],	/* M-b */
	(data_obj *) &commands[169],	/* M-c */
	(data_obj *) &commands[169],	/* M-d */
	(data_obj *) &commands[169],	/* M-e */
	(data_obj *) &commands[169],	/* M-f */
	(data_obj *) &commands[169],	/* M-g */
	(data_obj *) &commands[169],	/* M-h */
	(data_obj *) &commands[169],	/* M-i */
	(data_obj *) &commands[169],	/* M-j */
	(data_obj *) &commands[169],	/* M-k */
	(data_obj *) &commands[169],	/* M-l */
	(data_obj *) &commands[169],	/* M-m */
	(data_obj *) &commands[169],	/* M-n */
	(data_obj *) &commands[169],	/* M-o */
	(data_obj *) &commands[169],	/* M-p */
	(data_obj *) &commands[169],	/* M-q */
	(data_obj *) &commands[169],	/* M-r */
	(data_obj *) &commands[169],	/* M-s */
	(data_obj *) &commands[169],	/* M-t */
	(data_obj *) &commands[169],	/* M-u */
	(data_obj *) &commands[169],	/* M-v */
	(data_obj *) &commands[169],	/* M-w */
	(data_obj *) &commands[169],	/* M-x */
	(data_obj *) &commands[169],	/* M-y */
	(data_obj *) &commands[169],	/* M-z */
	(data_obj *) &commands[169],	/* M-{ */
	(data_obj *) &commands[169],	/* M-| */
	(data_obj *) &commands[169],	/* M-} */
	(data_obj *) &commands[169],	/* M-~ */
	(data_obj *) &commands[169],	/* M-^? */
#endif	/* !ASCII7 */
};

data_obj *EscKeys[NCHARS] = {
	(data_obj *) &commands[171],	/* C-@ */
	(data_obj *) NULL,		/* C-A */
	(data_obj *) &commands[10],	/* C-B */
	(data_obj *) NULL,		/* C-C */
	(data_obj *) &commands[64],	/* C-D */
	(data_obj *) NULL,		/* C-E */
	(data_obj *) &commands[87],	/* C-F */
	(data_obj *) NULL,		/* C-G */
	(data_obj *) NULL,		/* C-H */
	(data_obj *) NULL,		/* C-I */
	(data_obj *) NULL,		/* C-J */
	(data_obj *) &commands[106],	/* C-K */
	(data_obj *) &commands[32],	/* C-L */
	(data_obj *) NULL,		/* C-M */
	(data_obj *) &commands[85],	/* C-N */
	(data_obj *) NULL,		/* C-O */
	(data_obj *) &commands[8],	/* C-P */
	(data_obj *) NULL,		/* C-Q */
	(data_obj *) NULL,		/* C-R */
	(data_obj *) NULL,		/* C-S */
	(data_obj *) NULL,		/* C-T */
	(data_obj *) &commands[12],	/* C-U */
	(data_obj *) &commands[128],	/* C-V */
	(data_obj *) NULL,		/* C-W */
	(data_obj *) NULL,		/* C-X */
	(data_obj *) NULL,		/* C-Y */
	(data_obj *) NULL,		/* C-Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) NULL,		/* C-\ */
	(data_obj *) NULL,		/* C-] */
	(data_obj *) NULL,		/* C-^ */
	(data_obj *) NULL,		/* C-_ */
	(data_obj *) NULL,		/*   */
	(data_obj *) NULL,		/* ! */
	(data_obj *) NULL,		/* " */
	(data_obj *) NULL,		/* # */
	(data_obj *) NULL,		/* $ */
	(data_obj *) NULL,		/* % */
	(data_obj *) NULL,		/* & */
	(data_obj *) NULL,		/* ' */
	(data_obj *) NULL,		/* ( */
	(data_obj *) NULL,		/* ) */
	(data_obj *) NULL,		/* * */
	(data_obj *) NULL,		/* + */
	(data_obj *) &commands[17],	/* , */
	(data_obj *) &commands[62],	/* - */
	(data_obj *) &commands[69],	/* . */
	(data_obj *) NULL,		/* / */
	(data_obj *) &commands[52],	/* 0 */
	(data_obj *) &commands[53],	/* 1 */
	(data_obj *) &commands[54],	/* 2 */
	(data_obj *) &commands[55],	/* 3 */
	(data_obj *) &commands[56],	/* 4 */
	(data_obj *) &commands[57],	/* 5 */
	(data_obj *) &commands[58],	/* 6 */
	(data_obj *) &commands[59],	/* 7 */
	(data_obj *) &commands[60],	/* 8 */
	(data_obj *) &commands[61],	/* 9 */
	(data_obj *) NULL,		/* : */
	(data_obj *) NULL,		/* ; */
	(data_obj *) &commands[15],	/* < */
	(data_obj *) NULL,		/* = */
	(data_obj *) &commands[67],	/* > */
	(data_obj *) &commands[49],	/* ? */
	(data_obj *) NULL,		/* @ */
	(data_obj *) &commands[11],	/* A */
	(data_obj *) &commands[13],	/* B */
	(data_obj *) &commands[27],	/* C */
	(data_obj *) &commands[102],	/* D */
	(data_obj *) &commands[88],	/* E */
	(data_obj *) &commands[89],	/* F */
	(data_obj *) &commands[92],	/* G */
	(data_obj *) NULL,		/* H */
	(data_obj *) &commands[117],	/* I */
	(data_obj *) &commands[77],	/* J */
	(data_obj *) &commands[110],	/* K */
	(data_obj *) &commands[28],	/* L */
	(data_obj *) &commands[83],	/* M */
	(data_obj *) NULL,		/* N */
	(data_obj *) NULL,		/* O */
	(data_obj *) NULL,		/* P */
	(data_obj *) &commands[148],	/* Q */
	(data_obj *) &commands[157],	/* R */
	(data_obj *) NULL,		/* S */
	(data_obj *) NULL,		/* T */
	(data_obj *) &commands[29],	/* U */
	(data_obj *) &commands[137],	/* V */
	(data_obj *) &commands[34],	/* W */
	(data_obj *) &commands[74],	/* X */
	(data_obj *) &commands[202],	/* Y */
	(data_obj *) &commands[160],	/* Z */
	(data_obj *) &commands[9],	/* [ */
	(data_obj *) &commands[47],	/* \ */
	(data_obj *) &commands[86],	/* ] */
	(data_obj *) NULL,		/* ^ */
	(data_obj *) NULL,		/* _ */
	(data_obj *) NULL,		/* ` */
	(data_obj *) &commands[11],	/* a */
	(data_obj *) &commands[13],	/* b */
	(data_obj *) &commands[27],	/* c */
	(data_obj *) &commands[102],	/* d */
	(data_obj *) &commands[88],	/* e */
	(data_obj *) &commands[89],	/* f */
	(data_obj *) &commands[92],	/* g */
	(data_obj *) NULL,		/* h */
	(data_obj *) &commands[117],	/* i */
	(data_obj *) &commands[77],	/* j */
	(data_obj *) &commands[110],	/* k */
	(data_obj *) &commands[28],	/* l */
	(data_obj *) &commands[83],	/* m */
	(data_obj *) NULL,		/* n */
	(data_obj *) NULL,		/* o */
	(data_obj *) NULL,		/* p */
	(data_obj *) &commands[148],	/* q */
	(data_obj *) &commands[157],	/* r */
	(data_obj *) NULL,		/* s */
	(data_obj *) NULL,		/* t */
	(data_obj *) &commands[29],	/* u */
	(data_obj *) &commands[137],	/* v */
	(data_obj *) &commands[34],	/* w */
	(data_obj *) &commands[74],	/* x */
	(data_obj *) &commands[202],	/* y */
	(data_obj *) &commands[160],	/* z */
	(data_obj *) NULL,		/* { */
	(data_obj *) NULL,		/* | */
	(data_obj *) NULL,		/* } */
	(data_obj *) &commands[115],	/* ~ */
	(data_obj *) &commands[103],	/* ^? */
#ifndef	ASCII7
	(data_obj *) NULL,		/* M-C-@ */
	(data_obj *) NULL,		/* M-C-A */
	(data_obj *) NULL,		/* M-C-B */
	(data_obj *) NULL,		/* M-C-C */
	(data_obj *) NULL,		/* M-C-D */
	(data_obj *) NULL,		/* M-C-E */
	(data_obj *) NULL,		/* M-C-F */
	(data_obj *) NULL,		/* M-C-G */
	(data_obj *) NULL,		/* M-C-H */
	(data_obj *) NULL,		/* M-C-I */
	(data_obj *) NULL,		/* M-C-J */
	(data_obj *) NULL,		/* M-C-K */
	(data_obj *) NULL,		/* M-C-L */
	(data_obj *) NULL,		/* M-C-M */
	(data_obj *) NULL,		/* M-C-N */
	(data_obj *) NULL,		/* M-C-O */
	(data_obj *) NULL,		/* M-C-P */
	(data_obj *) NULL,		/* M-C-Q */
	(data_obj *) NULL,		/* M-C-R */
	(data_obj *) NULL,		/* M-C-S */
	(data_obj *) NULL,		/* M-C-T */
	(data_obj *) NULL,		/* M-C-U */
	(data_obj *) NULL,		/* M-C-V */
	(data_obj *) NULL,		/* M-C-W */
	(data_obj *) NULL,		/* M-C-X */
	(data_obj *) NULL,		/* M-C-Y */
	(data_obj *) NULL,		/* M-C-Z */
	(data_obj *) NULL,		/* M-ESC */
	(data_obj *) NULL,		/* M-C-\ */
	(data_obj *) NULL,		/* M-C-] */
	(data_obj *) NULL,		/* M-C-^ */
	(data_obj *) NULL,		/* M-C-_ */
	(data_obj *) NULL,		/* M-  */
	(data_obj *) NULL,		/* M-! */
	(data_obj *) NULL,		/* M-" */
	(data_obj *) NULL,		/* M-# */
	(data_obj *) NULL,		/* M-$ */
	(data_obj *) NULL,		/* M-% */
	(data_obj *) NULL,		/* M-& */
	(data_obj *) NULL,		/* M-' */
	(data_obj *) NULL,		/* M-( */
	(data_obj *) NULL,		/* M-) */
	(data_obj *) NULL,		/* M-* */
	(data_obj *) NULL,		/* M-+ */
	(data_obj *) NULL,		/* M-, */
	(data_obj *) NULL,		/* M-- */
	(data_obj *) NULL,		/* M-. */
	(data_obj *) NULL,		/* M-/ */
	(data_obj *) NULL,		/* M-0 */
	(data_obj *) NULL,		/* M-1 */
	(data_obj *) NULL,		/* M-2 */
	(data_obj *) NULL,		/* M-3 */
	(data_obj *) NULL,		/* M-4 */
	(data_obj *) NULL,		/* M-5 */
	(data_obj *) NULL,		/* M-6 */
	(data_obj *) NULL,		/* M-7 */
	(data_obj *) NULL,		/* M-8 */
	(data_obj *) NULL,		/* M-9 */
	(data_obj *) NULL,		/* M-: */
	(data_obj *) NULL,		/* M-; */
	(data_obj *) NULL,		/* M-< */
	(data_obj *) NULL,		/* M-= */
	(data_obj *) NULL,		/* M-> */
	(data_obj *) NULL,		/* M-? */
	(data_obj *) NULL,		/* M-@ */
	(data_obj *) NULL,		/* M-A */
	(data_obj *) NULL,		/* M-B */
	(data_obj *) NULL,		/* M-C */
	(data_obj *) NULL,		/* M-D */
	(data_obj *) NULL,		/* M-E */
	(data_obj *) NULL,		/* M-F */
	(data_obj *) NULL,		/* M-G */
	(data_obj *) NULL,		/* M-H */
	(data_obj *) NULL,		/* M-I */
	(data_obj *) NULL,		/* M-J */
	(data_obj *) NULL,		/* M-K */
	(data_obj *) NULL,		/* M-L */
	(data_obj *) NULL,		/* M-M */
	(data_obj *) NULL,		/* M-N */
	(data_obj *) NULL,		/* M-O */
	(data_obj *) NULL,		/* M-P */
	(data_obj *) NULL,		/* M-Q */
	(data_obj *) NULL,		/* M-R */
	(data_obj *) NULL,		/* M-S */
	(data_obj *) NULL,		/* M-T */
	(data_obj *) NULL,		/* M-U */
	(data_obj *) NULL,		/* M-V */
	(data_obj *) NULL,		/* M-W */
	(data_obj *) NULL,		/* M-X */
	(data_obj *) NULL,		/* M-Y */
	(data_obj *) NULL,		/* M-Z */
	(data_obj *) NULL,		/* M-[ */
	(data_obj *) NULL,		/* M-\ */
	(data_obj *) NULL,		/* M-] */
	(data_obj *) NULL,		/* M-^ */
	(data_obj *) NULL,		/* M-_ */
	(data_obj *) NULL,		/* M-` */
	(data_obj *) NULL,		/* M-a */
	(data_obj *) NULL,		/* M-b */
	(data_obj *) NULL,		/* M-c */
	(data_obj *) NULL,		/* M-d */
	(data_obj *) NULL,		/* M-e */
	(data_obj *) NULL,		/* M-f */
	(data_obj *) NULL,		/* M-g */
	(data_obj *) NULL,		/* M-h */
	(data_obj *) NULL,		/* M-i */
	(data_obj *) NULL,		/* M-j */
	(data_obj *) NULL,		/* M-k */
	(data_obj *) NULL,		/* M-l */
	(data_obj *) NULL,		/* M-m */
	(data_obj *) NULL,		/* M-n */
	(data_obj *) NULL,		/* M-o */
	(data_obj *) NULL,		/* M-p */
	(data_obj *) NULL,		/* M-q */
	(data_obj *) NULL,		/* M-r */
	(data_obj *) NULL,		/* M-s */
	(data_obj *) NULL,		/* M-t */
	(data_obj *) NULL,		/* M-u */
	(data_obj *) NULL,		/* M-v */
	(data_obj *) NULL,		/* M-w */
	(data_obj *) NULL,		/* M-x */
	(data_obj *) NULL,		/* M-y */
	(data_obj *) NULL,		/* M-z */
	(data_obj *) NULL,		/* M-{ */
	(data_obj *) NULL,		/* M-| */
	(data_obj *) NULL,		/* M-} */
	(data_obj *) NULL,		/* M-~ */
	(data_obj *) NULL,		/* M-^? */
#endif	/* !ASCII7 */
};

data_obj	*CtlxKeys[NCHARS] = {
	(data_obj *) NULL,		/* C-@ */
	(data_obj *) NULL,		/* C-A */
	(data_obj *) &commands[113],	/* C-B */
	(data_obj *) &commands[75],	/* C-C */
	(data_obj *) NULL,		/* C-D */
	(data_obj *) &commands[33],	/* C-E */
	(data_obj *) &commands[80],	/* C-F */
	(data_obj *) NULL,		/* C-G */
	(data_obj *) NULL,		/* C-H */
	(data_obj *) &commands[100],	/* C-I */
	(data_obj *) NULL,		/* C-J */
	(data_obj *) NULL,		/* C-K */
	(data_obj *) NULL,		/* C-L */
	(data_obj *) &commands[198],	/* C-M */
	(data_obj *) &commands[122],	/* C-N */
	(data_obj *) &commands[40],	/* C-O */
	(data_obj *) &commands[135],	/* C-P */
	(data_obj *) NULL,		/* C-Q */
	(data_obj *) &commands[193],	/* C-R */
	(data_obj *) &commands[159],	/* C-S */
	(data_obj *) &commands[189],	/* C-T */
	(data_obj *) NULL,		/* C-U */
	(data_obj *) &commands[193],	/* C-V */
	(data_obj *) &commands[196],	/* C-W */
	(data_obj *) &commands[71],	/* C-X */
	(data_obj *) NULL,		/* C-Y */
	(data_obj *) NULL,		/* C-Z */
	(data_obj *) NULL,		/* ESC */
	(data_obj *) &commands[159],	/* C-\ */
	(data_obj *) NULL,		/* C-] */
	(data_obj *) NULL,		/* C-^ */
	(data_obj *) NULL,		/* C-_ */
	(data_obj *) NULL,		/*   */
	(data_obj *) &commands[173],	/* ! */
	(data_obj *) NULL,		/* " */
	(data_obj *) NULL,		/* # */
	(data_obj *) NULL,		/* $ */
	(data_obj *) NULL,		/* % */
	(data_obj *) NULL,		/* & */
	(data_obj *) NULL,		/* ' */
	(data_obj *) &commands[14],	/* ( */
	(data_obj *) &commands[66],	/* ) */
	(data_obj *) NULL,		/* * */
	(data_obj *) NULL,		/* + */
	(data_obj *) NULL,		/* , */
	(data_obj *) NULL,		/* - */
	(data_obj *) NULL,		/* . */
	(data_obj *) NULL,		/* / */
	(data_obj *) NULL,		/* 0 */
	(data_obj *) &commands[45],	/* 1 */
	(data_obj *) &commands[183],	/* 2 */
	(data_obj *) NULL,		/* 3 */
	(data_obj *) &commands[194],	/* 4 */
	(data_obj *) NULL,		/* 5 */
	(data_obj *) NULL,		/* 6 */
	(data_obj *) NULL,		/* 7 */
	(data_obj *) NULL,		/* 8 */
	(data_obj *) NULL,		/* 9 */
	(data_obj *) NULL,		/* : */
	(data_obj *) NULL,		/* ; */
	(data_obj *) NULL,		/* < */
	(data_obj *) NULL,		/* = */
	(data_obj *) NULL,		/* > */
	(data_obj *) &commands[50],	/* ? */
	(data_obj *) NULL,		/* @ */
	(data_obj *) NULL,		/* A */
	(data_obj *) &commands[168],	/* B */
	(data_obj *) NULL,		/* C */
	(data_obj *) &commands[42],	/* D */
	(data_obj *) &commands[72],	/* E */
	(data_obj *) NULL,		/* F */
	(data_obj *) NULL,		/* G */
	(data_obj *) NULL,		/* H */
	(data_obj *) NULL,		/* I */
	(data_obj *) NULL,		/* J */
	(data_obj *) &commands[41],	/* K */
	(data_obj *) NULL,		/* L */
	(data_obj *) NULL,		/* M */
	(data_obj *) &commands[125],	/* N */
	(data_obj *) &commands[138],	/* O */
	(data_obj *) &commands[138],	/* P */
	(data_obj *) NULL,		/* Q */
	(data_obj *) NULL,		/* R */
	(data_obj *) &commands[159],	/* S */
	(data_obj *) &commands[81],	/* T */
	(data_obj *) NULL,		/* U */
	(data_obj *) NULL,		/* V */
	(data_obj *) NULL,		/* W */
	(data_obj *) NULL,		/* X */
	(data_obj *) NULL,		/* Y */
	(data_obj *) NULL,		/* Z */
	(data_obj *) NULL,		/* [ */
	(data_obj *) NULL,		/* \ */
	(data_obj *) NULL,		/* ] */
	(data_obj *) &commands[95],	/* ^ */
	(data_obj *) NULL,		/* _ */
	(data_obj *) NULL,		/* ` */
	(data_obj *) NULL,		/* a */
	(data_obj *) &commands[168],	/* b */
	(data_obj *) NULL,		/* c */
	(data_obj *) &commands[42],	/* d */
	(data_obj *) &commands[72],	/* e */
	(data_obj *) NULL,		/* f */
	(data_obj *) NULL,		/* g */
	(data_obj *) NULL,		/* h */
	(data_obj *) NULL,		/* i */
	(data_obj *) NULL,		/* j */
	(data_obj *) &commands[41],	/* k */
	(data_obj *) NULL,		/* l */
	(data_obj *) NULL,		/* m */
	(data_obj *) &commands[125],	/* n */
	(data_obj *) &commands[138],	/* o */
	(data_obj *) &commands[138],	/* p */
	(data_obj *) NULL,		/* q */
	(data_obj *) NULL,		/* r */
	(data_obj *) &commands[159],	/* s */
	(data_obj *) &commands[81],	/* t */
	(data_obj *) NULL,		/* u */
	(data_obj *) NULL,		/* v */
	(data_obj *) NULL,		/* w */
	(data_obj *) NULL,		/* x */
	(data_obj *) NULL,		/* y */
	(data_obj *) NULL,		/* z */
	(data_obj *) NULL,		/* { */
	(data_obj *) NULL,		/* | */
	(data_obj *) NULL,		/* } */
	(data_obj *) NULL,		/* ~ */
	(data_obj *) &commands[108],	/* ^? */
#ifndef	ASCII7
	(data_obj *) NULL,		/* M-C-@ */
	(data_obj *) NULL,		/* M-C-A */
	(data_obj *) NULL,		/* M-C-B */
	(data_obj *) NULL,		/* M-C-C */
	(data_obj *) NULL,		/* M-C-D */
	(data_obj *) NULL,		/* M-C-E */
	(data_obj *) NULL,		/* M-C-F */
	(data_obj *) NULL,		/* M-C-G */
	(data_obj *) NULL,		/* M-C-H */
	(data_obj *) NULL,		/* M-C-I */
	(data_obj *) NULL,		/* M-C-J */
	(data_obj *) NULL,		/* M-C-K */
	(data_obj *) NULL,		/* M-C-L */
	(data_obj *) NULL,		/* M-C-M */
	(data_obj *) NULL,		/* M-C-N */
	(data_obj *) NULL,		/* M-C-O */
	(data_obj *) NULL,		/* M-C-P */
	(data_obj *) NULL,		/* M-C-Q */
	(data_obj *) NULL,		/* M-C-R */
	(data_obj *) NULL,		/* M-C-S */
	(data_obj *) NULL,		/* M-C-T */
	(data_obj *) NULL,		/* M-C-U */
	(data_obj *) NULL,		/* M-C-V */
	(data_obj *) NULL,		/* M-C-W */
	(data_obj *) NULL,		/* M-C-X */
	(data_obj *) NULL,		/* M-C-Y */
	(data_obj *) NULL,		/* M-C-Z */
	(data_obj *) NULL,		/* M-ESC */
	(data_obj *) NULL,		/* M-C-\ */
	(data_obj *) NULL,		/* M-C-] */
	(data_obj *) NULL,		/* M-C-^ */
	(data_obj *) NULL,		/* M-C-_ */
	(data_obj *) NULL,		/* M-  */
	(data_obj *) NULL,		/* M-! */
	(data_obj *) NULL,		/* M-" */
	(data_obj *) NULL,		/* M-# */
	(data_obj *) NULL,		/* M-$ */
	(data_obj *) NULL,		/* M-% */
	(data_obj *) NULL,		/* M-& */
	(data_obj *) NULL,		/* M-' */
	(data_obj *) NULL,		/* M-( */
	(data_obj *) NULL,		/* M-) */
	(data_obj *) NULL,		/* M-* */
	(data_obj *) NULL,		/* M-+ */
	(data_obj *) NULL,		/* M-, */
	(data_obj *) NULL,		/* M-- */
	(data_obj *) NULL,		/* M-. */
	(data_obj *) NULL,		/* M-/ */
	(data_obj *) NULL,		/* M-0 */
	(data_obj *) NULL,		/* M-1 */
	(data_obj *) NULL,		/* M-2 */
	(data_obj *) NULL,		/* M-3 */
	(data_obj *) NULL,		/* M-4 */
	(data_obj *) NULL,		/* M-5 */
	(data_obj *) NULL,		/* M-6 */
	(data_obj *) NULL,		/* M-7 */
	(data_obj *) NULL,		/* M-8 */
	(data_obj *) NULL,		/* M-9 */
	(data_obj *) NULL,		/* M-: */
	(data_obj *) NULL,		/* M-; */
	(data_obj *) NULL,		/* M-< */
	(data_obj *) NULL,		/* M-= */
	(data_obj *) NULL,		/* M-> */
	(data_obj *) NULL,		/* M-? */
	(data_obj *) NULL,		/* M-@ */
	(data_obj *) NULL,		/* M-A */
	(data_obj *) NULL,		/* M-B */
	(data_obj *) NULL,		/* M-C */
	(data_obj *) NULL,		/* M-D */
	(data_obj *) NULL,		/* M-E */
	(data_obj *) NULL,		/* M-F */
	(data_obj *) NULL,		/* M-G */
	(data_obj *) NULL,		/* M-H */
	(data_obj *) NULL,		/* M-I */
	(data_obj *) NULL,		/* M-J */
	(data_obj *) NULL,		/* M-K */
	(data_obj *) NULL,		/* M-L */
	(data_obj *) NULL,		/* M-M */
	(data_obj *) NULL,		/* M-N */
	(data_obj *) NULL,		/* M-O */
	(data_obj *) NULL,		/* M-P */
	(data_obj *) NULL,		/* M-Q */
	(data_obj *) NULL,		/* M-R */
	(data_obj *) NULL,		/* M-S */
	(data_obj *) NULL,		/* M-T */
	(data_obj *) NULL,		/* M-U */
	(data_obj *) NULL,		/* M-V */
	(data_obj *) NULL,		/* M-W */
	(data_obj *) NULL,		/* M-X */
	(data_obj *) NULL,		/* M-Y */
	(data_obj *) NULL,		/* M-Z */
	(data_obj *) NULL,		/* M-[ */
	(data_obj *) NULL,		/* M-\ */
	(data_obj *) NULL,		/* M-] */
	(data_obj *) NULL,		/* M-^ */
	(data_obj *) NULL,		/* M-_ */
	(data_obj *) NULL,		/* M-` */
	(data_obj *) NULL,		/* M-a */
	(data_obj *) NULL,		/* M-b */
	(data_obj *) NULL,		/* M-c */
	(data_obj *) NULL,		/* M-d */
	(data_obj *) NULL,		/* M-e */
	(data_obj *) NULL,		/* M-f */
	(data_obj *) NULL,		/* M-g */
	(data_obj *) NULL,		/* M-h */
	(data_obj *) NULL,		/* M-i */
	(data_obj *) NULL,		/* M-j */
	(data_obj *) NULL,		/* M-k */
	(data_obj *) NULL,		/* M-l */
	(data_obj *) NULL,		/* M-m */
	(data_obj *) NULL,		/* M-n */
	(data_obj *) NULL,		/* M-o */
	(data_obj *) NULL,		/* M-p */
	(data_obj *) NULL,		/* M-q */
	(data_obj *) NULL,		/* M-r */
	(data_obj *) NULL,		/* M-s */
	(data_obj *) NULL,		/* M-t */
	(data_obj *) NULL,		/* M-u */
	(data_obj *) NULL,		/* M-v */
	(data_obj *) NULL,		/* M-w */
	(data_obj *) NULL,		/* M-x */
	(data_obj *) NULL,		/* M-y */
	(data_obj *) NULL,		/* M-z */
	(data_obj *) NULL,		/* M-{ */
	(data_obj *) NULL,		/* M-| */
	(data_obj *) NULL,		/* M-} */
	(data_obj *) NULL,		/* M-~ */
	(data_obj *) NULL,		/* M-^? */
#endif	/* !ASCII7 */
};

