/*** analog.c 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** sscanf.c; functions to replace sscanf(), which is far too slow, in
     certain specific cases ***/

#include "analhead2.h"

/*** First a routine to check if we want to read in the arguments for a
  given filename ***/

flag expandq(char *filename)
{
  extern struct stringlist *expandhead, *noexpandhead;
  extern struct wstringlist *wexpandhead, *wnoexpandhead;

  struct stringlist *stringp;
  struct wstringlist *wstringp;

  /* if it matches any of the WITHOUTARGs, throw it out straight away */

  for (stringp = noexpandhead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0)
      return(FALSE);
  }

  for (wstringp = wnoexpandhead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strncmp(filename, wstringp -> name,
		(size_t)(wstringp -> length)) == 0)
      return(FALSE);
  }

  /* otherwise, it has to match one of the WITHARGs */

  for (stringp = expandhead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0)
      return(TRUE);
  }

  for (wstringp = wexpandhead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strncmp(filename, wstringp -> name,
		(size_t)(wstringp -> length)) == 0)
      return(TRUE);
  }

  /* if it doesn't match any of them, we don't want it */

  return(FALSE);

}


/*** Now the scanning routines ***/

int sscanf_common(char *inputline, char hostn[MAXSTRINGLENGTH], int *date,
		  char month[4], int *year, int *hr, int *min,
		  char filename[MAXSTRINGLENGTH], int *code, char bytestr[16])
{     /* scanning 'common' format logfile entries */
  register char *cin = inputline;   /* the character we are reading */
  register char *cout;              /* where we are putting it */
  int i;

  /* read in hostname */
  i = 0;
  for (cout = hostn; *cin != ' ' && *cin != '\0' && i < MAXSTRINGLENGTH - 1;
       cin++) { 
    *cout = *cin;
    cout++;
    i++;
  }
  if (*cin != ' ')
    return(0);
  *cout = '\0';

  /* scan until next '[' */
  for (cin++; *cin != '[' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(1);

  /* read in date */
  cin++;
  if (!isdigit(*cin))
    return(1);
  else
    *date = 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(1);
  else
    *date += (*cin - '0');

  /* read in month */
  cin++;
  if (*cin != '/')
    return(2);
  cin++;
  cout = month;
  for (i = 0; i < 3 && *cin != '\0'; i++) {
    *cout = *cin;
    cout++;
    cin++;
  }
  if (*cin == '\0')
    return(2);
  *cout = '\0';

  /* read in year */
  if (*cin != '/')
    return(3);
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *year = 1000 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *year += 100 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *year += 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *year += (*cin - '0');

  /* read in hour */
  cin++;
  if (*cin != ':')
    return(4);
  cin++;
  if (!isdigit(*cin))
    return(4);
  else
    *hr = 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(4);
  else
    *hr += (*cin - '0');

  /* read in minute */
  cin++;
  if (*cin != ':')
    return(5);
  cin++;
  if (!isdigit(*cin))
    return(5);
  else
    *min = 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(5);
  else
    *min += (*cin - '0');
  
  /* ignore second & timezone; so scan to next '"' */
  for (cin++; *cin != '"' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(6);

  /* ignore method; so read to next ' ' */
  for (cin++; *cin != ' ' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(6);

  /* read in filename */
  cin++;
  i = 0;
  for (cout = filename; *cin != ' ' && *cin != '\0' && *cin != '"' &&
       *cin != '?' && i < MAXSTRINGLENGTH - 1; cin++) {
    *cout = *cin;
    cout++;
    i++;
  }
  *cout = '\0';
  if (*cin == '?' && expandq(filename)) {  /* read in some more */
    for ( ; *cin != ' ' && *cin != '\0' && *cin != '"' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
    *cout = '\0';
  }
  if (*cin != ' ' && *cin != '"' && *cin != '?')
    return(6);

  /* scan to next " */
  for ( ; *cin != '"' && *cin != '\0' ; cin++)
    ;
  if (*cin == '\0')
    return(7);

  /* read in return code; always 3 digits, or a - */
  cin++;
  if (*cin != ' ')
    return(7);
  cin++;
  if (!isdigit(*cin))
    if (*cin == '-' && *(cin + 1) == ' ')
      *code = 299;
    else
      return(7);
  else {
    *code = 100 * (*cin - '0');
    cin++;
    if (!isdigit(*cin))
      return(7);
    else
      *code += 10 * (*cin - '0');
    cin++;
    if (!isdigit(*cin))
      return(7);
    else
      *code += (*cin - '0');
  }

  /* finally, read in bytestr */
  cin++;
  if (*cin != ' ')
    return (8);
  cin++;
  i = 0;
  for (cout = bytestr; *cin != ' ' && *cin != '\n' && *cin != '\0' && i < 16;
       cin++) {
    *cout = *cin;
    cout++;
  }
  *cout = '\0';
  return(9);

}

int sscanf_ncsaold(char *inputline, char hostn[MAXSTRINGLENGTH],
		   char month[4], int *date, int *hr, int *min,
		   int *year, char filename[MAXSTRINGLENGTH])
{    /* scanning NCSA old-style logfile entries */
  register char *cin = inputline;   /* the character we are reading */
  register char *cout;              /* where we are putting it */
  int i;

  /* read in hostname */
  i = 0;
  for (cout = hostn; *cin != ' ' && *cin != '\0' && i < MAXSTRINGLENGTH - 1;
       cin++) { 
    *cout = *cin;
    cout++;
    i++;
  }
  if (*cin != ' ')
    return(0);
  *cout = '\0';

  /* scan until next '[' */
  for (cin++; *cin != '[' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(1);

  /* ignore day of week, so scan until next ' ' */
  for (cin++; *cin != ' ' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(1);

  /* read in month */
  cin++;
  cout = month;
  for (i = 0; i < 3 && *cin != '\0'; i++) {
    *cout = *cin;
    cout++;
    cin++;
  }
  if (*cin == '\0')
    return(1);
  *cout = '\0';

  /* read in date */
  if (*cin != ' ')
    return(2);
  cin++;
  if (!isdigit(*cin) && *cin != ' ')
    return(2);
  else if (*cin != ' ')
    *date = 10 * (*cin - '0');
  else
    *date = 0;
  cin++;
  if (!isdigit(*cin))
    return(2);
  else
    *date += (*cin - '0');

  /* read in hour */
  cin++;
  if (*cin != ' ')
    return(3);
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *hr = 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(3);
  else
    *hr += (*cin - '0');

  /* read in minute */
  cin++;
  if (*cin != ':')
    return(4);
  cin++;
  if (!isdigit(*cin))
    return(4);
  else
    *min = 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(4);
  else
    *min += (*cin - '0');
  
  /* ignore second; skip to year and read it */

  cin += 5;
  if (!isdigit(*cin))
    return(5);
  else
    *year = 1000 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(5);
  else
    *year += 100 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(5);
  else
    *year += 10 * (*cin - '0');
  cin++;
  if (!isdigit(*cin))
    return(5);
  else
    *year += (*cin - '0');

  /* ignore method, so skip to second space */
  for (cin++; *cin != ' ' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(6);

  for (cin++; *cin != ' ' && *cin != '\0'; cin++)
    ;
  if (*cin == '\0')
    return(6);

  /* finally, read in the filename */
  cin++;
  i = 0;
  for (cout = filename; *cin != ' ' && *cin != '\n' && *cin != '?' &&
       *cin != '\0' && i < MAXSTRINGLENGTH - 1; cin++) {
    *cout = *cin;
    cout++;
    i++;
  }
  *cout = '\0';
  if (*cin == '?' && expandq(filename)) {  /* read in some more */
    for ( ; *cin != ' ' && *cin != '\0' && *cin != '"' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
    *cout = '\0';
  }
  return (7);

}

int sscanf_domains(char *inputline, char string1[MAXSTRINGLENGTH],
		   char string2[MAXSTRINGLENGTH])
{   /* scanning the domains file */
  register char *cin = inputline;
  register char *cout;
  int i;

  /* run past any white space */
  while (*cin == ' ' || *cin == '\t')
    cin++;

  /* if no strings on this line, return 0 */
  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(0);

  /* otherwise fill up string 1; coerce domains to lower case */
  i = 0;
  for (cout = string1; *cin != ' ' && *cin != '\t' && *cin != '#' &&
       *cin != '\0' && *cin != '\n' && i < MAXSTRINGLENGTH - 1; cin++) {
    *cout = tolower(*cin);
    cout++;
    i++;
  }

  /* is that the end of the line (maybe after some white space)? */
  if (*cin == '#' || *cin == '\0' || *cin == '\n' || i == MAXSTRINGLENGTH - 1)
    return(1);

  *cout = '\0';
  cin++;

  while (*cin == ' ' || *cin == '\t')
    cin++;

  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(1);

  /* otherwise fill up string 2 */
  for (cout = string2; *cin != '#' && *cin != '\n' && *cin != '\0' &&
       i < MAXSTRINGLENGTH - 1; cin++) {
    *cout = *cin;
    cout++;
    i++;
  }

  *cout = '\0';
  return(2);

}

int sscanf_config(char *inputline, char string1[MAXSTRINGLENGTH],
		  char string2[MAXSTRINGLENGTH],
		  char string3[MAXSTRINGLENGTH])
{   /* scanning the domains file */
  register char *cin = inputline;
  register char *cout;
  int i;

  /* run past any white space */
  while (*cin == ' ' || *cin == '\t')
    cin++;

  /* if no strings on this line, return 0 */
  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(0);

  /* otherwise fill up string 1; convert arguments to upper case */
  i = 0;
  for (cout = string1; *cin != ' ' && *cin != '\t' && *cin != '#' &&
       *cin != '\0' && *cin != '\n' && i < MAXSTRINGLENGTH - 1; cin++) {
    *cout = *cin;
    cout++;
    i++;
  }

  *cout = '\0';

  /* is that the end of the line (maybe after some white space)? */
  if (*cin == '#' || *cin == '\0' || *cin == '\n' || i == MAXSTRINGLENGTH - 1)
    return(1);

  cin++;

  while (*cin == ' ' || *cin == '\t')
    cin++;

  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(1);

  /* if string 2 starts with a quote mark, fill up until the next quote
     mark. Otherwise, just fill until the next space */

  if (*cin == '\'') {
    cin++;
    for (cout = string2; *cin != '\n' && *cin != '\0' && *cin != '\'' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }
  else if (*cin == '"') {
    cin++;
    for (cout = string2; *cin != '\n' && *cin != '\0' && *cin != '"' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }
  else {
    for (cout = string2; *cin != '#' && *cin != '\n' && *cin != '\0' &&
	 *cin != ' ' && *cin != '\t' && i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }

  *cout = '\0';

  /* is that the end of the line (maybe after some white space)? */
  if (*cin == '#' || *cin == '\0' || *cin == '\n' || i == MAXSTRINGLENGTH - 1)
    return(2);

  cin++;

  while (*cin == ' ' || *cin == '\t')
    cin++;

  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(2);

  /* otherwise fill up string 3 */
  if (*cin == '\'') {
    cin++;
    for (cout = string3; *cin != '\n' && *cin != '\0' && *cin != '\'' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }
  else if (*cin == '"') {
    cin++;
    for (cout = string3; *cin != '\n' && *cin != '\0' && *cin != '"' &&
	 i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }
  else {
    for (cout = string3; *cin != '#' && *cin != '\n' && *cin != '\0' &&
	 *cin != ' ' && *cin != '\t' && i < MAXSTRINGLENGTH - 1; cin++) {
      *cout = *cin;
      cout++;
      i++;
    }
  }

  *cout = '\0';

  /* is that the end of the line (maybe after some white space)? */
  if (*cin == '#' || *cin == '\0' || *cin == '\n' || i == MAXSTRINGLENGTH - 1)
    return(3);

  cin++;

  while (*cin == ' ' || *cin == '\t')
    cin++;

  if (*cin == '#' || *cin == '\n' || *cin == '\0')
    return(3);

  return(4);   /* we don't ever want to read a fourth string; just know if
		  there is one for error checking */

}
