/*** analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** output.c; the output functions, obviously. ***/

#include "analhead2.h"

char reqcols[5]="Rb";
char dircols[5]="Rb";
char hostcols[5]="Rb";
char domcols[5]="Rb";

/* The first function prints the "goto" line; links to all reports except
   possibly one (the one we're on). If called gotos('\0') won't omit one.
   If called gotos('z') will omit 'Top'. */

void gotos(FILE *outf, char c)
{
  extern char reportorder[];
  extern flag dq, Dq, hq, iq, mq, oq, rq, Sq, Wq, xq;

  char *i;

  if (xq) {
    fprintf(outf, "\n\n<p>(<b>Go To</b>");

    if (c != 'z')
      fprintf(outf, ": <a HREF=\"#Top\">Top</a>");

    for (i = reportorder; *i != '\0'; i++) {
      if (c != *i) {   /* o/wise we don't want this one */
	switch(*i) {
	case 'd':
	  if (dq)
	    fprintf(outf, ": <a HREF=\"#Daily\">Daily summary</a>");
	  break;
	case 'D':
	  if (Dq)
	    fprintf(outf, ": <a HREF=\"#FullDaily\">Daily report</a>");
	  break;
	case 'h':
	  if (hq)
	    fprintf(outf, ": <a HREF=\"#Hourly\">Hourly summary</a>");
	  break;
	case 'i':
	  if (iq)
	    fprintf(outf, ": <a HREF=\"#Directory\">Directory report</a>");
	  break;
	case 'm':
	  if (mq)
	    fprintf(outf, ": <a HREF=\"#Monthly\">Monthly report</a>");
	  break;
	case 'o':
	  if (oq)
	    fprintf(outf, ": <a HREF=\"#Domain\">Domain report</a>");
	  break;
	case 'r':
	  if (rq)
	    fprintf(outf, ": <a HREF=\"#Request\">Request report</a>");
	  break;
	case 'S':
	  if (Sq)
	    fprintf(outf, ": <a HREF=\"#Host\">Host report</a>");
	  break;
	case 'W':
	  if (Wq)
	    fprintf(outf, ": <a HREF=\"#Weekly\">Weekly report</a>");
	  break;
	}   /* end switch */
      }     /* end if this i wanted */
    }       /* end for i */

    fprintf(outf, ")\n");

  }         /* end if xq */
}           /* end function gotos() */

/* The rest is one long and dull function , but I see no point in splitting
   it up further */

void output(struct url *urlsorthead, struct dir *dirsorthead,
	    struct host *hostsorthead, int firstdom)
{
  extern char *reversehostname();   /* in alias.c */
  extern flag ispage();             /* in alias.c */
  extern int dayofdate();           /* in utilities.c */
  extern int minsbetween();         /* in utilities.c */
  extern void int3printf();         /* in utilities.c */
  extern void double3printf();      /* in utilities.c */

  extern char outfile[];
  extern char dayname[7][4];
  extern char monthname[12][4];
  extern int monthlength[];
  extern char hostname[];
  extern char logourl[];
  extern char hosturl[];
  extern char commandname[];
  extern char headerfile[];
  extern char footerfile[];
  extern char background[];
  extern char reportorder[];
  extern char baseurl[];
  extern flag logoq, q7, bq, maskq, kq, aq;
  extern flag xq, dq, Dq, Wq, hq, mq, Sq, rq, oq, iq;
  extern int subonumber;
  extern int sq;
  extern char starttimestr[];
  extern struct timestruct firsttime, lasttime, oldtime, totime, starttimec;
  extern struct timeval starttime, stoptime;
  extern struct timezone tzp;
  extern int weekbeginson;
  extern struct monthly *firstm, *lastm;
  extern struct weekly *firstw, *lastw;
  extern struct daily *firstd, *lastd;
  extern struct domain *domainhead[];
  extern int dailyreq[], hourlyreq[];
  extern int monthlyunit, weeklyunit, hourlyunit, dailyunit, fulldailyunit;
  extern int total_succ_reqs, total_fail_reqs, total_other_reqs;
  extern int total_succ_reqs7, total_fail_reqs7, total_other_reqs7;
  extern int corrupt_lines, other_lines;
  extern int no_urls, no_hosts, no_urls7, no_hosts7, no_new_hosts7;
  extern double total_bytes, total_bytes7;
  extern int pagewidth;
  extern char markchar;
  extern int domsortby, hostsortby, reqsortby, dirsortby;
  extern int domfloor, subdomfloor, hostfloor, reqfloor, dirfloor;
  extern char reqcols[], dircols[], hostcols[], domcols[];
  extern int reqtype, dirlevel;
  extern int dom_max_reqs, dir_max_reqs, host_max_reqs, url_max_reqs;
  extern double dom_max_bytes, dir_max_bytes, host_max_bytes, url_max_bytes;

  FILE *outf;       /* the output file */
  int totalmins;    /* between first and last entries analysed */
  int fieldwidth;   /* Width we require to print #reqs in */
  int bfieldwidth;  /* #bytes ditto */
  double pc;
  int pc1, pc2;   /* the %age of bytes or reqs for a particular entry */
  struct domain *domp;
  struct url *urlp;
  struct dir *dirp;
  struct host *hostp;
  struct monthly *mp;
  struct daily *dp;
  struct weekly *wp;
  int maxmonthlyreq = 0, maxdailyreq = 0, maxhourlyreq = 0;
  int maxfulldailyreq = 0, maxweeklyreq = 0;
  int year, monthno;
  flag finished;
  int i, j, tempint, firsti, lasti;
  char *ro;
  char *cols;
  char *tempp;
  char tempstr[MAXSTRINGLENGTH];
  FILE *tempf;

  if (strcmp(outfile, "stdout") == 0)
    outf = stdout;

  else if ((outf = fopen(outfile, "w")) == NULL) {
    fprintf(stderr, "%s: Error: failed to open output file %s for writing.\n",
	    commandname, outfile);
    exit(ERR);  /* shouldn't get here because also tested at the beginning */
  }

  if (!aq) {
    fprintf(outf,
	    "<html>\n<head><title>Web Server Statistics for %s</title></head>\n",
	   hostname);
    fprintf(outf, "<body");
    if (strcmp(background, "none") != 0)
      fprintf(outf, " background=\"%s\"", background);
    fprintf(outf, ">\n<h1><a NAME=\"Top\">");
    if (logoq)
      fprintf(outf, "<IMG src=\"%s\" alt=\"\"> ", logourl);
    if (hosturl[0] == '-')
      fprintf(outf, "Web Server Statistics</a> for %s</h1>\n\n", hostname);
    else {
      fprintf(outf,
	      "Web Server Statistics</a> for <a HREF=\"%s\">%s</a></h1>\n\n",
	      hosturl, hostname);
    }
  }
  else {
    fprintf(outf, "Web Server Statistics for %s\n", hostname);
    fprintf(outf, "==========================");
    for (i = strlen(hostname); i > 0; i--)
      fprintf(outf, "=");
    fprintf(outf, "\n");
  }
    
  /* insert header file */

  headerfile[MAXSTRINGLENGTH - 5] = '\0';  /* for safety */

  if (strcmp(headerfile, "none") != 0) {
    if ((tempf = fopen(headerfile, "r")) == NULL) {
      fprintf(stderr,
	      "%s: Warning: Failed to open headerfile %s: ignoring it.\n",
	      commandname, headerfile);
    }
    else {  /* can open header file */
      if (!aq)
	fprintf(outf, "<hr>");
      else
	fprintf(outf, "\n");

      while(fgets(tempstr, MAXLINELENGTH, tempf) != NULL)
	fprintf(outf, "%s", tempstr);
      fclose(tempf);
      if (tempstr[strlen(tempstr) - 1] != '\n')
	fprintf(outf, "\n");

      if (aq) {
	for (i = 0; i < pagewidth; i++)
	  fprintf(outf, "-");
      }

      fprintf(outf, "\n");

    }
  }

  /* Summary statistics */

  if (xq) {

    if (!aq)
      fprintf(outf, "<hr>");

    fprintf(outf,
	    "\nProgram started at %c%c%c-%c%c-%c%c%c-%c%c%c%c %c%c:%c%c local time.\n",
	   starttimestr[0], starttimestr[1], starttimestr[2],
	   (starttimestr[8]==' ')?'0':starttimestr[8], starttimestr[9],
	   starttimestr[4], starttimestr[5], starttimestr[6],
	   starttimestr[20], starttimestr[21], starttimestr[22],
	   starttimestr[23],
	   starttimestr[11], starttimestr[12],
	   starttimestr[14], starttimestr[15]);
  
    if (firsttime.code > oldtime.code)
      q7 = OFF;
  
    if (total_succ_reqs > 0) {
      totalmins = minsbetween(firsttime.date, firsttime.monthno, firsttime.year,
			      firsttime.hr, firsttime.min,
			      lasttime.date, lasttime.monthno, lasttime.year,
			      lasttime.hr, lasttime.min) + 1;
      if (!aq)
	fprintf(outf, "<br>");
      fprintf(outf,
	      "Analysed requests from %s-%02d-%s-%d %02d:%02d to %s-%02d-%s-%d %02d:%02d\n  (%.1f days).\n\n",
	     dayname[dayofdate(firsttime.date,
			       firsttime.monthno, firsttime.year)],
	     firsttime.date, monthname[firsttime.monthno], firsttime.year,
	     firsttime.hr, firsttime.min,
	     dayname[dayofdate(lasttime.date, lasttime.monthno,
			       lasttime.year)],
	     lasttime.date, monthname[lasttime.monthno], lasttime.year,
	     lasttime.hr, lasttime.min,
	     (double)totalmins / 1440.0);
    }

    if (!aq)
      fprintf(outf, "<p><b>Total completed requests:</b> ");
    else
      fprintf(outf, "Total completed requests: ");
    int3printf(outf, total_succ_reqs);
    if (q7) {
      fprintf(outf, " (");
      int3printf(outf, total_succ_reqs7);
      fprintf(outf, ")");
    }
    if (!aq)
      fprintf(outf, "\n<br><b>Total failed requests:</b> ");
    else
      fprintf(outf, "\nTotal failed requests: ");
    int3printf(outf, total_fail_reqs);
    if (q7) {
      fprintf(outf, " (");
      int3printf(outf, total_fail_reqs7);
      fprintf(outf, ")");
    }
    if (!aq)
      fprintf(outf, "\n<br><b>Total redirected requests:</b> ");
    else
      fprintf(outf, "\nTotal redirected requests: ");
    int3printf(outf, total_other_reqs);
    if (q7) {
      fprintf(outf, " (");
      int3printf(outf, total_other_reqs7);
      fprintf(outf, ")");
    }
    if (totalmins > 30) {
      if (!aq)
	fprintf(outf, "\n<br><b>Average requests per day:</b> ");
      else
	fprintf(outf, "\nAverage requests per day: ");
      if (total_succ_reqs + total_fail_reqs + total_other_reqs < 2)
	fprintf(outf, "0");
      else
	double3printf(outf,
		      ((double)(total_succ_reqs + total_fail_reqs + total_other_reqs - 1)) * 1440.0 / (totalmins + 0.0));
      if (q7) {
	fprintf(outf, " (");
	int3printf(outf,
		   (total_succ_reqs7 + total_fail_reqs7 + total_other_reqs7) / 7);
	fprintf(outf, ")");
      }
    }
    if (rq) {   /* These data are not collected o/wise */
      if (!aq)
	fprintf(outf, "\n<br><b>Number of distinct files requested:</b> ");
      else
	fprintf(outf, "\nNumber of distinct files requested: ");
      int3printf(outf, no_urls);
      if (q7) {
	fprintf(outf, " (");
	int3printf(outf, no_urls7);
	fprintf(outf, ")");
      }
    }
    if (sq == ON || sq == APPROX) {
      if (!aq)
	fprintf(outf, "\n<br><b>%sumber of distinct hosts served:</b> ",
	       (sq == ON)?"N":"Approximate n");
      else
	fprintf(outf, "\n%sumber of distinct hosts served: ",
	       (sq == ON)?"N":"Approximate n");
      int3printf(outf, no_hosts);
      if (q7) {
	fprintf(outf, " (");
	int3printf(outf, no_hosts7);
	fprintf(outf, ")");
	if (!aq)
	  fprintf(outf,
		  "\n<br><b>%sumber of new hosts served in last 7 days:</b> ",
		 (sq == ON)?"N":"Approximate n");
	else
	  fprintf(outf, "\n%sumber of new hosts served in last 7 days: ",
		 (sq == ON)?"N":"Approximate n");
	int3printf(outf, no_new_hosts7);
      }
    }
    if (!aq)
      fprintf(outf, "\n<br><b>Corrupt logfile entries:</b> ");
    else
      fprintf(outf, "\nCorrupt logfile entries: ");
    int3printf(outf, corrupt_lines);
    if (maskq) {
      if (!aq)
	fprintf(outf, "\n<br><b>Other logfile entries:</b> ");
      else
	fprintf(outf, "\nOther logfile entries: ");
      int3printf(outf, other_lines);
    }
    if (bq) {
      if (!aq)
	fprintf(outf, "\n<br><b>Total bytes transferred:</b> ");
      else
	fprintf(outf, "\nTotal bytes transferred: ");
      double3printf(outf, total_bytes);
      if (q7) {
	fprintf(outf, " (");
	double3printf(outf, total_bytes7);
	fprintf(outf, ")");
      }
      if (totalmins > 30) {
	if (!aq)
	  fprintf(outf, "\n<br><b>Average bytes transferred per day:</b> ");
	else
	  fprintf(outf, "\nAverage bytes transferred per day: ");
	double3printf(outf, (total_bytes * 1440) / (totalmins + 0.0));
	if (q7) {
	  fprintf(outf, " (");
	  double3printf(outf, total_bytes7 / 7.0);
	  fprintf(outf, ")");
	}
      }
    }
    if (q7) {
      if (!aq)
	fprintf(outf, "\n<br>");
      else
	fprintf(outf, "\n");
      fprintf(outf, "(Figures in parentheses refer to the ");
      if (starttimec.code > totime.code)
	fprintf(outf, "7 days to %02d-%s-%4d).", totime.date,
		monthname[totime.monthno], totime.year);
      else
	fprintf(outf, "last 7 days).");
    }

    if (!aq && (mq || Wq || dq || Dq || hq || oq || Sq || iq || rq))
      gotos(outf, 'z');
    if (aq)
      fprintf(outf, "\n");
    
  }   /* end if xq */

  /*** Now for the rest of the reports, in reportorder order ***/

  for (ro = reportorder; *ro != '\0'; ro++) {

    switch(*ro) {

    case 'm':    /* Monthly report */

      if (mq) {

	if (!aq) {
	  fprintf(outf,
		  "<hr>\n<h2><a NAME=\"Monthly\">Monthly Report</a></h2>\n");
	  gotos(outf, 'm');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nMonthly Report\n");
	  fprintf(outf, "--------------\n");
	}
    
	finished = FALSE;
	for (mp = firstm; !finished; mp = mp -> next) {
	  for (i = 0; i < 12; i++)
	    maxmonthlyreq = MAX(maxmonthlyreq, mp -> reqs[i]);
	  if (mp == lastm)
	    finished = TRUE;
	}
	
	tempint = 10000;
	for (fieldwidth = 5; maxmonthlyreq / tempint >= 10; fieldwidth++)
	  tempint *= 10;   /* so f.w. is log_10(maxmonthlyreq), but >= 5 */
	
	if (monthlyunit <= 0) {   /* (o/wise just use the given amount) */
	  monthlyunit = (maxmonthlyreq - 1) / (pagewidth - fieldwidth - 12);
                   	        /* except we want a 'nice' amount, so ... */
	             /* (Nice amount is 1, 1.5, 2, 2.5, 3, 4, 5, 6, 8 * 10^n */

	  j = 0;
	  while (monthlyunit > 24) {
	    monthlyunit /= 10;
	    j++;
	  }
	  if (monthlyunit == 6)
	    monthlyunit = 7;
	  else if (monthlyunit == 8)
	    monthlyunit = 9;
	  else if (monthlyunit >= 20)
	    monthlyunit = 24;
	  else if (monthlyunit >= 15)
	    monthlyunit = 19;
	  else if (monthlyunit >= 10)
	    monthlyunit = 14;
	  monthlyunit++;
	  for (i = 0; i < j; i++) {
	    monthlyunit *= 10;
	  }

	}

	if (!aq) {
	  fprintf(outf, "\n<p>Each <code>%c</code> represents ", markchar);
	  int3printf(outf, monthlyunit);
	  fprintf(outf, " request%s.\n\n<pre width=%d>\n",
		 (monthlyunit == 1)?"":"s, or part thereof", pagewidth);
	}
	else {
	  fprintf(outf, "\nEach %c represents ", markchar);
	  int3printf(outf, monthlyunit);
	  fprintf(outf, " request%s.\n\n",
		 (monthlyunit == 1)?"":"s, or part thereof");
	}
	
	fprintf(outf, "   month: ");
	for (i = 5; i < fieldwidth; i++)
	  fprintf(outf, " ");
	fprintf(outf, "#reqs\n");
	fprintf(outf, "--------  ");
	for (i = 1; i <= fieldwidth; i++)
	  fprintf(outf, "-");
	fprintf(outf, "\n");
	
	finished = FALSE;
	year = firsttime.year;
	for (mp = firstm; !finished; mp = mp -> next) {
	  if (mp == firstm)
	    firsti = firsttime.monthno;
	  else
	    firsti = 0;
	  if (mp == lastm) {
	    finished = TRUE;
	    lasti = lasttime.monthno;
	  }
	  else
	    lasti = 11;
	  for (i = firsti; i <= lasti; i++) {
	    fprintf(outf, "%s %d: %*d: ", monthname[i], year, fieldwidth,
		   mp -> reqs[i]);
	    while (mp -> reqs[i] > 0) {
	      fprintf(outf, "%c", markchar);
	      mp -> reqs[i] -= monthlyunit;
	    }
	    fprintf(outf, "\n");
	  }
	  year++;
	}
	
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;
      
    case 'W':      /* Weekly report */

      if (Wq) {

	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Weekly\">Weekly Report</a></h2>\n");
	  gotos(outf, 'W');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nWeekly Report\n");
	  fprintf(outf, "-------------\n");
	}

	finished = FALSE;
	for (wp = firstw; !finished; wp = wp -> next) {
	  maxweeklyreq = MAX(maxweeklyreq, wp -> reqs);
	  if (wp == lastw)
	    finished = TRUE;
	}
	
	tempint = 10000;
	for (fieldwidth = 5; maxweeklyreq / tempint >= 10; fieldwidth++)
	  tempint *= 10;
    
	if (weeklyunit <= 0) {
	  weeklyunit = (maxweeklyreq - 1) / (pagewidth - 13 - fieldwidth);
    
	  j = 0;
	  while (weeklyunit > 24) {
	    weeklyunit /= 10;
	    j++;
	  }
	  if (weeklyunit == 6)
	    weeklyunit = 7;
	  else if (weeklyunit == 8)
	    weeklyunit = 9;
	  else if (weeklyunit >= 20)
	    weeklyunit = 24;
	  else if (weeklyunit >= 15)
	    weeklyunit = 19;
	  else if (weeklyunit >= 10)
	    weeklyunit = 14;
	  weeklyunit++;
	  for (i = 0; i < j; i++) {
	    weeklyunit *= 10;
	  }

	}
	
	if (!aq) {
	  fprintf(outf, "\n<p>Each <code>%c</code> represents ", markchar);
	  int3printf(outf, weeklyunit);
	  fprintf(outf, " request%s.\n\n<pre width=%d>\n",
		 (weeklyunit == 1)?"":"s, or part thereof", pagewidth);
	}
	else {
	  fprintf(outf, "\nEach %c represents ", markchar);
	  int3printf(outf, weeklyunit);
	  fprintf(outf, " request%s.\n\n",
		 (weeklyunit == 1)?"":"s, or part thereof");
	}

	fprintf(outf, "week beg.: ");
	for (i = 5; i < fieldwidth; i++)
	  fprintf(outf, " ");
	fprintf(outf, "#reqs\n");
	fprintf(outf, "---------  ");
	for (i = 1; i <= fieldwidth; i++)
	  fprintf(outf, "-");
	fprintf(outf, "\n");
	
	finished = FALSE;
	for (wp = firstw; !finished; wp = wp -> next) {
	  fprintf(outf, "%2d/%s/%02d: %*d: ", wp -> start.date,
		 monthname[wp -> start.monthno], wp -> start.year % 100,
		 fieldwidth, wp -> reqs);
	  while (wp -> reqs > 0) {
	    fprintf(outf, "%c", markchar);
	    wp -> reqs -= weeklyunit;
	  }
	  fprintf(outf, "\n");
	  
	  if (wp == lastw)
	    finished = TRUE;
	  
	}     /* end running through weeks */

	if (!aq)
	  fprintf(outf, "</pre>");
	
      }   /* end if Wq */

      break;

    case 'd':      /* Daily summary */

      if (dq) {
	
	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Daily\">Daily Summary</a></h2>\n");
	  gotos(outf, 'd');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nDaily Summary\n");
	  fprintf(outf, "-------------\n");
	}
	
	for (i = 0; i <= 6; i++)
	  if (dailyreq[i] > maxdailyreq)
	    maxdailyreq = dailyreq[i];
	
	tempint = 10000;
	for (fieldwidth = 5; maxdailyreq / tempint >= 10; fieldwidth++)
	  tempint *= 10;
    
	if (dailyunit <= 0) {
	  dailyunit = (maxdailyreq - 1) / (pagewidth - 7 - fieldwidth);
    
	  j = 0;
	  while (dailyunit > 24) {
	    dailyunit /= 10;
	    j++;
	  }
	  if (dailyunit == 6)
	    dailyunit = 7;
	  else if (dailyunit == 8)
	    dailyunit = 9;
	  else if (dailyunit >= 20)
	    dailyunit = 24;
	  else if (dailyunit >= 15)
	    dailyunit = 19;
	  else if (dailyunit >= 10)
	    dailyunit = 14;
	  dailyunit++;
	  for (i = 0; i < j; i++) {
	    dailyunit *= 10;
	  }

	}
	
	if (!aq) {
	  fprintf(outf, "\n<p>Each <code>%c</code> represents ", markchar);
	  int3printf(outf, dailyunit);
	  fprintf(outf, " request%s.\n\n<pre width=%d>\n",
		 (dailyunit == 1)?"":"s, or part thereof", pagewidth);
	}
	else {
	  fprintf(outf, "\nEach %c represents ", markchar);
	  int3printf(outf, dailyunit);
	  fprintf(outf, " request%s.\n\n",
		 (dailyunit == 1)?"":"s, or part thereof");
	}


	fprintf(outf, "day: ");
	for (i = 5; i < fieldwidth; i++)
	  fprintf(outf, " ");
	fprintf(outf, "#reqs\n");
	fprintf(outf, "---  ");
	for(i = 1; i <= fieldwidth; i++)
	  fprintf(outf, "-");
	fprintf(outf, "\n");
	
	for(i = 0; i <= 6; i++) {
	  j = (weekbeginson + i) % 7;
	  fprintf(outf, "%s: %*d: ", dayname[j], fieldwidth, dailyreq[j]);
	  while (dailyreq[j] > 0) {
	    fprintf(outf, "%c", markchar);
	    dailyreq[j] -= dailyunit;
	  }
	  fprintf(outf, "\n");
	}
	
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;
      
    case 'D':       /* Full daily report */

      if (Dq) {

	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"FullDaily\">Daily Report</a></h2>\n");
	  gotos(outf, 'D');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nDaily Report\n");
	  fprintf(outf, "------------\n");
	}
	
	finished = FALSE;
	for (dp = firstd; !finished; dp = dp -> next) {
	  for (i = 0; i < 31; i++)
	    maxfulldailyreq = MAX(maxfulldailyreq, dp -> reqs[i]);
	  if (dp == lastd)
	    finished = TRUE;
	}
	
	tempint = 10000;
	for (fieldwidth = 5; maxfulldailyreq / tempint >= 10; fieldwidth++)
	  tempint *= 10;
	
	if (fulldailyunit <= 0) {
	  fulldailyunit =
	    (maxfulldailyreq - 1) / (pagewidth - 13 - fieldwidth);
    
	  j = 0;
	  while (fulldailyunit > 24) {
	    fulldailyunit /= 10;
	    j++;
	  }
	  if (fulldailyunit == 6)
	    fulldailyunit = 7;
	  else if (fulldailyunit == 8)
	    fulldailyunit = 9;
	  else if (fulldailyunit >= 20)
	    fulldailyunit = 24;
	  else if (fulldailyunit >= 15)
	    fulldailyunit = 19;
	  else if (fulldailyunit >= 10)
	    fulldailyunit = 14;
	  fulldailyunit++;
	  for (i = 0; i < j; i++) {
	    fulldailyunit *= 10;
	  }

	}

	if (!aq) {
	  fprintf(outf, "\n<p>Each <code>%c</code> represents ", markchar);
	  int3printf(outf, fulldailyunit);
	  fprintf(outf, " request%s.\n\n<pre width=%d>\n",
		 (fulldailyunit == 1)?"":"s, or part thereof", pagewidth);
	}
	else {
	  fprintf(outf, "\nEach %c represents ", markchar);
	  int3printf(outf, fulldailyunit);
	  fprintf(outf, " request%s.\n\n",
		 (fulldailyunit == 1)?"":"s, or part thereof");
	}

	
	fprintf(outf, "     date: ");
	for (i = 5; i < fieldwidth; i++)
	  fprintf(outf, " ");
	fprintf(outf, "#reqs\n");
	fprintf(outf, "---------  ");
	for (i = 1; i <= fieldwidth; i++)
	  fprintf(outf, "-");
	fprintf(outf, "\n");
	
	finished = FALSE;
	year = firsttime.year;
	monthno = firsttime.monthno;
	for (dp = firstd; !finished; dp = dp -> next) {
	  if (dp == firstd)
	    firsti = firsttime.date - 1;
	  else
	    firsti = 0;
	  if (dp == lastd) {
	    finished = TRUE;
	    lasti = lasttime.date - 1;
	  }
	  else
	    lasti = monthlength[monthno] + (monthno == 1 && year % 4 == 0) - 1;
	  for (i = firsti; i <= lasti; i++) {
	    fprintf(outf, "%2d/%s/%02d: %*d: ", i + 1, monthname[monthno],
		    year % 100, fieldwidth, dp -> reqs[i]);
	    while (dp -> reqs[i] > 0) {
	      fprintf(outf, "%c", markchar);
	      dp -> reqs[i] -= fulldailyunit;
	    }
	    fprintf(outf, "\n");
	    if (((dayofdate(i + 1, monthno, year) + 1) % 7 == weekbeginson) &&
		!(finished && i == lasti))
	      fprintf(outf, "\n");
                         /* extra blank line after each week (not last) */
	  }

	  if ((++monthno) == 12) {
	    monthno = 0;
	    ++year;
	  }
	  
	}     /* end running through dp's */

	if (!aq)
	  fprintf(outf, "</pre>");
	
      }   /* end if Dq */

      break;

    case 'h': /* Hourly summary */

      if (hq) {

	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Hourly\">Hourly Summary</a></h2>\n");
	  gotos(outf, 'h');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nHourly Summary\n");
	  fprintf(outf, "--------------\n");
	}

	for (i = 0; i <= 23; i++)
	  if (hourlyreq[i] > maxhourlyreq)
	    maxhourlyreq = hourlyreq[i];
	
	tempint = 10000;
	for (fieldwidth = 5; maxhourlyreq / tempint >= 10; fieldwidth++)
	  tempint *= 10;

	if (hourlyunit <= 0) {
	  hourlyunit = (maxhourlyreq - 1) / (pagewidth - 6 - fieldwidth);
    
	  j = 0;
	  while (hourlyunit > 24) {
	    hourlyunit /= 10;
	    j++;
	  }
	  if (hourlyunit == 6)
	    hourlyunit = 7;
	  else if (hourlyunit == 8)
	    hourlyunit = 9;
	  else if (hourlyunit >= 20)
	    hourlyunit = 24;
	  else if (hourlyunit >= 15)
	    hourlyunit = 19;
	  else if (hourlyunit >= 10)
	    hourlyunit = 14;
	  hourlyunit++;
	  for (i = 0; i < j; i++) {
	    hourlyunit *= 10;
	  }

	}
    
	if (!aq) {
	  fprintf(outf, "\n<p>Each <code>%c</code> represents ", markchar);
	  int3printf(outf, hourlyunit);
	  fprintf(outf, " request%s.\n\n<pre width=%d>\n",
		 (hourlyunit == 1)?"":"s, or part thereof", pagewidth);
	}
	else {
	  fprintf(outf, "\nEach %c represents ", markchar);
	  int3printf(outf, hourlyunit);
	  fprintf(outf, " request%s.\n\n",
		 (hourlyunit == 1)?"":"s, or part thereof");
	}

	fprintf(outf, "hr: ");
	for(i = 5; i < fieldwidth; i++)
	  fprintf(outf, " ");
	fprintf(outf, "#reqs\n");
	fprintf(outf, "--  ");
	for (i = 1; i <= fieldwidth; i++)
	  fprintf(outf, "-");
	fprintf(outf, "\n");
	
	for(i = 0; i <= 23; i++) {
	  fprintf(outf, "%2d: %*d: ", i, fieldwidth, hourlyreq[i]);
	  while (hourlyreq[i] > 0) {
	    fprintf(outf, "%c", markchar);
	    hourlyreq[i] -= hourlyunit;
	  }
	  fprintf(outf, "\n");
	}
	
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }
      
      break;

    case 'o':    /* Domain report */

      if (oq) {

	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Domain\">Domain Report</a></h2>\n\n");
	  gotos(outf, 'o');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nDomain Report\n");
	  fprintf(outf, "-------------\n");
	}
	
	if (!aq)
	  fprintf(outf, "<p>");
	if (domfloor < 0) {
	  if (domfloor == -1)
	    fprintf(outf, "Printing the first domain, ");
	  else
	    fprintf(outf, "Printing the first %d domains, ", -domfloor);
	}
	else {
	  fprintf(outf, "Printing all domains ");
	  if (domsortby == BYBYTES) {
	    if (domfloor == 0)
	      fprintf(outf, "with any traffic, ");
	    else
	      fprintf(outf, "with at least %d.%02d%% of the traffic,\n",
		      domfloor / 100, domfloor % 100);
	  }
	  else   /* domsortby REQUESTS or ALPHABETICALLY */
	    if (domfloor > 0)
	      fprintf(outf, "with at least %d request%s, ", domfloor,
		     (domfloor == 1)?"":"s");
	}   
	if (domsortby == BYREQUESTS)
	  fprintf(outf, "sorted by number of requests");
	else if (domsortby == BYBYTES)
	  fprintf(outf, "sorted by amount of traffic");
	else
	  fprintf(outf, "sorted alphabetically");
	if (subonumber > 0) {
	  fprintf(outf, ",\nand requested subdomains");
	  if (subdomfloor > 0) {
	    if (domsortby == BYBYTES)
	      fprintf(outf, " with at least %d.%02d%% of the traffic",
		      subdomfloor / 100, subdomfloor % 100);
	    else   /* subdomfloor > 0; domsortby REQUESTS or ALPHABETICALLY */
	      fprintf(outf, " with at least %d request%s", subdomfloor,
		      (subdomfloor == 1)?"":"s");
	  }
	}
	fprintf(outf, ".\n\n");
	if (!aq)
	  fprintf(outf, "<pre>");

	tempint = 10000;
	for (fieldwidth = 5; dom_max_reqs / tempint >= 10; fieldwidth++)
	  tempint *= 10;
	
	if (bq) {
	  tempint = 100000;
	  for (bfieldwidth = 6; dom_max_bytes / tempint >= 10; bfieldwidth++)
	    tempint *= 10;
	}

	for (cols = domcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 5; i < fieldwidth; i++)
	      fprintf(outf, " ");
	    if (subonumber > 0)
	      fprintf(outf, " #reqs : ");
	    else
	      fprintf(outf, "#reqs: ");
	    break;
	  case 'r':
	    if (subonumber > 0)
	      fprintf(outf, "  %%reqs : ");
	    else
	      fprintf(outf, " %%reqs: ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 6; i < bfieldwidth; i++)
		fprintf(outf, " ");
	      if (subonumber > 0)
		fprintf(outf, " #bytes : ");
	      else
		fprintf(outf, "#bytes: ");
	    }
	    break;
	  case 'b':
	    if (bq) {
	      if (subonumber > 0)
		fprintf(outf, " %%bytes : ");
	      else
		fprintf(outf, "%%bytes: ");
	    }
	    break;
	  }
	}
	fprintf(outf, "domain\n");

	for (cols = domcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 1; i <= fieldwidth; i++)
	      fprintf(outf, "-");
	    if (subonumber > 0)
	      fprintf(outf, "--");
	    fprintf(outf, "  ");
	    break;
	  case 'r':
	    if (subonumber > 0)
	      fprintf(outf, "--");
	    fprintf(outf, "------  ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 1; i <= bfieldwidth; i++)
		fprintf(outf, "-");
	      if (subonumber > 0)
		fprintf(outf, "--");
	      fprintf(outf, "  ");
	    }
	    break;
	  case 'b':
	    if (bq) {
	      if (subonumber > 0)
		fprintf(outf, "--");
	      fprintf(outf, "------  ");
	    }
	    break;
	  }
	}
	fprintf(outf, "------\n");

	if (domfloor < 0)
	  j = domfloor;
	else j = 1;

	for (i = firstdom; i >= 0 && (j++) != 0 ; i = domainhead[i] -> nexti) {
	  
	  if (!(i == DOMHASHSIZE - 2 &&
		((domainhead[i] -> reqs < domfloor && domsortby != BYBYTES) ||
		 (domsortby == BYBYTES && domainhead[i] -> reqs == 0) ||
		 (domsortby == BYBYTES &&
		  domainhead[i] -> bytes / (total_bytes / 10000) < domfloor))))
	    {

	      for (cols = domcols; *cols != '\0'; cols++) {
		switch(*cols) {
		case 'R':
		  if (subonumber > 0)
		    fprintf(outf, " %*d : ", fieldwidth,
			    domainhead[i] -> reqs);
		  else
		    fprintf(outf, "%*d: ", fieldwidth, domainhead[i] -> reqs);
		  break;
		case 'r':
		  pc = (domainhead[i] -> reqs + 0.0) / 
		    ((total_succ_reqs + 0.0) / 10000);
		  pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
		  pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
		  if (subonumber > 0)
		    fprintf(outf, " ");
		  if (pc1 == 100)
		    fprintf(outf, "  100%%");
		  else if (pc1 > 0 || pc2 > 0)
		    fprintf(outf, "%2d.%02d%%", pc1, pc2);
		  else
		    fprintf(outf, "      ");
		  if (subonumber > 0)
		    fprintf(outf, " : ");
		  else
		    fprintf(outf, ": ");
		  break;
		case 'B':
		  if (bq) {
		    if (subonumber > 0)
		      fprintf(outf, " %*.0lf : ", bfieldwidth,
			      domainhead[i] -> bytes);
		    else
		      fprintf(outf, "%*.0lf: ", bfieldwidth,
			      domainhead[i] -> bytes);
		  }
		  break;
		case 'b':
		  if (bq) {
		    pc = domainhead[i] -> bytes / (total_bytes / 10000);
		    pc1 = ((int)(pc + 0.5)) / 100;    /* whole no. of %bytes */
		    pc2 = ((int)(pc + 0.5)) % 100;    /* remaining 100ths. */
		    if (subonumber > 0)
		      fprintf(outf, " ");
		    if (pc1 == 100)
		      fprintf(outf, "  100%%");
		    else if (pc1 > 0 || pc2 > 0)
		      fprintf(outf, "%2d.%02d%%", pc1, pc2);
		    else
		      fprintf(outf, "      ");
		    if (subonumber > 0)
		      fprintf(outf, " : ");
		    else
		      fprintf(outf, ": ");
		  }
		  break;
		}
	      }

	      if (domainhead[i] -> id[0] == '*')
	                        /* flagged domains, not real domain names */
		fprintf(outf, "[%s]\n", domainhead[i] -> name);
	      else if (domainhead[i] -> name[0] == '?')
	                        /* real domain, but don't print name */
		fprintf(outf, ".%s\n", domainhead[i] -> id);
	      else
		fprintf(outf, ".%s (%s)\n", domainhead[i] -> id,
			domainhead[i] -> name);

	      /* Now print its subdomains too. */
	      
	      for (domp = domainhead[i] -> next; domp -> name != NULL;
		   domp = domp -> next) {

		for (cols = domcols; *cols != '\0'; cols++) {
		  switch(*cols) {
		  case 'R':
		    fprintf(outf, "(%*d): ", fieldwidth, domp -> reqs);
		    break;
		  case 'r':
		    pc = (domp -> reqs + 0.0) /
		      ((total_succ_reqs + 0.0) / 10000);
		    pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
		    pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
		    if (pc1 == 100)
		      fprintf(outf, "(  100%%): ");
		    else if (pc1 > 0 || pc2 > 0)
		      fprintf(outf, "(%2d.%02d%%): ", pc1, pc2);
		    else
		      fprintf(outf, "        : ");
		    break;
		  case 'B':
		    if (bq)
		      fprintf(outf, "(%*.0lf): ", bfieldwidth, domp -> bytes);
		    break;
		  case 'b':
		    if (bq) {
		      pc = domp -> bytes / (total_bytes / 10000);
		      pc1 = ((int)(pc + 0.5)) / 100;  /* whole no. of %bytes */
		      pc2 = ((int)(pc + 0.5)) % 100;  /* remaining 100ths. */
		      if (pc1 == 100)
			fprintf(outf, "(  100%%): ");
		      else if (pc1 > 0 || pc2 > 0)
			fprintf(outf, "(%2d.%02d%%): ", pc1, pc2);
		      else
			fprintf(outf, "        : ");
		    }
		    break;
		  }
		}
	      
		tempp = domp -> id;
		while ((tempp = strchr(tempp, '.')) != NULL) {
		  fprintf(outf, "  "); 
		  /* print two spaces for each dot in name */
		  tempp++;
		}
		if (i == DOMHASHSIZE - 1)
		  fprintf(outf, "  ");  /* + 2 more for numerical domains */
		fprintf(outf, "%s", domp -> id);
	      
		if (domp -> name[0] != '?')    /* print name */
		  fprintf(outf, " (%s)", domp -> name);
	      
		fprintf(outf, "\n");
	  
	      }    /* end for domp */
	
	    }

	}   /* end for (i = running over domains) */

	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;

    case 'S':    /* Host report */
   
      if (Sq) {
 
	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Host\">Host Report</a></h2>\n\n");
	  gotos(outf, 'S');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nHost Report\n");
	  fprintf(outf, "-----------\n");
	}

	if (!aq)
	  fprintf(outf, "<p>");

	if (hostfloor < 0) {
	  if (hostfloor == -1)
	    fprintf(outf, "Printing the first host, ");
	  else
	    fprintf(outf, "Printing the first %d hosts, ", -hostfloor);
	}
	else {
	  fprintf(outf, "Printing all hosts");
	  if (hostsortby == BYBYTES) {
	    if (hostfloor > 0)
	      fprintf(outf, " with at least %d.%02d%% of the traffic,\n",
		     hostfloor / 100, hostfloor % 100);
	  }
	  else   /* hostsortby REQUESTS or ALPHABETICALLY */
	    if (hostfloor > 1)
	      fprintf(outf, " with at least %d requests, ", hostfloor);
	  else fprintf(outf, ", ");
	}
	if (hostsortby == BYREQUESTS)
	  fprintf(outf, "sorted by number of requests.\n\n");
	else if (hostsortby == BYBYTES)
	  fprintf(outf, "sorted by amount of traffic.\n\n");
	else
	  fprintf(outf, "sorted alphabetically.\n\n");
	if (!aq)
	  fprintf(outf, "<pre>");
	
	tempint = 10000;
	for (fieldwidth = 5; host_max_reqs / tempint >= 10; fieldwidth++)
	  tempint *= 10;

	if (bq) {
	  tempint = 100000;
	  for (bfieldwidth = 6; host_max_bytes / tempint >= 10; bfieldwidth++)
	    tempint *= 10;
	}

	for (cols = hostcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 5; i < fieldwidth; i++)
	      fprintf(outf, " ");
	    fprintf(outf, "#reqs: ");
	    break;
	  case 'r':
	    fprintf(outf, " %%reqs: ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 6; i < bfieldwidth; i++)
		fprintf(outf, " ");
	      fprintf(outf, "#bytes: ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "%%bytes: ");
	    break;
	  }
	}
	fprintf(outf, "host\n");

	for (cols = hostcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 1; i <= fieldwidth; i++)
	      fprintf(outf, "-");
	    fprintf(outf, "  ");
	    break;
	  case 'r':
	    fprintf(outf, "------  ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 1; i <= bfieldwidth; i++)
		fprintf(outf, "-");
	      fprintf(outf, "  ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "------  ");
	    break;
	  }
	}
	fprintf(outf, "----\n");

	if (hostfloor < 0)
	  j = hostfloor;
	else j = 1;

	for(hostp = hostsorthead; hostp -> name != NULL && (j++) != 0;
	    hostp = hostp -> next) {

	  for (cols = hostcols; *cols != '\0'; cols++) {
	    switch(*cols) {
	    case 'R':
	      fprintf(outf, "%*d: ", fieldwidth, hostp -> reqs);
	      break;
	    case 'r':
	      pc = (hostp -> reqs + 0.0) / ((total_succ_reqs + 0.0) / 10000);
	      pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
	      pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
	      if (pc1 == 100)
		fprintf(outf, "  100%%: ");
	      else if (pc1 > 0 || pc2 > 0)
		fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
	      else
		fprintf(outf, "      : ");
	      break;
	    case 'B':
	      if (bq)
		fprintf(outf, "%*.0lf: ", bfieldwidth, hostp -> bytes);
	      break;
	    case 'b':
	      if (bq) {
		pc = hostp -> bytes / (total_bytes / 10000);
		pc1 = ((int)(pc + 0.5)) / 100;    /* whole no. of %bytes */
		pc2 = ((int)(pc + 0.5)) % 100;    /* remaining 100ths. */
		if (pc1 == 100)
		  fprintf(outf, "  100%%: ");
		else if (pc1 > 0 || pc2 > 0)
		  fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
		else
		  fprintf(outf, "      : ");
	      }
	      break;
	    }
	  }

	  if (hostsortby == ALPHABETICAL &&  /* then we've swapped the names */
	      !isdigit(hostp -> name[0]))
	    reversehostname(hostp -> name);

	  fprintf(outf, "%s\n", hostp -> name);

	}
      
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;
    
    case 'i':   /* Directory report */
   
      if (iq) {
 
	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Directory\">Directory Report</a></h2>\n\n");
	  gotos(outf, 'i');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nDirectory Report\n");
	  fprintf(outf, "----------------\n");
	}
	
	if (!aq)
	  fprintf(outf, "<p>");
	if (dirfloor < 0) {
	  if (dirfloor == -1)
	    fprintf(outf, "Printing the first directory, ");
	  else
	    fprintf(outf, "Printing the first %d directories, ", -dirfloor);
	}
	else {
	  fprintf(outf, "Printing all directories to depth %d", dirlevel);
	  if (dirsortby == BYBYTES) {
	    if (dirfloor > 0)
	      fprintf(outf, " with at least %d.%02d%% of the traffic, ",
		      dirfloor / 100, dirfloor % 100);
	  }
	  else   /* dirsortby REQUESTS or ALPHABETICALLY */
	    if (dirfloor > 1)
	      fprintf(outf, " with at least %d requests, ", dirfloor);
	}
	if (dirsortby == BYREQUESTS)
	  fprintf(outf, "\nsorted by number of requests.\n\n");
	else if (dirsortby == BYBYTES)
	  fprintf(outf, "\nsorted by amount of traffic.\n\n");
	else
	  fprintf(outf, "\nsorted alphabetically.\n\n");
	if (!aq)
	  fprintf(outf, "<pre>");
    
	tempint = 10000;
	for (fieldwidth = 5; dir_max_reqs / tempint >= 10; fieldwidth++)
	  tempint *= 10;

	if (bq) {
	  tempint = 100000;
	  for (bfieldwidth = 6; dir_max_bytes / tempint >= 10; bfieldwidth++)
	    tempint *= 10;
	}

	for (cols = dircols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 5; i < fieldwidth; i++)
	      fprintf(outf, " ");
	    fprintf(outf, "#reqs: ");
	    break;
	  case 'r':
	    fprintf(outf, " %%reqs: ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 6; i < bfieldwidth; i++)
		fprintf(outf, " ");
	      fprintf(outf, "#bytes: ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "%%bytes: ");
	    break;
	  }
	}
	fprintf(outf, "directory\n");

	for (cols = dircols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 1; i <= fieldwidth; i++)
	      fprintf(outf, "-");
	    fprintf(outf, "  ");
	    break;
	  case 'r':
	    fprintf(outf, "------  ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 1; i <= bfieldwidth; i++)
		fprintf(outf, "-");
	      fprintf(outf, "  ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "------  ");
	    break;
	  }
	}
	fprintf(outf, "---------\n");

	if (dirfloor < 0)
	  j = dirfloor;
	else j = 1;

	for(dirp = dirsorthead; dirp -> name != NULL && (j++) != 0;
	    dirp = dirp -> next) {

	  for (cols = dircols; *cols != '\0'; cols++) {
	    switch(*cols) {
	    case 'R':
	      fprintf(outf, "%*d: ", fieldwidth, dirp -> reqs);
	      break;
	    case 'r':
	      pc = (dirp -> reqs + 0.0) / ((total_succ_reqs + 0.0) / 10000);
	      pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
	      pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
	      if (pc1 == 100)
		fprintf(outf, "  100%%: ");
	      else if (pc1 > 0 || pc2 > 0)
		fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
	      else
		fprintf(outf, "      : ");
	      break;
	    case 'B':
	      if (bq)
		fprintf(outf, "%*.0lf: ", bfieldwidth, dirp -> bytes);
	      break;
	    case 'b':
	      if (bq) {
		pc = dirp -> bytes / (total_bytes / 10000);
		pc1 = ((int)(pc + 0.5)) / 100;    /* whole no. of %bytes */
		pc2 = ((int)(pc + 0.5)) % 100;    /* remaining 100ths. */
		if (pc1 == 100)
		  fprintf(outf, "  100%%: ");
		else if (pc1 > 0 || pc2 > 0)
		  fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
		else
		  fprintf(outf, "      : ");
	      }
	      break;
	    }
	  }

	  fprintf(outf, "%s\n", dirp -> name);

	}
      
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;

    case 'r':    /* Request report */
      
      if (rq) {

	if (strcmp(baseurl, "none") == 0)
	  strcpy(baseurl, "");

	if (!aq) {
	  fprintf(outf,
		  "\n\n<hr>\n<h2><a NAME=\"Request\">Request Report</a></h2>\n\n");
	  gotos(outf, 'r');
	}
	else {
	  for (i = 0; i < pagewidth; i++)
	    fprintf(outf, "-");
	  fprintf(outf, "\n\nRequest Report\n");
	  fprintf(outf, "--------------\n");
	}

	if (!aq)
	  fprintf(outf, "<p>");
	if (reqfloor < 0) {
	  if (reqfloor == -1)
	    fprintf(outf, "Printing the first %s ",
		   (reqtype == PAGES)?"page,":"file,");
	  else
	    fprintf(outf, "Printing the first %d %s ", -reqfloor,
		   (reqtype == PAGES)?"pages,":"files,");
	}
	else {
	  fprintf(outf, "Printing all %s", (reqtype == PAGES)?"pages":"files");
	  if (reqsortby == BYBYTES) {
	    if (reqfloor > 0)
	      fprintf(outf, " with at least %d.%02d%% of the traffic,\n",
		      reqfloor / 100, reqfloor % 100);
	    else
	      fprintf(outf, ", ");
	  }
	  else   /* reqsortby REQUESTS or ALPHABETICALLY */
	    if (reqfloor > 1)
	      fprintf(outf, " with at least %d requests, ", reqfloor);
	    else
	      fprintf(outf, ", ");
	}
	  if (reqsortby == BYREQUESTS)
	    fprintf(outf, "sorted by number of requests.\n\n");
	  else if (reqsortby == BYBYTES)
	    fprintf(outf, "sorted by amount of traffic.\n\n");
	  else
	    fprintf(outf, "sorted alphabetically.\n\n");
	if (!aq)
	  fprintf(outf, "<pre>");
    
	tempint = 10000;
	for (fieldwidth = 5; url_max_reqs / tempint >= 10; fieldwidth++)
	  tempint *= 10;

	if (bq) {
	  tempint = 100000;
	  for (bfieldwidth = 6; url_max_bytes / tempint >= 10; bfieldwidth++)
	    tempint *= 10;
	}

	for (cols = reqcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 5; i < fieldwidth; i++)
	      fprintf(outf, " ");
	    fprintf(outf, "#reqs: ");
	    break;
	  case 'r':
	    fprintf(outf, " %%reqs: ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 6; i < bfieldwidth; i++)
		fprintf(outf, " ");
	      fprintf(outf, "#bytes: ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "%%bytes: ");
	    break;
	  }
	}
	fprintf(outf, "filename\n");

	for (cols = reqcols; *cols != '\0'; cols++) {
	  switch(*cols) {
	  case 'R':
	    for (i = 1; i <= fieldwidth; i++)
	      fprintf(outf, "-");
	    fprintf(outf, "  ");
	    break;
	  case 'r':
	    fprintf(outf, "------  ");
	    break;
	  case 'B':
	    if (bq) {
	      for (i = 1; i <= bfieldwidth; i++)
		fprintf(outf, "-");
	      fprintf(outf, "  ");
	    }
	    break;
	  case 'b':
	    if (bq)
	      fprintf(outf, "------  ");
	    break;
	  }
	}
	fprintf(outf, "--------\n");

	if (reqfloor < 0)
	  j = reqfloor;
	else j = 1;

	for(urlp = urlsorthead; urlp -> name != NULL && (j++) != 0;
	    urlp = urlp -> next) {

	  if (aq)
	    kq = 0;   /* no anchors in ASCII output! */

	  for (cols = reqcols; *cols != '\0'; cols++) {
	    switch(*cols) {
	    case 'R':
	      fprintf(outf, "%*d: ", fieldwidth, urlp -> reqs);
	      break;
	    case 'r':
	      pc = (urlp -> reqs + 0.0) / ((total_succ_reqs + 0.0) / 10000);
	      pc1 = ((int)(pc + 0.5)) / 100;     /* whole no. of %reqs */
	      pc2 = ((int)(pc + 0.5)) % 100;     /* remaining 100ths. */
	      if (pc1 == 100)
		fprintf(outf, "  100%%: ");
	      else if (pc1 > 0 || pc2 > 0)
		fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
	      else
		fprintf(outf, "      : ");
	      break;
	    case 'B':
	      if (bq)
		fprintf(outf, "%*.0lf: ", bfieldwidth, urlp -> bytes);
	      break;
	    case 'b':
	      if (bq) {
		pc = urlp -> bytes / (total_bytes / 10000);
		pc1 = ((int)(pc + 0.5)) / 100;    /* whole no. of %bytes */
		pc2 = ((int)(pc + 0.5)) % 100;    /* remaining 100ths. */
		if (pc1 == 100)
		  fprintf(outf, "  100%%: ");
		else if (pc1 > 0 || pc2 > 0)
		  fprintf(outf, "%2d.%02d%%: ", pc1, pc2);
		else
		  fprintf(outf, "      : ");
	      }
	      break;
	    }
	  }

	  if ((kq == 2) || (kq == 1 && reqtype == PAGES) ||
	             /* if we want to link to everything ... */
	      (kq == 1 && ispage(urlp -> name))) {
	             /* or it is a page, and we want to link to pages */
	    fprintf(outf, "<a HREF=\"%s%s\">%s</a>\n",
		      baseurl, urlp -> name, urlp -> name);
	  }
	  else
	    fprintf(outf, "%s\n", urlp -> name);

	}
      
	if (!aq)
	  fprintf(outf, "</pre>");
	
      }

      break;

    }    /* end switch */
  }      /* end for ro */

  /* Bit at the bottom of the page */

  if (!aq)
    fprintf(outf,
	    "\n\n<hr>\n<i>This analysis was produced by <a HREF=\"http://www.statslab.cam.ac.uk/~sret1/analog/\">analog%s</a>.\n",
	    VERSION);
  else {
    for (i = 0; i < pagewidth; i++)
      fprintf(outf, "-");
    fprintf(outf, "\n\nThis analysis was produced by analog%s.\n", VERSION);
  }

  gettimeofday(&stoptime, &tzp);
  
  stoptime.tv_sec -= starttime.tv_sec;
  stoptime.tv_usec -= starttime.tv_usec;   /* so now measures elapsed time */
  
  if (stoptime.tv_usec < -500000)
    stoptime.tv_sec--;

  if (stoptime.tv_usec >= 500000)
    stoptime.tv_sec++;

  if (stoptime.tv_sec == 0) {
    if (!aq)
      fprintf(outf, "<br><b>Running time:</b> Less than 1 second.</i>\n");
    else
      fprintf(outf, "Running time: Less than 1 second.\n");
  }

  else if (stoptime.tv_sec < 60) {
    if (!aq)
      fprintf(outf, "<br><b>Running time:</b> %ld second%s.</i>\n",
	     stoptime.tv_sec, ((stoptime.tv_sec) == 1)?"":"s");
    else
      fprintf(outf, "Running time: %ld second%s.\n",
	     stoptime.tv_sec, ((stoptime.tv_sec) == 1)?"":"s");
  }
  
  else {
    if (!aq)
      fprintf(outf,
	      "<br><b>Running time:</b> %ld minute%s, %ld second%s.</i>\n",
	     stoptime.tv_sec / 60, ((stoptime.tv_sec / 60) == 1)?"":"s",
	     stoptime.tv_sec % 60, ((stoptime.tv_sec % 60) == 1)?"":"s");
    else
      fprintf(outf, "Running time: %ld minute%s, %ld second%s.\n",
	     stoptime.tv_sec / 60, ((stoptime.tv_sec / 60) == 1)?"":"s",
	     stoptime.tv_sec % 60, ((stoptime.tv_sec % 60) == 1)?"":"s");
  }
  
  if (!aq && (mq || Wq || dq || Dq || hq || oq || Sq || iq || rq)) {
    gotos(outf, '\0');
  }

  /* Finally, insert footer file */

  footerfile[MAXSTRINGLENGTH - 5] = '\0';  /* for safety */

  if (strcmp(footerfile, "none") != 0) {
    if ((tempf = fopen(footerfile, "r")) == NULL) {
      fprintf(stderr,
	      "%s: Warning: Failed to open footer file %s: ignoring it.\n",
	      commandname, footerfile);
    }
    else {  /* can open footer file */
      if (!aq)
	fprintf(outf, "<hr>");
      else {
	for (i = 0; i < pagewidth; i++)
	  fprintf(outf, "-");
      }
      fprintf(outf, "\n\n");
      fflush(stdout);

      while(fgets(tempstr, MAXLINELENGTH, tempf) != NULL)
	fprintf(outf, "%s", tempstr);
      fclose(tempf);
      if (tempstr[strlen(tempstr) - 1] != '\n')
	fprintf(outf, "\n");

      fprintf(outf, "\n");
    }
  }

  if (!aq)
    fprintf(outf, "\n</body>\n</html>\n");

  fclose(outf);

}
