/*** analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** init.c; initialisation routines and declaration of global variables ***/

#include "analhead2.h"

/*** First declare all global variables. We choose to declare them in this
     file rather than analog.c because more are needed here. ***/

char dayname[7][4] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
char monthname[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
			   "Aug", "Sep", "Oct", "Nov", "Dec"};
/* Note: month numbers run from 0 (Jan) to 11 (Dec) internally to this
   program (though not where month numbers are needed in user input and
   output) */
int dateoffset[12] = {0, 31, 59, 90, 120, 151, 181,
			212, 243, 273, 304, 334};
int monthlength[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

char outfile[MAXSTRINGLENGTH];

struct timestruct firsttime, lasttime, starttimec, oldtime, fromtime, totime;
/* first and last log entries, now, a week before now, and
   lower and upper bounds on time interval we want to consider */

struct monthly *firstm, *lastm;
    /* pointers to the first and last years of monthly data */

struct daily *firstd, *lastd;   /* ... of daily data */

struct weekly *firstw, *lastw;  /* and to the first and last week */

int no_urls;                  /* the number of distinct files found so far */
int no_urls7;                 /* the number used in the last 7 days */
struct url *urlhead[URLHASHSIZE];  /* hash table listing all files found */
struct dir *dirhead[DIRHASHSIZE];  /* and one for all directories */
struct domain *subdomhead[SUBDOMHASHSIZE];  /* one for subdomains */
struct domain *wildsubdomhead;     /* and one for wild subdomains */
struct domain *nwildsubdomhead;    /* and one for wild numerical subdomains */
int no_hosts;                 /* the number of hosts so far */
int no_hosts7;                /* the number of all hosts in the last 7 days */
int no_new_hosts7;            /* the number of new hosts in the last 7 days */
struct host *hosthead[HOSTHASHSIZE];  /* and a record of all hosts */
char *approxhostspace;       /* start of the space for approx host counting */
char *approxhostspace7;      /* and a bit more for last 7 days accounting */
int approxhostsize;          /* the size of those spaces, in bytes */
struct domain *domainhead[DOMHASHSIZE];

struct alias *filealiashead, *hostaliashead, *subdomshead;
    /* subdomshead is not really an alias, but it's the right shape */
struct wildalias *filewaliashead;
struct stringlist *fileonlyhead, *fileignorehead, *hostonlyhead,
                  *hostignorehead, *ispagehead, *isnotpagehead,
                  *expandhead, *noexpandhead;
struct wstringlist *filewonlyhead, *filewignorehead, *hostwonlyhead,
                  *hostwignorehead, *hostnonlyhead, *hostnignorehead,
                  *wispagehead, *wisnotpagehead, *wexpandhead, *wnoexpandhead;

int url_max_reqs;        /* the max reqs for any file */
int dir_max_reqs;        /* for any directory */
int host_max_reqs;       /* for any host */
int dom_max_reqs;        /* for any domain */

double url_max_bytes;    /* the same for max bytes */
double dir_max_bytes;
double host_max_bytes;
double dom_max_bytes;

int dailyreq[7];            /* ... day */
int hourlyreq[24];          /* ... and hour */

FILE *lf;           /* the logfile we want to analyse. */
int dirsufflength;  /* the length of DIRSUFFIX */
int rnumber, inumber, onumber, subonumber, Snumber;
      /* the number of entries in the req, dir, dom, subdom and hostreports */
struct timeval starttime, stoptime;
char starttimestr[26];     /* the start and stop time of the program */
struct timezone tzp;       /* required by gettimeofday() */
int total_fail_reqs;
                           /* number of failed requests so far (400s, 500s) */
int total_fail_reqs7;      /* in last 7 days */
int total_succ_reqs;
                           /* no. of successful requests so far (200s, 304s) */
int total_succ_reqs7;
int total_other_reqs;      /* redirects (300s, not 304s) */
int total_other_reqs7;
double total_bytes;
double total_bytes7;
int corrupt_lines;         /* the number of corrupt lines in the logfile */
                             /* (Overlong lines, URLs with quotes in...) */
int other_lines;           /* Lines masked out */
flag bq;        /* whether we want to count bytes; always on unless we find an
	           old-style line in the log (with no bytes information). */
flag maskq;        /* whether there is any masking (inclusion or exclusion
		      of specific hosts or files) going on */

int weekbeginson;  /* which is the first day of the week? */
char sepchar;      /* character as separator in, e.g., 23 000 000 */

char commandname[MAXSTRINGLENGTH];  /* the name of the program, as called */

char background[MAXSTRINGLENGTH];  /* URL of background image */
char baseurl[MAXSTRINGLENGTH];     /* base URL for all URLs found */
char reqcols[5], dircols[5], hostcols[5], domcols[5];
                                   /* Columns appearing in each report */

/* Commandline variables */
/* Defaults for all these can be set in analhead.h; they are explained there
   (or in the config file) */

char logfile[MAXSTRINGLENGTH];
char domainsfile[MAXSTRINGLENGTH];
char configfile[MAXSTRINGLENGTH];
char logourl[MAXSTRINGLENGTH];
char headerfile[MAXSTRINGLENGTH];
char footerfile[MAXSTRINGLENGTH];
char reportorder[16];    /* the order in which reports occur */
flag xq, mq, oq, iq, rq, q7, dq, hq, Sq, Dq, Wq;
int sq;                           /* whether we want each type of report */
flag dnsq;                        /* try and look up numerical addresses? */
flag logoq;
flag aq;                /* do the output in plain (ASCII) text? */
int monthlyunit, weeklyunit, dailyunit, fulldailyunit, hourlyunit;
                        /* the size of the mark in the graphical displays */
int domfloor, subdomfloor, domsortby;
int dirfloor, dirsortby, hostfloor, hostsortby;
int dirlevel, reqtype, reqfloor, reqsortby, pagewidth;
char markchar;
char hostname[MAXSTRINGLENGTH], hosturl[MAXSTRINGLENGTH];
int kq;        /* default PAGELINKS */
flag debug;

flag vblesonly;  /* commandline only. If ON, just print variables and exit */
flag formq;      /* commandline only. If ON, just make a form interface */

extern void *xmalloc();   /* in utilities.c */
extern void *xcalloc();   /* in utilities.c */

/*** Now functions for initialisation of variables etc. ***/

/*** First, entering the default values for the various variables ***/

void defaults(void)
{
  struct wstringlist *wsl;

  strncpy(logfile, LOGFILE, MAXSTRINGLENGTH - 1);
  logfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(domainsfile, DOMAINSFILE, MAXSTRINGLENGTH - 1);
  domainsfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(configfile, CONFIGFILE, MAXSTRINGLENGTH - 1);
  configfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(headerfile, HEADERFILE, MAXSTRINGLENGTH - 1);
  headerfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(footerfile, FOOTERFILE, MAXSTRINGLENGTH - 1);
  footerfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(outfile, OUTFILE, MAXSTRINGLENGTH - 1);
  outfile[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(background, BACKGROUND, MAXSTRINGLENGTH - 1);
  background[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(baseurl, BASEURL, MAXSTRINGLENGTH - 1);
  baseurl[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(reportorder, REPORTORDER, 14);
  reportorder[15] = '\0';
  strncpy(domcols, DOMCOLS, 4);
  reqcols[4] = '\0';
  strncpy(hostcols, HOSTCOLS, 4);
  reqcols[4] = '\0';
  strncpy(dircols, DIRCOLS, 4);
  reqcols[4] = '\0';
  strncpy(reqcols, REQCOLS, 4);
  reqcols[4] = '\0';
  logoq = LOGO;
  strcpy(logourl, LOGOURL);
  mq = MONTHLY;
  Wq = WEEKLY;
  dq = DAILY;
  Dq = FULLDAILY;
  hq = HOURLY;
  oq = DOMAIN;
  iq = DIRECTORY;
  rq = REQUEST;
  sq = COUNTHOSTS;
  Sq = FULLHOSTS;
  xq = GENERAL;
  q7 = LASTSEVEN;
  dnsq = NUMLOOKUP;
  aq = ASCII;
  monthlyunit = MONTHLYUNIT;
  weeklyunit = WEEKLYUNIT;
  hourlyunit = HOURLYUNIT;
  dailyunit = DAILYUNIT;
  fulldailyunit = FULLDAILYUNIT;
  domsortby = DOMSORTBY;
  dirsortby = DIRSORTBY;
  reqsortby = REQSORTBY;
  hostsortby = HOSTSORTBY;
  if (domsortby == BYBYTES) {
    domfloor = MIN_DOM_BYTES;
    subdomfloor = MIN_SUBDOM_BYTES;
  }
  else {
    domfloor = MIN_DOM_REQS;
    subdomfloor = MIN_SUBDOM_REQS;
  }
  if (reqsortby == BYBYTES)
    reqfloor = MIN_URL_BYTES;
  else
    reqfloor = MIN_URL_REQS;
  if (hostsortby == BYBYTES)
    hostfloor = MIN_HOST_BYTES;
  else
    hostfloor = MIN_HOST_REQS;
  if (dirsortby == BYBYTES)
    dirfloor = MIN_DIR_BYTES;
  else
    dirfloor = MIN_DIR_REQS;
  dirlevel = DIRLEVEL;
  reqtype = REQTYPE;
  pagewidth = PAGEWIDTH;
  markchar = MARKCHAR;
  strncpy(hostname, HOSTNAME, MAXSTRINGLENGTH - 1);
  hostname[MAXSTRINGLENGTH - 1] = '\0';
  strncpy(hosturl, HOSTURL, MAXSTRINGLENGTH - 1);
  hosturl[MAXSTRINGLENGTH - 1] = '\0';
  kq = PAGELINKS;
  weekbeginson = WEEKBEGINSON;
  sepchar = SEPCHAR;
  vblesonly = OFF;
  formq = OFF;
  fromtime.code = -INFINITY;
  totime.code = INFINITY;
  approxhostsize = APPROXHOSTSIZE;
  debug = DEBUG;
  ispagehead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  ispagehead -> name[0] = '\0';
  isnotpagehead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  isnotpagehead -> name[0] = '\0';
  wispagehead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wispagehead;
  strcpy(wsl -> name, ".html");
  wsl -> length = 5;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, "/");
  wsl -> length = 1;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, ".htm");
  wsl -> length = 4;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, ".shtml");
  wsl -> length = 6;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, ".shtm");
  wsl -> length = 5;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, ".html3");
  wsl -> length = 6;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl = wsl -> next;
  strcpy(wsl -> name, ".ht3");
  wsl -> length = 4;
  wsl -> next = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wsl -> next -> length = -1;
  wisnotpagehead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wisnotpagehead -> length = -1;
  expandhead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  expandhead -> name[0] = '\0';
  noexpandhead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  noexpandhead -> name[0] = '\0';
  wexpandhead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wexpandhead -> length = -1;
  wnoexpandhead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  wnoexpandhead -> length = -1;
}

/*** Now for the function that parses the configuration file ***/

void configwarning(char *thiscommand, char *inputline)
{  /* a generic warning for the next command */
  fprintf(stderr, "%s: Warning: Not enough arguments to %s command: ignoring line\n", commandname, thiscommand);
  fprintf(stderr, "  %s", inputline);
}

void configwarning2(char *inputline)
{
  fprintf(stderr, "%s: Warning: Discarding illegal configuration line\n",
	  commandname);
  fprintf(stderr, "  %s", inputline);
}

void configwarning3(char *thiscommand, char *inputline)
{
  fprintf(stderr, "%s: Warning: Too many arguments to %s command: ignoring end of line\n", commandname, thiscommand);
  fprintf(stderr, "  %s", inputline);
}

void config(char *filename)
{
  extern int sscanf_config();  /* in sscanf.c */
  extern long timecode();      /* in utilities.c */
  extern char *strtolower();   /* in utilities.c */
  extern char *strtoupper();   /* in utilities.c */

  FILE *cf;
  char string1[MAXSTRINGLENGTH], string2[MAXSTRINGLENGTH],
       string3[MAXSTRINGLENGTH];
  char inputline[MAXLINELENGTH];
  int rc;   /* return code */
  int commandtype;  /* 0 for FILEALIAS, 1 for HOSTALIAS, etc. ... */
                    /* 'Commandline' vars start at 100 */
  struct alias *filealiasp, *hostaliasp, *subdomp, *subdomtempp;
  struct wildalias *filewaliasp;
  struct stringlist *fileonlyp, *fileignp, *hostonlyp, *hostignp;
  struct wstringlist *filewonlyp, *filewignp, *hostwonlyp, *hostwignp;
  struct wstringlist *hostnonlyp, *hostnignp;
  struct stringlist *ispagep, *isnotpagep, *expandp, *noexpandp;
  struct wstringlist *wispagep, *wisnotpagep, *wexpandp, *wnoexpandp;
  int tempint;
  char *tempp;

  if (strcmp(filename, "stdin") == 0 || strcmp(filename, "-") == 0)
    cf = stdin;
  else
    cf = fopen(filename, "r");

  if (cf == NULL) {
    fprintf(stderr,
    "%s: Warning: Failed to open configuration file \"%s\": ignoring it\n",
	    commandname, filename);
    return;
  }

  else {  /* we can read the config. file */

    for (filealiasp = filealiashead; filealiasp -> from[0] != '\0';
	 filealiasp = filealiasp -> next)
      ;     /* start at the first unused file alias */
    for (hostaliasp = hostaliashead; hostaliasp -> from[0] != '\0';
	 hostaliasp = hostaliasp -> next)
      ;
    for (filewaliasp = filewaliashead; filewaliasp -> flength != -1;
	 filewaliasp = filewaliasp -> next)
      ;
    for (fileonlyp = fileonlyhead; fileonlyp -> name[0] != '\0';
	 fileonlyp = fileonlyp -> next)
      ;
    for (hostonlyp = hostonlyhead; hostonlyp -> name[0] != '\0';
	 hostonlyp = hostonlyp -> next)
      ;
    for (fileignp = fileignorehead; fileignp -> name[0] != '\0';
	 fileignp = fileignp -> next)
      ;
    for (hostignp = hostignorehead; hostignp -> name[0] != '\0';
	 hostignp = hostignp -> next)
      ;
    for (filewonlyp = filewonlyhead; filewonlyp -> length != -1;
	 filewonlyp = filewonlyp -> next)
      ;
    for (hostwonlyp = hostwonlyhead; hostwonlyp -> length != -1;
	 hostwonlyp = hostwonlyp -> next)
      ;
    for (hostnonlyp = hostnonlyhead; hostnonlyp -> length != -1;
	 hostnonlyp = hostnonlyp -> next)
      ;
    for (filewignp = filewignorehead; filewignp -> length != -1;
	 filewignp = filewignp -> next)
      ;
    for (hostwignp = hostwignorehead; hostwignp -> length != -1;
	 hostwignp = hostwignp -> next)
      ;
    for (hostnignp = hostnignorehead; hostnignp -> length != -1;
	 hostnignp = hostnignp -> next)
      ;
    for (subdomp = subdomshead; subdomp -> from[0] != '\0';
	 subdomp = subdomp -> next)
      ;
    for (ispagep = ispagehead; ispagep -> name[0] != '\0';
	 ispagep = ispagep -> next)
      ;
    for (wispagep = wispagehead; wispagep -> length != -1;
	 wispagep = wispagep -> next)
      ;
    for (isnotpagep = isnotpagehead; isnotpagep -> name[0] != '\0';
	 isnotpagep = isnotpagep -> next)
      ;
    for (wisnotpagep = wisnotpagehead; wisnotpagep -> length != -1;
	 wisnotpagep = wisnotpagep -> next)
      ;
    for (expandp = expandhead; expandp -> name[0] != '\0';
	 expandp = expandp -> next)
      ;
    for (noexpandp = noexpandhead; noexpandp -> name[0] != '\0';
	 noexpandp = noexpandp -> next)
      ;
    for (wexpandp = wexpandhead; wexpandp -> length != -1;
	 wexpandp = wexpandp -> next)
      ;
    for (wnoexpandp = wnoexpandhead; wnoexpandp -> length != -1;
	 wnoexpandp = wnoexpandp -> next)
      ;

    while (fgets(inputline, MAXLINELENGTH, cf) != NULL) {
      rc = sscanf_config(inputline, string1, string2, string3);
      if (rc > 0) {
	commandtype = -1;   /* pessimism */
	strtoupper(string1);
	if (strcmp(string1, "FILEALIAS") == 0)
	  commandtype = 0;
	else if (strcmp(string1, "HOSTALIAS") == 0)
	  commandtype = 1;
	else if (strcmp(string1, "FILEONLY") == 0)
	  commandtype = 2;
	else if (strcmp(string1, "FILEIGNORE") == 0)
	  commandtype = 3;
	else if (strcmp(string1, "HOSTONLY") == 0)
	  commandtype = 4;
	else if (strcmp(string1, "HOSTIGNORE") == 0)
	  commandtype = 5;
	else if (strcmp(string1, "FROM") == 0)
	  commandtype = 6;
	else if (strcmp(string1, "TO") == 0)
	  commandtype = 7;
	else if (strcmp(string1, "SUBDOMAIN") == 0)
	  commandtype = 8;
	else if (strcmp(string1, "WEEKBEGINSON") == 0)
	  commandtype = 9;
	else if (strcmp(string1, "APPROXHOSTSIZE") == 0)
	  commandtype = 10;
	else if (strcmp(string1, "ISPAGE") == 0)
	  commandtype = 11;
	else if (strcmp(string1, "ISNOTPAGE") == 0)
	  commandtype = 12;
	else if (strcmp(string1, "SEPCHAR") == 0)
	  commandtype = 13;
	else if (strcmp(string1, "REPORTORDER") == 0)
	  commandtype = 14;
	else if (strcmp(string1, "WITHARGS") == 0)
	  commandtype = 15;
	else if (strcmp(string1, "WITHOUTARGS") == 0)
	  commandtype = 16;
	else if (strcmp(string1, "BACKGROUND") == 0)
	  commandtype = 17;
	else if (strcmp(string1, "SUBDOMFLOOR") == 0)
	  commandtype = 18;
	else if (strcmp(string1, "NOTSUBDOMAIN") == 0)
	  commandtype = 19;
	else if (strcmp(string1, "BASEURL") == 0)
	  commandtype = 20;
	else if (strcmp(string1, "DOMCOLS") == 0)
	  commandtype = 21;
	else if (strcmp(string1, "HOSTCOLS") == 0)
	  commandtype = 22;
	else if (strcmp(string1, "DIRCOLS") == 0)
	  commandtype = 23;
	else if (strcmp(string1, "REQCOLS") == 0)
	  commandtype = 24;
	else if (strcmp(string1, "LOGFILE") == 0)
	  commandtype = 100;
	else if (strcmp(string1, "DOMAINSFILE") == 0)
	  commandtype = 101;
	else if (strcmp(string1, "HOSTNAME") == 0)
	  commandtype = 102;
	else if (strcmp(string1, "HOSTURL") == 0)
	  commandtype = 103;
	else if (strcmp(string1, "REQFLOOR") == 0)
	  commandtype = 104;
	else if (strcmp(string1, "DIRFLOOR") == 0)
	  commandtype = 105;
	else if (strcmp(string1, "DOMFLOOR") == 0)
	  commandtype = 106;
	else if (strcmp(string1, "REQSORTBY") == 0)
	  commandtype = 107;
	else if (strcmp(string1, "DOMSORTBY") == 0)
	  commandtype = 108;
	else if (strcmp(string1, "DIRSORTBY") == 0)
	  commandtype = 109;
	else if (strcmp(string1, "MARKCHAR") == 0)
	  commandtype = 110;
	else if (strcmp(string1, "PAGEWIDTH") == 0)
	  commandtype = 111;
	else if (strcmp(string1, "MONTHLY") == 0)
	  commandtype = 112;
	else if (strcmp(string1, "DAILY") == 0)
	  commandtype = 113;
	else if (strcmp(string1, "HOURLY") == 0)
	  commandtype = 114;
	else if (strcmp(string1, "DOMAIN") == 0)
	  commandtype = 115;
	else if (strcmp(string1, "DIRECTORY") == 0)
	  commandtype = 116;
	else if (strcmp(string1, "REQUEST") == 0)
	  commandtype = 117;
	else if (strcmp(string1, "DIRLEVEL") == 0)
	  commandtype = 118;
	else if (strcmp(string1, "REQTYPE") == 0)
	  commandtype = 119;
	else if (strcmp(string1, "PAGELINKS") == 0)
	  commandtype = 120;
	else if (strcmp(string1, "COUNTHOSTS") == 0)
	  commandtype = 121;
	else if (strcmp(string1, "LASTSEVEN") == 0)
	  commandtype = 122;
	else if (strcmp(string1, "NUMLOOKUP") == 0)
	  commandtype = 123;
	else if (strcmp(string1, "MONTHLYUNIT") == 0)
	  commandtype = 124;
	else if (strcmp(string1, "HOURLYUNIT") == 0)
	  commandtype = 125;
	else if (strcmp(string1, "DAILYUNIT") == 0)
	  commandtype = 126;
	else if (strcmp(string1, "LOGOURL") == 0)
	  commandtype = 127;
	else if (strcmp(string1, "LOGO") == 0)
	  commandtype = 128;
	else if (strcmp(string1, "FULLHOSTS") == 0)
	  commandtype = 129;
	else if (strcmp(string1, "HOSTFLOOR") == 0)
	  commandtype = 130;
	else if (strcmp(string1, "HOSTSORTBY") == 0)
	  commandtype = 131;
	else if (strcmp(string1, "HEADERFILE") == 0)
	  commandtype = 132;
	else if (strcmp(string1, "FOOTERFILE") == 0)
	  commandtype = 133;
	else if (strcmp(string1, "FULLDAILY") == 0)
	  commandtype = 134;
	else if (strcmp(string1, "WEEKLY") == 0)
	  commandtype = 135;
	else if (strcmp(string1, "FULLDAILYUNIT") == 0)
	  commandtype = 136;
	else if (strcmp(string1, "WEEKLYUNIT") == 0)
	  commandtype = 137;
	else if (strcmp(string1, "ALL") == 0)
	  commandtype = 138;
	else if (strcmp(string1, "GENERAL") == 0)
	  commandtype = 139;
	else if (strcmp(string1, "ASCII") == 0)
	  commandtype = 140;
	else if (strcmp(string1, "HTML") == 0)
	  commandtype = 141;
	else if (strcmp(string1, "DEBUG") == 0)
	  commandtype = 142;
	else if (strcmp(string1, "OUTFILE") == 0)
	  commandtype = 143;

	switch(commandtype) {
	case (-1):     /* ERROR */
	  configwarning2(inputline);
	  break;
	case (0):      /* FILEALIAS */
	  if (rc < 3)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 3)
	      configwarning3(string1, inputline);
	    tempint = strlen(string2) - 1;
	    if (string2[tempint] == '*') {
	      /* special case; wild alias */
	      strcpy(filewaliasp -> from, string2);
	      filewaliasp -> from[tempint] = '\0';  /* omit final '*' */
	      filewaliasp -> flength = tempint;
	      strcpy(filewaliasp -> to, string3);
	      filewaliasp -> tlength = strlen(string3);
	      filewaliasp -> next =
		(struct wildalias *) xmalloc(sizeof(struct wildalias));
	      filewaliasp = filewaliasp -> next;
	      filewaliasp -> flength = -1;
	    }
	    else {
	      if (string2[0] == '\0' || string3[0] == '\0')
		configwarning2(inputline);
	      else {
		strcpy(filealiasp -> from, string2);
		strcpy(filealiasp -> to, string3);
		filealiasp -> next =
		  (struct alias *) xmalloc(sizeof(struct alias));
		filealiasp = filealiasp -> next;
		filealiasp -> from[0] = '\0';
	      }
	    }
	  }
	  break;
	case (1):      /* HOSTALIAS */
	  if (rc < 3)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0' || string3[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 3)
	      configwarning3(string1, inputline);
	    strcpy(hostaliasp -> from, strtolower(string2));
	    strcpy(hostaliasp -> to, strtolower(string3));
	    hostaliasp -> next = (struct alias *) xmalloc(sizeof(struct alias));
	    hostaliasp = hostaliasp -> next;
	    hostaliasp -> from[0] = '\0';
	  }
	  break;
	case (2):     /* FILEONLY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempint = strlen(string2) - 1;
	    if (string2[tempint] == '*') {  /* wild case */
	      strcpy(filewonlyp -> name, string2);
	      filewonlyp -> name[tempint] = '\0';  /* omit final '*' */
	      filewonlyp -> length = tempint;
	      filewonlyp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      filewonlyp = filewonlyp -> next;
	      filewonlyp -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(fileonlyp -> name, string2);
	      fileonlyp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      fileonlyp = fileonlyp -> next;
	      fileonlyp -> name[0] = '\0';
	    }
	  }
	  break;
	case (3):          /* FILEIGNORE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempint = strlen(string2) - 1;
	    if (string2[tempint] == '*') {  /* wild case */
	      if (tempint == 0)   /* Just 'FILEIGNORE *' */
		configwarning2(inputline);
	      else {
		strcpy(filewignp -> name, string2);
		filewignp -> name[tempint] = '\0';  /* omit final '*' */
		filewignp -> length = tempint;
		filewignp -> next =
		  (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
		filewignp = filewignp -> next;
		filewignp -> length = -1;
	      }
	    }
	    else {  /* not wild */
	      strcpy(fileignp -> name, string2);
	      fileignp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      fileignp = fileignp -> next;
	      fileignp -> name[0] = '\0';
	    }
	  }
	  break;
	case (4):             /* HOSTONLY */
	  if (rc < 2)
	    configwarning(string1, inputline);
 	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    if (string2[0] == '*') {  /* wild case */
	      strcpy(hostwonlyp -> name, strtolower(string2 + 1));
                                      /* omit intial '*' */
	      hostwonlyp -> length = strlen(string2) - 1;
	      hostwonlyp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      hostwonlyp = hostwonlyp -> next;
	      hostwonlyp -> length = -1;
	    }
	    else if (isdigit(string2[0]) &&
		     string2[strlen(string2) - 1] == '*') { /* wild, numeric */
	      strcpy(hostnonlyp -> name, string2);
	      hostnonlyp -> name[strlen(string2) - 1] = '\0';  /* omit '*' */
	      hostnonlyp -> length = strlen(string2) - 1;
	      hostnonlyp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      hostnonlyp = hostnonlyp -> next;
	      hostnonlyp -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(hostonlyp -> name, strtolower(string2));
	      hostonlyp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      hostonlyp = hostonlyp -> next;
	      hostonlyp -> name[0] = '\0';
	    }
	  }
	  break;
	case (5):                /* HOSTIGNORE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    if (string2[0] == '*') {  /* wild case */
	      if (string2[1] == '\0')
		configwarning2(inputline);
	      else {
		strcpy(hostwignp -> name, strtolower(string2 + 1));
                                                     /* omit intial '*' */
		hostwignp -> length = strlen(string2) - 1;
		hostwignp -> next =
		  (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
		hostwignp = hostwignp -> next;
		hostwignp -> length = -1;
	      }
	    }
	    else if (isdigit(string2[0]) &&
		     string2[strlen(string2) - 1] == '*') { /* wild, numeric */
	      strcpy(hostnignp -> name, string2);
	      hostnignp -> name[strlen(string2) - 1] = '\0';  /* omit '*' */
	      hostnignp -> length = strlen(string2) - 1;
	      hostnignp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      hostnignp = hostnignp -> next;
	      hostnignp -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(hostignp -> name, strtolower(string2));
	      hostignp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      hostignp = hostignp -> next;
	      hostignp -> name[0] = '\0';
	    }
	  }
	  break;
	case (6):             /* FROM */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (strlen(string2) < 6)
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempp = string2;
	    if (*tempp == '-') {
	      fromtime.year = starttimec.year;
	      fromtime.year -= 10 * (*(++tempp) - '0');
	      fromtime.year -= (*(++tempp) - '0');
	    }
	    else {
	      fromtime.year = 10 * (*tempp - '0');
	      fromtime.year += (*(++tempp) - '0');
	      if (fromtime.year > 70)   /* (say) */
		fromtime.year += 1900;
	      else
		fromtime.year += 2000;
	    }
	    tempp++;
	    if (*tempp == '-') {
	      fromtime.monthno = starttimec.monthno;
	      fromtime.monthno -= 10 * (*(++tempp) - '0');
	      fromtime.monthno -= (*(++tempp) - '0');
	      while (fromtime.monthno < 0) {
		fromtime.monthno += 12;
		fromtime.year--;
	      }
	    }
	    else if (*tempp == '+') {
	      fromtime.monthno = starttimec.monthno;
	      fromtime.monthno += 10 * (*(++tempp) - '0');
	      fromtime.monthno += (*(++tempp) - '0');
	      while (fromtime.monthno > 11) {
		fromtime.monthno -= 12;
		fromtime.year++;
	      }
	    }
	    else {
	      fromtime.monthno = 10 * (*tempp - '0');
	      fromtime.monthno += (*(++tempp) - '0');
	      fromtime.monthno--;  /* prog. months are 1 out from standard */
	    }
	    tempp++;
	    if (*tempp == '-') {
	      fromtime.date = starttimec.date;
	      fromtime.date -= 10 * (*(++tempp) - '0');
	      fromtime.date -= (*(++tempp) - '0');
	      while (fromtime.date <= 0) {
		fromtime.monthno--;
		if (fromtime.monthno < 0) {
		  fromtime.monthno += 12;
		  fromtime.year--;
		}
		fromtime.date += monthlength[fromtime.monthno] +
		  (fromtime.monthno == 1 && (fromtime.year % 4 == 0));
	      }
	    }
	    else if (*tempp == '+') {
	      fromtime.date = starttimec.date;
	      fromtime.date += 10 * (*(++tempp) - '0');
	      fromtime.date += (*(++tempp) - '0');
	      while (fromtime.date > monthlength[fromtime.monthno] +
		     (fromtime.monthno == 1 && fromtime.year % 4 == 0)) {
		fromtime.date -= monthlength[fromtime.monthno] +
		  (fromtime.monthno == 1 && (fromtime.year % 4 == 0));
		fromtime.monthno++;
		if (fromtime.monthno > 11) {
		  fromtime.monthno -= 12;
		  fromtime.year++;
		}
	      }
	    }
	    else {
	      fromtime.date = 10 * (*tempp - '0');
	      fromtime.date += (*(++tempp) - '0');
	    }
	    fromtime.hr = 0;
	    fromtime.min = 0;
	    fromtime.code = timecode(fromtime.date, fromtime.monthno,
				     fromtime.year, 0, 0);
	  }
	  break;
	case (7):           /* TO */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (strlen(string2) < 6)
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempp = string2;
	    if (*tempp == '-') {
	      totime.year = starttimec.year;
	      totime.year -= 10 * (*(++tempp) - '0');
	      totime.year -= (*(++tempp) - '0');
	    }
	    else {
	      totime.year = 10 * (*tempp - '0');
	      totime.year += (*(++tempp) - '0');
	      if (totime.year > 70)   /* (say) */
		totime.year += 1900;
	      else
		totime.year += 2000;
	    }
	    tempp++;
	    if (*tempp == '-') {
	      totime.monthno = starttimec.monthno;
	      totime.monthno -= 10 * (*(++tempp) - '0');
	      totime.monthno -= (*(++tempp) - '0');
	      while (totime.monthno < 0) {
		totime.monthno += 12;
		totime.year--;
	      }
	    }
	    else if (*tempp == '+') {
	      totime.monthno = starttimec.monthno;
	      totime.monthno += 10 * (*(++tempp) - '0');
	      totime.monthno += (*(++tempp) - '0');
	      while (totime.monthno > 11) {
		totime.monthno -= 12;
		totime.year++;
	      }
	    }
	    else {
	      totime.monthno = 10 * (*tempp - '0');
	      totime.monthno += (*(++tempp) - '0');
	      totime.monthno--;  /* prog. months are 1 out from standard */
	    }
	    tempp++;
	    if (*tempp == '-') {
	      totime.date = starttimec.date;
	      totime.date -= 10 * (*(++tempp) - '0');
	      totime.date -= (*(++tempp) - '0');
	      while (totime.date <= 0) {
		totime.monthno--;
		if (totime.monthno < 0) {
		  totime.monthno += 12;
		  totime.year--;
		}
		totime.date += monthlength[totime.monthno] +
		  (totime.monthno == 1 && (totime.year % 4 == 0));
	      }
	    }
	    else if (*tempp == '+') {
	      totime.date = starttimec.date;
	      totime.date += 10 * (*(++tempp) - '0');
	      totime.date += (*(++tempp) - '0');
	      while (totime.date > monthlength[totime.monthno] +
		     (totime.monthno == 1 && totime.year % 4 == 0)) {
		totime.date -= monthlength[totime.monthno] +
		  (totime.monthno == 1 && (totime.year % 4 == 0));
		totime.monthno++;
		if (totime.monthno > 11) {
		  totime.monthno -= 12;
		  totime.year++;
		}
	      }
	    }
	    else {
	      totime.date = 10 * (*tempp - '0');
	      totime.date += (*(++tempp) - '0');
	    }
	    totime.hr = 23;
	    totime.min = 59;
	    totime.code = timecode(totime.date, totime.monthno, totime.year,
				   23, 59);
	  }
	  break;
	case (8):            /* SUBDOMAIN */
	  if (string2[0] == '\0')
	    configwarning2(inputline);
	  else if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 3 || (rc == 3 && (string2[0] == '*' || 
				       string2[strlen(string2) - 1] == '*' ||
				       string2[0] == '%')))
	      configwarning3(string1, inputline);
	    strcpy(subdomp -> from, string2);
	    if (rc == 2 || string2[0] == '*' ||
		string2[strlen(string2) - 1] == '*' || string2[0] == '%')
	      strcpy(subdomp -> to, "?");
	    else
	      strcpy(subdomp -> to, string3);
	    subdomp -> next =
	      (struct alias *) xmalloc(sizeof(struct alias));
	    subdomp = subdomp -> next;
	    subdomp -> from[0] = '\0';
	  }
	  break;
	case (9):          /* WEEKBEGINSON */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "SUNDAY") == 0)
	      weekbeginson = SUNDAY;
	    else if (strcmp(string2, "MONDAY") == 0)
	      weekbeginson = MONDAY;
	    else if (strcmp(string2, "TUESDAY") == 0)
	      weekbeginson = TUESDAY;
	    else if (strcmp(string2, "WEDNESDAY") == 0)
	      weekbeginson = WEDNESDAY;
	    else if (strcmp(string2, "THURSDAY") == 0)
	      weekbeginson = THURSDAY;
	    else if (strcmp(string2, "FRIDAY") == 0)
	      weekbeginson = FRIDAY;
	    else if (strcmp(string2, "SATURDAY") == 0)
	      weekbeginson = SATURDAY;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (10):            /* APPROXHOSTSIZE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    approxhostsize = atoi(string2);
	    if (approxhostsize <= 0)
	      configwarning2(inputline);
	  }
	  break;
	case (11):           /* ISPAGE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    if (string2[0] == '*') {  /* wild case */
	      strcpy(wispagep -> name, string2 + 1);  /* omit intial '*' */
	      wispagep -> length = strlen(string2) - 1;
	      wispagep -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      wispagep = wispagep -> next;
	      wispagep -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(ispagep -> name, string2);
	      ispagep -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      ispagep = ispagep -> next;
	      ispagep -> name[0] = '\0';
	    }
	  }
	  break;
	case (12):        /* ISNOTPAGE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    if (string2[0] == '*') {
	      if (string2[1] == '\0')
		configwarning2(inputline);
	      else {
		strcpy(wisnotpagep -> name, string2 + 1);
		wisnotpagep -> length = strlen(string2) - 1;
		wisnotpagep -> next =
		  (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
		wisnotpagep = wisnotpagep -> next;
		wisnotpagep -> length = -1;
	      }
	    }
	    else {
	      strcpy(isnotpagep -> name, string2);
	      isnotpagep -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      isnotpagep = isnotpagep -> next;
	      isnotpagep -> name[0] = '\0';
	    }
	  }
	  break;
	case (13):      /* SEPCHAR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || string2[1] != '\0')
	      configwarning3(string1, inputline);
	    sepchar = string2[0];
	  }
	  break;
	case (14):         /* REPORTORDER */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || strlen(string2) > 14)
	      configwarning3(string1, inputline);
	    strncpy(reportorder, string2, 14);
	  }
	  break;
	case (15):          /* WTHARGS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempint = strlen(string2) - 1;
	    if (string2[tempint] == '*') {  /* wild case */
	      strcpy(wexpandp -> name, string2);
	      wexpandp -> name[tempint] = '\0';  /* omit final '*' */
	      wexpandp -> length = tempint;
	      wexpandp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      wexpandp = wexpandp -> next;
	      wexpandp -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(expandp -> name, string2);
	      expandp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      expandp = expandp -> next;
	      expandp -> name[0] = '\0';
	    }
	  }
	  break;
	case (16):        /* WITHOUTARGS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else if (string2[0] == '\0')
	    configwarning2(inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    maskq = ON;
	    tempint = strlen(string2) - 1;
	    if (string2[tempint] == '*') {  /* wild case */
	      strcpy(wnoexpandp -> name, string2);
	      wnoexpandp -> name[tempint] = '\0';  /* omit final '*' */
	      wnoexpandp -> length = tempint;
	      wnoexpandp -> next =
		(struct wstringlist *) xmalloc(sizeof(struct wstringlist));
	      wnoexpandp = wnoexpandp -> next;
	      wnoexpandp -> length = -1;
	    }
	    else {  /* not wild */
	      strcpy(noexpandp -> name, string2);
	      noexpandp -> next =
		(struct stringlist *) xmalloc(sizeof(struct stringlist));
	      noexpandp = noexpandp -> next;
	      noexpandp -> name[0] = '\0';
	    }
	  }
	  break;
	case (17):     /* BACKGROUND */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(background, string2);
	  }
	  break;
	case (18):       /* SUBDOMFLOOR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    subdomfloor = atoi(string2);
	  }
	  break;
	case (19):            /* NOTSUBDOMAIN */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    for (subdomtempp = subdomshead; subdomtempp -> from[0] != '\0' &&
		 strcmp(subdomtempp -> from, string2) != 0;
		 subdomtempp = subdomtempp -> next)
	      ;     /* run to the subdomain we want to remove */
	    if (subdomtempp -> from[0] != '\0')
	      subdomtempp -> from[0] = '?';   /* mark that we don't want it */
	  }
	  break;
	case (20):     /* BASEURL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(baseurl, string2);
	  }
	  break;
	case (21):         /* DOMCOLS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || strlen(string2) > 4)
	      configwarning3(string1, inputline);
	    strncpy(domcols, string2, 4);
	  }
	  break;
	case (22):         /* HOSTCOLS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || strlen(string2) > 4)
	      configwarning3(string1, inputline);
	    strncpy(hostcols, string2, 4);
	  }
	  break;
	case (23):         /* DIRCOLS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || strlen(string2) > 4)
	      configwarning3(string1, inputline);
	    strncpy(dircols, string2, 4);
	  }
	  break;
	case (24):         /* REQCOLS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || strlen(string2) > 4)
	      configwarning3(string1, inputline);
	    strncpy(reqcols, string2, 4);
	  }
	  break;
	case (100):         /* LOGFILE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(logfile, string2);
	  }
	  break;
	case (101):         /* DOMAINSFILE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(domainsfile, string2);
	  }
	  break;
	case (102):        /* HOSTNAME */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strcpy(hostname, string2);
	    if (rc > 2)
	      configwarning3(string1, inputline);
	  }
	  break;
	case (103):        /* HOSTURL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(hosturl, string2);
	  }
	  break;
	case (104):        /* REQFLOOR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    reqfloor = atoi(string2);
	  }
	  break;
	case (105):       /* DIRFLOOR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    dirfloor = atoi(string2);
	  }
	  break;
	case (106):       /* DOMFLOOR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    domfloor = atoi(string2);
	  }
	  break;
	case (107):       /* REQSORTBY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "BYREQUESTS") == 0)
	      reqsortby = BYREQUESTS;
	    else if (strcmp(string2, "BYBYTES") == 0)
	      reqsortby = BYBYTES;
	    else if (strcmp(string2, "ALPHABETICAL") == 0)
	      reqsortby = ALPHABETICAL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (108):      /* DOMSORTBY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "BYREQUESTS") == 0)
	      domsortby = BYREQUESTS;
	    else if (strcmp(string2, "BYBYTES") == 0)
	      domsortby = BYBYTES;
	    else if (strcmp(string2, "ALPHABETICAL") == 0)
	      domsortby = ALPHABETICAL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (109):      /* DIRSORTBY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "BYREQUESTS") == 0)
	      dirsortby = BYREQUESTS;
	    else if (strcmp(string2, "BYBYTES") == 0)
	      dirsortby = BYBYTES;
	    else if (strcmp(string2, "ALPHABETICAL") == 0)
	      dirsortby = ALPHABETICAL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (110):      /* MARKCHAR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2 || string2[1] != '\0')
	      configwarning3(string1, inputline);
	    markchar = string2[0];
	  }
	  break;
	case (111):      /* PAGEWIDTH */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    pagewidth = atoi(string2);
	    if (pagewidth < MINPAGEWIDTH || pagewidth > MAXPAGEWIDTH) {
	      fprintf(stderr, "%s: Page width should be between %d and %d\n",
		commandname, MINPAGEWIDTH, MAXPAGEWIDTH);
	      configwarning2(inputline);
	      pagewidth = PAGEWIDTH;
	    }
	  }
	  break;
	case (112):      /* MONTHLY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      mq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      mq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (113):      /* DAILY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      dq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      dq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (114):      /* HOURLY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      hq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      hq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (115):      /* DOMAIN */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      oq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      oq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (116):      /* DIRECTORY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      iq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      iq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (117):      /* REQUEST */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      rq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      rq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (118):     /* DIRLEVEL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    dirlevel = atoi(string2);
	  }
	  break;
	case (119):     /* REQTYPE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "PAGES") == 0)
	      reqtype = PAGES;
	    else if (strcmp(string2, "ALL") == 0)
	      reqtype = ALL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (120):     /* PAGELINKS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      kq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      kq = OFF;
	    else if (strcmp(string2, "ALL") == 0)
	      kq = ALL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (121):      /* COUNTHOSTS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      sq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      sq = OFF;
	    else if (strcmp(string2, "APPROX") == 0)
	      sq = APPROX;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (122):      /* LASTSEVEN */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      q7 = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      q7 = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (123):      /* NUMLOOKUP */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      dnsq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      dnsq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (124):      /* MONTHLYUNIT */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    monthlyunit = atoi(string2);
	  }
	  break;
	case (125):      /* HOURLYUNIT */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    hourlyunit = atoi(string2);
	  }
	  break;
	case (126):      /* DAILYUNIT */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    dailyunit = atoi(string2);
	  }
	  break;
	case (127):      /* LOGOURL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(logourl, string2);
	  }
	  break;
	case (128):      /* LOGO */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      logoq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      logoq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (129):      /* FULLHOSTS */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0) {
	      Sq = ON;
	      sq = ON;
	    }
	    else if (strcmp(string2, "OFF") == 0)
	      Sq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (130):     /* HOSTFLOOR */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    hostfloor = atoi(string2);
	  }
	  break;
	case (131):     /* HOSTSORTBY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "BYREQUESTS") == 0)
	      hostsortby = BYREQUESTS;
	    else if (strcmp(string2, "BYBYTES") == 0)
	      hostsortby = BYBYTES;
	    else if (strcmp(string2, "ALPHABETICAL") == 0)
	      hostsortby = ALPHABETICAL;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (132):     /* HEADERFILE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(headerfile, string2);
	  }
	  break;
	case (133):     /* FOOTERFILE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(footerfile, string2);
	  }
	  break;
	case (134):     /* FULLDAILY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      Dq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      Dq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (135):     /* WEEKLY */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      Wq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      Wq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (136):     /* FULLDAILYUNIT */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    fulldailyunit = atoi(string2);
	  }
	  break;
	case (137):     /* WEEKLYUNIT */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    weeklyunit = atoi(string2);
	  }
	  break;
	case (138):      /* ALL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0) {
	      mq = ON;
	      Wq = ON;
	      dq = ON;
	      Dq = ON;
	      hq = ON;
	      oq = ON;
	      Sq = ON;
	      iq = ON;
	      rq = ON;
	    }
	    else if (strcmp(string2, "OFF") == 0)  {
	      mq = OFF;
	      Wq = OFF;
	      dq = OFF;
	      Dq = OFF;
	      hq = OFF;
	      oq = OFF;
	      Sq = OFF;
	      iq = OFF;
	      rq = OFF;
	    }
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (139):      /* GENERAL */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      xq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      xq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (140):      /* ASCII */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      aq = ON;
	    else if (strcmp(string2, "OFF") == 0)
	      aq = OFF;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (141):      /* HTML */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    strtoupper(string2);
	    if (strcmp(string2, "ON") == 0)
	      aq = OFF;
	    else if (strcmp(string2, "OFF") == 0)
	      aq = ON;
	    else
	      configwarning2(inputline);
	  }
	  break;
	case (142):       /* DEBUG */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    debug = atoi(string2);
	  }
	  break;
	case (143):         /* OUTFILE */
	  if (rc < 2)
	    configwarning(string1, inputline);
	  else {
	    if (rc > 2)
	      configwarning3(string1, inputline);
	    strcpy(outfile, string2);
	  }
	  break;
	}
      }
    }

    if (fromtime.code > totime.code) {
      fprintf(stderr, "%s: Error: FROM and TO exclude all dates.\n",
	      commandname);
      exit(ERR);
    }

  }
}

/*** Now the function to parse the commandline arguments ***/

void commandline(int argc, char **argv)
{
  int i;

  int configfound = 0;

  /* The values given in the configuration file are overridden by those on
     the commandline, so we need to read the config. file first. To do this,
     we first scan backwards through the arguments looking for the (last)
     occurrence of +g or -g. We then run the config. file, then look at the
     other arguments. */

  for (i = argc - 1; i >= 1 && configfound == 0; i--) {
    if (argv[i][1] == 'g' || argv[i][1] == 'G') {
      if (argv[i][0] == '+') {
	if (argv[i][2] == '\0') {
	  fprintf(stderr,
                  "%s: Warning: no filename supplied after +%c option\n",
		  commandname, argv[i][1]);
	  fprintf(stderr, "  (or space left before filename)\n");
	}
	else
	  strncpy(configfile, argv[i] + 2, MAXSTRINGLENGTH - 1);
	configfound = 1 + (argv[i][1] == 'G');
      }
      else if (argv[i][0] == '-') {
	strcpy(configfile, "none");
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -%c option\n",
		  commandname, argv[i][1]);
	configfound = 1;
      }
    }
  }

  if (configfound == 2) {   /* then do the default configfile & the new one */
    if (strcmp(CONFIGFILE, "none") != 0)
      config(CONFIGFILE);
    config(configfile);
  }    

  else {   /* configfound == 0 or 1; just do one configfile */
    if (strcmp(configfile, "none") != 0)
      config(configfile);
  }

  /* Now read the other arguments */

  for (i = 1; i < argc; i++) {

    if (argv[i][0] != '+' && argv[i][0] != '-')
      strncpy(logfile, argv[i], MAXSTRINGLENGTH - 1);

    else switch (argv[i][1]) {
    case '\0':    /* read stdin */
      strcpy(logfile, "stdin");
      break;
    case '1':     /* try and resolve numerical addresses */
      if (argv[i][0] == '-')
	dnsq = OFF;
      else
	dnsq = ON;
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %c1 option\n",
		commandname, argv[i][0]);
      break;      
    case '7':     /* stats for last 7 days */
      if (argv[i][0] == '-')
	q7 = OFF;
      else
	q7 = ON;
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %c7 option\n",
		commandname, argv[i][0]);
      break;
    case 'a':     /* ASCII output */
      if (argv[i][0] == '-')
	aq = OFF;
      else
	aq = ON;
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %ca option\n",
		commandname, argv[i][0]);
      break;      
    case 'A':     /* all reports */
      if (argv[i][0] == '-') {
	mq = OFF;
	Wq = OFF;
	dq = OFF;
	Dq = OFF;
	hq = OFF;
	oq = OFF;
	Sq = OFF;
	iq = OFF;
	rq = OFF;
      }
      else {
	mq = ON;
	Wq = ON;
	dq = ON;
	Dq = ON;
	hq = ON;
	oq = ON;
	Sq = ON;
	iq = ON;
	rq = ON;
      }
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %cA option\n",
		commandname, argv[i][0]);
      break;
    case 'c':     /* markchar */
      markchar = argv[i][2];
      if (argv[i][3] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %cc%c option\n",
		commandname, argv[i][0], argv[i][2]);
      break;
    case 'd':     /* daily summary */
      if (argv[i][0] == '-') {
	dq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -d option\n",
		  commandname);
      }
      else {
	dq = ON;
	if (argv[i][2] != '\0')
	  dailyunit = atoi(argv[i] + 2);
      }
      break;
    case 'D':     /* full daily report */
      if (argv[i][0] == '-') {
	Dq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -D option\n",
		  commandname);
      }
      else {
	Dq = ON;
	if (argv[i][2] != '\0')
	  fulldailyunit = atoi(argv[i] + 2);
      }
      break;
    case 'f':     /* domains file */
      if (strcmp(argv[i] + 2, "orm") == 0)
	formq = ON;
      else if (argv[i][2] == '\0') {
	fprintf(stderr, "%s: Warning: no filename supplied after %cf option\n",
		commandname, argv[i][0]);
	fprintf(stderr, "  (or space left before filename)\n");
      }
      else
	strncpy(domainsfile, argv[i] + 2, MAXSTRINGLENGTH - 1);
      break;
    case 'F':     /* footer file */
      if (argv[i][0] == '-') {
	strcpy(footerfile, "none");
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -F option\n",
		  commandname);
      }
      else {
	if (argv[i][2] == '\0') {
	  fprintf(stderr, "%s: Warning: no filename supplied after +F option\n",
		  commandname);
	  fprintf(stderr, "  (or space left before filename)\n");
	}
	else
	  strncpy(footerfile, argv[i] + 2, MAXSTRINGLENGTH - 1);
      }
      break;
    case 'g':     /* configuration file; but we've already read it */
    case 'G':
      break;
    case 'h':     /* hourly summary */
      if (argv[i][0] == '-') {
	hq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -h option\n",
		  commandname);
      }
      else {
	hq = ON;
	if (argv[i][2] != '\0')
	  hourlyunit = atoi(argv[i] + 2);
      }
      break;
    case 'H':     /* header file */
      if (argv[i][0] == '-') {
	strcpy(headerfile, "none");
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -H option\n",
		  commandname);
      }
      else {
	if (argv[i][2] == '\0') {
	  fprintf(stderr, "%s: Warning: no filename supplied after +H option\n",
		  commandname);
	  fprintf(stderr, "  (or space left before filename)\n");
	}
	else
	  strncpy(headerfile, argv[i] + 2, MAXSTRINGLENGTH - 1);
      }
      break;
    case 'i':     /* directory report */
      if (argv[i][0] == '-') {
	iq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -i option\n",
		  commandname);
      }
      else {
	iq = ON;
	switch (argv[i][2]) {
	case 'a':
	  dirsortby = ALPHABETICAL;
	  if (argv[i][3] == '\0')
	    dirfloor = MIN_DIR_REQS;
	  else
	    dirfloor = atoi(argv[i] + 3);
	  break;
	case 'b':
	  dirsortby = BYBYTES;
	  if (argv[i][3] == '\0')
	    dirfloor = MIN_DIR_BYTES;
	  else
	    dirfloor = atoi(argv[i] + 3);
	  break;
	case 'r':
	  dirsortby = BYREQUESTS;
	  if (argv[i][3] == '\0')
	    dirfloor = MIN_DIR_REQS;
	  else
	    dirfloor = atoi(argv[i] + 3);
	  break;
	default:
	  if (argv[i][2] != '\0')
	    dirfloor = atoi(argv[i] + 2);
	}
      }
      break;
    case 'k':     /* link to pages in req. report? */
      if (argv[i][0] == '-') {
	kq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -k option\n",
		  commandname);
      }
      else {
	kq = ON;
	if (argv[i][2] == 'k')
	  kq = ALL;
      }
      break;
    case 'l':     /* 'level' of dir report */
      dirlevel = atoi(argv[i] + 2);
      break;
    case 'm':     /* monthly report */
      if (argv[i][0] == '-') {
	mq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -m option\n",
		  commandname);
      }
      else {
	mq = ON;
	if (argv[i][2] == '\0')
	  monthlyunit = atoi(argv[i] + 2);
      }
      break;
    case 'n':     /* our host or organisation name */
      if (argv[i][2] == '\0') {
	fprintf(stderr, "%s: Warning: no text supplied after %cn option\n",
		commandname, argv[i][0]);
	fprintf(stderr, "  (or space left before text)\n");
      }
      else
	strncpy(hostname, argv[i] + 2, MAXSTRINGLENGTH - 1);
      break;
    case 'o':                 /* domain report */
      if (argv[i][0] == '-') {
	oq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -o option\n",
		  commandname);
      }
      else {
	oq = ON;
	switch (argv[i][2]) {
	case 'a':
	  domsortby = ALPHABETICAL;
	  if (argv[i][3] == '\0')
	    domfloor = MIN_DOM_REQS;
	  else
	    domfloor = atoi(argv[i] + 3);
	  subdomfloor = MIN_SUBDOM_REQS;
	  break;
	case 'b':
	  domsortby = BYBYTES;
	  if (argv[i][3] == '\0')
	    domfloor = MIN_DOM_BYTES;
	  else
	    domfloor = atoi(argv[i] + 3);
	  subdomfloor = MIN_SUBDOM_BYTES;
	  break;
	case 'r':
	  domsortby = BYREQUESTS;
	  if (argv[i][3] == '\0')
	    domfloor = MIN_DOM_REQS;
	  else
	    domfloor = atoi(argv[i] + 3);
	  subdomfloor = MIN_SUBDOM_REQS;
	  break;
	default:
	  if (argv[i][2] != '\0')
	    domfloor = atoi(argv[i] + 2);
	}
      }
      break;
    case 'O':     /* outfile */
      if (argv[i][0] == '-') {
	strcpy(outfile, "stdout");
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -O option\n",
		  commandname);
      }
      else {
	if (argv[i][2] == '\0') {
	  fprintf(stderr, "%s: Error: no filename supplied after +O option\n",
		  commandname);
	  fprintf(stderr, "  (or space left before filename)\n");
	  exit(ERR);
	}
	else
	  strncpy(outfile, argv[i] + 2, MAXSTRINGLENGTH - 1);
      }
      break;
    case 'p':    /* logo? */
      if (argv[i][0] == '-') {
	logoq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -p option\n",
		  commandname);
      }
      else {
	logoq = ON;
	if (argv[i][2] != '\0')
	  strcpy(logourl, argv[i] + 2);
      }
      break;
    case 'r':    /* request report */
    case 'R':
      if (argv[i][0] == '-') {
	rq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -%c option\n",
		  commandname, argv[i][1]);
      }
      else {
	rq = ON;
	if (argv[i][1] == 'r')
	  reqtype = PAGES;
	else
	  reqtype = ALL;
	switch (argv[i][2]) {
	case 'a':
	  reqsortby = ALPHABETICAL;
	  if (argv[i][3] == '\0')
	    reqfloor = MIN_URL_REQS;
	  else
	    reqfloor = atoi(argv[i] + 3);
	  break;
	case 'b':
	  reqsortby = BYBYTES;
	  if (argv[i][3] == '\0')
	    reqfloor = MIN_URL_BYTES;
	  else
	    reqfloor = atoi(argv[i] + 3);
	  break;
	case 'r':
	  reqsortby = BYREQUESTS;
	  if (argv[i][3] == '\0')
	    reqfloor = MIN_URL_REQS;
	  else
	    reqfloor = atoi(argv[i] + 3);
	  break;
	default:
	  if (argv[i][2] != '\0')
	    reqfloor = atoi(argv[i] + 2);
	}
      }
      break;
    case 's':      /* count hosts? */
      if (argv[i][0] == '-')
	sq = OFF;
      else if (argv[i][2] == 's')
	sq = APPROX;
      else
	sq = ON;
      if (argv[i][2] == 's') {
	if (argv[i][3] != '\0')
	  fprintf(stderr,
		  "%s: Warning: ignoring extra text after %css option\n",
		  commandname, argv[i][0]);
      }
      else {  /* argv[i][2] != 's' */
	if (argv[i][2] != '\0')
	  fprintf(stderr,
		  "%s: Warning: ignoring extra text after %cs option\n",
		  commandname, argv[i][0]);
      }
      break;
    case 'S':      /* full hostname report */
      if (argv[i][0] == '-') {
	Sq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr,
		  "%s: Warning: ignoring extra text after %cS option\n",
		  commandname, argv[i][0]);
      }
      else {
	Sq = ON;
	sq = ON;  /* +S implies +s */
	switch (argv[i][2]) {
	case 'a':
	  hostsortby = ALPHABETICAL;
	  if (argv[i][3] == '\0')
	    hostfloor = MIN_HOST_REQS;
	  else
	    hostfloor = atoi(argv[i] + 3);
	  break;
	case 'b':
	  hostsortby = BYBYTES;
	  if (argv[i][3] == '\0')
	    hostfloor = MIN_HOST_BYTES;
	  else
	    hostfloor = atoi(argv[i] + 3);
	  break;
	case 'r':
	  hostsortby = BYREQUESTS;
	  if (argv[i][3] == '\0')
	    hostfloor = MIN_HOST_REQS;
	  else
	    hostfloor = atoi(argv[i] + 3);
	  break;
	default:
	  if (argv[i][2] != '\0')
	    hostfloor = atoi(argv[i] + 2);
	}
      }
      break;
    case 'u':     /* host URL */
      if (argv[i][2] == '\0') {
	fprintf(stderr, "%s: Warning: no URL supplied after %cu option\n",
		commandname, argv[i][0]);
	fprintf(stderr, "  (or space left before URL)\n");
      }
      else
	strncpy(hosturl, argv[i] + 2, MAXSTRINGLENGTH - 1);
      break;
    case 'v':          /* print variables and exit */
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %cv option\n",
		commandname, argv[i][0]);
      vblesonly = ON;
      break;
    case 'V':          /* debugging info */
      if (argv[i][0] == '-') {
	debug = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -V option\n",
		  commandname);
      }
      else {
	if (argv[i][2] == '\0')
	  debug = 1;
	else
	  debug = atoi(argv[i] + 2);
      }
      break;
    case 'w':          /* pagewidth */
      pagewidth = atoi(argv[i] + 2);
      if (pagewidth < MINPAGEWIDTH || pagewidth > MAXPAGEWIDTH) {
	fprintf(stderr,
	"%s: Warning: at option %s, page width should be between %d and %d\n",
		commandname, argv[i], MINPAGEWIDTH, MAXPAGEWIDTH);
	fprintf(stderr, "  Resetting to default value of %d\n", PAGEWIDTH);
	pagewidth = PAGEWIDTH;
      }
      break;
    case 'W':           /* weekly report */
      if (argv[i][0] == '-') {
	Wq = OFF;
	if (argv[i][2] != '\0')
	  fprintf(stderr, "%s: Warning: ignoring extra text after -W option\n",
		  commandname);
      }
      else {
	Wq = ON;
	if (argv[i][2] != '\0')
	  weeklyunit = atoi(argv[i] + 2);
      }
      break;
    case 'x':           /* general summary and gotos */
      if (argv[i][0] == '-')
	xq = OFF;
      else
	xq = ON;
      if (argv[i][2] != '\0')
	fprintf(stderr, "%s: Warning: ignoring extra text after %cx option\n",
		commandname, argv[i][0]);
      break;
    default:
      fprintf(stderr,
      "%s: Error: Unknown option %s: see README.html for correct usage\n",
	      commandname, argv[i]);
      fprintf(stderr,
      "  or go to http://www.statslab.cam.ac.uk/~sret1/analog/\n");
      exit(ERR);
    }
  }
}

/*** Next, the function that parses the domains file ***/

void domainscan(void)
{
  extern flag subdomadd();        /* in hash.c */
  extern int sscanf_domains();    /* in sscanf.c */

  FILE *df;
  struct domain *domp, *domlastp;
  struct alias *subdomp;
  char tempstr[MAXSTRINGLENGTH], tempstr2[MAXSTRINGLENGTH];
  char inputline[MAXLINELENGTH];
  int rc;    /* return code */
  int domcode;   /* the code of a particular domain;
		    see the long comment just below */

  df = fopen(domainsfile, "r");
  if (df == NULL) {
    fprintf(stderr, "%s: Warning: Failed to open domains file \"%s\":\n",
	    commandname, domainsfile);
    fprintf(stderr,"  will not construct domain report.\n");
    oq = OFF;
    return;
  }

  /* We put the domains in the following order. aa = 0, ab = 2, ...,
     ba = 52, ... Domains with more than two letters go in the spaces;
     co = 134, com = 135, cp = 136. We assume that there are no two long
     domain names with the same two initial letters. Finally zz = 1350,
     zzspam = 1351, Unknown = 1352, Numerical = 1353. Each domain contains
     a 'nexti' element to show which is the next domain that occurs in the
     domains file. */

  else {   /* there is a domains file */
    domp = domainhead[DOMHASHSIZE - 2];
    domp -> id = xmalloc(5);      /* enough for "*UNK\0" */
    strcpy(domp -> id, "*UNK");
    domp -> name = xmalloc(8);
    strcpy(domp -> name, "unknown");
    domp -> reqs = 0;
    domp -> bytes = 0;
    domp -> next = (struct domain *) xmalloc(sizeof(struct domain));
    domp -> next -> name = NULL;
    domp = domainhead[DOMHASHSIZE - 1];
    domp -> id = xmalloc(5);
    strcpy(domp -> id, "*NUM");
    domp -> name = xmalloc(31);
    strcpy(domp -> name, "unresolved numerical addresses");
    domp -> reqs = 0;
    domp -> bytes = 0;
    domp -> next = (struct domain *) xmalloc(sizeof(struct domain));
    domp -> next -> name = NULL;
    domlastp = domp;
    domp = domp -> next;

    while (fgets(inputline, MAXLINELENGTH, df) != NULL) {
      rc = sscanf_domains(inputline, tempstr, tempstr2);
      if (rc == 2) {
	if ((!isdigit(tempstr[0])) && strchr(tempstr, '.') == NULL) {
                                                    /* new domain */
	  domcode = (tempstr[0] - 'a') * 52 + (tempstr[1] - 'a') * 2 +
	    (tempstr[2] != '\0');
	  if (domcode < 0 || domcode > DOMHASHSIZE - 3) {
	    fprintf(stderr, "%s: Warning: Ignoring corrupt line in domains file looking like\n", commandname);
	    fprintf(stderr,"  %s", inputline);
	  }
	  domp = domainhead[domcode];
	  domp -> id = xmalloc((size_t)(strlen(tempstr) + 1));
	  strcpy(domp -> id, tempstr);
	  domp -> name = xmalloc((size_t)(strlen(tempstr2) + 1));
	  strcpy(domp -> name, tempstr2);
	  domp -> reqs = 0;
	  domp -> bytes = 0;
	  domp -> next = (struct domain *) xmalloc(sizeof(struct domain));
	  domp -> next -> name = NULL;
	  domlastp -> nexti = domcode;
                            /* domlastp is the last domain we looked at */
	  domlastp = domp;
	  domp = domp -> next;
	}
	else {   /* old specification subdomain */
	  fprintf(stderr,
          "%s: Warning: Subdomains should now be specified in configuration\n",
		  commandname);
	  fprintf(stderr, "  file, not domains file. Ignoring line\n  %s",
		  inputline);
	}
      }
      else if (rc == 1) {
	fprintf(stderr, "%s: Warning: Ignoring corrupt line in domains file looking like\n", commandname);
	fprintf(stderr, "  %s", inputline);
      }
    }

    domlastp -> nexti = -1;   /* marker; last domain has no subsequent one */
    
    fclose(df);

    /* Now do the subdomains which we read in at configuration time */

    for (subdomp = subdomshead; subdomp -> from[0] != '\0';
	 subdomp = subdomp -> next)
      if (subdomp -> from[0] != '?')
	subdomadd(subdomp -> from, subdomp -> to);

  }     /* end else can read domains file */
}


/*** The actual initialise() function ***/

void initialise(int argc, char **argv)
{
  extern void formgen();      /* in formgen.c */
  extern int strtomonth();    /* in utilities.c */
  extern long timecode();     /* in utilities.c */

  int i;
  char startmonth[4];
  char oldmonth[4];    /* the time 7 days ago */
  long oldtimeno;
  char oldtimestr[26];
  FILE *outf;

  gettimeofday(&starttime, &tzp);
  strcpy(starttimestr, (char *)(ctime((time_t *)(&starttime.tv_sec))));
  starttimec.year = (starttimestr[23] - '0') + (starttimestr[22] - '0') * 10
    + (starttimestr[21] - '0') * 100 + (starttimestr[20] - '0') * 1000;
  starttimec.date = (starttimestr[9] - '0');
  if (starttimestr[8] != ' ')
    starttimec.date += (starttimestr[8] - '0') * 10;
  strncpy(startmonth, starttimestr + 4, 3);
  starttimec.monthno = strtomonth(startmonth);
  starttimec.code = timecode(starttimec.date, starttimec.monthno,
			     starttimec.year, 23, 59);
  /* end of today will be good enough for our purposes */

  defaults();   /* enter the defaults for all the variables
		   (before possibly changing them). */

  filealiashead = (struct alias *) xmalloc(sizeof(struct alias));
  filealiashead -> from[0] = '\0';
  hostaliashead = (struct alias *) xmalloc(sizeof(struct alias));
  hostaliashead -> from[0] = '\0';
  filewaliashead = (struct wildalias *) xmalloc(sizeof(struct wildalias));
  filewaliashead -> flength = -1;
  fileonlyhead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  fileonlyhead -> name[0] = '\0';
  fileignorehead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  fileignorehead -> name[0] = '\0';
  hostonlyhead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  hostonlyhead -> name[0] = '\0';
  hostignorehead = (struct stringlist *) xmalloc(sizeof(struct stringlist));
  hostignorehead -> name[0] = '\0';
  filewonlyhead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  filewonlyhead -> length = -1;
  filewignorehead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  filewignorehead -> length = -1;
  hostwonlyhead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  hostwonlyhead -> length = -1;
  hostwignorehead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  hostwignorehead -> length = -1;
  hostnonlyhead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  hostnonlyhead -> length = -1;
  hostnignorehead = (struct wstringlist *) xmalloc(sizeof(struct wstringlist));
  hostnignorehead -> length = -1;
  subdomshead = (struct alias *) xmalloc(sizeof(struct alias));
  subdomshead -> from[0] = '\0';
  maskq = OFF;

  strncpy(commandname, argv[0], MAXSTRINGLENGTH - 1);

  commandline(argc, argv);  /* parse commandline. This also calls the
			       configuration file parser */

  /* correct any variables for which wrong value given */

  if (dirlevel == 0)
    dirlevel = 1;

  if (strcmp(outfile, "stdout") != 0) {
    if ((outf = fopen(outfile, "w")) == NULL) {
      fprintf(stderr,
	      "%s: Error: failed to open output file %s for writing.\n",
	      commandname, outfile);
      exit(ERR);   /* test now so we don't do the processing THEN find out */
    }
    else
      fclose(outf);  /* no need to hold it open */
  }

  /* if we just want a form, generate that and exit */

  if (formq) {
    formgen();
    exit(OK);
  }

  if (!vblesonly) {

    no_urls = 0;
    no_urls7 = 0;
    no_hosts = 0;
    no_hosts7 = 0;
    no_new_hosts7 = 0;
    url_max_reqs = 0;
    dir_max_reqs = 0;
    host_max_reqs = 0;
    url_max_bytes = 0;
    dir_max_bytes = 0;
    host_max_bytes = 0;   /* dom_max_reqs and _bytes are set later */
    total_fail_reqs = 0;
    total_fail_reqs7 = 0;
    total_succ_reqs = 0;
    total_succ_reqs7 = 0;
    total_other_reqs = 0;
    total_other_reqs7 = 0;
    total_bytes = 0.0;
    total_bytes7 = 0.0;
    corrupt_lines = 0;
    other_lines = 0;
    bq = ON;

    if (q7) {   /* calculate the time 7 days ago */
      if (starttimec.code <= totime.code) {
	oldtimeno = starttime.tv_sec - 604800;   /* seconds in a week */
	strcpy(oldtimestr, (char *)(ctime((time_t *)(&oldtimeno))));
	oldtime.year = (oldtimestr[23] - '0') + (oldtimestr[22] - '0') * 10
	  + (oldtimestr[21] - '0') * 100 + (oldtimestr[20] - '0') * 1000;
	oldtime.min = (oldtimestr[15] - '0') + (oldtimestr[14] - '0') * 10;
	oldtime.hr = (oldtimestr[12] - '0') + (oldtimestr[11] - '0') * 10;
	oldtime.date = (oldtimestr[9] - '0');
	if (oldtimestr[8] != ' ')
	  oldtime.date += (oldtimestr[8] - '0') * 10;
	oldtimestr[7] = '\0';
	strcpy(oldmonth, oldtimestr + 4);
	oldtime.monthno = strtomonth(oldmonth);
      }
      else {    /* totime is earlier than today; take 7 days before that */
	oldtime.hr = 23;
	oldtime.min = 59;
	oldtime.year = totime.year;
	oldtime.monthno = totime.monthno;
	oldtime.date = totime.date - 7;
	if (oldtime.date < 1) {
	  oldtime.monthno--;
	  oldtime.date += monthlength[oldtime.monthno] +
	    (oldtime.monthno == 1 && oldtime.year % 4 == 0);
	}
	if (oldtime.monthno < 0) {
	  oldtime.year--;
	  oldtime.monthno += 12;
	}
      }
      oldtime.code = timecode(oldtime.date, oldtime.monthno, oldtime.year,
			      oldtime.hr, oldtime.min);
      if (oldtime.code < fromtime.code)
	q7 = OFF;  /* FROM--TO is all in last 7 days */
    }
    
    dirsufflength = strlen(DIRSUFFIX);
    
    if (rq || iq) {   /* we do a (silent) req. report if iq as well */
      for (i = 0; i < URLHASHSIZE; i++) {
	urlhead[i] = (struct url *) xmalloc(sizeof(struct url));
	urlhead[i] -> name = NULL;
      }
    }
    
    if (iq) {
      for (i = 0; i < DIRHASHSIZE; i++) {
	dirhead[i] = (struct dir *) xmalloc(sizeof(struct dir));
	dirhead[i] -> name = NULL;
      }
    }
    
    if (sq == ON) {
      for (i = 0; i < HOSTHASHSIZE; i++) {
	hosthead[i] = (struct host *) xmalloc(sizeof(struct host));
	hosthead[i] -> name = NULL;
      }
    }

    else if (sq == APPROX) {
      approxhostspace = (char *) xcalloc(approxhostsize, 1);
      if (q7)
	approxhostspace7 = (char *) xcalloc(approxhostsize, 1);
    }

    if (oq) {
      for (i = 0; i < DOMHASHSIZE; i++) {
	domainhead[i] = (struct domain *) xmalloc(sizeof(struct domain));
	domainhead[i] -> name = NULL;
      }
      for (i = 0; i < SUBDOMHASHSIZE; i++) {
	subdomhead[i] = (struct domain *) xmalloc(sizeof(struct domain));
	subdomhead[i] -> name = NULL;
      }
      wildsubdomhead = (struct domain *) xmalloc(sizeof(struct domain));
      wildsubdomhead -> id = NULL;
      nwildsubdomhead = (struct domain *) xmalloc(sizeof(struct domain));
      nwildsubdomhead -> id = NULL;

      domainscan();      /* read in all the domains */

    }   /* end if (oq) */

  }   /* end if not vblesonly */

}   /* end initialise() */


/*** Finally, a function just to print variables and exit ***/

void printvbles(void)
{
  extern void int3printf();    /* in utilities.c */

  FILE *filep;
  struct alias *filealiasp, *hostaliasp, *subdomp;
  struct wildalias *filewaliasp;
  struct stringlist *fileonlyp, *fileignp, *hostonlyp, *hostignp;
  struct wstringlist *filewonlyp, *filewignp, *hostwonlyp, *hostwignp;
  char *c, *d;

  printf("This is analog version %s\n", VERSION);
  printf("For more information on analog see Readme.html or\n");
  printf("http://www.statslab.cam.ac.uk/~sret1/analog/\n\n");

  printf("The logfile is %s\n", logfile);
  if ((filep = fopen(logfile, "r")) == NULL && strcmp(logfile, "stdin") != 0)
    printf("  Warning: cannot open that file\n");
  else
    fclose(filep);  /* NB So condl 3 lines back must be in that order */

  printf("The domains file is %s\n", domainsfile);
  if ((filep = fopen(domainsfile, "r")) == NULL)
    printf(
         "  Warning: cannot open that file: cannot construct domain report\n");
  else
    fclose(filep);

  printf("The output file is %s\n", outfile);
  /* Don't check for being able to write as it will destroy the file */

  printf("\nReport order:\n");
  printf("General summary  %s\n", xq?"ON":"OFF");
  for (c = reportorder; *c != '\0'; c++) {
    switch(*c) {
    case 'd':
      printf("Daily summary    %s\n", dq?"ON":"OFF");
      if (dq && dailyunit != 0) {
	printf("Each character in the graph will represent");
	int3printf(stdout, dailyunit);
	printf(" requests\n");
      }
      break;
    case 'D':
      printf("Daily report     %s\n", Dq?"ON":"OFF");
      if (Dq && fulldailyunit != 0) {
	printf("Each character in the graph will represent");
	int3printf(stdout, fulldailyunit);
	printf(" requests\n");
      }
      break;
    case 'h':
      printf("Hourly summary   %s\n", hq?"ON":"OFF");
      if (hq && hourlyunit != 0) {
	printf("Each character in the graph will represent");
	int3printf(stdout, hourlyunit);
	printf(" requests\n");
      }
      break;
    case 'i':
      printf("Directory report %s\n", iq?"ON":"OFF");
      if (iq) {
	if (dirfloor < 0) {
	  if (dirfloor == -1)
	    printf("  Printing the first directory ");
	  else
	    printf("  Printing the first %d directories ", -dirfloor);
	  if (dirsortby == BYREQUESTS)
	    printf("by number of requests.\n");
	  else if (dirsortby == BYBYTES)
	    printf("by amount of traffic.\n");
	  else
	    printf("alphabetically.\n");
	}
	else {
	  printf("  Printing all directories to depth %d", dirlevel);
	  if (dirsortby == BYBYTES) {
	    if (dirfloor > 0)
	      printf(" with at least %d.%02d%% of the traffic", dirfloor / 100,
		     dirfloor % 100);
	    printf(",\n  sorted by traffic.\n");
	  }
	  else {
	    if (dirfloor > 1)
	      printf(" with at least %d requests", dirfloor);
	    printf(",\n  sorted %s\n",
		   (dirsortby==BYREQUESTS)?"by requests.":"alphabetically.");
	  }
	}
	printf("  Columns:");
	if (*dircols == '\0')
	  printf("  none");
	else for (d = dircols; *d != '\0'; d++) {
	  switch(*d) {
	  case 'b':
	    printf("  %%bytes");
	    break;
	  case 'B':
	    printf("  #bytes");
	    break;
	  case 'r':
	    printf("  %%requests");
	    break;
	  case 'R':
	    printf("  #requests");
	    break;
	  }
	}
	printf("\n");
      }
      break;
    case 'm':
      printf("Monthly report   %s\n", mq?"ON":"OFF");
      if (mq && monthlyunit != 0) {
	printf("Each character in the graph will represent");
	int3printf(stdout, monthlyunit);
	printf(" requests\n");
      }
      break;
    case 'o':
      printf("Domain report    %s\n", oq?"ON":"OFF");
      if (oq) {
	if (domfloor < 0) {
	  if (domfloor == -1)
	    printf("  Printing the first domain ");
	  else
	    printf("  Printing the first %d domains ", -domfloor);
	  if (domsortby == BYREQUESTS)
	    printf("by number of requests.\n");
	  else if (domsortby == BYBYTES)
	    printf("by amount of traffic.\n");
	  else
	    printf("alphabetically.\n");
	}
	else {  /* domfloor >= 0 */
	  printf("  Printing all domains");
	  if (domsortby == BYBYTES) {
	    if (domfloor == 0)
	      printf(" with any traffic");
	    else
	      printf(" with at least %d.%02d%% of the traffic", domfloor / 100,
		     domfloor % 100);
	    printf(", sorted by traffic.\n");
	  }
	  else {  /* domsortby REQUESTS or ALPHABETICALLY */
	    if (domfloor > 0)
	      printf(" with at least %d request%s", domfloor,
		     (domfloor == 1)?"":"s");
	    printf(", sorted %s\n",
		   (domsortby==BYREQUESTS)?"by requests.":"alphabetically.");
	  }
	}
	printf("  Printing all requested subdomains");
	if (subdomfloor > 0) {
	  printf(" with at least");
	  if (domsortby == BYBYTES)
	    printf(" %d.%02d%% of the traffic", subdomfloor / 100,
		   subdomfloor % 100);
	  else
	    printf(" %d request%s", subdomfloor, (subdomfloor == 1)?"":"s");
	}
	printf(".\n");
	printf("  Columns:");
	if (*domcols == '\0')
	  printf("  none");
	else for (d = domcols; *d != '\0'; d++) {
	  switch(*d) {
	  case 'b':
	    printf("  %%bytes");
	    break;
	  case 'B':
	    printf("  #bytes");
	    break;
	  case 'r':
	    printf("  %%requests");
	    break;
	  case 'R':
	    printf("  #requests");
	    break;
	  }
	}
	printf("\n");
      }
      break;
    case 'r':
      printf("Request report   %s\n", rq?"ON":"OFF");
      if (rq) {
	if (reqfloor < 0) {
	  if (reqfloor == -1)
	    printf("  Printing the first %s ",
		   (reqtype == PAGES)?"page":"file");
	  else
	    printf("  Printing the first %d %s ", -reqfloor,
		   (reqtype == PAGES)?"pages":"files");
	  if (reqsortby == BYREQUESTS)
	    printf("by number of requests.\n");
	  else if (reqsortby == BYBYTES)
	    printf("by amount of traffic.\n");
	  else
	    printf("alphabetically.\n");
	}
	else {
	  printf("  Printing all %s", (reqtype == PAGES)?"pages":"files");
	  if (reqsortby == BYBYTES) {
	    if (reqfloor > 0)
	      printf(" with at least %d.%02d%% of the traffic", reqfloor / 100,
		     reqfloor % 100);
	    printf(", sorted by traffic.\n");
	  }
	  else {
	    if (reqfloor > 1)
	      printf(" with at least %d requests", reqfloor);
	    printf(", sorted %s\n",
		   (reqsortby==BYREQUESTS)?"by requests.":"alphabetically.");
	  }
	}
	if (kq == OFF)
	  printf("  Linking disabled.\n");
	else {
	  printf("  Linking to %s enabled", (kq==ALL)?"all files":"pages");
	  if (strcmp(baseurl, "none") != 0)
	    printf(" (prepended by %s)", baseurl);
	  printf(".\n");
	}
	printf("  Columns:");
	if (*reqcols == '\0')
	  printf("  none");
	else for (d = reqcols; *d != '\0'; d++) {
	  switch(*d) {
	  case 'b':
	    printf("  %%bytes");
	    break;
	  case 'B':
	    printf("  #bytes");
	    break;
	  case 'r':
	    printf("  %%requests");
	    break;
	  case 'R':
	    printf("  #requests");
	    break;
	  }
	}
	printf("\n");
      }
      break;
    case 'S':
      printf("Host report      %s\n", Sq?"ON":"OFF");
      if (Sq) {
	if (hostfloor < 0) {
	  if (hostfloor == -1)
	    printf("  Printing the first host ");
	  else
	    printf("  Printing the first %d hosts ", -hostfloor);
	  if (hostsortby == BYREQUESTS)
	    printf("by number of requests.\n");
	  else if (hostsortby == BYBYTES)
	    printf("by amount of traffic.\n");
	  else
	    printf("alphabetically.\n");
	}
	else {
	  printf("  Printing all hosts");
	  if (hostsortby == BYBYTES) {
	    if (hostfloor > 0)
	      printf(" with at least %d.%02d%% of the traffic", hostfloor / 100,
		     hostfloor % 100);
	    printf(", sorted by traffic.\n");
	  }
	  else {
	    if (hostfloor > 1)
	      printf(" with at least %d requests", hostfloor);
	    printf(", sorted %s\n",
		   (hostsortby==BYREQUESTS)?"by requests.":"alphabetically.");
	  }
	}
	printf("  Columns:");
	if (*hostcols == '\0')
	  printf("  none");
	else for (d = hostcols; *d != '\0'; d++) {
	  switch(*d) {
	  case 'b':
	    printf("  %%bytes");
	    break;
	  case 'B':
	    printf("  #bytes");
	    break;
	  case 'r':
	    printf("  %%requests");
	    break;
	  case 'R':
	    printf("  #requests");
	    break;
	  }
	}
	printf("\n");
      }
      break;
    case 'W':
      printf("Weekly report    %s\n", Wq?"ON":"OFF");
      if (Wq && weeklyunit != 0) {
	printf("Each character in the graph will represent");
	int3printf(stdout, weeklyunit);
	printf(" requests\n");
      }
      break;
    }  /* end switch c */
  }    /* end for c */


  if (sq == APPROX) {
    printf("\nApproximate hostname count ON\n");
    printf("  Space used for hostname count: ");
    int3printf(stdout, approxhostsize);
    printf(" bytes\n");
  }
  else
    printf("\nHostname count   %s\n", (sq == ON)?"ON":"OFF");




  printf("Statistics for last 7 days %s\n", q7?"ON":"OFF");

  printf("Resolving numerical hosts  %s\n", dnsq?"ON":"OFF");

  if (oq) {
    printf("\nRequested subdomains:\n");
    if (subdomshead -> from[0] == '\0')
      printf("  None\n");
    else for (subdomp = subdomshead; subdomp -> from[0] != '\0';
	 subdomp = subdomp -> next) {
      if (subdomp -> from[0] == '?')  /* don't want it */
	;
      else if (subdomp -> from[0] == '%')
	printf("  Numerical subdomains\n");
      else {
	printf("  %s", subdomp -> from);
	if (subdomp -> to[0] != '?')
	  printf(" (%s)", subdomp -> to);
	printf("\n");
      }
    }
  }

  if (mq || dq || hq || Dq || Wq) {
    printf("\nThe character used in the graphs will be '%c'\n", markchar);
    printf("The page width is %d\n", pagewidth);
  }

  printf("The character used as a separator in big numbers will be '%c'\n",
	 sepchar);

  if (Wq || Dq || dq) {
    printf("Weeks are taken to begin on ");
    switch(weekbeginson) {
    case (SUNDAY):
      printf("Sunday.\n");
      break;
    case (MONDAY):
      printf("Monday.\n");
      break;
    case (TUESDAY):
      printf("Tuesday.\n");
      break;
    case (WEDNESDAY):
      printf("Wednesday.\n");
      break;
    case (THURSDAY):
      printf("Thursday.\n");
      break;
    case (FRIDAY):
      printf("Friday.\n");
      break;
    case (SATURDAY):
      printf("Saturday.\n");
      break;
    }
  }

  printf("\nThe output will be in %s.\n",aq?"plain text":"HTML");
  printf("The following will be included in the output:\n");

  if (!aq) {
    printf("Background image   %s\n",
	 (strcmp(background, "none")==0)?"OFF":background);
    printf("Logo               %s\n", logoq?logourl:"OFF");
  }
  printf("Header file        %s\n",
	 (strcmp(headerfile, "none")==0)?"OFF":headerfile);
  if (strcmp(headerfile, "none") != 0) {
    if ((filep = fopen(headerfile, "r")) == NULL)
      printf("  Warning: cannot open that file: will ignore it\n");
    else
      fclose(filep);
  }
  printf("Footer file        %s\n",
	 (strcmp(footerfile, "none")==0)?"OFF":footerfile);
  if (strcmp(footerfile, "none") != 0) {
    if ((filep = fopen(footerfile, "r")) == NULL)
      printf("  Warning: cannot open that file: will ignore it\n");
    else
      fclose(filep);
  }
  printf("Organisation name  \"%s\"\n", hostname);
  if (!aq)
    printf("Name linked to URL %s\n", (hosturl[0]=='-')?"OFF":hosturl);
  
  if (fileonlyhead -> name[0] != '\0' || filewonlyhead -> length != -1) {
    printf("\nExamining only files");
    for (fileonlyp = fileonlyhead; fileonlyp -> name[0] != '\0';
	 fileonlyp = fileonlyp -> next)
	printf("\n  %s", fileonlyp -> name);
    if (fileonlyhead -> name[0] != '\0' && filewonlyhead -> length != -1)
      printf("\nand those");
    if (filewonlyhead -> length != -1)
      printf(" starting");
    for (filewonlyp = filewonlyhead; filewonlyp -> length != -1;
	 filewonlyp = filewonlyp -> next)
      printf("\n  %s", filewonlyp -> name);
    printf("\n");
  }
  
  if (fileignorehead -> name[0] != '\0' ||
      filewignorehead -> length != -1) {
    printf("\nIgnoring files");
    for (fileignp = fileignorehead; fileignp -> name[0] != '\0';
	 fileignp = fileignp -> next)
      printf("\n  %s", fileignp -> name);
    if (fileignorehead -> name[0] != '\0' &&
	filewignorehead -> length != -1)
      printf("\nand those");
    if (filewignorehead -> length != -1)
      printf(" starting");
    for (filewignp = filewignorehead; filewignp -> length != -1;
	 filewignp = filewignp -> next)
      printf("\n  %s", filewignp -> name);
    printf("\n");
    }
  
  if (filealiashead -> from[0] != '\0' || filewaliashead -> flength != -1) {
    printf("\nFile aliases:\n");
    for (filealiasp = filealiashead; filealiasp -> from[0] != '\0';
	 filealiasp = filealiasp -> next)
      printf("  %s -> %s\n", filealiasp -> from, filealiasp -> to);
    for (filewaliasp = filewaliashead; filewaliasp -> flength != -1;
	 filewaliasp = filewaliasp -> next)
      printf("  %s* -> %s*\n", filewaliasp -> from, filewaliasp -> to);
  }

  if (hostonlyhead -> name[0] != '\0' || hostwonlyhead -> length != -1
      || hostnonlyhead -> length != -1) {
    printf("\nExamining only hosts");
    for (hostonlyp = hostonlyhead; hostonlyp -> name[0] != '\0';
	 hostonlyp = hostonlyp -> next)
      printf("\n  %s", hostonlyp -> name);
    for (hostwonlyp = hostwonlyhead; hostwonlyp -> length != -1;
	   hostwonlyp = hostwonlyp -> next)
      printf("\n  *%s", hostwonlyp -> name);
    for (hostwonlyp = hostnonlyhead; hostwonlyp -> length != -1;
	   hostwonlyp = hostwonlyp -> next)
      printf("\n  %s*", hostwonlyp -> name);
    printf("\n");
  }
	
  if (hostignorehead -> name[0] != '\0' ||
      hostwignorehead -> length != -1) {
    printf("\nIgnoring hosts");
    for (hostignp = hostignorehead; hostignp -> name[0] != '\0';
	 hostignp = hostignp -> next)
      printf("\n  %s", hostignp -> name);
    for (hostwignp = hostwignorehead; hostwignp -> length != -1;
	 hostwignp = hostwignp -> next)
	printf("\n  *%s", hostwignp -> name);
    for (hostwignp = hostnignorehead; hostwignp -> length != -1;
	 hostwignp = hostwignp -> next)
	printf("\n  %s*", hostwignp -> name);
    printf("\n");
    }
  
  if (hostaliashead -> from[0] != '\0') {
    printf("\nHost aliases:");
    for (hostaliasp = hostaliashead; hostaliasp -> from[0] != '\0';
	 hostaliasp = hostaliasp -> next)
      printf("  %s -> %s\n", hostaliasp -> from, hostaliasp -> to);
  }
  
  if (fromtime.code > -INFINITY || totime.code < INFINITY) {
    printf("\nExamining only times");
    if (fromtime.code > -INFINITY)
      printf(" from %02d/%s/%d", fromtime.date,
	     monthname[fromtime.monthno], fromtime.year);
    if (totime.code < INFINITY)
      printf(" to %02d/%s/%d", totime.date,
	     monthname[totime.monthno], totime.year);
    printf("\n");
  }

  printf("\nDebug level is %d\n", debug);

  exit(OK);

}
