/*** analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

#include "analhead2.h"

/*** hash.c; the functions which do all the work in the hash tables. ***/

/*** The first few are all exactly the same, adding a certain number of
  requests and a certain number of bytes to the hash entry for that item,
  creating a new hash entry if none existed before. ***/

extern void *xmalloc();    /* in utilities.c */
                           /* used in so many functions, I declare it here */

void reqhashadd(char *filename, int reqs, double bytes, flag last7q, flag al)
{
  extern int magicno();             /* in utilities.c */

  extern struct url *urlhead[];
  extern int no_urls, no_urls7;

  int magicnumber;
  flag finished;
  struct url *urlp, *urllastp, *urlprevp;

  /* First calculate filename's "magic number" */

  magicnumber = magicno(filename, URLHASHSIZE);

  /* Now look through the magicnumber'th list for that URL */

  finished = FALSE;
  urlp = (urlhead[magicnumber]);
  urllastp = urlp;
  urlprevp = urlp;
  while (urlp -> name != NULL && !finished) {
    if (strcmp(urlp -> name, filename) == 0) {   /* then done */
      urlp -> reqs += reqs;
      urlp -> bytes += bytes;
      if (last7q && !(urlp -> last7)) {
	no_urls7++;
	urlp -> last7 = TRUE;
      }
      /* keep the list in rough (not exact) order of number of
	 accesses for quicker searching; particularly useful if
	 the HASHSIZE is set too low. */
      if (urlp -> reqs > urllastp -> reqs) {
	if (urlprevp == urllastp) {   /* iff urlp is 2nd in the list */
	  urlhead[magicnumber] = urlp;
	  urllastp -> next = urlp -> next;
	  urlp -> next = urllastp;
	}
	else {  /* urlp is 3rd or later in the list */
	  urlprevp -> next = urlp;
	  urllastp -> next = urlp -> next;
	  urlp -> next = urllastp;
	}
      }
      finished = TRUE;
    }
    else {      /* look at the next one */
      urlprevp = urllastp;
      urllastp = urlp;
      urlp = urlp -> next;
    }
  }
  
  if (!finished) {   /* reached the end of the list without success; new URL */
    no_urls++;
    urlp -> name = (char *) xmalloc((size_t)(strlen(filename) + 1));
    strcpy(urlp -> name, filename);
    urlp -> reqs = reqs;
    urlp -> bytes = bytes;
    urlp -> aliasdone = al;
    if (last7q) {
      no_urls7++;
      urlp -> last7 = TRUE;
    }
    else
      urlp -> last7 = FALSE;
    urlp -> next = (struct url *) xmalloc(sizeof(struct url));
    urlp -> next -> name = NULL;
  }

}

void dirhashadd(char *dirname, int reqs, double bytes)
{
  extern int magicno();          /* in utilities.c */

  extern struct dir *dirhead[];

  int magicnumber;
  flag finished;
  struct dir *dirp, *dirlastp, *dirprevp;

  magicnumber = magicno(dirname, DIRHASHSIZE);

  finished = FALSE;
  dirp = (dirhead[magicnumber]);
  dirlastp = dirp;
  dirprevp = dirp;
  while (dirp -> name != NULL && !finished) {
    if (strcmp(dirp -> name, dirname) == 0) {
      dirp -> reqs += reqs;
      dirp -> bytes += bytes;
      if (dirp -> reqs > dirlastp -> reqs) {
	if (dirprevp == dirlastp) {
	  dirhead[magicnumber] = dirp;
	  dirlastp -> next = dirp -> next;
	  dirp -> next = dirlastp;
	}
	else {
	  dirprevp -> next = dirp;
	  dirlastp -> next = dirp -> next;
	  dirp -> next = dirlastp;
	}
      }
      finished = TRUE;
    }
    else {
      dirprevp = dirlastp;
      dirlastp = dirp;
      dirp = dirp -> next;
    }
  }
  
  if (!finished) {
    dirp -> name = (char *) xmalloc((size_t)(strlen(dirname) + 1));
    strcpy(dirp -> name, dirname);
    dirp -> reqs = reqs;
    dirp -> bytes = bytes;
    dirp -> next = (struct dir *) xmalloc(sizeof(struct dir));
    dirp -> next -> name = NULL;
  }

}


void hosthashadd(char *hostn, int reqs, double bytes, flag last7q)
{
  extern int magicno();          /* in utilities.c */

  extern struct host *hosthead[];
  extern int no_hosts, no_hosts7, no_new_hosts7;

  int magicnumber;
  flag finished;
  struct host *hostp, *hostlastp, *hostprevp;

  magicnumber = magicno(hostn, HOSTHASHSIZE);

  finished = FALSE;
  hostp = (hosthead[magicnumber]);
  hostlastp = hostp;
  hostprevp = hostp;
  while (hostp -> name != NULL && !finished) {
    if (strcmp(hostp -> name, hostn) == 0) {
      hostp -> reqs += reqs;
      hostp -> bytes += bytes;
      if (last7q && !(hostp -> last7)) {
	no_hosts7++;
	hostp -> last7 = TRUE;
      }
      if (!last7q && !(hostp -> pre7)) {
	hostp -> pre7 = TRUE;
	no_new_hosts7--;  /* Must have hostp -> last7, so have wrongly
			     counted it as new in last 7 */
      }
      if (hostp -> reqs > hostlastp -> reqs) {
	if (hostprevp == hostlastp) {
	  hosthead[magicnumber] = hostp;
	  hostlastp -> next = hostp -> next;
	  hostp -> next = hostlastp;
	}
	else {
	  hostprevp -> next = hostp;
	  hostlastp -> next = hostp -> next;
	  hostp -> next = hostlastp;
	}
      }
      finished = TRUE;
    }
    else {
      hostprevp = hostlastp;
      hostlastp = hostp;
      hostp = hostp -> next;
    }
  }
  
  if (!finished) {
    no_hosts++;
    hostp -> name = xmalloc((size_t)(strlen(hostn) + 1));
    strcpy(hostp -> name, hostn);
    hostp -> reqs = reqs;
    hostp -> bytes = bytes;
    if (last7q) {
      no_hosts7++;
      no_new_hosts7++;
      hostp -> last7 = TRUE;
      hostp -> pre7 = FALSE;
    }
    else {
      hostp -> pre7 = TRUE;
      hostp -> last7 = FALSE;
    }
    hostp -> next = (struct host *) xmalloc(sizeof(struct host));
    hostp -> next -> name = NULL;
  }
  
}

/*** The domain hashadd function is different from the other three, because we
   already know all domains, so there need be no clashes in the hash table. ***/

void domhashadd(char *hostn, int reqs, double bytes)
{
  extern int hosttodomcode();           /* in alias.c */
  extern flag subdomadd();              /* in this file */
  extern int magicno();                 /* in utilities.c */

  extern struct domain *domainhead[], *subdomhead[], *wildsubdomhead,
                       *nwildsubdomhead;
  extern int debug;

  int domcode;   /* domcode is as explained at the bit where we read the
		    domains in. It's the equivalent of magic number for
		    the other hashadd functions. */
  int magicnumber;  /* for subdomains */
  flag finished;
  struct domain *domp;
  char *tempp;
  char tempchar;

  domcode = hosttodomcode(hostn);
  if (domcode == DOMHASHSIZE - 2 && debug >= 2)
    fprintf(stderr, "U: %s\n", hostn);

  domainhead[domcode] -> reqs += reqs;
  domainhead[domcode] -> bytes += bytes;

  /* Next run through the list of wild subdomains. There are two cases;
     numerical and ordinary subdomains */

  if (!isdigit(hostn[strlen(hostn) - 1])) {  /* non-numerical */

    for (domp = wildsubdomhead; domp -> id != NULL; domp = domp -> next) {
      if(strcmp(domp -> id, hostn + MAX(strlen(hostn) - strlen(domp -> id), 0))
	 == 0) {
	/* run back to just after the previous . (or the initial character) */
	tempp = hostn + MAX(strlen(hostn) - strlen(domp -> id), 0);
	while (tempp != hostn && *(tempp - 1) != '.')
	  tempp--;
	/* now add that one to the list of subdoms; it will get looked at
	   in the next stage */
	subdomadd(tempp, "?");
      }
    }

    /* now run through the subdomains this hostname could belong to and see
       if any of them are required to be analysed */

    tempp = strrchr(hostn, '.');  /* the final dot */

    if (tempp != NULL) {

      while (tempp != hostn) {
	tempp--;
	while (tempp != hostn && *(tempp - 1) != '.')
	  tempp--;
	magicnumber = magicno(tempp, SUBDOMHASHSIZE);
	finished = OFF;
	for (domp = subdomhead[magicnumber]; domp -> name != NULL && !finished;
	     domp = domp -> next) {
	  if (strcmp(domp -> id, tempp) == 0) {
	    domp -> reqs += reqs;
	    domp -> bytes += bytes;
	    finished = ON;
	  }
	}
      }
    }

  }   /* end non-numerical subdomains; now do numerical ones */

  else {

    /* wild numerical subdomains */

    for (domp = nwildsubdomhead; domp -> id != NULL; domp = domp -> next) {
      if(strncmp(domp -> id, hostn, (size_t)strlen(domp -> id)) == 0) {
	/* run to the next . (or the end) */
	tempp = hostn + strlen(domp -> id);
	while (*tempp != '.' && *tempp != '\0')
	  tempp++;
	/* now add that one to the subdoms */
	tempchar = *tempp;
	*tempp = '\0';   /* temporarily trucate the string after the subdom */
	subdomadd(hostn, "?");
	*tempp = tempchar;
      }
    }

    /* and now run through the ordinary subdoms for this numerical host */

    tempp = hostn + strlen(hostn);

    while (tempp != hostn) {
      while (tempp != hostn && *tempp != '.' && *tempp != '\0')
	tempp--;
      if (tempp != hostn) {
	tempchar = *tempp;
	*tempp = '\0';   /* temporarily trucate the string again */
	magicnumber = magicno(hostn, SUBDOMHASHSIZE);
	finished = OFF;
	for (domp = subdomhead[magicnumber]; domp -> name != NULL && !finished;
	     domp = domp -> next) {
	  if (strcmp(domp -> id, hostn) == 0) {
	    domp -> reqs += reqs;
	    domp -> bytes += bytes;
	    finished = ON;
	  }
	}
	*tempp = tempchar;
	tempp--;
      }
    }
  }

}

/*** Add a new subdomain to the list of subdomains ***/

flag subdomadd(char *id, char *name)
{
  extern char *reversehostname(); /* in alias.c */

  extern struct domain *subdomhead[SUBDOMHASHSIZE];
  extern struct domain *wildsubdomhead, *nwildsubdomhead;

  struct domain *domp, *domnextp;
  int magicnumber;
  flag numeric;       /* whether it's a numerical subdomain */

  if (id[0] == '?')  /* we don't want it */
    ;

  else if (id[0] == '*') {  /* put at start wild list (order doesn't matter) */
    domnextp = wildsubdomhead;
    wildsubdomhead = (struct domain *) xmalloc(sizeof(struct domain));
    wildsubdomhead -> next = domnextp;
    wildsubdomhead -> id = xmalloc((size_t)(strlen(id)));
    strcpy(wildsubdomhead -> id, id + 1);
  }

  else if (id[strlen(id) - 1] == '*') {
    domnextp = nwildsubdomhead;
    nwildsubdomhead = (struct domain *) xmalloc(sizeof(struct domain));
    nwildsubdomhead -> next = domnextp;
    nwildsubdomhead -> id = xmalloc((size_t)(strlen(id)));
    strncpy(nwildsubdomhead -> id, id, (size_t)(strlen(id) - 1));
    *(nwildsubdomhead -> id + strlen(id) - 1) = '\0';
  }

  else if (id[0] == '%') {   /* token representing "all numerical domains" */
    domnextp = nwildsubdomhead;
    nwildsubdomhead = (struct domain *) xmalloc(sizeof(struct domain));
    nwildsubdomhead -> next = domnextp;
    nwildsubdomhead -> id = xmalloc(1);
    nwildsubdomhead -> id[0] = '\0';
  }

  else {
    magicnumber = magicno(id, SUBDOMHASHSIZE);
    domp = subdomhead[magicnumber];

    /* look through that list and slot it in alphabetically
       (for quicker finding than random if it's repeated later) */

    if (!isdigit(id[strlen(id) - 1])) {
      reversehostname(id);
      numeric = FALSE;
    }
    else
      numeric = TRUE;

    /* if it goes at the beginning of the list, slot it in there */
    if (domp -> name == NULL || strcmp(domp -> revid, id) > 0) {
      domnextp = domp;
      domp = (struct domain *) xmalloc(sizeof(struct domain));
      subdomhead[magicnumber] = domp;
      domp -> revid = xmalloc((size_t)(strlen(id) + 1));
      strcpy(domp -> revid, id);
      domp -> id = xmalloc((size_t)(strlen(id) + 1));
      if (!numeric)
	reversehostname(id);
      strcpy(domp -> id, id);
      domp -> name = xmalloc((size_t)(strlen(name) + 1));
      strcpy(domp -> name, name);
      domp -> reqs = 0;
      domp -> bytes = 0;
      domp -> next = domnextp;
      return(TRUE);
    }
    else if (strcmp(domp -> revid, id) == 0) {
      if (!numeric)
	reversehostname(id);
      return(FALSE);
    }
    else {   /* run to right place in alphabet */
      while (domp -> next -> name != NULL &&
	     strcmp(domp -> next -> revid, id) < 0)
	domp = domp -> next;
      if (domp -> next -> name != NULL &&
	  strcmp(domp -> next -> revid, id) == 0) {
	if (!numeric)
	  reversehostname(id);   /* so as to leave it unchanged on exit */
	return(FALSE);
      }
      else {
	domnextp = domp -> next;
	domp -> next = (struct domain *) xmalloc(sizeof(struct domain));
	domp = domp -> next;
	domp -> revid = xmalloc((size_t)(strlen(id) + 1));
	strcpy(domp -> revid, id);
	domp -> id = xmalloc((size_t)(strlen(id) + 1));
	if (!numeric)
	  reversehostname(id);
	strcpy(domp -> id, id);
	domp -> name = xmalloc((size_t)(strlen(name) + 1));
	strcpy(domp -> name, name);
	domp -> reqs = 0;
	domp -> bytes = 0;
	domp -> next = domnextp;
	return(TRUE);
      }
    }
  }
}

/*** Next a function to do an approx count of the number of distinct hosts ***/
/* First some utilities for it */

flag approxhostfilled(char *space, int i)
{    /* whether there is already a 1 at entry i of the table */
  int j, k;

  j = i / 8;
  k = i % 8;

  return((*(space + j) >> k) & 1);
}

void approxhostfill(char *space, int i)
{    /* put a 1 at entry i; ASSUMES IT IS CURRENTLY EMPTY */
  int j, k;

  j = i / 8;
  k = i % 8;
  *(space + j) += (1 << k);

}

void approxhosthashadd(char *hostn, flag last7q)
{
  extern char *approxhostspace, *approxhostspace7;
  extern int approxhostsize;
  extern int no_hosts, no_hosts7, no_new_hosts7;
  extern flag q7;

  int magicnumber1, magicnumber2, magicnumber3, magicnumber4;
  flag seen1, seen2, seen3, seen4; /* whether we'd already seen that number */
  flag seen17, seen27, seen37, seen47;  /* ditto in last 7 days */
  flag seen, seen7;        /* whether we've seen all 4 numbers before */
  register int i;
  /* NB Note approxhostfill assumes empty; be careful about two equal magic
     numbers for some host */

  magicnumber1 = 0;
  for (i = 0; hostn[i] != '\0'; i++) {
    magicnumber1 = 101 * magicnumber1 + hostn[i];
    if (magicnumber1 < 0)
      magicnumber1 = -magicnumber1;
    while (magicnumber1 >= 8 * approxhostsize)
      magicnumber1 -= 8 * approxhostsize;
  }
  seen1 = approxhostfilled(approxhostspace, magicnumber1);
  if (!seen1 && (!q7 || !last7q))  /* if q7 only pre-last7 go here;
				      if !q7 everything does */
    approxhostfill(approxhostspace, magicnumber1);
  if (q7) {
    seen17 = approxhostfilled(approxhostspace7, magicnumber1);
    if (!seen17 && last7q)
      approxhostfill(approxhostspace7, magicnumber1);
  }

  magicnumber2 = 0;
  for (i--; i >= 0; i--) {
    magicnumber2 = 101 * magicnumber2 + hostn[i];
    if (magicnumber2 < 0)
      magicnumber2 = -magicnumber2;
    while (magicnumber2 >= 8 * approxhostsize)
      magicnumber2 -= 8 * approxhostsize;
  }
  seen2 = approxhostfilled(approxhostspace, magicnumber2);
  if (!seen2 && (!q7 || !last7q))
    approxhostfill(approxhostspace, magicnumber2);
  if (q7) {
    seen27 = approxhostfilled(approxhostspace7, magicnumber2);
    if (!seen27 && last7q)
      approxhostfill(approxhostspace7, magicnumber2);
  }

  magicnumber3 = 0;
  for (i = 0; hostn[i] != '\0'; i++) {
    magicnumber3 = 103 * magicnumber3 + hostn[i];
    if (magicnumber3 < 0)
      magicnumber3 = -magicnumber3;
    while (magicnumber3 >= 8 * approxhostsize)
      magicnumber3 -= 8 * approxhostsize;
  }
  seen3 = approxhostfilled(approxhostspace, magicnumber3);
  if (!seen3 && (!q7 || !last7q))
    approxhostfill(approxhostspace, magicnumber3);
  if (q7) {
    seen37 = approxhostfilled(approxhostspace7, magicnumber3);
    if (!seen37 && last7q)
      approxhostfill(approxhostspace7, magicnumber3);
  }

  magicnumber4 = 0;
  for (i--; i >= 0; i--) {
    magicnumber4 = 103 * magicnumber4 + hostn[i];
    if (magicnumber4 < 0)
      magicnumber4 = -magicnumber4;
    while (magicnumber4 >= 8 * approxhostsize)
      magicnumber4 -= 8 * approxhostsize;
  }
  seen4 = approxhostfilled(approxhostspace, magicnumber4);
  if (!seen4 && (!q7 || !last7q))
    approxhostfill(approxhostspace, magicnumber4);
  if (q7) {
    seen47 = approxhostfilled(approxhostspace7, magicnumber4);
    if (!seen47 && last7q)
      approxhostfill(approxhostspace7, magicnumber4);
    seen7 = seen17 && seen27 && seen37 && seen47;
  }

  seen = seen1 && seen2 && seen3 && seen4;

  if (!q7) {
    if (!seen)   /* new host */
      ++no_hosts;
  }

  else {    /* q7 */
    if (!seen && !seen7) {
      ++no_hosts;
      if (last7q) {
	++no_hosts7;
	++no_new_hosts7;
      }
    }
    else if (!seen && seen7 && !last7q)  /* it wasn't really a new host 7 */
      --no_new_hosts7;
    else if (seen && !seen7 && last7q)
      ++no_hosts7;

  }    /* end else (= if q7) */

}   /* end approxhosthashadd() */


/*** add 1 to the number of requests for a particular month ***/
void addmonthlydata(int year, int monthno)
{
  extern struct monthly *firstm;
  extern struct timestruct firsttime;

  struct monthly *mp;
  int i;

  mp = firstm;

  for (i = year - firsttime.year; i > 0; i--)
    mp = mp -> next;       /* run on to the right year */

  mp -> reqs[monthno]++;   /* and add 1 to the right month in that year */

}

/* add 1 to the number of requests for a particular day */
void adddailydata(int year, int monthno, int date)
{
  extern struct daily *firstd;
  extern struct timestruct firsttime;

  struct daily *dp;
  int i;

  dp = firstd;

  for (i = (year - firsttime.year) * 12 + monthno - firsttime.monthno;
       i > 0; i--)
    dp = dp -> next;       /* run on to the right month */

  dp -> reqs[date - 1]++;   /* and add 1 to the right date in that month */

}

/* add 1 to the number of requests for a particular week */
void addweeklydata(int year, int monthno, int date)
{
  extern int minsbetween();     /* in utilities.c */

  extern struct weekly *firstw;

  struct weekly *wp;

  wp = firstw;

  while(minsbetween(wp -> start.date, wp -> start.monthno, wp -> start.year,
		    0, 0, date, monthno, year, 0, 0) >= 10800)
    wp = wp -> next;       /* run on to the right week */

  wp -> reqs++;            /* and add 1 to it */

}

/*** Now some routines to sort the various reports ready for printing ***/

struct url *reqsort(void)
{   /* sort the request report */

  extern flag ispage();           /* in alias.c */

  extern int rnumber;
  extern struct url *urlhead[];
  extern int reqtype;
  extern int reqsortby;
  extern int reqfloor;
  extern double total_bytes;
  extern int url_max_reqs;
  extern double url_max_bytes;

  flag wantit = ON;    /* whether we want a particular URL */
  struct url *urlsorthead;   /* build up the sort in this list
				(and return it at the end) */
  struct url *urlp, *urlp2, *urlnextp, *urllastp;
  int onlist;          /* the list we are processing */
  flag finished;       /* whether we've finished with a particular entry */

  int i;

  rnumber = 0;
  urlsorthead = (struct url *) xmalloc(sizeof(struct url));
  urlsorthead -> name = NULL;        /* as marker */
  onlist = 0;                        /* the list we are on */
  urlp = urlhead[0];                 /* starting at list 0 */
  for ( ; onlist < URLHASHSIZE; urlp = urlnextp)  {
                                     /* run through all the URLs */
    if (urlp -> name == NULL)    {   /* then finished this list */
      urlnextp = urlhead[++onlist];  /* so look at the next list */
    }
    else {
      if (reqtype == PAGES)
	wantit = ispage(urlp -> name);  /* o/wise wantit is always ON */
      if ((reqsortby == BYBYTES &&
	   (urlp -> bytes / (total_bytes / 10000)) < reqfloor) ||
	  (reqsortby != BYBYTES && urlp -> reqs < reqfloor) ||
	  (!wantit)) {  /* we don't want it */
	urlnextp = urlp -> next;
      }
      else {
	rnumber++;
	url_max_reqs = MAX(urlp -> reqs, url_max_reqs);
	url_max_bytes = MAX(urlp -> bytes, url_max_bytes);
	if ((urlsorthead -> name == NULL) ||
	    (reqsortby == BYBYTES && urlp -> bytes > urlsorthead -> bytes) ||
	    (reqsortby == BYREQUESTS && urlp -> reqs > urlsorthead -> reqs) ||
	    (reqsortby == ALPHABETICAL &&
	     strcmp(urlp -> name, urlsorthead -> name) < 0)) {
	  /* if it's before the first item currently on the list, slot it in */
	  urlnextp = urlp -> next;   /* the next one we're going to look at */
	  urlp -> next = urlsorthead;
	  urlsorthead = urlp;
	}
	else {                   /* otherwise compare with the ones so far */
	  finished = OFF;
	  urllastp = urlsorthead;
	  if (reqfloor < 0)
	    i = reqfloor;
	  else
	    i = 1;
	  for (urlp2 = urlsorthead -> next;
	       urlp2 -> name != NULL && (!finished) && (i++) != -1;
	       urlp2 = urlp2 -> next) {
	    if ((reqsortby == BYBYTES && urlp -> bytes > urlp2 -> bytes) ||
		(reqsortby == BYREQUESTS && urlp -> reqs > urlp2 -> reqs) ||
		(reqsortby == ALPHABETICAL &&
		 strcmp(urlp -> name, urlp2 -> name) < 0)) {
	  /* if urlp comes before urlp2 in the chosen ordering, slot it in */
	      urlnextp = urlp -> next;
	      urlp -> next = urlp2;
	      urllastp -> next = urlp;
	      finished = ON;
	    }
	    urllastp = urlp2;
	  }
	  if (!finished) {         /* we've reached the end of the list; */
	                           /* slot it in at the end */
	    urlnextp = urlp -> next;
	    urlp -> next = urlp2;
	    urlp2 -> name = NULL;
	    urllastp -> next = urlp;
	  }
	}
      }
    }
    
    urlp = urlnextp;   /* so, on to the next one */

  }        /* end for running through all filenames */

  return(urlsorthead);

}    /* end reqsort */



struct dir *dirsort(void)
{   /* sort the directory report */

  extern int inumber;
  extern struct dir *dirhead[];
  extern int dirsortby;
  extern int dirfloor;
  extern double total_bytes;
  extern int dir_max_reqs;
  extern double dir_max_bytes;

  struct dir *dirsorthead;   /* build up the sort in this list
				(and return it at the end) */
  struct dir *dirp, *dirp2, *dirnextp, *dirlastp;
  int onlist;          /* the list we are processing */
  flag finished;       /* whether we've finished with a particular entry */

  int i;

  inumber = 0;
  dirsorthead = (struct dir *) xmalloc(sizeof(struct dir));
  dirsorthead -> name = NULL;        /* as marker */
  onlist = 0;                        /* the list we are on */
  dirp = dirhead[0];                 /* starting at list 0 */
  for ( ; onlist < DIRHASHSIZE; dirp = dirnextp)  {
                                     /* run through all the DIRs */
    if (dirp -> name == NULL) {      /* then finished this list */
      dirnextp = dirhead[++onlist];  /* so look at the next list */
    }
    else {
      if ((dirsortby == BYBYTES &&
	   (dirp -> bytes / (total_bytes / 10000)) < dirfloor) ||
	  (dirsortby != BYBYTES && dirp -> reqs < dirfloor)) {
                                              /* we don't want it */
	dirnextp = dirp -> next;
      }
      else {
	inumber++;
	dir_max_reqs = MAX(dirp -> reqs, dir_max_reqs);
	dir_max_bytes = MAX(dirp -> bytes, dir_max_bytes);
	if ((dirsorthead -> name == NULL) ||
	    (dirsortby == BYBYTES && dirp -> bytes > dirsorthead -> bytes) ||
	    (dirsortby == BYREQUESTS && dirp -> reqs > dirsorthead -> reqs) ||
	    (dirsortby == ALPHABETICAL &&
	     strcmp(dirp -> name, dirsorthead -> name) < 0)) {
	  /* if it's before the first item currently on the list, slot it in */
	  dirnextp = dirp -> next;   /* the next one we're going to look at */
	  dirp -> next = dirsorthead;
	  dirsorthead = dirp;
	}
	else {              /* otherwise compare with the ones so far */
	  finished = OFF;
	  dirlastp = dirsorthead;
	  if (dirfloor < 0)
	    i = dirfloor;
	  else
	    i = 1;
	  for (dirp2 = dirsorthead -> next; dirp2 -> name != NULL
	       && (!finished) && (i++) != -1;
	       dirp2 = dirp2 -> next) {
	    if ((dirsortby == BYBYTES && dirp -> bytes > dirp2 -> bytes) ||
		(dirsortby == BYREQUESTS && dirp -> reqs > dirp2 -> reqs) ||
		(dirsortby == ALPHABETICAL &&
		 strcmp(dirp -> name, dirp2 -> name) < 0)) {
	  /* if dirp comes before dirp2 in the chosen ordering, slot it in */
	      dirnextp = dirp -> next;
	      dirp -> next = dirp2;
	      dirlastp -> next = dirp;
	      finished = ON;
	    }
	    dirlastp = dirp2;
	  }
	  if (!finished) {         /* we've reached the end of the list; */
	                           /* slot it in at the end */
	    dirnextp = dirp -> next;
	    dirp -> next = dirp2;
	    dirp2 -> name = NULL;
	    dirlastp -> next = dirp;
	  }
	}
      }
    }
    
    dirp = dirnextp;   /* so, on to the next one */

  }        /* end for running through all filenames */

  return(dirsorthead);

}    /* end dirsort */


struct host *hostsort(void)
{   /* sort the host report */

  extern char *reversehostname();    /* in alias.c */
  extern int hoststrcmp();           /* in utilities.c */

  extern int Snumber;
  extern struct host *hosthead[];
  extern int hostsortby;
  extern int hostfloor;
  extern double total_bytes;
  extern int host_max_reqs;
  extern double host_max_bytes;

  struct host *hostsorthead;   /* build up the sort in this list
				(and return it at the end) */
  struct host *hostp, *hostp2, *hostnextp, *hostlastp;
  int onlist;          /* the list we are processing */
  flag finished;       /* whether we've finished with a particular entry */

  int i;

  Snumber = 0;
  hostsorthead = (struct host *) xmalloc(sizeof(struct host));
  hostsorthead -> name = NULL;        /* as marker */
  onlist = 0;                        /* the list we are on */
  hostp = hosthead[0];                 /* starting at list 0 */
  for ( ; onlist < HOSTHASHSIZE; hostp = hostnextp)  {
                                     /* run through all the HOSTs */
    if (hostp -> name == NULL) {      /* then finished this list */
      hostnextp = hosthead[++onlist];  /* so look at the next list */
    }
    else {
      if ((hostsortby == BYBYTES &&
	   (hostp -> bytes / (total_bytes / 10000)) < hostfloor) ||
	  (hostsortby != BYBYTES && hostp -> reqs < hostfloor)) {
                                              /* we don't want it */
	hostnextp = hostp -> next;
      }
      else {
	Snumber++;
	host_max_reqs = MAX(hostp -> reqs, host_max_reqs);
	host_max_bytes = MAX(hostp -> bytes, host_max_bytes);
	if (hostsortby == ALPHABETICAL &&
	    !isdigit(hostp -> name[strlen(hostp -> name) - 1]))
	  reversehostname(hostp -> name);
	if ((hostsorthead -> name == NULL) ||
	    (hostsortby == BYBYTES && hostp -> bytes > hostsorthead -> bytes) ||
	    (hostsortby == BYREQUESTS &&
	     hostp -> reqs > hostsorthead -> reqs) ||
	    (hostsortby == ALPHABETICAL && hoststrcmp(hostp -> name,
						  hostsorthead -> name) < 0)) {
	  /* if it's before the first item currently on the list, slot it in */
	  hostnextp = hostp -> next;   /* the next one we're going to look at */
	  hostp -> next = hostsorthead;
	  hostsorthead = hostp;
	}
	else {              /* otherwise compare with the ones so far */
	  finished = OFF;
	  hostlastp = hostsorthead;
	  if (hostfloor < 0)
	    i = hostfloor;
	  else
	    i = 1;
	  for (hostp2 = hostsorthead -> next; hostp2 -> name != NULL
	       && (!finished) && (i++) != -1;
	       hostp2 = hostp2 -> next) {
	    if ((hostsortby == BYBYTES && hostp -> bytes > hostp2 -> bytes) ||
		(hostsortby == BYREQUESTS && hostp -> reqs > hostp2 -> reqs) ||
		(hostsortby == ALPHABETICAL &&
		 hoststrcmp(hostp -> name, hostp2 -> name) < 0)) {
	  /* if hostp comes before hostp2 in the chosen ordering, slot it in */
	      hostnextp = hostp -> next;
	      hostp -> next = hostp2;
	      hostlastp -> next = hostp;
	      finished = ON;
	    }
	    hostlastp = hostp2;
	  }
	  if (!finished) {         /* we've reached the end of the list; */
	                           /* slot it in at the end */
	    hostnextp = hostp -> next;
	    hostp -> next = hostp2;
	    hostp2 -> name = NULL;
	    hostlastp -> next = hostp;
	  }
	}
      }
    }
    
    hostp = hostnextp;   /* so, on to the next one */

  }        /* end for running through all filenames */

  return(hostsorthead);

}    /* end hostsort */


/*** Again, the domain report is a bit different because the
   structure is stored differently ***/

int domsort(void)
{
  extern int onumber;
  extern struct domain *domainhead[];
  extern int domsortby;
  extern int domfloor;
  extern double total_bytes;
  extern int dom_max_reqs;
  extern double dom_max_bytes;

  int i, j, k;
  int firstdom;  /* the numerical index of the first domain; we return this */
  int domnextj;
  struct domain *domp, *domlastp;
  flag finished;

  onumber = 0;
  firstdom = DOMHASHSIZE - 2; /* start with unknown domains at front of list */
  dom_max_reqs = domainhead[firstdom] -> reqs;
  dom_max_bytes = domainhead[firstdom] -> bytes;
  domainhead[firstdom] -> nexti = -1;
  j = DOMHASHSIZE - 1; /* the domain we are on; start with numerical domains */
  while (j >= 0) {              /* run through all the domains */
    domp = domainhead[j];
    domnextj = domp -> nexti;
                            /* the one we're going to look at after this one */
    if (!((domsortby == BYBYTES && domp -> reqs == 0) ||
	  (domsortby == BYBYTES &&
	   (domp -> bytes / (total_bytes / 10000)) < domfloor) ||
	  (domsortby != BYBYTES && domp -> reqs < domfloor))) {
                                   /* else we don't want it */
      onumber++;
      dom_max_reqs = MAX(domp -> reqs, dom_max_reqs);
      dom_max_bytes = MAX(domp -> bytes, dom_max_bytes);
      if ((domsortby == BYBYTES &&
	   domp -> bytes > domainhead[firstdom] -> bytes) ||
	  (domsortby == BYREQUESTS &&
	   domp -> reqs > domainhead[firstdom] -> reqs) ||
	  (domsortby == ALPHABETICAL &&
	   strcmp(domp -> id, domainhead[firstdom] -> id) < 0)) {
	/* if it's before the first item currently on the list, slot it in */
	domp -> nexti = firstdom;
	firstdom = j;
      }
      else {        /* otherwise compare with the ones so far */
	finished = OFF;
	domlastp = domainhead[firstdom];
	if (domfloor < 0)
	  k = domfloor;
	else
	  k = 1;
	for (i = domainhead[firstdom] -> nexti;
	     i >= 0 && (!finished) && (k++) != -1;
	     i = domainhead[i] -> nexti) {
	  if ((domsortby == BYBYTES &&
	       domp -> bytes > domainhead[i] -> bytes) ||
	      (domsortby == BYREQUESTS &&
	       domp -> reqs > domainhead[i] -> reqs) ||
	      (domsortby == ALPHABETICAL &&
	       strcmp(domp -> id, domainhead[i] -> id) < 0)) {
	    /* if domp comes before domp2 in the chosen ordering, slot it in */
	    domp -> nexti = i;
	    domlastp -> nexti = j;
	    finished = ON;
	  }
	  domlastp = domainhead[i];
	}
	if (!finished) {
	  domp -> nexti = -1;   /* meaning, last item on the list */
	  domlastp -> nexti = j;
	}
      }
    }
    
    j = domnextj;   /* so, on to the next one */
	
  }        /* end while j >= 0 */

  return(firstdom);

}   /* end domsort */

/*** Finally, sort subdomains into the domain report ***/

void subdomsort(void)
{
  extern int hosttodomcode();          /* in alias.c */
  extern int hoststrcmp();             /* in utilities.c */

  extern int subonumber;
  extern struct domain *domainhead[], *subdomhead[];
  extern int domsortby, subdomfloor;
  extern double total_bytes;

  struct domain *subdomp, *subdomnextp, *domp, *domnextp;
  int onlist;
  int domcode;

  onlist = 0;
  subonumber = 0;
  subdomp = subdomhead[0];              /* starting at list 0 */
  for ( ; onlist < SUBDOMHASHSIZE; subdomp = subdomnextp)  {
                                        /* run through all the subdoms */
    if (subdomp -> name == NULL) {      /* then finished this list */
      subdomnextp = subdomhead[++onlist];  /* so look at the next list */
    }
    else if ((domsortby == BYBYTES &&
	     subdomp -> bytes / (total_bytes / 10000) >= subdomfloor) ||
	       (domsortby != BYBYTES && subdomp -> reqs >= subdomfloor)) {
      subdomnextp = subdomp -> next;
      subonumber++;
      domcode = hosttodomcode(subdomp -> id);
      if (domcode != DOMHASHSIZE - 2) {
	domp = domainhead[domcode];   /* now run through that domain's
					  subdomains */
	while (domp -> next -> name != NULL &&
	       hoststrcmp(domp -> next -> revid, subdomp -> revid) < 0)
	  domp = domp -> next;  /* run to right place in alphabet */
	domnextp = domp -> next;  /* then slot it in */
	domp -> next = subdomp;
	subdomp -> next = domnextp;
      }
    }
    else
      subdomnextp = subdomp -> next;
  }
}
