/*** analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** formgen.c; generate a form for the analog form interface ***/

#include "analhead2.h"

void formgen(void)
{
  extern flag xq, mq, Wq, dq, Dq, hq, oq, Sq, iq, rq;
  extern char reportorder[];
  extern int domsortby, dirsortby, hostsortby, reqsortby;
  extern int domfloor, dirfloor, hostfloor, reqfloor;
  extern int dirlevel, reqtype, kq;
  extern char hostname[], hosturl[], logourl[], commandname[];
  extern char outfile[];
  extern struct timestruct fromtime, totime;

  int domsortcode, dirsortcode, hostsortcode, reqsortcode;
  char *ro;
  FILE *outf;

  if (strcmp(outfile, "stdout") == 0)
    outf = stdout;

  else if ((outf = fopen(outfile, "w")) == NULL) {
    fprintf(stderr, "%s: Error: failed to open output file %s for writing.\n",
	    commandname, outfile);
    exit(ERR);  /* shouldn't get here because also tested at the beginning */
  }

  fprintf(outf, "<html><head>\n");
  fprintf(outf, "<title>Analog form interface</title>\n");
  fprintf(outf, "</head>\n\n");
  fprintf(outf, "<body>\n");
  if (hosturl[0] == '-')
    fprintf(outf, "<h1><img src=\"%s\" alt=\"\"> Analog form interface for %s</h1>\n",
	   logourl, hostname);
  else
    fprintf(outf, "<h1><img src=\"%s\" alt=\"\"> Analog form interface for <a HREF=\"%s\">%s</a></h1>\n",
	   logourl, hosturl, hostname);    
  fprintf(outf, "<form action=\""FORMPROG"\" method=\"GET\">\n");
  fprintf(outf, "<hr>\n<h2>1. Report choices</h2>\n");
  fprintf(outf, "<i>See <a href=\"http://www.statslab.cam.ac.uk/~sret1/analog/\">the analog\n");
  fprintf(outf, "home page</a> for the meanings of the various reports.</i>\n\n");
  fprintf(outf, "<p>\n<h3>Which reports do you want to see?</h3>\n");
  fprintf(outf, "<INPUT TYPE=checkbox NAME=xq VALUE=1%s>General statistics?\n",
	 xq?" checked":"");
  
  for (ro = reportorder; *ro != '\0'; ro++) {
    switch(*ro) {
    case 'd':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"dq\" VALUE=1%s>Daily summary?\n",
	     dq?" checked":"");
      break;
    case 'D':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"Dq\" VALUE=1%s>Daily report? (NB: Can be long)\n",
	     Dq?" checked":"");
      break;
    case 'h':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"hq\" VALUE=1%s>Hourly summary?\n",
	     hq?" checked":"");
      break;
    case 'i':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"iq\" VALUE=1%s>Directory report?\n",
	     iq?" checked":"");
      break;
    case 'm':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"mq\" VALUE=1%s>Monthly report?\n",
	     mq?" checked":"");
      break;
    case 'o':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"oq\" VALUE=1%s>Domain report?\n",
	     oq?" checked":"");
      break;
    case 'r':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"rq\" VALUE=1%s>Request report?\n",
	     rq?" checked":"");
      break;
    case 'S':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"Sq\" VALUE=1%s>Host report? (NB: Can be long)\n",
	     Sq?" checked":"");
      break;
    case 'W':
      fprintf(outf, "<BR><INPUT TYPE=checkbox NAME=\"Wq\" VALUE=1%s>Weekly report?\n",
	     Wq?" checked":"");
      break;
    }
  }

  for (ro = reportorder; *ro != '\0'; ro++) {
    switch(*ro) {

    case 'i':
      fprintf(outf, "\n<h3>Directory report options</h3>\n\n");
      fprintf(outf, "<i>(If you are not having a directory report, ignore this section)</i>\n");
      fprintf(outf, "<br>Display\n<select name=\"is\" size=1>\n");
      if (dirsortby == BYBYTES)
	dirsortcode = 2 + (dirfloor < 0);
      else if (dirsortby == BYREQUESTS)
	dirsortcode = 4 + (dirfloor < 0);
      else
	dirsortcode = 1;
      fprintf(outf, "<option value=1%s>directories with at least n requests, sorted alphabetically\n",
	     dirsortcode==1?" selected":"");
      fprintf(outf, "<option value=2%s>directories with at least n%% of traffic, sorted by traffic\n",
	     dirsortcode==2?" selected":"");
      fprintf(outf, "<option value=3%s>busiest n directories, sorted by traffic\n",
	     dirsortcode==3?" selected":"");
      fprintf(outf, "<option value=4%s>directories with at least n requests, sorted by requests\n",
	     dirsortcode==4?" selected":"");
      fprintf(outf, "<option value=5%s>busiest n directories, sorted by requests\n",
	     dirsortcode==5?" selected":"");
      fprintf(outf, "</select>\n");
      fprintf(outf, "<br>where n = <input type=TEXT name=\"in\" maxlength=4 size=4>");
      fprintf(outf, "(leave blank for default n)\n");
      fprintf(outf, "<br>Print directories to depth ");
      fprintf(outf, "<input type=text name=\"id\" maxlength=1 size=1 value=%d>\n",
	     dirlevel);
      break;

    case 'o':
      fprintf(outf, "\n<h3>Domain report options</h3>\n\n");
      fprintf(outf, "<i>(If you are not having a domain report, ignore this section)</i>\n");
      fprintf(outf, "<br>Display\n<select name=\"os\" size=1>\n");
      if (domsortby == BYBYTES)
	domsortcode = 2 + (domfloor < 0);
      else if (domsortby == BYREQUESTS)
	domsortcode = 4 + (domfloor < 0);
      else
	domsortcode = 1;
      fprintf(outf, "<option value=1%s>domains with at least n requests, sorted alphabetically\n",
	     domsortcode==1?" selected":"");
      fprintf(outf, "<option value=2%s>domains with at least n%% of traffic, sorted by traffic\n",
	     domsortcode==2?" selected":"");
      fprintf(outf, "<option value=3%s>busiest n domains, sorted by traffic\n",
	     domsortcode==3?" selected":"");
      fprintf(outf, "<option value=4%s>domains with at least n requests, sorted by requests\n",
	     domsortcode==4?" selected":"");
      fprintf(outf, "<option value=5%s>busiest n domains, sorted by requests\n",
	     domsortcode==5?" selected":"");
      fprintf(outf, "</select>\n");
      fprintf(outf, "<br>where n = <input type=TEXT name=\"on\" maxlength=4 size=4>");
      fprintf(outf, "(leave blank for default n)\n");
      break;

    case 'r':
      fprintf(outf, "\n<h3>Request report options</h3>\n\n");
      fprintf(outf, "<i>(If you are not having a request report, ignore this section)</i>\n");
      fprintf(outf, "<br>Display\n<select name=\"rs\" size=1>\n");
      if (reqsortby == BYBYTES)
	reqsortcode = 2 + (reqfloor < 0);
      else if (reqsortby == BYREQUESTS)
	reqsortcode = 4 + (reqfloor < 0);
      else
	reqsortcode = 1;
      fprintf(outf, "<option value=1%s>files with at least n requests, sorted alphabetically\n",
	     reqsortcode==1?" selected":"");
      fprintf(outf, "<option value=2%s>files with at least n%% of traffic, sorted by traffic\n",
	     reqsortcode==2?" selected":"");
      fprintf(outf, "<option value=3%s>busiest n files, sorted by traffic\n",
	     reqsortcode==3?" selected":"");
      fprintf(outf, "<option value=4%s>files with at least n requests, sorted by requests\n",
	     reqsortcode==4?" selected":"");
      fprintf(outf, "<option value=5%s>busiest n files, sorted by requests\n",
	     reqsortcode==5?" selected":"");
      fprintf(outf, "</select>\n");
      fprintf(outf, "<br>where n = <input type=TEXT name=\"rn\" maxlength=4 size=4>");
      fprintf(outf, "(leave blank for default n)\n");
      fprintf(outf, "<br>Show\n");
      fprintf(outf, "<select name=\"rt\" size=1>\n");
      fprintf(outf, "<option value=\"f\"%s>all files\n",
	     reqtype == ALL?" selected":"");
      fprintf(outf, "<option value=\"p\"%s>pages only\n",
	     reqtype == PAGES?" selected":"");
      fprintf(outf, "</select>\n; include links to\n");
      fprintf(outf, "<select name=\"rl\" size=1>\n");
      fprintf(outf, "<option value=\"f\"%s>all files\n",
	     kq == ALL?" selected":"");
      fprintf(outf, "<option value=\"p\"%s>pages only\n",
	     kq == ON?" selected":"");
      fprintf(outf, "<option value=\"n\"%s>no files\n",
	     kq == OFF?" selected":"");
      fprintf(outf, "</select>\n");

      break;

    case 'S':
      fprintf(outf, "\n<h3>Host report options</h3>\n\n");
      fprintf(outf, "<i>(If you are not having a host report, ignore this section)</i>\n");
      fprintf(outf, "<br>Display\n<select name=\"Ss\" size=1>\n");
      if (hostsortby == BYBYTES)
	hostsortcode = 2 + (hostfloor < 0);
      else if (hostsortby == BYREQUESTS)
	hostsortcode = 4 + (hostfloor < 0);
      else
	hostsortcode = 1;
      fprintf(outf, "<option value=1%s>hosts with at least n requests, sorted alphabetically\n",
	     hostsortcode==1?" selected":"");
      fprintf(outf, "<option value=2%s>hosts with at least n%% of traffic, sorted by traffic\n",
	     hostsortcode==2?" selected":"");
      fprintf(outf, "<option value=3%s>busiest n hosts, sorted by traffic\n",
	     hostsortcode==3?" selected":"");
      fprintf(outf, "<option value=4%s>hosts with at least n requests, sorted by requests\n",
	     hostsortcode==4?" selected":"");
      fprintf(outf, "<option value=5%s>busiest n hosts, sorted by requests\n",
	     hostsortcode==5?" selected":"");
      fprintf(outf, "</select>\n");
      fprintf(outf, "<br>where n = <input type=TEXT name=\"Sn\" maxlength=4 size=4>");
      fprintf(outf, "(leave blank for default n)\n");
      break;

    }
  }


  fprintf(outf, "<hr>\n\n<h2>2. Analysing only part of the logfile</h2>\n");
  fprintf(outf, "<b>Only certain dates</b>\n");
  fprintf(outf, "<br>You can analyse only the requests from certain dates.\n");
  fprintf(outf, "Enter the range of dates below in the from <i>yymmdd</i>;\n");
  fprintf(outf, "e.g., 950701 for 1st July 1995 (or fill in just one box\n");
  fprintf(outf, "to limit the range of dates on just one side).");
  fprintf(outf, "<br>From <input type=TEXT name=\"fr\" maxlength=6 size=6");
  if (fromtime.code > -INFINITY)
    fprintf(outf, " value=\"%02d%02d%02d\"", fromtime.year % 100,
	   fromtime.monthno + 1, fromtime.date);
  fprintf(outf, ">\nto <input type=TEXT name=\"to\" maxlength=6 size=6");
  if (totime.code < INFINITY)
    fprintf(outf, " value=\"%02d%02d%02d\"", totime.year % 100,
	   totime.monthno + 1, totime.date);
  fprintf(outf, ">\n\n");

  fprintf(outf, "<p><b>Only certain files</b>\n");
  fprintf(outf, "<br>Only look at the following files (list, separated by commas)\n");
  fprintf(outf, "<br><input type=TEXT name=\"fy\" size=60>\n");
  fprintf(outf, "<br>and those in the following directories\n");
  fprintf(outf, "<br><input type=TEXT name=\"dy\" size=60>\n");

  fprintf(outf, "<p><b>Ignore certain files</b>\n");
  fprintf(outf, "<br>Ignore the following files\n");
  fprintf(outf, "<br><input type=TEXT name=\"fi\" size=60>\n");
  fprintf(outf, "<br>and those in the following directories\n");
  fprintf(outf, "<br><input type=TEXT name=\"di\" size=60>\n");

  fprintf(outf, "<hr><h2>3. Layout</h2>\n");

  fprintf(outf, "<b>Your organisation's name</b> (for the title of the page)\n");
  fprintf(outf, "<input type=TEXT name=\"or\" value=\"%s\" size=60>\n",
	 hostname);

  fprintf(outf, "<p><b>Your organisation's home page</b> (leave blank for none)\n");
  fprintf(outf, "<br>URL: <input type=TEXT name=\"ho\" value=\"%s\" size=60>\n",
         hosturl);

  fprintf(outf, "<hr><input type=hidden name=\"TZ\" value=\"%s\">\n",
         getenv("TZ")!=NULL?getenv("TZ"):"");  /* gets it twice, but easy */
  fprintf(outf, "<input type=submit value=\"Produce statistics\"> ");
  fprintf(outf, "<input type=reset value=\"Reset form\">\n");
  fprintf(outf, "</form>\n");
  fprintf(outf, "</body></html>\n");

}
