/*** analhead2.h; header file for analog version 1.2.3 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/ */

/*** These things are not intended to be user definable; user definable headers
     are in analhead.h ***/

#ifndef ANALHEAD2
#define ANALHEAD2

/*** First some #define's and #include's ***/

#define VERSION "1.2.3"    /* the version number of this program */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <ctype.h>
#include <sys/types.h>   /* the next 5 for looking up numerical addresses */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#ifdef TRUE  /* I suppose everyone else defines TRUE = 1, but I won't */
#undef TRUE  /* risk it by doing an #ifndef */
#endif
#define TRUE (1)
#ifdef FALSE
#undef FALSE
#endif
#define FALSE (0)
#ifdef ON
#undef ON
#endif
#define ON (TRUE)
#ifdef OFF
#undef OFF
#endif
#define OFF (FALSE)
#ifdef OK
#undef OK
#endif
#define OK (0)
#ifdef ERR
#undef ERR
#endif
#define ERR (-1)
#define INET_ADDR_ERR (-1)   /* what inet_addr() returns on error */
#define BYREQUESTS (0)       /* ways of sorting */
#define BYBYTES (1)
#define ALPHABETICAL (2)
#ifdef APPROX
#undef APPROX
#endif
#define APPROX (2)       /* for hostname counting */
#ifdef ALL
#undef ALL
#endif
#define ALL (2)          /* see PAGELINKS and REQTYPE in analhead.h */
#ifdef PAGES
#undef PAGES
#endif
#define PAGES (1)
#ifdef COMMON
#undef COMMON
#endif
#define COMMON (2)       /* three types of input lines */
#define NCSAOLD (1)
#ifdef CORRUPT
#undef CORRUPT
#endif
#define CORRUPT (0)
#ifdef MAX
#undef MAX
#endif
#define MAX(a,b) (((a)>(b))?(a):(b))
#ifdef MIN
#undef MIN
#endif
#define MIN(a,b) (((a)<(b))?(a):(b))
#ifdef INFINITY
#undef INFINITY
#endif
#define INFINITY (2000000000)
                   /* something very big (but that will fit in a long) */
#ifdef SUNDAY
#undef SUNDAY
#endif
#define SUNDAY (0)
#ifdef MONDAY
#undef MONDAY
#endif
#define MONDAY (1)
#ifdef TUESDAY
#undef TUESDAY
#endif
#define TUESDAY (2)
#ifdef WEDNESDAY
#undef WEDNESDAY
#endif
#define WEDNESDAY (3)
#ifdef THURSDAY
#undef THURSDAY
#endif
#define THURSDAY (4)
#ifdef FRIDAY
#undef FRIDAY
#endif
#define FRIDAY (5)
#ifdef SATURDAY
#undef SATURDAY
#endif
#define SATURDAY (6)

#define DOMHASHSIZE (1354)
/* = 2 * 26^2 + 2 by description of domain algorithm */

/*** Now include the user-definable header things ***/

#include "analhead.h"

/*** Next some global structures ***/

typedef int flag;

struct timestruct {        /* some things we might want to know about a
			      particular time */
  int date;                /* the day of the month */
  int monthno;             /* 0 for Jan, ... , 11 for Dec */
  int year;                /* 4 digits */
  int hr;                  /* 0 to 23 */
  int min;                 /* 0 to 59 */
  long code;               /* an increasing (though not necessarily linear)
			      function of time, for quick comparisons.
			      Defined in timecode() */
};

struct monthly {           /* a structure for a year's worth of monthly data */
  int reqs[12];            /* the number of requests on each month */
  struct monthly *next;    /* where the next year's data is */
};

struct daily {             /* similarly, for a month's worth of daily data */
  int reqs[31];            /* NB Day n is stored in location (n - 1) */
  struct daily *next;
};

struct weekly {             /* a structure for weekly data */
  int reqs;
  struct timestruct start;  /* the start of the week */
  struct weekly *next;
};

struct url {                 /* information about a requested file */
  char *name;                /* the name of the file */
  int reqs;                  /* the number of requests it has received */
  double bytes;              /* the number of bytes transferred due to it */
  flag last7;                /* has been used in the last 7 days? */
  flag aliasdone;            /* have we done an alias on it? */
  struct url *next;          /* the next url in the list */
};

struct dir {                 /* directories ditto */
  char *name;
  int reqs;
  double bytes;
  struct dir *next;
};

struct host {
  char *name;
  int reqs;
  double bytes;
  flag pre7;                  /* been used before last 7 days? */
  flag last7;
  struct host *next;
};

struct domain {              /* and domains */
  char *id;                  /* can be as long as host for subdomains */
  char *revid;               /* same reversed */
  char *name;                /* the geographical location of the domain */
  int reqs;
  double bytes;
  int nexti;                 /* the index of the next domain alphabetically */
  struct domain *next;       /* the next subdomain of the current domain */
};

struct alias {      /* FILEALIAS and HOSTALIAS from the configuration file */
  char from[MAXSTRINGLENGTH];
  char to[MAXSTRINGLENGTH];
  struct alias *next;
};

struct wildalias {   /* alias with wildcards */
  char from[MAXSTRINGLENGTH];
  char to[MAXSTRINGLENGTH];
  int flength;   /* the length of from; carry round rather than recompute */
  int tlength;
  struct wildalias *next;
};

struct stringlist {   /* a linked list of strings */
  char name[MAXSTRINGLENGTH];
  struct stringlist *next;
};

struct wstringlist {  /* the same with lengths included (for wildcards) */
  char name[MAXSTRINGLENGTH];
  int length;
  struct wstringlist *next;
};

#endif  /* not previously included */
